/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.newproject.type;

import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.ProjectsContainer;
import se.prediktera.map.main.newproject.AbstractProjectInfo;
import se.prediktera.map.main.newproject.ItemClass;
import se.prediktera.map.main.newproject.NewProjectWizard;
import se.prediktera.map.main.newproject.type.ListPage;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;

public class ScriptPage
extends AbstractProjectInfo {
    private static final ImageIcon imageIcon = new ImageIcon(NewProjectWizard.class.getResource("image/template.gif"));
    private ListPage listPage;

    public ScriptPage(AbstractWizard abstractWizard) {
        this(abstractWizard, 2);
    }

    public ScriptPage(AbstractWizard abstractWizard, int n) {
        try {
            this.listPage = new ListPage(abstractWizard, n);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public boolean canFinish() {
        return this.listPage.getSelectedItem() != null;
    }

    @Override
    public boolean canNext() {
        return this.listPage.hasFiles();
    }

    @Override
    public Project_GUI createProject(ProjectsContainer projectsContainer) {
        try {
            ItemClass itemClass = this.listPage.getSelectedItem();
            ScriptFile scriptFile = (ScriptFile)itemClass.getObject();
            ScriptManager scriptManager = new ScriptManager(false);
            scriptManager.evaluteScript(scriptFile.getScript(), false);
            scriptManager.addScriptEvent(bl -> SwingUtilities.invokeLater(() -> {
                Main_GUI main_GUI = (Main_GUI)IniManager.getMainFrame();
                if (projectsContainer.getNumberOfProject() == 0) {
                    main_GUI.setVisible(true);
                    main_GUI.newProject(null, true);
                } else if (!main_GUI.isVisible()) {
                    main_GUI.setVisible(true);
                }
            }));
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return null;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(this.listPage);
        return vector;
    }

    @Override
    public ImageIcon getWizardImage() {
        return imageIcon;
    }

    @Override
    public String getWizardInfo() {
        return "Allows the user to run a custom routine analysis.";
    }

    public void saveSelectedFiles() {
        Object[] objectArray;
        for (Object object : objectArray = this.listPage.getSelectedValues()) {
            ItemClass itemClass = (ItemClass)object;
            ScriptFile scriptFile = (ScriptFile)itemClass.getObject();
            ScriptManager.saveScriptFile(scriptFile);
        }
    }

    @Override
    public String toString() {
        return "Routine Analysis";
    }

    @Override
    protected void cleanUpChild() {
        if (this.listPage != null) {
            this.listPage.cleanUp();
            this.listPage = null;
        }
    }
}

