/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.ScriptHelper;

public class FileDataClass
extends DataTreeClass {
    private final File file;
    private String path;
    private String filename;
    private String extension;
    private int mapID = -1;

    public static File copyFile(File file, String object) throws Exception {
        int n;
        File file2 = new File((String)object);
        if (!file2.isFile()) {
            if (!((String)object).endsWith(IniManager.getFileSeparator())) {
                object = (String)object + IniManager.getFileSeparator();
            }
            if (!(file2 = new File((String)object)).exists() && !file2.mkdirs()) {
                throw new Exception("Cannot create path: " + (String)object);
            }
            file2 = new File((String)object, file.getName());
        }
        if (file2.exists()) {
            file2.delete();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
        return file2;
    }

    public static String getRelativePath(File file, File file2) {
        List list = FileDataClass.getPathList(file);
        List list2 = FileDataClass.getPathList(file2);
        return FileDataClass.matchPathLists(list, list2);
    }

    public static boolean isAbsolut(String string) {
        return string.contains(":");
    }

    public static void move(File file, String string) throws Exception {
        FileDataClass fileDataClass = new FileDataClass(file);
        fileDataClass.move(string);
    }

    private static List getPathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            arrayList = null;
        }
        return arrayList;
    }

    private static String matchPathLists(List list, List list2) {
        int n;
        Object object = "";
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            object = (String)object + ".." + File.separator;
            --n2;
        }
        while (n >= 1) {
            object = (String)object + String.valueOf(list2.get(n)) + File.separator;
            --n;
        }
        object = (String)object + String.valueOf(list2.get(n));
        return object;
    }

    public FileDataClass(File file) {
        super("File");
        this.file = file;
        this.path = this.isDirectory(file) ? file.getPath() : file.getParent();
        if (this.path != null && !this.path.endsWith(IniManager.getFileSeparator())) {
            this.path = this.path + IniManager.getFileSeparator();
        }
        this.filename = file.getName();
        int n = this.filename.lastIndexOf(".");
        if (n >= 0) {
            this.extension = this.filename.substring(n + 1);
            this.filename = this.filename.substring(0, n);
        } else {
            this.extension = "";
        }
    }

    public FileDataClass(String string) {
        this(new File(string));
    }

    public FileDataClass(String string, int n) {
        this(string);
        this.mapID = n;
    }

    public FileDataClass copy(String string) throws Exception {
        File file = FileDataClass.copyFile(this.file, string);
        return new FileDataClass(file);
    }

    public void delete() throws Exception {
        this.delete(null);
    }

    public void delete(Properties properties) throws Exception {
        boolean bl = true;
        if (properties != null && ScriptHelper.hasKey(properties, "onfailure_deleteonexit")) {
            bl = ScriptHelper.getPropertyBool(properties, "onfailure_deleteonexit");
        }
        if (this.file.isFile() && !this.file.delete()) {
            if (bl) {
                this.file.deleteOnExit();
            } else {
                throw new Exception("Cannot delete file: " + String.valueOf(this));
            }
        }
    }

    public void deletefiles() throws Exception {
        this.deletefiles(null);
    }

    public void deletefiles(File file, boolean bl) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (bl) {
                    this.deletefiles(file2, bl);
                }
                file2.delete();
            }
        }
    }

    public void deletefiles(Properties properties) throws Exception {
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "recursive")) {
            bl = ScriptHelper.getPropertyBool(properties, "recursive");
        }
        this.deletefiles(this.file, bl);
    }

    public void deleteFolder() throws Exception {
        this.deletefiles();
        this.file.delete();
    }

    public Double exists() {
        return this.file.exists() ? 1.0 : 0.0;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameWithExt() {
        return this.filename + "." + this.extension;
    }

    public FileDataClass getFolder() {
        if (this.isDirectory(this.file)) {
            return this;
        }
        return new FileDataClass(this.file.getParentFile());
    }

    public String getFoldername() {
        return this.getFolder().getFilename();
    }

    public String getFullPath() {
        return this.file.getAbsolutePath();
    }

    public int getMapID() {
        return this.mapID;
    }

    public String getModified() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-hhmmss");
        return simpleDateFormat.format(this.file.lastModified());
    }

    public String getModifiedValue() {
        return String.valueOf(this.file.lastModified() / 1000L);
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    public FileDataClass getParent() {
        if (this.isDirectory(this.file)) {
            return new FileDataClass(this.file.getParentFile());
        }
        return new FileDataClass(this.file.getParentFile().getParentFile());
    }

    public String getParentname() {
        return this.getParent().getFilename();
    }

    public String getPath() {
        return this.path;
    }

    public FileDataClass getRelativepath(FileDataClass fileDataClass) {
        return new FileDataClass(FileDataClass.getRelativePath(fileDataClass.getFile(), this.file));
    }

    public FileDataClass getRelativepath(String string) {
        return this.getRelativepath(new FileDataClass(string));
    }

    public String getRelativeStringPath(FileDataClass fileDataClass) {
        return FileDataClass.getRelativePath(fileDataClass.getFile(), this.file);
    }

    public String getRelativeStringPath(String string) {
        return FileDataClass.getRelativePath(new File(string), this.file);
    }

    public long getSize() {
        return this.file.length();
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public Double mkdirs() {
        if (this.file.isDirectory()) {
            return this.file.mkdirs() ? 1.0 : 0.0;
        }
        return this.file.getParentFile().mkdirs() ? 1.0 : 0.0;
    }

    public FileDataClass move(String string) throws Exception {
        FileDataClass fileDataClass = this.copy(string);
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
        return fileDataClass;
    }

    public FileDataClass rename(String string) {
        File file = new File(string);
        this.file.renameTo(file);
        return new FileDataClass(file);
    }

    @Override
    public String toString() {
        if (this.isDirectory(this.file)) {
            return this.path;
        }
        if (this.path != null && this.path.startsWith("..")) {
            return this.file.toString();
        }
        return this.file.getAbsolutePath();
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    private boolean isDirectory(File file) {
        if (file != null) {
            String string;
            if (file.isDirectory()) {
                return true;
            }
            if (!file.exists() && (string = file.getAbsolutePath()).indexOf(".") < 0) {
                return true;
            }
        }
        return false;
    }
}

