/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import se.prediktera.map.common.cleanup.CleanUpTableModel;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.FileTools;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.multi.MultiCellIdentifierModel;
import se.prediktera.map.dataimport.raw.RawImportInfo;
import se.prediktera.map.dataimport.raw.RawImportPanel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ImportClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class LoadHelper {
    public static File downloadFile(ProgressManager progressManager, String string) {
        return LoadHelper.downloadFile(progressManager, string, null);
    }

    public static File downloadFile(ProgressManager progressManager, String string, File file) {
        try {
            int n;
            String string2;
            int n2;
            if (file == null) {
                n2 = string.lastIndexOf(".");
                string2 = "txt";
                if (n2 >= 0) {
                    string2 = string.substring(n2);
                }
                file = File.createTempFile("evince", string2);
                file.deleteOnExit();
            }
            n2 = string.lastIndexOf("/");
            string2 = string;
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
            }
            progressManager.setInfoText("Downloading file " + string2);
            progressManager.setIndeterminate(true);
            Url url = new Url(string);
            byte[] byArray = new byte[4096];
            InputStream inputStream = url.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            return file;
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return null;
        }
    }

    public static AbstractImportInfo getImportInfo(String string, File file) {
        Vector<AbstractImportInfo> vector = ImportHelper.getExternImportInfo();
        for (int i = 0; i < vector.size(); ++i) {
            AbstractImportInfo abstractImportInfo = vector.elementAt(i);
            if (string != null && !abstractImportInfo.supportExtension(string) || !abstractImportInfo.accepts(file)) continue;
            return abstractImportInfo;
        }
        return new RawImportInfo();
    }

    public static boolean isProjectFile(File file) {
        return LoadHelper.isProjectFile(file.getName());
    }

    public static boolean isProjectFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".map");
    }

    public static boolean isUrlFile(String string) {
        return (string = string.toLowerCase()).startsWith("http://") || string.startsWith("ftp://");
    }

    public static DataTreeInterface load(Project_GUI project_GUI, ProgressManager progressManager, String string, Double[] doubleArray, Double[] doubleArray2, String string2, String string3, Properties properties) {
        DataSet dataSet;
        Object[] objectArray = LoadHelper.getFile(progressManager, string);
        File file = (File)objectArray[0];
        String string4 = (String)objectArray[1];
        if (LoadHelper.isProjectFile(string)) {
            try {
                Project_GUI project_GUI2 = Main_GUI.get().loadProject(progressManager, file, false);
                Case case_ = project_GUI2.getPrimaryCase();
                return (DataTreeInterface)case_.getDsContainer().get(0);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (ScriptHelper.hasKey(properties, "delimiter")) {
            string3 = ScriptHelper.getProperty(properties, "delimiter");
        }
        Object[] objectArray2 = LoadHelper.getFileModel(progressManager, file, string4, string, doubleArray, doubleArray2, string2, string3, false, properties);
        AbstractImportInfo abstractImportInfo = (AbstractImportInfo)objectArray2[0];
        CellIdentifierModel cellIdentifierModel = (CellIdentifierModel)objectArray2[1];
        if (ScriptHelper.hasKey(properties, "forcemultilayer")) {
            cellIdentifierModel.setForceMultiLayer(ScriptHelper.getPropertyBool(properties, "forcemultilayer"));
        }
        if ((dataSet = LoadHelper.loadDataSource(project_GUI, progressManager, abstractImportInfo, cellIdentifierModel, properties)) != null) {
            dataSet.getProject_GUI().setProjectFile(file);
            return dataSet;
        }
        throw new RuntimeException("Failed to open file " + string);
    }

    public static DataSet loadDataSource(ProgressManager progressManager, AbstractImportInfo abstractImportInfo, CellIdentifierModel cellIdentifierModel, Properties properties) {
        return LoadHelper.loadDataSource(Main_GUI.getOrCreateScriptProject(), progressManager, abstractImportInfo, cellIdentifierModel, properties);
    }

    public static DataSet loadDataSource(Project_GUI project_GUI, ProgressManager progressManager, AbstractImportInfo abstractImportInfo, CellIdentifierModel cellIdentifierModel, Properties properties) {
        Case case_ = project_GUI.getOrCreatePrimaryCase();
        if (case_.importCaseFromModel(cellIdentifierModel, project_GUI, progressManager, properties)) {
            AbstractDataMatrix abstractDataMatrix = case_.getOriginalMatrix();
            if (properties != null) {
                abstractImportInfo.performProperties(progressManager, new Object[]{cellIdentifierModel, abstractDataMatrix}, properties);
            }
            ImportHelper.replaceMissingWithMedian(progressManager, cellIdentifierModel, abstractDataMatrix);
            DataSet dataSet = (DataSet)case_.getDsContainer().get(0);
            if (properties != null && ScriptHelper.hasKey(properties, "viewdataset")) {
                EvinceScriptCommands.show((AbstractTable)EvinceScriptCommands.createTable(project_GUI, progressManager, "viewdataset", dataSet, new Properties()));
            }
            if (cellIdentifierModel.isDataSource() || abstractImportInfo.supportDataSource()) {
                cellIdentifierModel.closeConnections();
            } else {
                cellIdentifierModel.cleanUp();
            }
            project_GUI.getModel_GUI().createModelWindows(case_);
            cellIdentifierModel.importComplete(progressManager, dataSet);
            return dataSet;
        }
        return null;
    }

    public static DataSet loadMulti(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        return LoadHelper.loadMulti(Main_GUI.getOrCreateScriptProject(), progressManager, objectArray, properties);
    }

    public static DataSet loadMulti(Project_GUI project_GUI, ProgressManager progressManager, Object[] objectArray, Properties properties) {
        int n;
        Object object;
        int n2 = 1;
        int n3 = objectArray.length;
        boolean bl = false;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "alignment") && ((String)(object = ScriptHelper.getProperty(properties, "alignment"))).equals("square")) {
                double d = Math.sqrt(objectArray.length);
                n2 = n3 = (int)Math.ceil(d);
            }
            if (ScriptHelper.hasKey(properties, "rowwize")) {
                bl = ScriptHelper.getPropertyBool(properties, "rowwize");
            }
        }
        object = project_GUI.getOrCreatePrimaryCase();
        CellIdentifierModel[][][] cellIdentifierModelArray = new CellIdentifierModel[n3][n2][1];
        ImportWizard[][][] importWizardArray = new ImportWizard[n3][n2][1];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[1];
        String[][] stringArray = new String[1][];
        for (n = 0; n < 1; ++n) {
            int n4 = -1;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    Object[] objectArray2;
                    int n5 = bl ? i * n3 + j : j * n2 + i;
                    if (n5 >= objectArray.length) continue;
                    Properties properties2 = properties;
                    File file = null;
                    String string = null;
                    String string2 = null;
                    Object object2 = objectArray[n5];
                    if (object2 instanceof FileDataClass) {
                        objectArray2 = object2;
                        string = objectArray2.getFullPath();
                        object2 = LoadHelper.getFile(progressManager, string);
                        file = (File)object2[0];
                        string2 = (String)object2[1];
                    }
                    objectArray2 = LoadHelper.getFileModel(progressManager, file, string2, string, null, null, null, null, true, properties2);
                    object2 = (AbstractImportInfo)objectArray2[0];
                    CellIdentifierModel cellIdentifierModel = (CellIdentifierModel)objectArray2[1];
                    cellIdentifierModel.setImportInfo((AbstractImportInfo)object2);
                    cellIdentifierModelArray[j][i][n] = cellIdentifierModel;
                    importWizardArray[j][i][n] = new ImportWizard(file);
                    if (cellIdentifierModelArray[j][i][n] == null) continue;
                    if (nArray[j] < cellIdentifierModelArray[j][i][n].getRowCount()) {
                        nArray[j] = cellIdentifierModelArray[j][i][n].getRowCount();
                    }
                    if (nArray2[i] < cellIdentifierModelArray[j][i][n].getColumnCount()) {
                        nArray2[i] = cellIdentifierModelArray[j][i][n].getColumnCount();
                    }
                    if (nArray3[n] < cellIdentifierModelArray[j][i][n].getLayerCount()) {
                        nArray3[n] = cellIdentifierModelArray[j][i][n].getLayerCount();
                    }
                    if (n4 == -1) {
                        n4 = cellIdentifierModelArray[j][i][n].getLayerCount();
                        stringArray[n] = new String[n4];
                        for (int k = 0; k < n4; ++k) {
                            stringArray[n][k] = cellIdentifierModelArray[j][i][n].getLayerName(k);
                        }
                        continue;
                    }
                    if (cellIdentifierModelArray[j][i][n].getLayerCount() == n4) continue;
                    throw new RuntimeException("The number of spectral bands must be the same for all data");
                }
            }
        }
        n = 0;
        for (int n5 : nArray) {
            n += n5;
        }
        int n6 = 0;
        for (int n7 : nArray2) {
            n6 += n7;
        }
        int n8 = 0;
        for (int n9 : nArray3) {
            n8 += n9;
        }
        Object object3 = new MultiCellIdentifierModel(n, n6, n8, cellIdentifierModelArray, nArray, nArray2, nArray3, stringArray, importWizardArray, true, false);
        ((MultiCellIdentifierModel)object3).dataSetName = "Multi Import";
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "reducerows")) {
                ((CellIdentifierModel)object3).setResolution(0, ScriptHelper.getPropertyInt(properties, "reducerows"));
            }
            if (ScriptHelper.hasKey(properties, "reducecolumns")) {
                ((CellIdentifierModel)object3).setResolution(1, ScriptHelper.getPropertyInt(properties, "reducecolumns"));
            }
            if (ScriptHelper.hasKey(properties, "reducelayers")) {
                ((CellIdentifierModel)object3).setResolution(2, ScriptHelper.getPropertyInt(properties, "reducelayers"));
            }
            if (ScriptHelper.hasKey(properties, "rootfolder")) {
                ((MultiCellIdentifierModel)object3).setRootFolder(new File(ScriptHelper.getProperty(properties, "rootfolder")));
            }
            if (ScriptHelper.hasKey(properties, "defaultbands")) {
                ((CellIdentifierModel)object3).setDefaultBand(ScriptHelper.getPropertyIntArray(properties, "defaultbands"));
            }
        }
        ((MultiCellIdentifierModel)object3).excludeBySelectionPath(null);
        ((MultiCellIdentifierModel)object3).autoIdentifyData(progressManager, 100000);
        if (((Case)object).importCaseFromModel((CellIdentifierModel)object3, project_GUI, progressManager, properties)) {
            AbstractDataMatrix abstractDataMatrix = ((Case)object).getOriginalMatrix();
            ((MultiCellIdentifierModel)object3).finishImport(progressManager, abstractDataMatrix, properties);
            ImportHelper.replaceMissingWithMedian(progressManager, (CellIdentifierModel)object3, abstractDataMatrix);
            DataSet dataSet = (DataSet)((Case)object).getDsContainer().get(0);
            if (properties != null && ScriptHelper.hasKey(properties, "viewdataset")) {
                EvinceScriptCommands.show((AbstractTable)EvinceScriptCommands.createTable(project_GUI, progressManager, "viewdataset", dataSet, new Properties()));
            }
            ((CleanUpTableModel)object3).cleanUp();
            return dataSet;
        }
        throw new RuntimeException("Failed to open file multi files");
    }

    private static Object[] getFile(ProgressManager progressManager, String string) {
        File file;
        String string2 = null;
        if (LoadHelper.isUrlFile(string)) {
            file = LoadHelper.downloadFile(progressManager, string);
            string2 = string.substring(string.lastIndexOf(61) + 1);
        } else {
            file = new File(string);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            String[] stringArray = new String[]{"xml", "brz"};
            block0: for (File file2 : fileArray) {
                if (!file2.getName().startsWith(file.getName())) continue;
                String string3 = jopensaveDialog.getFileExtension(file2);
                for (String string4 : stringArray) {
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    file = file2;
                    continue block0;
                }
            }
        }
        if (!file.exists()) {
            file = new File(String.valueOf(IniManager.getWorkDir((byte)1)) + IniManager.getFileSeparator() + string);
        }
        if (!file.exists()) {
            throw new RuntimeException("File not found: " + string);
        }
        return new Object[]{file, string2};
    }

    private static Object[] getFileModel(ProgressManager progressManager, File file, String string, String string2, Double[] doubleArray, Double[] doubleArray2, String string3, String string4, boolean bl, Properties properties) {
        Object object;
        Object object2;
        Object object3;
        AbstractImportInfo abstractImportInfo = LoadHelper.getImportInfo(string3, file);
        if (LoadHelper.isUrlFile(string2) && abstractImportInfo.requireHeaderFile()) {
            object3 = string2;
            int n = ((String)object3).lastIndexOf(".");
            object3 = ((String)object3).substring(0, n) + ".hdr";
            Object object4 = file.getAbsolutePath();
            n = ((String)object4).lastIndexOf(".");
            object4 = ((String)object4).substring(0, n) + ".hdr";
            LoadHelper.downloadFile(progressManager, (String)object3, new File((String)object4));
        }
        object3 = abstractImportInfo.getImportPanel(new ImportClass(new File[]{file}, 0, false, bl), properties);
        if (string4 != null && object3 instanceof RawImportPanel) {
            RawImportPanel rawImportPanel = (RawImportPanel)object3;
            rawImportPanel.setDelimiter(string4);
        }
        ((AbstractImportPanel)object3).finishIdentify(progressManager);
        int n = -1;
        int n2 = -1;
        boolean bl2 = false;
        boolean bl3 = true;
        String string5 = null;
        String string6 = null;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "header_type")) {
                object2 = ScriptHelper.getProperty(properties, "header_type");
                object = ((String)object2).split(";");
                int n3 = 0;
                String[] stringArray = object;
                int n4 = stringArray.length;
                for (int i = 0; i < n4; ++i) {
                    String string7 = stringArray[i];
                    if (string7.equalsIgnoreCase("data")) continue;
                    ++n3;
                }
                doubleArray = new Double[n3];
                int n5 = 0;
                for (n4 = 0; n4 < ((String[])object).length; ++n4) {
                    if (object[n4].equalsIgnoreCase("data")) continue;
                    doubleArray[n5++] = (double)n4 + 1.0;
                }
            }
            if (ScriptHelper.hasKey(properties, "primaryrow")) {
                n = ScriptHelper.getPropertyInt(properties, "primaryrow") - 1;
            }
            if (ScriptHelper.hasKey(properties, "primarycolumn")) {
                n2 = ScriptHelper.getPropertyInt(properties, "primarycolumn") - 1;
            }
            if (ScriptHelper.hasKey(properties, "autoidentify")) {
                bl2 = ScriptHelper.getPropertyBool(properties, "autoidentify");
            }
            if (ScriptHelper.hasKey(properties, "selectionpath")) {
                string5 = ScriptHelper.getProperty(properties, "selectionpath");
            }
            if (ScriptHelper.hasKey(properties, "insets")) {
                string6 = ScriptHelper.getProperty(properties, "insets");
            }
            if (ScriptHelper.hasKey(properties, "identify")) {
                bl3 = ScriptHelper.getPropertyBool(properties, "identify");
            }
        }
        object2 = ((AbstractImportPanel)object3).getCellIdentifierModel(progressManager);
        ((CellIdentifierModel)object2).init(progressManager);
        if (doubleArray != null || doubleArray2 != null) {
            if (bl2) {
                ((CellIdentifierModel)object2).autoIdentifyData(progressManager, Integer.MAX_VALUE, properties);
            }
            ((CellIdentifierModel)object2).identifyData(doubleArray, n2, doubleArray2, n, null);
        } else if (!bl && bl3) {
            ((CellIdentifierModel)object2).autoIdentifyData(progressManager, Integer.MAX_VALUE, properties);
        }
        ((CellIdentifierModel)object2).excludeBySelectionPath(string5);
        ((CellIdentifierModel)object2).excludeByInsets(string6);
        if (ScriptHelper.hasKey(properties, "insetsarray")) {
            ((CellIdentifierModel)object2).excludeByInsets(ScriptHelper.getPropertyIntArray(properties, "insetsarray"));
        }
        if (properties != null) {
            ((CellIdentifierModel)object2).setProperties(properties);
            object = properties.getProperty("smiles");
            if (object != null) {
                ((CellIdentifierModel)object2).identifyData(null, -1, null, -1, (String)object);
            }
            if (ScriptHelper.hasKey(properties, "reducerows")) {
                ((CellIdentifierModel)object2).setResolution(0, ScriptHelper.getPropertyInt(properties, "reducerows"));
            }
            if (ScriptHelper.hasKey(properties, "reducecolumns")) {
                ((CellIdentifierModel)object2).setResolution(1, ScriptHelper.getPropertyInt(properties, "reducecolumns"));
            }
            if (ScriptHelper.hasKey(properties, "reducelayers")) {
                ((CellIdentifierModel)object2).setResolution(2, ScriptHelper.getPropertyInt(properties, "reducelayers"));
            }
            if (ScriptHelper.hasKey(properties, "defaultbands")) {
                ((CellIdentifierModel)object2).setDefaultBand(ScriptHelper.getPropertyIntArray(properties, "defaultbands"));
            }
            if (ScriptHelper.hasKey(properties, "variancecheck") && ScriptHelper.getPropertyBool(properties, "variancecheck")) {
                ((CellIdentifierModel)object2).checkAndRemoveZeroVariance(progressManager);
            }
            if (ScriptHelper.hasKey(properties, "mvother")) {
                ((CellIdentifierModel)object2).setMissing(1, true, ScriptHelper.getPropertyDouble(properties, "mvother"));
            }
            if (ScriptHelper.hasKey(properties, "transpose")) {
                ((CellIdentifierModel)object2).setTranspose(ScriptHelper.getPropertyBool(properties, "transpose"));
            }
            if (ScriptHelper.hasKey(properties, "keepdataondisk")) {
                ((CellIdentifierModel)object2).setDataSourceMatrix(ScriptHelper.getPropertyBool(properties, "keepdataondisk"));
                ((CellIdentifierModel)object2).setDataSource(((CellIdentifierModel)object2).isDataSourceMatrix());
            }
            if (ScriptHelper.hasKey(properties, "categoryindices")) {
                for (String string8 : ScriptHelper.getProperty(properties, "categoryindices").split(";")) {
                    ((CellIdentifierModel)object2).addInterval(1, Integer.parseInt(string8) - 1, (byte)3);
                }
            }
            if (ScriptHelper.hasKey(properties, "yindices")) {
                for (String string9 : ScriptHelper.getProperty(properties, "yindices").split(";")) {
                    ((CellIdentifierModel)object2).addInterval(1, Integer.parseInt(string9) - 1, (byte)10);
                }
            }
        }
        if (string == null) {
            string = file.getName();
        }
        ((CellIdentifierModel)object2).dataSetName = FileTools.getBaseName(string);
        if (ScriptHelper.hasKey(properties, "name")) {
            ((CellIdentifierModel)object2).dataSetName = ScriptHelper.getProperty(properties, "name");
        }
        if (ScriptHelper.hasKeyValue(properties, "apply", "unitconversion")) {
            ((CellIdentifierModel)object2).setCalibrated(true);
        } else if (ScriptHelper.hasKeyValue(properties, "apply", "nounitconversion")) {
            ((CellIdentifierModel)object2).setCalibrated(false);
            properties.remove("apply");
        } else {
            abstractImportInfo.setCalibrationProperties(properties, false);
            if (ScriptHelper.hasKeyValue(properties, "apply", "unitconversion")) {
                ((CellIdentifierModel)object2).setCalibrated(true);
            }
        }
        ((CellIdentifierModel)object2).setReplaceMissingWithMedian(ScriptHelper.getPropertyBool(properties, "replacemissing", false));
        return new Object[]{abstractImportInfo, object2};
    }
}

