/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.InvalidParametersException;
import se.prediktera.map.main.script.MethodCallException;
import se.prediktera.map.main.script.MethodNotFoundException;
import se.prediktera.map.main.script.ScriptMethod;

public class ScriptClass {
    private String scriptName = "";
    private final HashMap<String, ScriptMethod> methods = new HashMap();
    private final ArrayList<Method> availableMethods = new ArrayList();
    private final ArrayList<MethodObject> methodObjectCacheList = new ArrayList();

    public ScriptClass(String string) {
        this.scriptName = string;
    }

    public void addMethod(String string, String string2) {
        this.addMethod(string, string2, null);
    }

    public void addMethod(String string, String string2, Class clazz) {
        this.methods.put(string.toUpperCase(), new ScriptMethod(string, string2, clazz));
    }

    public Object callMethod(ProgressManager progressManager, BasicTreeInterface basicTreeInterface, String string, Object[] objectArray) throws MethodCallException {
        if (this.hasMethod(string)) {
            Object object;
            Object object2 = null;
            if (basicTreeInterface == null) {
                object2 = this.findGlobalMethod(this.methods.get((Object)string).realName, objectArray);
                if (object2 == null) {
                    object2 = this.findGlobalMethod(this.methods.get((Object)string).realName, new Object[]{objectArray});
                    if (object2 != null) {
                        if (objectArray == null) {
                            object = this.findGlobalMethod(this.methods.get((Object)string).realName, new Object[]{progressManager});
                            if (object != null) {
                                object2 = object;
                                objectArray = new Object[]{progressManager};
                            } else {
                                objectArray = new Object[]{objectArray};
                            }
                        } else {
                            objectArray = new Object[]{objectArray};
                        }
                    } else {
                        object2 = this.findGlobalMethod(this.methods.get((Object)string).realName, new Object[]{progressManager, objectArray});
                        if (object2 != null) {
                            objectArray = new Object[]{progressManager, objectArray};
                        }
                    }
                }
            } else {
                object2 = this.findMethod(basicTreeInterface, this.methods.get((Object)string).realName, objectArray);
                if (object2 == null) {
                    if (objectArray != null) {
                        object2 = this.findMethod(basicTreeInterface, this.methods.get((Object)string).realName, new Object[]{objectArray});
                        if (object2 != null) {
                            objectArray = new Object[]{objectArray};
                        } else {
                            object2 = this.findMethod(basicTreeInterface, this.methods.get((Object)string).realName, new Object[]{progressManager, objectArray});
                            if (object2 != null) {
                                objectArray = new Object[]{progressManager, objectArray};
                            }
                        }
                    } else {
                        object2 = this.findMethod(basicTreeInterface, this.methods.get((Object)string).realName, new Object[]{progressManager});
                        if (object2 != null) {
                            objectArray = new Object[]{progressManager};
                        }
                    }
                }
            }
            if (object2 == null && progressManager != null && objectArray != null) {
                object = new Object[objectArray.length + 1];
                object[0] = progressManager;
                System.arraycopy(objectArray, 0, object, 1, objectArray.length);
                return this.callMethod(null, basicTreeInterface, string, (Object[])object);
            }
            if (object2 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid parameters for function: " + string);
                for (int i = 0; i < this.availableMethods.size(); ++i) {
                    ((StringBuilder)object).append("\n");
                    if (i == 0) {
                        ((StringBuilder)object).append("Available methods:\n");
                    }
                    Method method = this.availableMethods.get(i);
                    ((StringBuilder)object).append(" * " + method.getName() + "(");
                    Class<?>[] classArray = method.getParameterTypes();
                    boolean bl = true;
                    for (Class<?> clazz : classArray) {
                        String string2;
                        if (!bl) {
                            ((StringBuilder)object).append(", ");
                        }
                        if ((string2 = clazz.getSimpleName()).equalsIgnoreCase("ProgressManager")) continue;
                        ((StringBuilder)object).append(clazz.getSimpleName());
                        bl = false;
                    }
                    ((StringBuilder)object).append(")");
                }
                throw new InvalidParametersException(((StringBuilder)object).toString());
            }
            try {
                return object2.invoke((Object)basicTreeInterface, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
                throw new MethodCallException("Method: " + string.toLowerCase() + "\nError: " + throwable.getMessage(), throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new MethodNotFoundException(string, exception);
            }
        }
        throw new MethodNotFoundException(basicTreeInterface, string);
    }

    public Method findGlobalMethod(String string, Object[] objectArray) {
        return this.findMethod(EvinceScriptCommands.class, string, objectArray);
    }

    public ScriptMethod getMethod(String string) {
        return this.methods.get(string);
    }

    public HashMap<String, ScriptMethod> getMethods() {
        return this.methods;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public List<ScriptMethod> getSortedMethodList() {
        ArrayList<ScriptMethod> arrayList = new ArrayList<ScriptMethod>();
        Set<Map.Entry<String, ScriptMethod>> set = this.methods.entrySet();
        for (Map.Entry<String, ScriptMethod> entry : set) {
            arrayList.add(entry.getValue());
        }
        Collections.sort(arrayList, (scriptMethod, scriptMethod2) -> scriptMethod.realName.compareTo(scriptMethod2.realName));
        return arrayList;
    }

    public boolean hasMethod(String string) {
        return this.methods.containsKey(string);
    }

    public void printInfo() {
        for (Map.Entry<String, ScriptMethod> entry : this.methods.entrySet()) {
            ScriptMethod scriptMethod = entry.getValue();
            System.out.println(scriptMethod.realName);
        }
    }

    public void setScriptName(String string) {
        this.scriptName = string;
    }

    private Method findMethod(BasicTreeInterface basicTreeInterface, String string, Object[] objectArray) {
        return this.findMethod(basicTreeInterface.getClass(), string, objectArray);
    }

    private Method findMethod(Class clazz, String string, Object[] objectArray) {
        MethodObject methodObject = new MethodObject(this, clazz, string, objectArray);
        int n = this.methodObjectCacheList.indexOf(methodObject);
        if (n < 0) {
            methodObject.setMethod(this.findMethodLocal(clazz, string, objectArray));
            this.methodObjectCacheList.add(methodObject);
            if (this.methodObjectCacheList.size() > 20) {
                this.methodObjectCacheList.remove(0);
            }
        } else {
            methodObject = this.methodObjectCacheList.get(n);
        }
        return methodObject.getMethod();
    }

    private Method findMethodLocal(Class clazz, String string, Object[] objectArray) {
        Method[] methodArray = clazz.getMethods();
        string = string.toLowerCase();
        Method method = null;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        this.availableMethods.clear();
        for (Method method2 : methodArray) {
            String string2 = method2.toString().toLowerCase();
            if (string2.indexOf("." + string + "(") == -1) continue;
            method = method2;
            Class<?>[] classArray = method.getParameterTypes();
            boolean bl = false;
            if (objectArray == null) {
                if (classArray != null && classArray.length != 0) {
                    bl = true;
                }
            } else if (classArray.length == objectArray.length) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    if (classArray[i].isPrimitive()) {
                        if (classArray[i].equals(objectArray[i].getClass())) continue;
                        bl = true;
                    } else {
                        if (classArray[i].isInstance(objectArray[i])) continue;
                        bl = true;
                    }
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.availableMethods.add(method);
                continue;
            }
            arrayList.add(method);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() > 1) {
            Logg.warn("Ambiguous method call. More than one matching method found {} {} {}", clazz, string, objectArray);
        }
        return (Method)arrayList.get(0);
    }

    private class MethodObject {
        private final Class methodclass;
        private final String methodName;
        private final Object[] params;
        private Method method;

        MethodObject(ScriptClass scriptClass, Class clazz, String string, Object[] objectArray) {
            this.methodclass = clazz;
            this.methodName = string;
            this.params = objectArray;
        }

        public boolean equals(Object object) {
            if (object instanceof MethodObject) {
                MethodObject methodObject = (MethodObject)object;
                if (this.methodclass.equals(methodObject.methodclass) && this.methodName.equals(methodObject.methodName)) {
                    if (this.params == null && methodObject.params == null) {
                        return true;
                    }
                    if (this.params != null && methodObject.params != null && this.params.length == methodObject.params.length) {
                        for (int i = 0; i < this.params.length; ++i) {
                            if (this.params[i] == null && methodObject.params[i] == null || this.params[i] != null && methodObject.params[i] != null && this.params[i].getClass().equals(methodObject.params[i].getClass())) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return super.equals(object);
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }
}

