/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.main.script.AbstractScriptInfo;

public class ScriptFile
extends AbstractScriptInfo
implements BasicTreeInterface,
Cloneable,
Comparable {
    public static final byte UNCHANGED = 0;
    public static final byte CHANGED = 1;
    public static final byte DELETED = 2;
    private static final String nameTag = "$name";
    private static final String descriptionTag = "$description";
    private static final String typeTag = "$type";
    private static final String subTypeTag = "$subtype";
    private static final String contextTag = "$context";
    private static final String groupTag = "$group";
    private static final String iconTag = "icon";
    private static final String shortcutTag = "shortcut";
    private File file;
    private String name;
    private String extension;
    private String script;
    private String description;
    private String type;
    private String subtype;
    private String context = null;
    private String group = null;
    private String icon = null;
    private String shortcut = null;
    private byte status = 0;

    public ScriptFile() {
    }

    public ScriptFile(File file) throws Exception {
        this.setFile(file);
        if (this.extension == null) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.parseScript(byArray, this.extension);
    }

    public ScriptFile(String string) throws Exception {
        this.parseScript(string.getBytes(), "xml");
    }

    public ScriptFile(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public ScriptFile(String string, String string2, String string3, String string4) {
        this.name = string;
        this.description = string2;
        this.type = string3;
        this.subtype = string4;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ErrorHandler.logAndReportException(cloneNotSupportedException);
            return null;
        }
    }

    public int compareTo(Object object) {
        if (object instanceof ScriptFile) {
            ScriptFile scriptFile = (ScriptFile)object;
            return this.name.compareToIgnoreCase(scriptFile.getName());
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this.type != null && object instanceof ScriptFile) {
            ScriptFile scriptFile = (ScriptFile)object;
            return this.type.equals(scriptFile.getType()) && this.name.equalsIgnoreCase(scriptFile.getName());
        }
        return super.equals(object);
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.name;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        this.addInfo(stringBuilder, "Name", this.name);
        this.addInfo(stringBuilder, "Type", this.type);
        this.addInfo(stringBuilder, "Sub type", this.subtype);
        this.addInfo(stringBuilder, "Context", this.context);
        this.addInfo(stringBuilder, "Group", this.group);
        this.addInfo(stringBuilder, "Icon", this.icon);
        this.addInfo(stringBuilder, "Description", this.description);
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public KeyStroke getKeyStroke() {
        if (this.shortcut != null && this.shortcut.length() > 0) {
            String string = this.shortcut.replace('+', ' ');
            return KeyStroke.getKeyStroke(string);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getScriptInfo() {
        return this.description;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return "";
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    public String getSubType() {
        return this.subtype;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.script == null || this.script.equals("");
    }

    public boolean isScript() {
        return this.extension != null;
    }

    public boolean isXML() {
        return this.extension == null || this.extension.equalsIgnoreCase("XML");
    }

    public void parseScript(byte[] byArray, String string) throws Exception {
        if (string.equals("xml")) {
            ByteArrayInputStream byteArrayInputStream;
            byArray = this.replaceReservedXMLcharacters(byArray);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream = new ByteArrayInputStream(byArray));
            NodeList nodeList = document.getChildNodes();
            if (nodeList.getLength() == 1 && nodeList.item(0).getNodeName().equals("xml")) {
                nodeList = nodeList.item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeName().equals("name")) {
                        this.name = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("description")) {
                        this.description = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("type")) {
                        this.type = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("subtype")) {
                        this.subtype = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("script")) {
                        this.script = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("context")) {
                        this.context = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals("group")) {
                        this.group = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (node.getNodeName().equals(iconTag)) {
                        this.icon = node.getChildNodes().item(0).getNodeValue().trim();
                        continue;
                    }
                    if (!node.getNodeName().equals(shortcutTag)) continue;
                    this.shortcut = node.getChildNodes().item(0).getNodeValue().trim();
                }
            }
            byteArrayInputStream.close();
        } else {
            this.name = this.getScriptInfo(byArray, nameTag);
            this.description = this.getScriptInfo(byArray, descriptionTag);
            this.type = this.getScriptInfo(byArray, typeTag);
            this.subtype = this.getScriptInfo(byArray, subTypeTag);
            this.context = this.getScriptInfo(byArray, contextTag);
            this.group = this.getScriptInfo(byArray, groupTag);
            this.icon = this.getScriptInfo(byArray, iconTag);
            this.shortcut = this.getScriptInfo(byArray, shortcutTag);
            int n = 0;
            if (this.description != null || this.type != null) {
                int n2;
                for (n2 = 1; n2 < byArray.length; ++n2) {
                    if (byArray[n2 - 1] != 42 || byArray[n2] != 47) continue;
                    n = n2 + 1;
                    break;
                }
                for (n2 = n; n2 < byArray.length; ++n2) {
                    if (byArray[n2] == 32 || byArray[n2] == 10 || byArray[n2] == 13 || byArray[n2] == 9) continue;
                    n = n2;
                    break;
                }
            }
            this.script = new String(byArray, n, byArray.length - n);
            this.script = this.script.trim();
        }
        if (this.name == null) {
            throw new Exception("Not a valid script file, name is required: " + this.getFilename());
        }
        this.name = this.name.replace("\n", "");
        if (this.type != null) {
            this.type = this.type.replace("\n", "");
        }
        if (this.subtype != null) {
            this.subtype = this.subtype.replace("\n", "");
        }
    }

    public void setFile(File file) {
        this.file = file;
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            this.extension = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (this.name == null || this.name.equals("Untitled")) {
            this.name = string;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setScript(String string) {
        this.script = string;
    }

    public void setScriptInfo(String string) {
        this.description = string;
    }

    public void setShortcut(String string) {
        this.shortcut = string;
    }

    public void setStatus(byte by) {
        if (this.status != 2) {
            this.status = by;
        }
    }

    public void setSubType(String string) {
        this.subtype = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public boolean supportObject(Object object) {
        return true;
    }

    public String toString() {
        return this.name;
    }

    private void addBytes(List<Byte> list, String string) {
        for (int i = 0; i < string.length(); ++i) {
            list.add((byte)string.charAt(i));
        }
    }

    private void addInfo(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append("<TR><TD>");
            stringBuilder.append(string);
            stringBuilder.append(":</TD><TD>");
            stringBuilder.append(string2);
            stringBuilder.append("</TD></TR>");
        }
    }

    private String getScriptInfo(byte[] byArray, String string) {
        int n;
        String string2 = string + "_start";
        String string3 = string + "_end";
        String string4 = new String(byArray);
        int n2 = string4.indexOf(string3);
        if (n >= 0 && n2 > n) {
            for (n = string4.indexOf(string2) + string2.length(); n < byArray.length && byArray[n] == 32; ++n) {
            }
            String string5 = new String(byArray, n, n2 - n);
            return string5.trim();
        }
        return null;
    }

    private byte[] replaceReservedXMLcharacters(byte[] byArray) throws UnsupportedEncodingException {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < byArray.length && !bl2; ++i) {
            if (byArray[i] == 34) {
                boolean bl3 = bl = !bl;
            }
            if (!bl) continue;
            switch (byArray[i]) {
                case 38: 
                case 60: 
                case 62: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            bl = false;
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            for (byte by : byArray) {
                if (by == 34) {
                    boolean bl4 = bl = !bl;
                }
                if (bl) {
                    switch (by) {
                        case 60: {
                            this.addBytes(arrayList, "&lt;");
                            break;
                        }
                        case 62: {
                            this.addBytes(arrayList, "&gt;");
                            break;
                        }
                        case 38: {
                            this.addBytes(arrayList, "&amp;");
                            break;
                        }
                        default: {
                            arrayList.add(by);
                            break;
                        }
                    }
                    continue;
                }
                arrayList.add(by);
            }
            byArray = new byte[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                byArray[i] = (Byte)arrayList.get(i);
            }
        }
        return byArray;
    }
}

