/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.ScriptNode;
import se.prediktera.map.main.script.ScriptParser;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;

public class ScriptHelper {
    public static void addIfNotExist(Properties properties, String string, String string2) {
        if (!ScriptHelper.hasKey(properties, string)) {
            properties.put(string, string2);
        }
    }

    public static double[] breakIntoNumberTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        double[] dArray = new double[stringTokenizer.countTokens()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringTokenizer.nextToken());
        }
        return dArray;
    }

    public static String[] breakIntoTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().toLowerCase();
        }
        return stringArray;
    }

    public static File chooseFromList(List<File> list) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (File file : list) {
                String string = file.getName();
                int n2 = string.lastIndexOf(".");
                if (n > 0) {
                    stringBuilder.append(",");
                }
                String string2 = string.substring(0, n2);
                stringBuilder.append(string2);
                stringArray[n] = string2;
                ++n;
            }
            Object object = EvinceScriptCommands.showInputDialog(null, "option", "Select properties", stringBuilder.toString());
            if (object != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equalsIgnoreCase(object.toString())) continue;
                    return list.get(n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String generateString(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(", {");
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                stringBuilder.append("\"");
                stringBuilder.append(entry.getKey().toString().toLowerCase());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue().toString().toLowerCase());
                stringBuilder.append("\"");
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        return "";
    }

    public static List<File> getBreezeProperties() {
        ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles("custom", "breeze");
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (ScriptFile scriptFile : arrayList) {
            File[] fileArray;
            File file = scriptFile.getFile();
            if (!file.getName().equalsIgnoreCase("breeze.xml")) continue;
            File file2 = new File(file.getParent() + IniManager.getFileSeparator() + "application");
            for (File file3 : fileArray = file2.listFiles()) {
                String string = jopensaveDialog.getFileExtension(file3);
                if (!string.equalsIgnoreCase("properties")) continue;
                arrayList2.add(file3);
            }
        }
        return arrayList2;
    }

    public static String getProperty(Properties properties, String string) {
        if (properties.containsKey(string = EvinceScriptCommands.removeSpace(string.toLowerCase()))) {
            return properties.getProperty(string);
        }
        throw new PropertyMissingException("Required property is missing: " + string);
    }

    public static String getProperty(Properties properties, String string, String string2) {
        if (properties != null && ScriptHelper.hasKey(properties, string)) {
            try {
                return ScriptHelper.getProperty(properties, string);
            }
            catch (PropertyMissingException propertyMissingException) {
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return string2;
    }

    public static boolean getPropertyBool(Properties properties, String string) {
        String string2 = ScriptHelper.getProperty(properties, string);
        double d = NiceDataFormat.toNumber(string2);
        if (!Double.isNaN(d)) {
            return d != 0.0;
        }
        return Boolean.parseBoolean(string2);
    }

    public static boolean getPropertyBool(Properties properties, String string, boolean bl) {
        try {
            return ScriptHelper.getPropertyBool(properties, string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static double getPropertyDouble(Properties properties, String string) {
        String string2 = ScriptHelper.getProperty(properties, string);
        return Double.parseDouble(ScriptHelper.fixNumber(string2));
    }

    public static double getPropertyDouble(Properties properties, String string, double d) {
        if (ScriptHelper.hasKey(properties, string)) {
            try {
                return ScriptHelper.getPropertyDouble(properties, string);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return d;
    }

    public static int getPropertyInt(Properties properties, String string) {
        return (int)ScriptHelper.getPropertyDouble(properties, string);
    }

    public static int[] getPropertyIntArray(Properties properties, String string) {
        String string2 = ScriptHelper.getProperty(properties, string);
        String[] stringArray = string2.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static boolean hasKey(Properties properties, String string) {
        return properties != null && (properties.containsKey(string.toLowerCase()) || properties.containsKey(string));
    }

    public static boolean hasKeyValue(Properties properties, String string, String string2) {
        try {
            String string3 = ScriptHelper.getProperty(properties, string);
            string3 = EvinceScriptCommands.removeSpace(string3.toLowerCase());
            return string3.equals(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasValue(Properties properties, Object object) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object object2 = entry.getValue();
                if (!object.equals(object2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasValue(Properties properties, String string, String string2) {
        if (properties.containsKey(string)) {
            return ScriptHelper.getProperty(properties, string).equals(string2);
        }
        return false;
    }

    public static Properties loadProperties(File file) {
        if (file.exists()) {
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                return properties;
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return null;
    }

    public static String makeAnonymous(String string) {
        if (string != null) {
            ScriptParser scriptParser = new ScriptParser();
            try {
                PolyNode polyNode = scriptParser.parseScript(string);
                ScriptHelper.makeAnonymous(polyNode);
                return ScriptEditorPanel.formatPolyNode(polyNode);
            }
            catch (PolynomException polynomException) {
                ErrorHandler.logAndReportException(polynomException);
            }
        }
        return null;
    }

    public static void saveProperties(File file, Properties properties) {
        if (properties != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "Breeze Properties");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    public static Object[] splitPropertiesFromParam(Object[] objectArray) {
        return ScriptHelper.splitPropertiesFromParam(objectArray, 0);
    }

    public static Object[] splitPropertiesFromParam(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Properties properties = null;
        for (int i = n; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Properties) {
                properties = (Properties)objectArray[i];
                continue;
            }
            arrayList.add(objectArray[i]);
        }
        objectArray2[0] = arrayList.toArray();
        objectArray2[1] = properties;
        return objectArray2;
    }

    private static String fixNumber(String string) {
        return string.replace(",", ".");
    }

    private static void makeAnonymous(PolyNode polyNode) {
        if (polyNode != null) {
            ScriptNode scriptNode;
            if (polyNode.getType() == 2001 && (scriptNode = (ScriptNode)polyNode).getToken().equalsIgnoreCase("setName")) {
                scriptNode.setRight(null);
            }
            ScriptHelper.makeAnonymous(polyNode.getLeft());
            ScriptHelper.makeAnonymous(polyNode.getRight());
        }
    }

    private static class PropertyMissingException
    extends RuntimeException {
        public PropertyMissingException(String string) {
            super(string);
        }
    }

    public static class Property {
        String key;
        String value;

        public Property(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }

    public static class ScriptProperties
    extends Properties {
        public ScriptProperties() {
        }

        public ScriptProperties(Property ... propertyArray) {
            for (Property property : propertyArray) {
                this.put(property.key, property.value);
            }
        }

        public ScriptProperties(String ... stringArray) {
            for (String string : stringArray) {
                String[] stringArray2 = string.split("=");
                this.put(stringArray2[0], stringArray2[1]);
            }
        }
    }
}

