/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.NoneImportScriptInfo;
import se.prediktera.map.main.script.NoneScriptInfo;
import se.prediktera.map.main.script.ScriptClass;
import se.prediktera.map.main.script.ScriptEvent;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptMethod;
import se.prediktera.map.main.script.ScriptParser;
import se.prediktera.map.main.script.ScriptPerformance;
import se.prediktera.map.main.script.ScriptTokenizer;
import se.prediktera.map.main.script.VariableNode;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.register.RegisterKeyManager;

public class ScriptManager
extends CleanUpClass {
    public static final String[] TYPES = new String[]{"Custom", "Import", "DataSet", "Model", "Prediction", "Table", "Plot"};
    private static EvinceScriptCommands evinceScriptCommands = new EvinceScriptCommands();
    private static boolean isEvaluating = false;
    private static final HashMap<File, ArrayList<ScriptFile>> scriptFileCacheMap = new HashMap();
    private static File customScriptFolder = null;
    private boolean exitOnError = false;
    private final ScriptParser scriptParser = new ScriptParser();
    private final ArrayList<ScriptEvent> scriptEvents = new ArrayList();

    public static int addScriptInfoComboBox(JComboBoxCell jComboBoxCell, String string, Object object) {
        return ScriptManager.addScriptInfoComboBox(jComboBoxCell, string, "", object);
    }

    public static int addScriptInfoComboBox(JComboBoxCell jComboBoxCell, String string, String string2, Object object) {
        AbstractScriptInfo abstractScriptInfo;
        int n = 0;
        jComboBoxCell.removeAllItems();
        if (!string.equals("prediction")) {
            if (string.equals("import")) {
                jComboBoxCell.addItem(new NoneImportScriptInfo(object));
            } else {
                jComboBoxCell.addItem(new NoneScriptInfo());
            }
        }
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.SCRIPT_INFO);
        for (AbstractInfo abstractInfo : list) {
            abstractScriptInfo = (AbstractScriptInfo)abstractInfo;
            if (!abstractScriptInfo.support(string, string2) || !abstractScriptInfo.supportObject(object)) continue;
            jComboBoxCell.addItem(abstractScriptInfo);
            if (n >= abstractScriptInfo.getDefaultIndex()) continue;
            n = abstractScriptInfo.getDefaultIndex();
        }
        ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(string, string2);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i == 0) {
                jComboBoxCell.addSeparator();
            }
            jComboBoxCell.addItem(arrayList.get(i));
        }
        String string3 = IniManager.getScriptName(string.toUpperCase(), string2.toUpperCase(), n);
        abstractScriptInfo = null;
        for (int i = 0; i < jComboBoxCell.getItemCount(); ++i) {
            Object e = jComboBoxCell.getItemAt(i);
            if (!(e instanceof AbstractScriptInfo)) continue;
            AbstractScriptInfo abstractScriptInfo2 = (AbstractScriptInfo)e;
            for (int j = 0; j <= n; ++j) {
                boolean bl;
                boolean bl2 = bl = string3 != null ? string3.equals(abstractScriptInfo2.toString()) : false;
                if (string3 != null && !bl || abstractScriptInfo != null && abstractScriptInfo.getDefaultIndex() >= j && (abstractScriptInfo.getDefaultIndex() != j || !bl)) continue;
                abstractScriptInfo = abstractScriptInfo2;
            }
        }
        if (abstractScriptInfo != null) {
            jComboBoxCell.setSelectedItem(abstractScriptInfo);
        }
        return n;
    }

    public static void addScriptToMenu(CMenu cMenu, final DataTreeInterface dataTreeInterface, final DataTreeInterface dataTreeInterface2, final String string, String string2) {
        List<2> list;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        CMenuItem cMenuItem = new CMenuItem("Custom", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(false);
                scriptEditorPanel.setScript(string + ";", string);
                scriptEditorPanel.format();
                JDialog jDialog = new JDialog(IniManager.getMainFrame(), true);
                jDialog.setTitle("Custom Template");
                JPanel jPanel = (JPanel)jDialog.getContentPane();
                jPanel.add((Component)scriptEditorPanel, "Center");
                jDialog.setSize(600, 500);
                jDialog.setLocationRelativeTo(IniManager.getMainFrame());
                jDialog.setVisible(true);
                ScriptManager.applyTemplate(dataTreeInterface, dataTreeInterface2, string, scriptEditorPanel.getScript());
            }
        };
        cMenu.add(cMenuItem);
        cMenu.addSeparator();
        ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(string, string2);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap hashMap = new HashMap();
        for (final ScriptFile object4 : arrayList) {
            CMenuItem cMenuItem2 = new CMenuItem(object4.getName(), false){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScriptManager.applyTemplate(dataTreeInterface, dataTreeInterface2, string, object4.getScript());
                }
            };
            serializable2 = object4.getImageIcon();
            if (serializable2 != null) {
                cMenuItem2.setIcon((Icon)((Object)serializable2));
            }
            if ((serializable = object4.getKeyStroke()) != null) {
                cMenuItem2.setAccelerator((KeyStroke)serializable);
            }
            if ((object3 = object4.getGroup()) != null && ((String)object3).length() > 0) {
                list = (List)hashMap.get(object3);
                if (list == null) {
                    list = new GroupList((String)object3);
                    hashMap.put(object3, list);
                    arrayList2.add(list);
                }
                list.add(cMenuItem2);
                continue;
            }
            arrayList2.add(cMenuItem2);
        }
        Comparator comparator = (object, object2) -> {
            if (object instanceof List && !(object2 instanceof List)) {
                return -1;
            }
            if (object2 instanceof List && !(object instanceof List)) {
                return 1;
            }
            String string = object.toString();
            String string2 = object2.toString();
            return string.compareToIgnoreCase(string2);
        };
        Collections.sort(arrayList2, comparator);
        for (Object e : arrayList2) {
            if (e instanceof GroupList) {
                serializable2 = (GroupList)e;
                Collections.sort(serializable2, comparator);
                serializable = new CMenu(((GroupList)serializable2).name, true);
                object3 = ((ArrayList)serializable2).iterator();
                while (object3.hasNext()) {
                    list = object3.next();
                    ((JMenu)serializable).add((CMenuItem)((Object)list));
                }
                cMenu.add((JMenuItem)serializable);
                continue;
            }
            cMenu.add((CMenuItem)e);
        }
        cMenu.setEnabled(!arrayList.isEmpty());
    }

    public static void applyTemplate(final DataTreeInterface dataTreeInterface, final DataTreeInterface dataTreeInterface2, final String string, final String string2) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                try {
                    ScriptManager scriptManager = new ScriptManager(null);
                    scriptManager.addVariable(dataTreeInterface, string);
                    if (dataTreeInterface2 instanceof AbstractDataMatrix) {
                        scriptManager.addVariable(dataTreeInterface2, "data");
                        if (dataTreeInterface2 instanceof FoldMatrix) {
                            scriptManager.addVariable(((FoldMatrix)dataTreeInterface2).getFold(), "dataindex");
                        }
                    } else if (dataTreeInterface2 instanceof DataSet) {
                        scriptManager.addVariable(dataTreeInterface2, "dataset");
                    } else if (dataTreeInterface2 instanceof DataSetTable) {
                        scriptManager.addVariable(((DataSetTable)dataTreeInterface2).getDataSet(), "dataset");
                    } else if (dataTreeInterface2 instanceof AbstractControlTable) {
                        scriptManager.addVariable(((AbstractControlTable)dataTreeInterface2).getDataSet(), "dataset");
                    }
                    scriptManager.evaluteScript(this, string2);
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
                return null;
            }
        };
        progressManagerImpl.invokeLater();
    }

    public static void clearScriptFileCache() {
        scriptFileCacheMap.clear();
    }

    public static ScriptFile cloneFile(ScriptFile scriptFile) {
        ScriptFile scriptFile2 = (ScriptFile)scriptFile.clone();
        scriptFile2.setName(ScriptManager.getUniqueName(scriptFile2.getName()));
        ScriptManager.saveScriptFile(scriptFile2);
        return scriptFile2;
    }

    public static void deleteScriptFile(ScriptFile scriptFile) {
        try {
            File file = scriptFile.getFile();
            if (file == null) {
                Object object = scriptFile.getName();
                if (!((String)object).toLowerCase().endsWith(".txt")) {
                    object = (String)object + ".txt";
                }
                file = new File(IniManager.getScriptDir(), (String)object);
            }
            if (file.exists()) {
                file.delete();
            }
            scriptFile.setStatus((byte)2);
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public static ScriptClass getClass(BasicTreeInterface basicTreeInterface) {
        return ScriptManager.findClass(basicTreeInterface != null ? basicTreeInterface.getClass() : null);
    }

    public static ScriptClass getClass(Class clazz) {
        return ScriptManager.findClass(clazz);
    }

    public static String getLastScriptName(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, String string) {
        int n = 0;
        if (project_GUI != null && project_GUI.isSpectralImage()) {
            n = 1;
        }
        return IniManager.getScriptName(string.toUpperCase() + "WIZARD", ScriptManager.getType(dataTreeInterface), ScriptManager.getSubType(dataTreeInterface), n);
    }

    public static String getRootStackTrace(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable2.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static ArrayList<ScriptFile> getScriptByContext(String string) {
        ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(null);
        Iterator<ScriptFile> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ScriptFile scriptFile = iterator.next();
            if (string.equalsIgnoreCase(scriptFile.getContext())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public static ScriptFile getScriptFileByName(String string) throws Exception {
        ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(null, null);
        for (ScriptFile scriptFile : arrayList) {
            if (!string.equalsIgnoreCase(scriptFile.getFilename()) && !string.equalsIgnoreCase(scriptFile.getName())) continue;
            return scriptFile;
        }
        throw new Exception("No such script file: " + string);
    }

    public static ArrayList<ScriptFile> getScriptFiles(String string) {
        return ScriptManager.getScriptFiles(string, null);
    }

    public static void setCustomScriptFolder(File file) {
        customScriptFolder = file;
    }

    public static ArrayList<ScriptFile> getScriptFiles(String string, String string2) {
        try {
            File file = IniManager.getScriptDir();
            ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(file, string, string2, true);
            File file2 = IniManager.getWorkDir((byte)8);
            if (file2 != null) {
                ScriptManager.addUnique(arrayList, ScriptManager.getScriptFiles(file2, string, string2, true));
            }
            if (RegisterKeyManager.isPredikteraLicense()) {
                ScriptManager.addUnique(arrayList, ScriptManager.getScriptFiles(new File("../MAP/script/"), string, string2, true));
                ScriptManager.addUnique(arrayList, ScriptManager.getScriptFiles(new File("../Workspace/MAP/script/"), string, string2, true));
            }
            if (customScriptFolder != null) {
                ScriptManager.addUnique(arrayList, ScriptManager.getScriptFiles(customScriptFolder, string, string2, true));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return new ArrayList<ScriptFile>();
        }
    }

    public static ScriptMethod getScriptMethod(Class clazz, String string) {
        ScriptMethod scriptMethod;
        ScriptClass scriptClass = ScriptManager.findClass(clazz);
        if (scriptClass != null && (scriptMethod = scriptClass.getMethod(string)) != null) {
            return scriptMethod;
        }
        return null;
    }

    public static String getSubType(DataTreeInterface dataTreeInterface) {
        String string = null;
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            if (DataTreeManager.getAncestorNull(dataTreeInterface, AbstractModel.class) != null) {
                string = dataTreeInterface.toString();
            }
        } else if (dataTreeInterface instanceof AbstractModel) {
            string = ((AbstractModel)dataTreeInterface).getModelName();
        }
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    public static String getType(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof DataSet) {
            return "DATASET";
        }
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            return "MATRIX";
        }
        if (dataTreeInterface instanceof AbstractModel) {
            return "MODEL";
        }
        return "DATA";
    }

    public static String getUniqueName(String string) {
        try {
            File file = IniManager.getScriptDir();
            File[] fileArray = file.listFiles();
            if (fileArray.length == 0) {
                return string;
            }
            int n = string.length();
            boolean bl = false;
            int n2 = 1;
            for (File file2 : fileArray) {
                String string2 = file2.getName();
                int n3 = string2.lastIndexOf(".");
                if (n3 >= 0) {
                    string2 = string2.substring(0, n3);
                }
                if (!string2.startsWith(string)) continue;
                bl = true;
                int n4 = string2.indexOf(40, n) + 1;
                int n5 = string2.indexOf(41, n);
                if (n4 <= 0 || n5 <= n4) continue;
                try {
                    int n6 = Integer.parseInt(string2.substring(n4, n5));
                    if (n6 < n2) continue;
                    n2 = n6 + 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl) {
                return string + " (" + n2 + ")";
            }
            return string;
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return null;
        }
    }

    public static boolean isWorking() {
        return isEvaluating;
    }

    public static ArrayList<ScriptFile> listScriptFromServer() {
        ArrayList<ScriptFile> arrayList = new ArrayList<ScriptFile>();
        String string = ScriptManager.readFromServer("list", "");
        if (string == null) {
            throw new RuntimeException("Cannot connect to prediktera server, please check you proxy or firewall and try again.");
        }
        if (string.length() > 0) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; i += 3) {
                try {
                    String string2 = stringArray[i];
                    String string3 = ScriptManager.readFromServer("get", string2);
                    if (string3 == null) continue;
                    string3 = string3.replace("&lt;", "<");
                    ScriptFile scriptFile = new ScriptFile(string3);
                    scriptFile.setFile(new File(IniManager.getScriptDir(), string2));
                    arrayList.add(scriptFile);
                    continue;
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        }
        return arrayList;
    }

    public static void saveScriptFile(ScriptFile scriptFile) {
        if (scriptFile != null) {
            ScriptManager.saveScriptFile(scriptFile, scriptFile.isXML());
            ScriptManager.clearScriptFileCache();
        }
    }

    public static void saveScriptFile(ScriptFile scriptFile, boolean bl) {
        try {
            File file;
            Object object = scriptFile.getName();
            if (bl) {
                if (!((String)object).toLowerCase().endsWith(".xml")) {
                    object = (String)object + ".xml";
                }
            } else if (!((String)object).toLowerCase().endsWith(".txt")) {
                object = (String)object + ".txt";
            }
            if ((file = scriptFile.getFile()) == null) {
                file = new File(IniManager.getScriptDir(), (String)object);
            }
            ScriptManager.saveScriptFile(scriptFile, file, bl);
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public static void saveScriptFile(ScriptFile scriptFile, File file, boolean bl) {
        try {
            file.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            if (bl) {
                ScriptManager.writeNewLine(bufferedWriter, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                ScriptManager.writeNewLine(bufferedWriter, "<xml>");
                ScriptManager.writeNewLine(bufferedWriter, "<name>");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getName());
                ScriptManager.writeNewLine(bufferedWriter, "</name>");
                ScriptManager.writeNewLine(bufferedWriter, "<description>");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getScriptInfo());
                ScriptManager.writeNewLine(bufferedWriter, "</description>");
                ScriptManager.writeNewLine(bufferedWriter, "<type>");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getType());
                ScriptManager.writeNewLine(bufferedWriter, "</type>");
                if (scriptFile.getSubType() != null && scriptFile.getSubType().length() > 0) {
                    ScriptManager.writeNewLine(bufferedWriter, "<subtype>");
                    ScriptManager.writeNewLine(bufferedWriter, scriptFile.getSubType());
                    ScriptManager.writeNewLine(bufferedWriter, "</subtype>");
                }
                if (scriptFile.getShortcut() != null && scriptFile.getShortcut().length() > 0) {
                    ScriptManager.writeNewLine(bufferedWriter, "<shortcut>");
                    ScriptManager.writeNewLine(bufferedWriter, scriptFile.getShortcut());
                    ScriptManager.writeNewLine(bufferedWriter, "</shortcut>");
                }
                ScriptManager.writeNewLine(bufferedWriter, "<script>");
            } else {
                ScriptManager.writeNewLine(bufferedWriter, "/**********************************************");
                ScriptManager.writeNewLine(bufferedWriter, "$name_start");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getName());
                ScriptManager.writeNewLine(bufferedWriter, "$name_end");
                ScriptManager.writeNewLine(bufferedWriter, "$description_start");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getScriptInfo());
                ScriptManager.writeNewLine(bufferedWriter, "$description_end");
                ScriptManager.writeNewLine(bufferedWriter, "$type_start");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getType());
                ScriptManager.writeNewLine(bufferedWriter, "$type_end");
                ScriptManager.writeNewLine(bufferedWriter, "$subtype_start");
                ScriptManager.writeNewLine(bufferedWriter, scriptFile.getSubType());
                ScriptManager.writeNewLine(bufferedWriter, "$subtype_end");
                ScriptManager.writeNewLine(bufferedWriter, "**********************************************/");
                bufferedWriter.newLine();
            }
            String string = scriptFile.getScript();
            for (int i = 0; i < string.length(); ++i) {
                bufferedWriter.write(string.charAt(i));
                if (string.charAt(i) != ';') continue;
                bufferedWriter.newLine();
            }
            if (bl) {
                ScriptManager.writeNewLine(bufferedWriter, "</script>");
                ScriptManager.writeNewLine(bufferedWriter, "</xml>");
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public static Project_GUI setupScriptProject() {
        return Project_GUI.createNewProject(false);
    }

    public static void writeScriptLog(String string) {
        RandomOutputStream randomOutputStream = null;
        try {
            randomOutputStream = new RandomOutputStream(IniManager.getEvinceSettingsFile("script.log"), true, null);
            randomOutputStream.write(string + "\r\n");
        }
        catch (IOException iOException) {
        }
        finally {
            if (randomOutputStream != null) {
                try {
                    randomOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addUnique(ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            ScriptFile scriptFile = (ScriptFile)arrayList2.get(i);
            if (arrayList.contains(scriptFile)) continue;
            arrayList.add(scriptFile);
        }
    }

    private static ScriptClass findClass(Class clazz) {
        ScriptClass scriptClass;
        String string = "";
        if (clazz != null) {
            string = clazz.getName();
        }
        if ((scriptClass = evinceScriptCommands.getClass(string)) == null) {
            return ScriptManager.findClass(clazz.getSuperclass());
        }
        return scriptClass;
    }

    private static ArrayList<ScriptFile> getScriptFiles(File file, boolean bl) {
        ArrayList<ScriptFile> arrayList = new ArrayList<ScriptFile>();
        try {
            File[] fileArray;
            if (file == null) {
                file = IniManager.getScriptDir();
            }
            if ((fileArray = file.listFiles()) != null && fileArray.length > 0) {
                for (File file2 : fileArray) {
                    Object object;
                    if (file2.isDirectory()) {
                        if (!bl) continue;
                        object = ScriptManager.getScriptFiles(file2, bl);
                        arrayList.addAll((Collection<ScriptFile>)object);
                        continue;
                    }
                    try {
                        ScriptFile scriptFile;
                        object = jopensaveDialog.getFileExtension(file2);
                        if (!((String)object).equalsIgnoreCase("xml") && !((String)object).equalsIgnoreCase("txt") || !(scriptFile = new ScriptFile(file2)).isScript()) continue;
                        arrayList.add(scriptFile);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException("Cannot parse script file: " + file2.toString(), exception);
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
        return arrayList;
    }

    private static ArrayList<ScriptFile> getScriptFiles(File file, String string, String string2, boolean bl) {
        ArrayList<ScriptFile> arrayList = new ArrayList<ScriptFile>();
        ArrayList<ScriptFile> arrayList2 = scriptFileCacheMap.get(file);
        if (arrayList2 == null) {
            arrayList2 = ScriptManager.getScriptFiles(file, bl);
            scriptFileCacheMap.put(file, arrayList2);
        }
        for (ScriptFile scriptFile : arrayList2) {
            if (!scriptFile.support(string, string2)) continue;
            arrayList.add(scriptFile);
        }
        return arrayList;
    }

    private static String readFromServer(String string, String string2) {
        try {
            Url url = new Url(IniManager.getWebSite("/download/script/filetransfer.php?type=" + string + "&filename=" + string2), true, true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.getInputStream()));
            String string3 = null;
            StringBuilder stringBuilder = new StringBuilder();
            do {
                if ((string3 = bufferedReader.readLine()) == null) continue;
                stringBuilder.append(string3);
            } while (string3 != null);
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return null;
        }
    }

    private static void writeNewLine(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string != null ? string : "");
        bufferedWriter.newLine();
    }

    public ScriptManager(boolean bl) throws Exception {
        Evince.initNoShow(bl);
    }

    public ScriptManager(Project_GUI project_GUI) {
    }

    public void addGlobalVariables(ScriptParser scriptParser) {
        this.scriptParser.addGlobalVariables(scriptParser);
    }

    public void addScriptEvent(ScriptEvent scriptEvent) {
        this.scriptEvents.add(scriptEvent);
    }

    public void addVariable(Object object, String string) {
        VariableNode variableNode = this.scriptParser.addVariable(new VariableNode(string));
        if (object instanceof BasicTreeInterface) {
            variableNode.setDataTreeInterface((BasicTreeInterface)object);
        }
        if (object != null) {
            variableNode.setResultObject(object);
            variableNode.setVariableClass(object.getClass());
        }
    }

    public void addVariablesFromProperties(Properties properties) {
        this.scriptParser.addVariablesFromProperties(properties);
    }

    public void evaluateScriptPart(ProgressManager progressManager, String string) throws Exception {
        this.scriptParser.evaluateScript(progressManager, string);
    }

    public boolean evaluteScript(ProgressManager progressManager, String string) {
        return this.evaluteScript(progressManager, string, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluteScript(ProgressManager progressManager, String string, boolean bl, boolean bl2) {
        isEvaluating = true;
        boolean bl3 = false;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z");
            String object = "########## EVINCE SCRIPT LOG, " + simpleDateFormat.format(new Date()) + " ##########\n\n";
            ScriptManager.writeScriptLog(object);
            progressManager.setInfoText("Applying template...");
            progressManager.setIndeterminate(true);
            this.scriptParser.evaluateScript(progressManager, string);
            bl3 = true;
        }
        catch (Throwable throwable) {
            progressManager.Finish();
            this.writeErrorLog(throwable);
        }
        finally {
            isEvaluating = false;
            if (bl2) {
                this.cleanUp();
            }
        }
        for (ScriptEvent scriptEvent : this.scriptEvents) {
            scriptEvent.scriptFinished(bl3);
        }
        if (!bl3 && bl) {
            System.exit(1);
        }
        return bl3;
    }

    public void evaluteScript(String string) {
        this.evaluteScript(string, true);
    }

    public void evaluteScript(final String string, final boolean bl) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this, "Evince " + InitClass.GetVersionString()){
            final /* synthetic */ ScriptManager this$0;
            {
                this.this$0 = scriptManager;
                super(string3);
            }

            @Override
            public Object doWork() {
                this.this$0.evaluteScript(this, string, bl, true);
                DataSet dataSet = (DataSet)this.this$0.getVariable("dataset");
                if (dataSet != null && dataSet.getCase() != null) {
                    dataSet.copyTransformations(dataSet.getCase().getOriginalDataSet(), AbstractTransform.Type.localUpdate);
                }
                return null;
            }
        };
        progressManagerImpl.setDeciSeconds(10);
        progressManagerImpl.invokeNow();
    }

    public ScriptPerformance getPerformance() {
        return this.scriptParser.getPerformance();
    }

    public BasicTreeInterface getVariable(String string) {
        VariableNode variableNode = this.scriptParser.getVariable(string);
        if (variableNode != null) {
            return variableNode.getDataTreeInterface();
        }
        return null;
    }

    public void printScript(String string) {
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string);
        while (scriptTokenizer.hasMoreTokens()) {
            System.out.println(scriptTokenizer.nextToken() + ";");
        }
    }

    public void printScriptInfo() {
        evinceScriptCommands.printInfo();
    }

    public void setExitOnError(boolean bl) {
        this.exitOnError = bl;
    }

    @Override
    protected void cleanUpChild() {
        this.scriptParser.cleanUp();
    }

    private void writeErrorLog(Throwable throwable) {
        String string = null;
        if (throwable instanceof PolynomException) {
            string = ((PolynomException)throwable).getErrorToken();
        }
        String string2 = ScriptManager.getRootStackTrace(throwable);
        ScriptManager.writeScriptLog((String)(string != null ? string + " " : "") + "[ERROR, " + throwable.getMessage() + "] " + string2);
        JOptionPane.showConfirmDialog(null, (String)(string != null ? string + ":\n" : "") + throwable.getMessage(), "Script error", -1, 0, null);
        ErrorHandler.logAndReportException(throwable);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    private static class GroupList
    extends ArrayList {
        public String name;

        public GroupList(String string) {
            this.name = string;
        }
    }
}

