/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.main.script.MethodCallException;
import se.prediktera.map.main.script.ScriptClass;
import se.prediktera.map.main.script.ScriptInterface;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.StringDataClass;

public class ScriptNode
extends PolyNode
implements ScriptInterface {
    private String token;
    private BasicTreeInterface dti;
    private Object[] objIntervall;
    private Object resultObject;

    public ScriptNode(int n, BasicTreeInterface basicTreeInterface) {
        super(n, 0.0);
        this.dti = basicTreeInterface;
    }

    public ScriptNode(int n, double d) {
        super(n, d);
    }

    public ScriptNode(int n, int n2) {
        super(n, (double)n2);
    }

    public ScriptNode(int n, String string) {
        super(n, 0.0);
        this.token = string;
    }

    public ScriptNode(PolyNode polyNode, int n, PolyNode polyNode2) {
        super(polyNode, n, polyNode2);
    }

    public ScriptNode(PolyNode polyNode, int n, String string, PolyNode polyNode2) {
        this(polyNode, n, polyNode2);
        this.token = string;
    }

    public PolyNode add(ProgressManager progressManager, PolyNode polyNode) throws MethodCallException {
        return new ScriptNode(1002, this.getValueStr() + polyNode.getValueStr());
    }

    public PolyNode array(PolyNode polyNode) throws MethodCallException {
        Object[] objectArray = polyNode.getParam();
        if (objectArray.length > 0) {
            Object object = objectArray[0];
            if (object instanceof Double || object instanceof Double[]) {
                LinkedList<Double> linkedList = new LinkedList<Double>();
                for (Object object2 : objectArray) {
                    if (object2 instanceof Double) {
                        linkedList.add((Double)object2);
                        continue;
                    }
                    if (object2 instanceof Double[]) {
                        Double[] doubleArray = (Double[])object2;
                        Collections.addAll(linkedList, doubleArray);
                        continue;
                    }
                    throw new MethodCallException("Parameter is not a number");
                }
                Object[] objectArray2 = new Double[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    objectArray2[i] = (Double)linkedList.get(i);
                }
                this.objectArray = objectArray2;
            } else if (objectArray.length > 0) {
                this.objectArray = objectArray;
            }
        }
        return this;
    }

    public PolyNode assign(PolyNode polyNode) {
        ScriptNode scriptNode = null;
        scriptNode = polyNode instanceof ScriptNode ? (ScriptNode)polyNode : new ScriptNode(polyNode.getType(), polyNode.getNum());
        if (scriptNode.resultObject != null) {
            this.resultObject = scriptNode.resultObject;
            this.dti = scriptNode.getDataTreeInterface();
        } else if (scriptNode.getSuperType() == 1002) {
            this.token = scriptNode.getToken();
            this.resultObject = null;
        } else if (scriptNode.getSuperType() == 3) {
            this.type = 3;
            this.setNum(scriptNode.getNum());
        } else {
            this.dti = scriptNode.getDataTreeInterface();
            if (this.dti == null) {
                this.token = scriptNode.getToken();
            }
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof ScriptNode) {
            ScriptNode scriptNode = (ScriptNode)object;
            return scriptNode.token != null && scriptNode.token.equalsIgnoreCase(this.token);
        }
        return false;
    }

    public BasicTreeInterface getDataTreeInterface() {
        return this.dti;
    }

    @Override
    public double getNum() {
        if (this.resultObject instanceof Double) {
            return (Double)this.resultObject;
        }
        return super.getNum();
    }

    public int getSuperType() {
        return super.getType();
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public Object getValue() {
        if (this.resultObject != null) {
            return this.resultObject;
        }
        if ((this.type == 1002 || this.type == 2002) && this.dti == null) {
            return this.token;
        }
        if (this.type == 3) {
            return this.getNum();
        }
        return this.dti;
    }

    public final PolyNode method(ProgressManager progressManager, PolyNode polyNode) throws MethodCallException {
        Object object;
        Object[] objectArray = null;
        if (polyNode != null) {
            objectArray = polyNode.getParam();
        }
        if (objectArray != null) {
            object = new LinkedList();
            for (Object object2 : objectArray) {
                if (object2 instanceof double[]) {
                    double[] dArray = (double[])object2;
                    Double[] doubleArray = new Double[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        doubleArray[i] = dArray[i];
                    }
                    object.add(doubleArray);
                    continue;
                }
                if (object2 == null || object2.equals("#")) continue;
                object.add(object2);
            }
            objectArray = object.toArray();
        }
        if ((object = this.runMethod(progressManager, this.dti, this.token, objectArray)) instanceof BasicTreeInterface) {
            this.dti = (BasicTreeInterface)object;
        } else if (object != null) {
            this.resultObject = object;
        }
        return this;
    }

    public PolyNode objIntervall(PolyNode polyNode) throws MethodCallException {
        this.objIntervall = polyNode.getParam();
        return this;
    }

    public void setDataTreeInterface(BasicTreeInterface basicTreeInterface) {
        this.dti = basicTreeInterface;
    }

    public void setResultObject(Object object) {
        this.resultObject = object;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public PolyNode transfer(PolyNode polyNode) {
        ScriptNode scriptNode = (ScriptNode)polyNode;
        if (this.type == 1002 || this.type == 2002 && this.dti == null) {
            scriptNode.setDataTreeInterface(new StringDataClass(this.token));
        } else {
            scriptNode.setDataTreeInterface(this.dti);
        }
        return polyNode;
    }

    @Override
    protected void createParam(List<Object> list) throws MethodCallException {
        if (this.objIntervall != null) {
            Properties properties = new Properties();
            for (Object object : this.objIntervall) {
                String string;
                int n;
                if (object instanceof Properties) {
                    properties.putAll((Map<?, ?>)((Properties)object));
                    continue;
                }
                if (object == null || (n = (string = object.toString()).indexOf("=")) < 0) continue;
                String string2 = string.substring(0, n);
                string2 = string2.toLowerCase();
                try {
                    String string3 = string.substring(n + 1);
                    properties.put(string2.trim(), string3.trim());
                }
                catch (Exception exception) {
                    throw new MethodCallException("Property " + string2 + " has no value");
                }
            }
            list.add(properties);
        } else if (this.objectArray != null) {
            list.add(this.objectArray);
        } else if (this.resultObject != null) {
            list.add(this.resultObject);
        } else {
            super.createParam(list);
        }
    }

    private Object runMethod(ProgressManager progressManager, BasicTreeInterface basicTreeInterface, String string, Object[] objectArray) throws MethodCallException {
        ScriptClass scriptClass = ScriptManager.getClass(basicTreeInterface);
        if (scriptClass != null) {
            return scriptClass.callMethod(progressManager, basicTreeInterface, string, objectArray);
        }
        return null;
    }
}

