/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.Lexikator;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.polynom.PolynomParser;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.script.ConditionNode;
import se.prediktera.map.main.script.ErrorNode;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ForEachNode;
import se.prediktera.map.main.script.MethodCallException;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptInformationException;
import se.prediktera.map.main.script.ScriptInterface;
import se.prediktera.map.main.script.ScriptLexikator;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.ScriptMethod;
import se.prediktera.map.main.script.ScriptNode;
import se.prediktera.map.main.script.ScriptPerformance;
import se.prediktera.map.main.script.StringDataClass;
import se.prediktera.map.main.script.VariableArrayNode;
import se.prediktera.map.main.script.VariableNode;
import se.prediktera.map.main.script.gui.MethodDescription;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;

public class ScriptParser
extends PolynomParser
implements ScriptInterface {
    private final ArrayList<VariableNode> variableList = new ArrayList();
    private ProgressManager pManager = null;
    private boolean throwException = false;
    private MethodDescription methodDescription;
    private final boolean createperformance = false;
    private final ScriptPerformance scriptPerformance = new ScriptPerformance();
    private final boolean showprint = false;

    public static void evaluateScriptStatic(ProgressManager progressManager, String string) throws PolynomException, MethodCallException, ScriptInformationException {
        ScriptParser scriptParser = new ScriptParser();
        scriptParser.evaluateScript(progressManager, string);
    }

    public static void main(String[] stringArray) {
        try {
            Evince.initNoShow();
            final StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("index = 1;");
            stringBuilder.append("while (index < 5)");
            stringBuilder.append("index = index + 1;");
            stringBuilder.append("end");
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    try {
                        ScriptParser.evaluateScriptStatic(this, stringBuilder.toString());
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                    return null;
                }
            };
            progressManagerImpl.invokeNow();
            System.exit(0);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public ScriptParser() {
    }

    public ScriptParser(boolean bl) {
        this();
    }

    public void addGlobalVariables(ScriptParser scriptParser) {
        ArrayList<VariableNode> arrayList = scriptParser.getVariableList();
        this.variableList.addAll(arrayList);
    }

    public VariableNode addVariable(VariableNode variableNode) {
        int n = this.variableList.indexOf(variableNode);
        if (n < 0) {
            this.variableList.add(variableNode);
            return variableNode;
        }
        return this.variableList.get(n);
    }

    public void addVariablesFromProperties(Properties properties) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String string = entry.getKey().toString();
            Object object = entry.getValue();
            String string2 = object.toString();
            if (string2.length() == 0) continue;
            VariableNode variableNode = this.addVariable(new VariableNode(string));
            if (string.endsWith("file") || string.endsWith("path")) {
                Object object2;
                int n = string2.indexOf("?");
                int n2 = -1;
                if (n > 0) {
                    object2 = string2.substring(n + 1);
                    string2 = string2.substring(0, n);
                    try {
                        n2 = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorHandler.logAndReportException(numberFormatException);
                    }
                }
                object2 = new FileDataClass(string2, n2);
                variableNode.setResultObject(object2);
                variableNode.setDataTreeInterface((BasicTreeInterface)object2);
                variableNode.setVariableClass(FileDataClass.class);
                continue;
            }
            try {
                if (string2.equalsIgnoreCase("true")) {
                    string2 = "1";
                } else if (string2.equalsIgnoreCase("false")) {
                    string2 = "0";
                }
                variableNode.setResultObject(Double.valueOf(string2));
                variableNode.setVariableClass(Double.class);
            }
            catch (NumberFormatException numberFormatException) {
                variableNode.setResultObject(object);
                variableNode.setVariableClass(String.class);
            }
        }
    }

    @Override
    public Lexikator createLexikator() {
        return new ScriptLexikator();
    }

    public ScriptPerformance evaluateScript(ProgressManager progressManager, String string) throws PolynomException, MethodCallException, ScriptInformationException {
        this.pManager = progressManager;
        if (progressManager != null) {
            progressManager.setArguments(new Object[]{this});
        }
        this.parseScript(string, true);
        this.executeFunction(this.root);
        this.pManager = null;
        return this.scriptPerformance;
    }

    @Override
    public final PolyNode executeFunction(PolyNode polyNode) throws MethodCallException, PolynomException, ScriptInformationException {
        if (polyNode != null) {
            switch (polyNode.getType()) {
                case 61: {
                    return ((ScriptNode)polyNode.getLeft()).assign(this.executeFunction(polyNode.getRight()));
                }
                case 43: {
                    return new ScriptNode(3, this.executeFunction(polyNode.getLeft()).getNum() + this.executeFunction(polyNode.getRight()).getNum());
                }
                case 45: {
                    return new ScriptNode(3, this.executeFunction(polyNode.getLeft()).getNum() - this.executeFunction(polyNode.getRight()).getNum());
                }
                case 46: {
                    ((ScriptNode)polyNode.getLeft()).transfer(polyNode.getRight());
                    return this.executeFunction(polyNode.getRight());
                }
                case 44: {
                    polyNode.setLeft(this.executeLeaf(polyNode.getLeft()));
                    polyNode.setRight(this.executeLeaf(polyNode.getRight()));
                    return polyNode;
                }
                case 123: {
                    return ((ScriptNode)polyNode).objIntervall(this.executeFunction(polyNode.getRight()));
                }
                case 91: {
                    return ((ScriptNode)polyNode).array(this.executeFunction(polyNode.getRight()));
                }
                case 58: {
                    return polyNode.interval(polyNode.getLeft(), polyNode.getRight());
                }
                case 64: {
                    return this.executeLeaf(((ScriptNode)this.executeFunction(polyNode.getLeft())).add(this.pManager, this.executeFunction(polyNode.getRight())));
                }
                case 2001: {
                    return ((ScriptNode)polyNode).method(this.pManager, this.executeFunction(polyNode.getRight()));
                }
                case 1002: 
                case 2002: 
                case 2003: 
                case 2004: {
                    return polyNode;
                }
                case 3001: {
                    if (this.executeFunction(((ConditionNode)polyNode).getNode()).getNum() != 0.0) {
                        this.executeFunction(polyNode.getLeft());
                    } else if (((ConditionNode)polyNode).getElseNode() != null) {
                        this.executeFunction(((ConditionNode)polyNode).getElseNode());
                    }
                    return this.executeFunction(polyNode.getRight());
                }
                case 3003: {
                    while (this.executeFunction(((ConditionNode)polyNode).getNode()).getNum() == 1.0) {
                        PolyNode polyNode2 = polyNode.getLeft();
                        PolyNode polyNode3 = (PolyNode)polyNode2.clone();
                        this.executeFunction(polyNode3);
                    }
                    return this.executeFunction(polyNode.getRight());
                }
                case 3004: 
                case 3008: 
                case 3009: {
                    final ForEachNode forEachNode = (ForEachNode)polyNode;
                    PolyNode polyNode4 = this.executeFunction(forEachNode.getExpr());
                    final Object[] objectArray = (Object[])polyNode4.getValue();
                    if (objectArray == null) {
                        throw new PolynomException("Foreach list is not created");
                    }
                    final VariableNode variableNode = forEachNode.getVarNode();
                    final int n = this.pManager.setGroupMaximumAndReset(objectArray.length);
                    if (polyNode.getType() == 3004) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            this.runForEach(forEachNode, i, objectArray, variableNode, n);
                        }
                    } else if (polyNode.getType() == 3008) {
                        Threader threader = new Threader(this){
                            final /* synthetic */ ScriptParser this$0;
                            {
                                this.this$0 = scriptParser;
                            }

                            @Override
                            protected void doOp(boolean bl, int n4, int n2) {
                                int n3 = n4;
                                while (n3 < objectArray.length) {
                                    try {
                                        this.this$0.runForEach(forEachNode, n3, objectArray, variableNode, n);
                                    }
                                    catch (Exception exception) {
                                        ErrorHandler.logAndReportException(exception);
                                    }
                                    ++n2;
                                }
                            }
                        };
                        threader.execute(objectArray.length);
                    }
                    this.pManager.showGroupProgressBar(false);
                    return this.executeFunction(polyNode.getRight());
                }
                case 3006: {
                    try {
                        this.executeFunction(polyNode.getLeft());
                    }
                    catch (Exception exception) {
                        VariableNode variableNode = this.addVariable(new VariableNode("exception"));
                        variableNode.setToken(exception.getMessage());
                    }
                    return this.executeFunction(polyNode.getRight());
                }
                case 4001: {
                    try {
                        long l = System.currentTimeMillis();
                        this.executeFunction(polyNode.getLeft());
                    }
                    catch (PolynomException | ScriptInformationException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                        throw new PolynomException(exception.getMessage(), ScriptEditorPanel.formatPolyNode(polyNode.getLeft()), exception);
                    }
                    this.executeFunction(polyNode.getRight());
                    return null;
                }
            }
            return new PolyNode(3, super.recExecute(polyNode));
        }
        return null;
    }

    public ScriptPerformance getPerformance() {
        return this.scriptPerformance;
    }

    @Override
    public PolyNode getRoot() {
        return this.root;
    }

    public VariableNode getVariable(String string) {
        VariableNode variableNode = new VariableNode(string);
        int n = this.variableList.indexOf(variableNode);
        if (n >= 0) {
            return this.variableList.get(n);
        }
        return null;
    }

    public PolyNode parseScript(String string) throws PolynomException {
        return this.parseScript(string, false);
    }

    public PolyNode parseScript(String string, boolean bl) throws PolynomException {
        this.throwException = bl;
        this.root = null;
        this.lexikator.setPolynom(string);
        this.curId = this.lexikator.getTokenID();
        this.root = this.block();
        return this.root;
    }

    public void setMethodDescription(MethodDescription methodDescription) {
        this.methodDescription = methodDescription;
    }

    public void setProgressManager(ProgressManager progressManager) {
        this.pManager = progressManager;
    }

    @Override
    protected PolyNode expression() throws PolynomException {
        PolyNode polyNode = this.string();
        while (true) {
            switch (this.curId) {
                case 61: {
                    break;
                }
                default: {
                    return polyNode;
                }
            }
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.string());
            this.checkVariableAssignment(polyNode);
        }
    }

    @Override
    protected PolyNode factor() throws PolynomException {
        int n = this.curId;
        String string = this.lexikator.getToken();
        switch (n) {
            case 40: {
                this.match(40);
                PolyNode polyNode = new PolyNode(null, 7, this.expression());
                this.match(41);
                return polyNode;
            }
            case 45: {
                this.match(45);
                return new PolyNode(null, 8, this.factor());
            }
            case 3: {
                PolyNode polyNode = new PolyNode(n, this.lexikator.getDouble());
                this.match(n);
                return polyNode;
            }
            case 11: {
                PolyNode polyNode = new PolyNode(3, Double.POSITIVE_INFINITY);
                this.match(n);
                return polyNode;
            }
            case 123: {
                this.match(n);
                ScriptNode scriptNode = new ScriptNode(null, n, string, this.parameters());
                this.match(125);
                return scriptNode;
            }
            case 91: {
                ScriptNode scriptNode;
                this.match(n);
                if (this.check(93)) {
                    ScriptNode scriptNode2 = new ScriptNode(3, "Empty");
                    scriptNode2.setResultObject(new Double[0]);
                    scriptNode = new ScriptNode(null, n, string, scriptNode2);
                } else {
                    scriptNode = new ScriptNode(null, n, string, this.parameters());
                }
                this.match(93);
                return scriptNode;
            }
            case 2001: {
                this.match(n);
                this.match(40);
                ScriptNode scriptNode = new ScriptNode(null, n, string, this.parameters());
                if (!scriptNode.hasError()) {
                    this.match(41);
                }
                return scriptNode;
            }
            case 2002: {
                this.match(n);
                VariableNode variableNode = this.addVariable(new VariableNode(string));
                return variableNode;
            }
            case 2003: {
                this.match(n);
                VariableNode variableNode = this.addVariable(new VariableArrayNode(string, null));
                return variableNode;
            }
            case 1002: {
                this.match(1002);
                string = this.checkForImplicitCharactors(string);
                return new ScriptNode(null, n, string, null);
            }
            case 1001: {
                this.match(1001);
                return new ScriptNode(null, n, string, null);
            }
            case 64: {
                this.match(64);
                return new ScriptNode(null, n, string, null);
            }
            case 34: 
            case 41: 
            case 59: {
                return null;
            }
            case 35: {
                this.match(n);
                return new ScriptNode(null, n, string, null);
            }
            case 2004: {
                this.match(n);
                return new ScriptNode(null, n, string, null);
            }
        }
        throw new PolynomException("Cannot recognize element: \"" + string + "\"");
    }

    protected PolyNode string() throws PolynomException {
        PolyNode polyNode = this.term();
        while (true) {
            switch (this.curId) {
                case 38: 
                case 43: 
                case 45: 
                case 64: 
                case 124: {
                    break;
                }
                default: {
                    return polyNode;
                }
            }
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.term());
        }
    }

    @Override
    protected PolyNode term() throws PolynomException {
        PolyNode polyNode = this.factor();
        while (true) {
            switch (this.curId) {
                case 37: 
                case 42: 
                case 46: 
                case 47: 
                case 58: 
                case 60: 
                case 62: 
                case 94: {
                    break;
                }
                default: {
                    return polyNode;
                }
            }
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.factor());
            this.checkMethod(polyNode);
        }
    }

    private PolyNode block() throws PolynomException {
        try {
            int n = this.curId;
            String string = this.lexikator.getToken();
            PolyNode polyNode = null;
            switch (n) {
                case 3001: 
                case 3003: {
                    this.match(n);
                    this.match(40);
                    PolyNode polyNode2 = this.expression();
                    this.match(41);
                    PolyNode polyNode3 = this.block();
                    if (n == 3001 && this.check(3002)) {
                        this.match(3002);
                        polyNode = this.block();
                    }
                    this.match(3005);
                    return new ConditionNode(polyNode2, polyNode3, polyNode, n, string, this.block());
                }
                case 3004: 
                case 3008: 
                case 3009: {
                    this.match(n);
                    this.match(40);
                    String string2 = this.lexikator.getToken();
                    this.match(2002);
                    VariableNode variableNode = this.addVariable(new VariableNode(string2));
                    this.match(58);
                    PolyNode polyNode4 = this.expression();
                    this.match(41);
                    variableNode.setVariableClass(this.checkMethod(polyNode4));
                    PolyNode polyNode5 = this.block();
                    this.match(3005);
                    return new ForEachNode(polyNode5, n, string, this.block(), variableNode, polyNode4);
                }
                case 3006: {
                    this.match(n);
                    PolyNode polyNode6 = this.block();
                    this.match(3007);
                    return new ScriptNode(polyNode6, n, string, this.block());
                }
                case 3002: 
                case 3005: 
                case 3007: {
                    return new ScriptNode(null, n, string, null);
                }
                case 0: {
                    return null;
                }
                case 1001: 
                case 2004: {
                    return new PolyNode(this.expression(), 4001, this.block());
                }
                case 6001: {
                    List<File> list;
                    File file;
                    this.match(n);
                    this.match(40);
                    string = this.lexikator.getToken();
                    if (string.equalsIgnoreCase("breeze") && (file = ScriptHelper.chooseFromList(list = ScriptHelper.getBreezeProperties())) != null) {
                        this.addVariablesFromProperties(ScriptHelper.loadProperties(file));
                    }
                    this.match(1002);
                    this.match(41);
                    this.match(59);
                    return new PolyNode(null, 4001, this.block());
                }
                case 5001: {
                    Object object;
                    Object object2;
                    this.match(n);
                    this.match(40);
                    Object object3 = this.lexikator.getToken();
                    if (((String)object3).contains(",")) {
                        try {
                            object2 = EvinceScriptCommands.showInputDialog(this.pManager, "option", "Select application", (String)object3);
                            object3 = object2.toString();
                            object = this.addVariable(new VariableNode("application"));
                            ((ScriptNode)object).setToken((String)object3);
                            object3 = "BreezeOutput" + (String)object3 + ".xml";
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndReportException(exception);
                        }
                    }
                    this.match(1002);
                    try {
                        object2 = ScriptManager.getScriptFileByName((String)object3);
                        object = ((ScriptFile)object2).getScript();
                        this.lexikator.insertString((String)object);
                    }
                    catch (Exception exception) {
                        throw new PolynomException(exception.getMessage());
                    }
                    this.match(41);
                    this.match(59);
                    return new PolyNode(this.expression(), 4001, this.block());
                }
            }
            PolyNode polyNode7 = this.expression();
            this.checkMethod(polyNode7);
            this.match(59);
            return new PolyNode(polyNode7, 4001, this.block());
        }
        catch (PolynomException polynomException) {
            String string = this.lexikator.getErrorToken();
            if (polynomException.hasErrorToken()) {
                string = polynomException.getErrorToken();
            }
            if (this.throwException) {
                polynomException.setErrorToken(string);
                throw polynomException;
            }
            this.curId = this.lexikator.getTokenID();
            return new ErrorNode(polynomException, 2, string, this.block());
        }
    }

    private String checkForImplicitCharactors(String string) {
        string = this.replace(string, "<BR>", "\n");
        string = this.replace(string, "<br>", "\n");
        string = this.replace(string, "%BR%", "\n");
        string = this.replace(string, "%br%", "\n");
        return this.replace(string, "%tab%", "\t");
    }

    private Class checkMethod(PolyNode polyNode) throws PolynomException {
        if (this.methodDescription == null) {
            return null;
        }
        PolyNode polyNode2 = null;
        VariableNode variableNode = null;
        Class clazz = null;
        if (polyNode != null && polyNode.getType() == 46 && polyNode.getLeft() instanceof VariableNode) {
            polyNode2 = polyNode.getRight();
            variableNode = (VariableNode)polyNode.getLeft();
            if (variableNode != null) {
                clazz = variableNode.getVariableClass();
            }
        } else {
            polyNode2 = polyNode;
        }
        if (polyNode2 != null && polyNode2.getType() == 2001) {
            String string = ((ScriptNode)polyNode2).getToken();
            ScriptMethod scriptMethod = ScriptManager.getScriptMethod(clazz, string);
            if (scriptMethod == null) {
                if (variableNode != null) {
                    if (variableNode.getVariableClass() == null) {
                        throw new PolynomException("Variable \"" + variableNode.getVariableName() + "\" has not been initiated", variableNode.getVariableName());
                    }
                    throw new PolynomException("Cannot found method \"" + string + "\" for variable \"" + variableNode.getVariableName() + "\"", string);
                }
                throw new PolynomException("Cannot found method \"" + string + "\"", string);
            }
            this.checkParameter(string, clazz, polyNode2.getRight());
            return scriptMethod.returnClass;
        }
        return StringDataClass.class;
    }

    private void checkParameter(String string, Class clazz, PolyNode polyNode) throws PolynomException {
        VariableNode variableNode;
        if (polyNode != null && polyNode.getType() == 44) {
            this.checkParameter(string, clazz, polyNode.getLeft());
            this.checkParameter(string, clazz, polyNode.getRight());
        } else if (polyNode instanceof VariableNode && (variableNode = (VariableNode)polyNode).getVariableClass() == null) {
            String string2 = variableNode.getVariableName();
            if (string2.equalsIgnoreCase("filename") || string2.equalsIgnoreCase("filepath") || string2.equalsIgnoreCase("modelfile") || this.methodDescription.hasOption(string, clazz, string2)) {
                throw new PolynomException(string, clazz, "Click to choose " + string2, string2);
            }
            if (string2.equalsIgnoreCase("variable")) {
                throw new PolynomException(string, clazz, "Click to choose " + string2, string2, this.getAssignedVariables());
            }
            throw new PolynomException("Variable \"" + string2 + "\" has not been initiated", string2);
        }
    }

    private void checkVariableAssignment(PolyNode polyNode) throws PolynomException {
        Object object;
        if (this.methodDescription == null) {
            return;
        }
        if (polyNode.getType() == 61 && (object = polyNode.getLeft()) instanceof VariableNode) {
            VariableNode variableNode = (VariableNode)object;
            object = this.checkMethod(polyNode.getRight());
            if (object == null) {
                throw new PolynomException("Variable \"" + variableNode.getVariableName() + "\" has nothing to be assigned to", variableNode.getVariableName());
            }
            variableNode.setVariableClass((Class)object);
        }
    }

    private PolyNode executeLeaf(PolyNode polyNode) throws MethodCallException, PolynomException, ScriptInformationException {
        if (polyNode.getType() == 46 || polyNode.getType() == 64 || polyNode.getType() == 43 || polyNode.getType() == 45 || polyNode.getType() == 42 || polyNode.getType() == 47) {
            polyNode = this.executeFunction(polyNode);
            polyNode.setLeft(null);
            polyNode.setRight(null);
        } else {
            this.executeFunction(polyNode);
        }
        return polyNode;
    }

    private List getAssignedVariables() {
        ArrayList<VariableNode> arrayList = new ArrayList<VariableNode>();
        for (VariableNode variableNode : this.variableList) {
            if (variableNode.getVariableClass() == null) continue;
            arrayList.add(variableNode);
        }
        return arrayList;
    }

    private ArrayList<VariableNode> getVariableList() {
        return this.variableList;
    }

    private PolyNode parameters() throws PolynomException {
        PolyNode polyNode = this.expression();
        while (this.curId == 44 || this.curId == 64) {
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.expression());
        }
        return polyNode;
    }

    private void println(Object object) {
    }

    private void printTree(PolyNode polyNode, int n) {
        if (polyNode != null) {
            this.printTree(polyNode.getLeft(), n + 1);
            for (int i = 0; i < n; ++i) {
                System.out.print(" ");
            }
            System.out.print("| ");
            System.out.print((char)polyNode.getType());
            if (polyNode.getValue() != null) {
                System.out.print("[" + polyNode.getValue().toString() + "]");
            }
            System.out.println("");
            this.printTree(polyNode.getRight(), n + 1);
        }
    }

    private String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string2.length();
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n != -1) {
            stringBuilder.append(cArray, n3, n - n3);
            stringBuilder.append(string3);
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        stringBuilder.append(cArray, n3, cArray.length - n3);
        return stringBuilder.toString();
    }

    private void runForEach(ForEachNode forEachNode, int n, Object[] objectArray, VariableNode variableNode, int n2) throws MethodCallException, PolynomException, ScriptInformationException {
        this.println("Looping index " + (n + 1) + " of " + objectArray.length);
        PolyNode polyNode = forEachNode.getLeft();
        PolyNode polyNode2 = (PolyNode)polyNode.clone();
        if (objectArray[n] instanceof DataTreeInterface) {
            variableNode.setDataTreeInterface((DataTreeInterface)objectArray[n]);
        } else if (objectArray[n] instanceof Double) {
            variableNode.setNum((Double)objectArray[n]);
            variableNode.setType(3);
        } else {
            variableNode.setToken(objectArray[n].toString());
        }
        this.executeFunction(polyNode2);
        this.pManager.incStepGroup(n2);
    }
}

