/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;

public class ScriptPerformance {
    private final List<Action> list = new ArrayList<Action>();

    public void add(String string, long l) {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory();
        long l4 = l3 - runtime.freeMemory();
        this.list.add(new Action(string, l, l2, l3, l4));
    }

    public void export(File file) {
        try {
            long l = 0L;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("Description;Time;Max Memory;Total Memory;Used Memory");
            bufferedWriter.newLine();
            for (Action action : this.list) {
                String string = action.scriptrow.replace(";", ":");
                bufferedWriter.write(string);
                bufferedWriter.write(";");
                bufferedWriter.write(String.valueOf(action.time));
                bufferedWriter.write(";");
                bufferedWriter.write(String.valueOf(action.max));
                bufferedWriter.write(";");
                bufferedWriter.write(String.valueOf(action.total));
                bufferedWriter.write(";");
                bufferedWriter.write(String.valueOf(action.used));
                bufferedWriter.newLine();
                if (string.contains("showinputdialog")) continue;
                l += action.time;
            }
            System.out.println("Script Performance:");
            bufferedWriter.write("size;");
            bufferedWriter.write(NiceDataFormat.toString(this.list.size()));
            System.out.println("Size: " + NiceDataFormat.toString(this.list.size()));
            bufferedWriter.newLine();
            bufferedWriter.write("total;");
            bufferedWriter.write(NiceDataFormat.toString(l));
            System.out.println("Total: " + NiceDataFormat.toString(l) + " ms");
            bufferedWriter.newLine();
            bufferedWriter.write("average;");
            bufferedWriter.write(NiceDataFormat.toString((double)l / (double)this.list.size()));
            System.out.println("Average: " + NiceDataFormat.toString((double)l / (double)this.list.size()) + " ms");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private static class Action {
        public String scriptrow;
        public long time;
        public double max;
        public double total;
        public double used;

        public Action(String string, long l, double d, double d2, double d3) {
            this.scriptrow = string;
            this.time = l;
            this.max = d / 1024.0 / 1024.0;
            this.total = d2 / 1024.0 / 1024.0;
            this.used = d3 / 1024.0 / 1024.0;
        }
    }
}

