/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.script.ScriptClass;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.doclet.ScriptDoclet;
import se.prediktera.map.main.script.gui.MethodHolder;

public class MethodDescription {
    private final HashMap<String, HashMap> hashMap;
    private Style boldStyle;
    private Style syntaxStyle;

    public MethodDescription() throws Exception {
        this(null);
    }

    public MethodDescription(JTextPane jTextPane) throws Exception {
        Object object;
        if (jTextPane != null) {
            object = (StyledDocument)jTextPane.getDocument();
            this.boldStyle = object.addStyle("Bold", null);
            StyleConstants.setBold(this.boldStyle, true);
            this.syntaxStyle = object.addStyle("Syntax", null);
            StyleConstants.setItalic(this.syntaxStyle, true);
        }
        object = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        InputStream inputStream = ScriptDoclet.class.getResourceAsStream("ScriptDoclet.xml");
        Document document = documentBuilder.parse(inputStream);
        this.hashMap = new HashMap();
        this.parseXMLNodes(this.hashMap, document.getChildNodes());
        inputStream.close();
    }

    public void addMethods(Vector<MethodHolder> vector, ScriptClass scriptClass, String string, Class clazz) {
        Method method;
        String string2 = scriptClass.getScriptName();
        HashMap hashMap = this.hashMap.get(string2);
        if (hashMap != null && (method = (Method)hashMap.get(string.toLowerCase())) != null) {
            List<String> list = method.syntaxList;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.add(new MethodHolder(string2, string, iterator.next()));
            }
        }
    }

    public void generateText(JTextPane jTextPane, String string, String string2) {
        try {
            Method method;
            HashMap hashMap = this.hashMap.get(string);
            if (hashMap != null && (method = (Method)hashMap.get(string2.toLowerCase())) != null) {
                jTextPane.setText("");
                StyledDocument styledDocument = (StyledDocument)jTextPane.getDocument();
                styledDocument.insertString(styledDocument.getLength(), "Description:\n", this.boldStyle);
                styledDocument.insertString(styledDocument.getLength(), method.description + "\n\n", null);
                List<String> list = method.syntaxList;
                styledDocument.insertString(styledDocument.getLength(), "Syntax:\n", this.boldStyle);
                Object object = list.iterator();
                while (object.hasNext()) {
                    styledDocument.insertString(styledDocument.getLength(), (String)object.next() + "\n", this.syntaxStyle);
                }
                object = method.optionList;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Option option = (Option)iterator.next();
                    styledDocument.insertString(styledDocument.getLength(), "\n" + option.name + "\n", this.boldStyle);
                    List<String> list2 = option.paramList;
                    Iterator<String> iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        styledDocument.insertString(styledDocument.getLength(), "  \u25cf  " + iterator2.next() + "\n", null);
                    }
                }
                jTextPane.setCaretPosition(0);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorHandler.logAndReportException(badLocationException);
        }
        jTextPane.setText("N/A");
    }

    public List getParameterList(String string, Class clazz, String string2) {
        Method method;
        ScriptClass scriptClass = ScriptManager.getClass(clazz);
        String string3 = scriptClass.getScriptName();
        HashMap hashMap = this.hashMap.get(string3);
        if (hashMap != null && string != null && (method = (Method)hashMap.get(string.toLowerCase())) != null) {
            string2 = string2.replace("_", " ");
            List<Option> list = method.optionList;
            for (Option option : list) {
                if (!option.name.equalsIgnoreCase(string2)) continue;
                return option.paramList;
            }
        }
        return null;
    }

    public boolean hasOption(String string, Class clazz, String string2) {
        return this.getParameterList(string, clazz, string2) != null;
    }

    private String getItem(Node node, String string) {
        List<Node> list = this.getItemList(node, string);
        if (!list.isEmpty() && list.get(0).getFirstChild() != null) {
            return list.get(0).getFirstChild().getNodeValue();
        }
        return "";
    }

    private List<Node> getItemList(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private void parseXMLNodes(HashMap<String, HashMap> hashMap, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("class")) {
                String string = this.getItem(node, "name");
                HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
                hashMap.put(string, hashMap2);
                List<Node> list = this.getItemList(node, "method");
                for (Node node2 : list) {
                    Method method = new Method();
                    method.name = this.getItem(node2, "name");
                    method.description = this.getItem(node2, "description");
                    method.example = this.getItem(node2, "example");
                    List<Node> list2 = this.getItemList(node2, "syntax");
                    for (Node node3 : list2) {
                        method.syntaxList.add(this.getItem(node3, "name"));
                    }
                    List<Node> list3 = this.getItemList(node2, "param");
                    Iterator object2 = list3.iterator();
                    while (object2.hasNext()) {
                        Node node4 = (Node)object2.next();
                        Option option = new Option();
                        option.name = this.getItem(node4, "name");
                        List<Node> list4 = this.getItemList(node4, "option");
                        for (Node node5 : list4) {
                            option.paramList.add(this.getItem(node5, "name"));
                        }
                        method.optionList.add(option);
                    }
                    hashMap2.put(method.name.toLowerCase(), method);
                }
                continue;
            }
            this.parseXMLNodes(hashMap, node.getChildNodes());
        }
    }

    private static class Method {
        public String name;
        public String description;
        public String example;
        public List<String> syntaxList = new ArrayList<String>();
        public List<Option> optionList = new ArrayList<Option>();

        private Method() {
        }
    }

    private static class Option {
        public String name;
        public List<String> paramList = new ArrayList<String>();

        private Option() {
        }
    }
}

