/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;
import se.prediktera.map.main.script.gui.ScriptEditorToolbar;
import se.prediktera.map.main.script.gui.ScriptFilePanel;
import se.prediktera.map.main.script.gui.ScriptStatusBar;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.main.window.EmptyWindow;

public class ScriptDesktopPanel
extends AbstractWindow_GUI {
    private final ScriptFilePanel scriptFilePanel;
    private final ScriptStatusBar scriptStatusBar = new ScriptStatusBar();
    private ScriptFile emtpyScript = null;

    public ScriptDesktopPanel(ScriptFilePanel scriptFilePanel, CMenu cMenu) {
        super(null, "Script Editor", cMenu);
        this.scriptFilePanel = scriptFilePanel;
        this.setAutoMode((byte)2);
        this.add((Component)this.scriptStatusBar, "South");
    }

    public void addEmptyScript() {
        this.emtpyScript = this.scriptFilePanel.newScript(false);
    }

    public void addScriptEditor(ScriptFile scriptFile, boolean bl) {
        ScriptEditorWindow scriptEditorWindow;
        String string;
        BaseInternalFrame baseInternalFrame;
        if (this.emtpyScript != null && (baseInternalFrame = this.getFrameFromScript(this.emtpyScript)) != null && (string = (scriptEditorWindow = (ScriptEditorWindow)baseInternalFrame.getFrameGUI()).getScriptEditor().getScript()).length() == 0) {
            this.removeScript(this.emtpyScript);
            this.emtpyScript = null;
        }
        if (bl) {
            SwingUtilities.invokeLater(() -> this.addWindow(new ScriptEditorWindow(scriptFile), false));
        } else {
            this.addWindow(new ScriptEditorWindow(scriptFile), false);
        }
    }

    @Override
    public DataContainer createWindowContainer() {
        return new DataContainer("Templates", 0);
    }

    @Override
    public AbstractWindow createWindowFromWizard(DataTreeInterface dataTreeInterface, WizardInfoInterface wizardInfoInterface) {
        return null;
    }

    @Override
    public void dataDropped(DataTreeInterface dataTreeInterface, int n) {
    }

    @Override
    public void DataTreeSelected(DataTreeInterface dataTreeInterface) {
    }

    @Override
    public String getAreaName() {
        return "Templates";
    }

    @Override
    public String getGUI_Name() {
        return "Script Editor";
    }

    public ScriptEditorPanel getSelectedScriptEditor() {
        AbstractWindow abstractWindow = this.getSelectedWindow();
        if (abstractWindow instanceof ScriptEditorWindow) {
            return ((ScriptEditorWindow)abstractWindow).scriptEditorPanel;
        }
        return null;
    }

    @Override
    public String getTitle(AbstractWindow abstractWindow) {
        return null;
    }

    @Override
    public ImageIcon getWindowIcon() {
        return null;
    }

    public boolean hasScriptFile(ScriptFile scriptFile) {
        return this.getFrameFromScript(scriptFile) != null;
    }

    public void removeScript(ScriptFile scriptFile) {
        BaseInternalFrame baseInternalFrame = this.getFrameFromScript(scriptFile);
        this.removeWindow(baseInternalFrame);
    }

    @Override
    public void selectedWindowUpdated(AbstractWindow abstractWindow, boolean bl) {
        if (this.project_GUI != null) {
            this.guiSelected();
        }
        ScriptEditorWindow scriptEditorWindow = (ScriptEditorWindow)abstractWindow;
        this.scriptFilePanel.setScriptFile(scriptEditorWindow.getScriptEditor(), scriptEditorWindow.getScriptFile());
        BaseInternalFrame baseInternalFrame = null;
        if (abstractWindow == null) {
            if (this.project_GUI == null) {
                return;
            }
            abstractWindow = this.project_GUI.getEmptyWindow();
        } else {
            if (abstractWindow instanceof AbstractControlTable) {
                abstractWindow = ((AbstractControlTable)abstractWindow).getDataSetTable();
            }
            baseInternalFrame = abstractWindow.getAssociatedFrame();
        }
        boolean bl2 = abstractWindow instanceof EmptyWindow;
        if (!(bl2 || baseInternalFrame != null && baseInternalFrame.getLayer() <= 0)) {
            return;
        }
        if (!bl && abstractWindow == this.getCurrentWindow()) {
            if (abstractWindow != null) {
                this.setWindowProperties(abstractWindow.getSettingsPanel(), !bl2);
            }
            return;
        }
        this.windowSpecificToolBar.removeAll();
        if (this.menu != null) {
            this.menu.removeAll();
            this.setWindowMenu(this.menu, this.windowToolbar);
        }
        if (baseInternalFrame != null || bl2) {
            this.currentWindow = abstractWindow;
            this.windowToolbarsVector.clear();
            String string = this.getTitle(null);
            string = this.getTitle(abstractWindow);
            this.setSettingsToolbar(abstractWindow.getSettingsToolbar());
            this.desktop.getWindowToolbar().updateWindow(abstractWindow);
            abstractWindow.getToolbars(this.windowToolbarsVector);
            for (JToolBar jToolBar : this.windowToolbarsVector) {
                if (jToolBar.isVisible()) {
                    this.windowSpecificToolBar.add(jToolBar);
                }
                this.setWindowMenu(this.menu, jToolBar);
                this.windowSpecificToolBar.revalidate();
                this.northTitle.setText(string);
                this.setWindowProperties(abstractWindow.getSettingsPanel(), !bl2);
            }
        }
        if (this.centerPanel != null) {
            this.centerPanel.repaint();
        }
        if (this.northTitle != null) {
            this.northTitle.repaint();
        }
    }

    public void showScriptEditor(ScriptFile scriptFile) {
        BaseInternalFrame baseInternalFrame = this.getFrameFromScript(scriptFile);
        if (baseInternalFrame != null) {
            this.selectWindow((ScriptEditorWindow)baseInternalFrame.getFrameGUI());
        }
    }

    @Override
    protected boolean supportVersion(long l) {
        return false;
    }

    private BaseInternalFrame getFrameFromScript(ScriptFile scriptFile) {
        JInternalFrame[] jInternalFrameArray;
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.desktop.getAllFrames()) {
            AbstractGUI abstractGUI;
            if (!(jInternalFrame instanceof BaseInternalFrame) || !((abstractGUI = ((BaseInternalFrame)jInternalFrame).getFrameGUI()) instanceof ScriptEditorWindow) || !scriptFile.equals(((ScriptEditorWindow)abstractGUI).getScriptFile())) continue;
            return (BaseInternalFrame)jInternalFrame;
        }
        return null;
    }

    class ScriptEditorWindow
    extends AbstractWindow {
        private final ImageIcon icon;
        private final ScriptEditorPanel scriptEditorPanel;
        private final ScriptEditorToolbar toolbar;
        private final ScriptFile scriptFile;

        public ScriptEditorWindow(ScriptFile scriptFile) {
            super("", (AbstractInit)null);
            this.icon = AbstractPaint.createIcon(11, 16);
            this.scriptEditorPanel = new ScriptEditorPanel();
            this.toolbar = this.scriptEditorPanel.createToolbar();
            this.scriptFile = scriptFile;
            this.setLayout(new BorderLayout());
            this.add((Component)this.scriptEditorPanel, "Center");
            this.scriptEditorPanel.setStatusBar(ScriptDesktopPanel.this.scriptStatusBar);
            this.scriptEditorPanel.setScript(scriptFile.getScript(), scriptFile.getType());
        }

        @Override
        public boolean doInteraction(InteractionInterface interactionInterface) {
            return false;
        }

        @Override
        public void finishInteraction() {
        }

        @Override
        public String getGUI_Name() {
            return this.scriptFile.getFilename();
        }

        @Override
        public ImageIcon getIcon(byte by) {
            return this.icon;
        }

        @Override
        public String getInformation() {
            return null;
        }

        public InteractionArray getInteractionArray(int n) {
            return null;
        }

        @Override
        public byte getNodeType() {
            return 0;
        }

        public ScriptEditorPanel getScriptEditor() {
            return this.scriptEditorPanel;
        }

        public ScriptFile getScriptFile() {
            return this.scriptFile;
        }

        @Override
        public void getToolbars(Vector<JToolBar> vector) {
            vector.add(this.toolbar);
        }

        @Override
        public byte getTreeType() {
            return 0;
        }

        @Override
        public void prepareInteraction() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            return 0;
        }

        @Override
        public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        }

        @Override
        public String toString() {
            return this.scriptFile.getFilename();
        }

        @Override
        protected void cleanUpChild() {
            this.checkAndSaveScript();
            super.cleanUpChild();
            if (ScriptDesktopPanel.this.getWindowContainer().getTreeNodeCount() == 0) {
                ScriptDesktopPanel.this.scriptFilePanel.setScriptFile(null, null);
                ScriptDesktopPanel.this.menu.removeAll();
                ScriptDesktopPanel.this.setWindowMenu(ScriptDesktopPanel.this.menu, ScriptDesktopPanel.this.windowToolbar);
                ScriptDesktopPanel.this.windowSpecificToolBar.removeAll();
                ScriptDesktopPanel.this.windowSpecificToolBar.invalidate();
                ScriptDesktopPanel.this.windowSpecificToolBar.repaint();
            }
        }

        @Override
        protected AbstractWindowProperties createProperties() {
            return null;
        }

        @Override
        protected String getDefaultTitle() {
            return "Test";
        }

        @Override
        protected AbstractInit loadInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
            return null;
        }

        private void checkAndSaveScript() {
            int n;
            String string = this.scriptEditorPanel.getScript();
            if (this.scriptFile.getStatus() != 2 && !string.equalsIgnoreCase(this.scriptFile.getScript()) && (n = JOptionPane.showConfirmDialog(this, "The script \"" + this.getGUI_Name() + "\" has changed. Do you want to save changes?", "Save changes", 0, 3)) == 0) {
                this.scriptFile.setScript(this.scriptEditorPanel.getScript());
                ScriptDesktopPanel.this.scriptFilePanel.saveScript(this.scriptFile);
            }
        }
    }
}

