/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.script.ConditionNode;
import se.prediktera.map.main.script.ErrorNode;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ForEachNode;
import se.prediktera.map.main.script.ScriptClass;
import se.prediktera.map.main.script.ScriptInterface;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.ScriptMethod;
import se.prediktera.map.main.script.ScriptNode;
import se.prediktera.map.main.script.ScriptParser;
import se.prediktera.map.main.script.VariableNode;
import se.prediktera.map.main.script.gui.MethodDescription;
import se.prediktera.map.main.script.gui.MethodHolder;
import se.prediktera.map.main.script.gui.ScriptEditorToolbar;
import se.prediktera.map.main.script.gui.ScriptStatusBar;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class ScriptEditorPanel
extends JPanel
implements ScriptInterface {
    private static ScriptEditorPanel staticeditor = new ScriptEditorPanel(false);
    private JScrollPane jScrollPane1;
    private JTextPane scriptTextArea;
    private ScriptStatusBar scriptStatusBar;
    private JTextPane pane;
    private Style noneStyle;
    private Style variableStyle;
    private Style stringStyle;
    private Style commentStyle;
    private Style tagStyle;
    private Style statementStyle;
    private Style errorStyle;
    private Style chooseStyle;
    private Timer highlightTimer;
    private boolean ishighlighting = false;
    private ScriptEditorToolbar toolbar = null;
    private LineNr linePanel = null;
    private MethodDescription methodDescription = null;
    private String scriptUppercase;
    private String type;
    private final ArrayList<ErrorHolder> errorList = new ArrayList();

    public static String formatPolyNode(PolyNode polyNode) {
        try {
            staticeditor.getScriptTextArea().setText("");
            StyledDocument styledDocument = (StyledDocument)staticeditor.getDocument();
            ScriptEditorPanel.staticeditor.ishighlighting = true;
            staticeditor.writeFunction(styledDocument, polyNode, 0);
            ScriptEditorPanel.staticeditor.ishighlighting = false;
            return staticeditor.getScript();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return "Error";
        }
    }

    public ScriptEditorPanel() {
        this(true);
    }

    public ScriptEditorPanel(boolean bl) {
        this.initComponents();
        this.highlightTimer = new Timer(1000, actionEvent -> this.highlight());
        this.highlightTimer.setRepeats(false);
        try {
            if (bl) {
                Evince.initNoShow();
            }
            this.pane = new JTextPane(){

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    Container container = this.getParent();
                    TextUI textUI = this.getUI();
                    return container != null ? textUI.getPreferredSize((JComponent)this).width <= container.getSize().width : true;
                }
            };
            this.methodDescription = new MethodDescription(this.pane);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public JPanel createLineNr() {
        this.linePanel = new LineNr(this.jScrollPane1, this.scriptTextArea);
        return this.linePanel;
    }

    public ScriptStatusBar createStatusbar() {
        this.scriptStatusBar = new ScriptStatusBar();
        return this.scriptStatusBar;
    }

    public ScriptEditorToolbar createToolbar() {
        this.toolbar = new ScriptEditorToolbar(this);
        return this.toolbar;
    }

    public boolean format() {
        boolean bl = false;
        try {
            this.ishighlighting = true;
            String string = this.scriptTextArea.getText();
            StyledDocument styledDocument = (StyledDocument)this.scriptTextArea.getDocument();
            PolyNode polyNode = this.parseScript(string).getRoot();
            boolean bl2 = bl = polyNode == null || polyNode.hasError();
            if (!bl) {
                this.scriptTextArea.setText("");
                this.writeFunction(styledDocument, polyNode, 0);
                this.scriptTextArea.setCaretPosition(0);
                this.errorList.clear();
                if (this.scriptStatusBar != null) {
                    this.scriptStatusBar.setErrorList(this.errorList);
                }
                if (this.toolbar != null) {
                    this.toolbar.updateState(this.type, polyNode);
                }
            }
            this.ishighlighting = false;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return bl;
    }

    public Document getDocument() {
        return this.scriptTextArea.getDocument();
    }

    public String getScript() {
        return this.scriptTextArea.getText();
    }

    public JTextPane getScriptTextArea() {
        return this.scriptTextArea;
    }

    public void highlight() {
        if (this.ishighlighting) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.ishighlighting) {
                return;
            }
            this.ishighlighting = true;
            try {
                Thread.sleep(200L);
                int n = this.scriptTextArea.getCaretPosition();
                String string = this.scriptTextArea.getText();
                string = string.replace("\r", "");
                this.scriptTextArea.setText(string == null ? "" : string);
                this.scriptTextArea.setCaretPosition(n);
                StyledDocument styledDocument = (StyledDocument)this.scriptTextArea.getDocument();
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.noneStyle, true);
                this.errorList.clear();
                try {
                    PolyNode polyNode = this.parseScript(string).getRoot();
                    this.scriptUppercase = string.toUpperCase();
                    this.highlightFunction(styledDocument, 0, polyNode);
                    if (this.toolbar != null) {
                        this.toolbar.updateState(this.type, polyNode);
                    }
                }
                catch (PolynomException polynomException) {
                    // empty catch block
                }
                if (this.scriptStatusBar != null) {
                    this.scriptStatusBar.setErrorList(this.errorList);
                }
                if (this.linePanel != null) {
                    this.linePanel.repaint();
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
            this.ishighlighting = false;
        });
    }

    public boolean isHighLighting() {
        return this.ishighlighting;
    }

    public String search(String string) {
        int n = this.scriptTextArea.getCaretPosition();
        if (string == null) {
            string = JOptionPane.showInputDialog(this, "Find:", "Find", 3);
            if (string != null && string.length() == 0) {
                string = null;
            }
            n = 0;
        }
        if (string != null) {
            string = string.toLowerCase();
            String string2 = this.scriptTextArea.getText().toLowerCase();
            int n2 = (string2 = string2.substring(n)).indexOf(string);
            if (n2 >= 0) {
                this.scriptTextArea.select(n + n2, n + n2 + string.length());
            } else if (n > 0 && (n2 = (string2 = this.scriptTextArea.getText().toLowerCase()).indexOf(string)) >= 0) {
                this.scriptTextArea.select(n2, n2 + string.length());
            }
        }
        return string;
    }

    public void setHighLighting(boolean bl) {
        this.ishighlighting = bl;
    }

    public void setScript(String string, String string2) {
        this.type = string2;
        this.ishighlighting = true;
        this.scriptTextArea.setText(string.replace("\r", ""));
        boolean bl = this.format();
        this.ishighlighting = false;
        if (bl) {
            this.highlight();
        }
    }

    public void setStatusBar(ScriptStatusBar scriptStatusBar) {
        this.scriptStatusBar = scriptStatusBar;
    }

    public void setType(String string) {
        this.type = string;
        this.highlight();
    }

    private void addLevel(StyledDocument styledDocument, int n) throws BadLocationException {
        this.addStr(styledDocument, "", null, n);
    }

    private void addStr(StyledDocument styledDocument, String string) throws BadLocationException {
        this.addStr(styledDocument, string, null, 0);
    }

    private void addStr(StyledDocument styledDocument, String string, Style style) throws BadLocationException {
        this.addStr(styledDocument, string, style, 0);
    }

    private void addStr(StyledDocument styledDocument, String string, Style style, int n) throws BadLocationException {
        for (int i = 0; i < n; ++i) {
            styledDocument.insertString(styledDocument.getLength(), "  ", null);
        }
        styledDocument.insertString(styledDocument.getLength(), string, style);
    }

    private int countRows(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private void createOptionPopup(List list, Point point, boolean bl) {
        if (list != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JMenuItem jMenuItem = new JMenuItem(iterator.next().toString().toLowerCase());
                jMenuItem.addActionListener(actionEvent -> {
                    String string = jMenuItem.getText();
                    string = EvinceScriptCommands.removeSpace(string).toLowerCase();
                    if (bl) {
                        this.scriptTextArea.replaceSelection("\"" + string + "\"");
                    } else {
                        this.scriptTextArea.replaceSelection(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(this.scriptTextArea, point.x, point.y);
        }
    }

    private ErrorHolder getErrorHolderAt(Point point) {
        int n;
        if (this.scriptTextArea.getText() != null && (n = this.scriptTextArea.viewToModel2D(point)) >= 0) {
            for (ErrorHolder errorHolder : this.errorList) {
                if (n < errorHolder.index || n > errorHolder.index + errorHolder.length) continue;
                return errorHolder;
            }
        }
        return null;
    }

    private ErrorNode getErrorNodeAt(Point point) {
        ErrorHolder errorHolder = this.getErrorHolderAt(point);
        if (errorHolder != null) {
            return errorHolder.errorNode;
        }
        return null;
    }

    private boolean hasMoreLeftNodes(PolyNode polyNode) {
        return polyNode.getLeft() != null || polyNode.getRight() != null && this.hasMoreLeftNodes(polyNode.getRight());
    }

    private int highlightFunction(StyledDocument styledDocument, int n, PolyNode polyNode) throws Exception {
        if (polyNode != null) {
            if (polyNode.getType() < 2000) {
                n = this.highlightFunction(styledDocument, n, polyNode.getLeft());
            }
            Object object = null;
            String string = null;
            switch (polyNode.getType()) {
                case 2002: 
                case 2003: {
                    object = ((VariableNode)polyNode).getVariableName().toUpperCase();
                    string = "Variable";
                    break;
                }
                case 1002: {
                    object = "\"" + ((ScriptNode)polyNode).getToken().toUpperCase() + "\"";
                    string = "String";
                    break;
                }
                case 1001: {
                    object = "/*" + ((ScriptNode)polyNode).getToken().toUpperCase() + "*/";
                    ((String)object).replace("\r", "");
                    string = "Comment";
                    break;
                }
                case 2004: {
                    object = ((ScriptNode)polyNode).getToken().toUpperCase();
                    string = "Tag";
                    break;
                }
                case 2: {
                    ErrorNode errorNode = (ErrorNode)polyNode;
                    object = errorNode.getToken().toUpperCase();
                    if (errorNode.isParameterType()) {
                        string = "Choose";
                        break;
                    }
                    string = "Error";
                    break;
                }
                case 3001: 
                case 3002: 
                case 3003: 
                case 3004: 
                case 3005: {
                    object = ((ScriptNode)polyNode).getToken().toUpperCase();
                    string = "Statement";
                }
            }
            if (object != null && string != null && n < styledDocument.getLength()) {
                try {
                    int n2 = this.scriptUppercase.indexOf((String)object, n);
                    if (n2 >= 0) {
                        if (string.equals("Error") || string.equals("Choose")) {
                            int n3 = this.countRows(styledDocument.getText(0, n2));
                            this.errorList.add(new ErrorHolder((ErrorNode)polyNode, n2, ((String)object).length(), n3));
                        }
                        styledDocument.setCharacterAttributes(n2, ((String)object).length(), styledDocument.getStyle(string), true);
                        n = n2 + ((String)object).length();
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
            if (polyNode.getType() >= 2000) {
                if (polyNode instanceof ConditionNode) {
                    n = this.highlightFunction(styledDocument, n, ((ConditionNode)polyNode).getNode());
                }
                n = this.highlightFunction(styledDocument, n, polyNode.getLeft());
            }
            return this.highlightFunction(styledDocument, n, polyNode.getRight());
        }
        return n;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.scriptTextArea = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container container = this.getParent();
                TextUI textUI = this.getUI();
                return container != null ? textUI.getPreferredSize((JComponent)this).width <= container.getSize().width : true;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                ErrorNode errorNode = ScriptEditorPanel.this.getErrorNodeAt(mouseEvent.getPoint());
                if (errorNode != null) {
                    return errorNode.getErrorMessage();
                }
                return null;
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (ScriptEditorPanel.this.linePanel != null) {
                    ScriptEditorPanel.this.linePanel.repaint();
                }
            }
        };
        this.scriptTextArea.addCaretListener(caretEvent -> {
            Element element = this.getDocument().getDefaultRootElement();
            int n = element.getElementIndex(caretEvent.getDot());
            Element element2 = element.getElement(n);
            int n2 = 0;
            if (element2 != null) {
                n2 = element2.getStartOffset();
            }
            if (this.scriptStatusBar != null) {
                this.scriptStatusBar.setRowCol(n + 1, caretEvent.getDot() - n2 + 1);
            }
        });
        this.scriptTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ScriptEditorPanel.this.toolbar.addToPopup(jPopupMenu);
                    jPopupMenu.show(ScriptEditorPanel.this.scriptTextArea, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ErrorHolder errorHolder = ScriptEditorPanel.this.getErrorHolderAt(mouseEvent.getPoint());
                    if (errorHolder != null && errorHolder.errorNode != null) {
                        ScriptEditorPanel.this.scriptTextArea.select(errorHolder.index, errorHolder.index + errorHolder.length);
                        ErrorNode errorNode = errorHolder.errorNode;
                        String string = errorNode.getToken();
                        if (string.equalsIgnoreCase("filename")) {
                            jopensaveDialog jopensaveDialog2 = ImportHelper.createFileDialog("Choose filename", null);
                            if (jopensaveDialog2.openshow()) {
                                ScriptEditorPanel.this.scriptTextArea.replaceSelection("\"" + jopensaveDialog2.getSelectedFile().getAbsolutePath() + "\"");
                            }
                        } else if (string.equalsIgnoreCase("filepath")) {
                            jopensaveDialog jopensaveDialog3 = new jopensaveDialog("Select file path", ScriptEditorPanel.this);
                            jopensaveDialog3.setDialogType(1);
                            if (jopensaveDialog3.openshow()) {
                                ScriptEditorPanel.this.scriptTextArea.replaceSelection("\"" + jopensaveDialog3.getSelectedFile().getAbsolutePath() + "\"");
                            }
                        } else if (string.equalsIgnoreCase("modelfile")) {
                            jopensaveDialog jopensaveDialog4 = ImportHelper.createModelDialog("Choose model file", null, false);
                            if (jopensaveDialog4.openshow()) {
                                ScriptEditorPanel.this.scriptTextArea.replaceSelection("\"" + jopensaveDialog4.getSelectedFile().getAbsolutePath() + "\"");
                            }
                        } else if (string.equalsIgnoreCase("variable")) {
                            ScriptEditorPanel.this.createOptionPopup(errorNode.getOptionList(), mouseEvent.getPoint(), false);
                        } else if (!string.equalsIgnoreCase("components_number")) {
                            List list = ScriptEditorPanel.this.methodDescription.getParameterList(errorNode.getMethodName(), errorNode.getVariableClass(), errorNode.getToken());
                            ScriptEditorPanel.this.createOptionPopup(list, mouseEvent.getPoint(), true);
                        }
                    }
                }
            }
        });
        this.scriptTextArea.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ErrorNode errorNode = ScriptEditorPanel.this.getErrorNodeAt(mouseEvent.getPoint());
                if (errorNode != null && errorNode.isParameterType()) {
                    ScriptEditorPanel.this.scriptTextArea.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    ScriptEditorPanel.this.scriptTextArea.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.scriptTextArea);
        Font font = new Font("Courier", 0, 12);
        this.scriptTextArea.setFont(font);
        StyledDocument styledDocument = (StyledDocument)this.scriptTextArea.getDocument();
        ScriptDocumentListener scriptDocumentListener = new ScriptDocumentListener();
        this.scriptTextArea.addKeyListener(scriptDocumentListener);
        styledDocument.addDocumentListener(scriptDocumentListener);
        this.noneStyle = styledDocument.addStyle("None", null);
        this.variableStyle = styledDocument.addStyle("Variable", null);
        StyleConstants.setForeground(this.variableStyle, Color.blue);
        StyleConstants.setItalic(this.variableStyle, true);
        this.stringStyle = styledDocument.addStyle("String", null);
        StyleConstants.setForeground(this.stringStyle, Color.blue);
        this.commentStyle = styledDocument.addStyle("Comment", null);
        StyleConstants.setForeground(this.commentStyle, Color.green.darker());
        this.tagStyle = styledDocument.addStyle("Tag", null);
        StyleConstants.setForeground(this.tagStyle, Color.lightGray);
        StyleConstants.setItalic(this.tagStyle, true);
        this.statementStyle = styledDocument.addStyle("Statement", null);
        StyleConstants.setForeground(this.statementStyle, Color.magenta);
        StyleConstants.setBold(this.statementStyle, true);
        this.errorStyle = styledDocument.addStyle("Error", null);
        StyleConstants.setForeground(this.errorStyle, Color.red);
        StyleConstants.setUnderline(this.errorStyle, true);
        this.chooseStyle = styledDocument.addStyle("Choose", null);
        StyleConstants.setForeground(this.chooseStyle, Color.red);
        StyleConstants.setBold(this.chooseStyle, true);
        StyleConstants.setUnderline(this.chooseStyle, true);
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.scriptTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private boolean onlyComment(PolyNode polyNode) {
        return polyNode.getType() == 1001 && polyNode.getLeft() == null && polyNode.getRight() == null;
    }

    private ScriptParser parseScript(String string) throws PolynomException {
        ScriptParser scriptParser = new ScriptParser();
        if (this.type != null) {
            if (this.type.equalsIgnoreCase("plot")) {
                scriptParser.addVariable(new VariableNode("plot", AbstractPlotLayout.class));
            } else if (this.type.equalsIgnoreCase("table") || this.type.equalsIgnoreCase("dataset")) {
                scriptParser.addVariable(new VariableNode("dataset", DataSet.class));
            } else if (this.type.equalsIgnoreCase("model")) {
                scriptParser.addVariable(new VariableNode("model", AbstractModel.class));
            } else if (this.type.equalsIgnoreCase("prediction")) {
                scriptParser.addVariable(new VariableNode("prediction", AbstractPrediction.class));
            } else if (this.type.equalsIgnoreCase("import")) {
                scriptParser.addVariable(new VariableNode("dataset", DataSet.class));
            }
        }
        scriptParser.setMethodDescription(this.methodDescription);
        scriptParser.parseScript(string);
        return scriptParser;
    }

    private void showInsightPopup(boolean bl, Point point) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Class clazz = null;
        int n = this.scriptTextArea.viewToModel2D(point);
        if (bl && n >= 0) {
            int n2;
            object4 = this.scriptTextArea.getText();
            for (n2 = n - 1; n2 > 0 && ((String)object4).charAt(n2 - 1) != ' ' && ((String)object4).charAt(n2 - 1) != '\n' && ((String)object4).charAt(n2 - 1) != '\r' && ((String)object4).charAt(n2 - 1) != ',' && ((String)object4).charAt(n2 - 1) != '(' && ((String)object4).charAt(n2 - 1) != '@'; --n2) {
            }
            if (n2 >= 0 && n2 < ((String)object4).length()) {
                object3 = ((String)object4).substring(n2, n);
                try {
                    object2 = this.parseScript((String)object4);
                    object = ((ScriptParser)object2).getVariable((String)object3);
                    if (object != null) {
                        clazz = ((VariableNode)object).getVariableClass();
                    }
                }
                catch (PolynomException polynomException) {
                    ErrorHandler.logAndReportException(polynomException);
                }
            }
        }
        if (bl && clazz == null) {
            return;
        }
        object4 = ScriptManager.getClass(clazz);
        HashMap<String, ScriptMethod> hashMap = ((ScriptClass)object4).getMethods();
        object3 = hashMap.entrySet().iterator();
        object2 = new JPopupMenu();
        object = new JScrollPane();
        JList<Object> jList = new JList<Object>();
        jList.setCellRenderer(new TemplateListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        this.pane.setMinimumSize(new Dimension(400, 250));
        this.pane.setPreferredSize(new Dimension(400, 250));
        this.pane.setBackground(new Color(255, 255, 225));
        this.pane.setEditable(false);
        Vector<MethodHolder> vector = new Vector<MethodHolder>();
        ((Container)object2).setLayout(new BorderLayout());
        while (object3.hasNext()) {
            Map.Entry entry = (Map.Entry)object3.next();
            ScriptMethod scriptMethod = (ScriptMethod)entry.getValue();
            this.methodDescription.addMethods(vector, (ScriptClass)object4, scriptMethod.realName, clazz);
        }
        if (vector.isEmpty()) {
            return;
        }
        Collections.sort(vector);
        jList.setListData(vector);
        jList.setSelectedIndex(0);
        jList.addListSelectionListener(listSelectionEvent -> {
            int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
            MethodHolder methodHolder = (MethodHolder)vector.get(n);
            this.methodDescription.generateText(this.pane, methodHolder.c, methodHolder.method);
        });
        jList.addMouseListener(new MouseAdapter(this, (JPopupMenu)object2){
            final /* synthetic */ JPopupMenu val$popupMenu;
            final /* synthetic */ ScriptEditorPanel this$0;
            {
                this.val$popupMenu = jPopupMenu;
                this.this$0 = scriptEditorPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MethodHolder methodHolder = (MethodHolder)((JList)mouseEvent.getSource()).getSelectedValue();
                    this.this$0.scriptTextArea.replaceSelection(methodHolder.fullmethod + ";");
                    this.val$popupMenu.setVisible(false);
                }
            }
        });
        jList.addKeyListener(new KeyAdapter(this, (JPopupMenu)object2){
            final /* synthetic */ JPopupMenu val$popupMenu;
            final /* synthetic */ ScriptEditorPanel this$0;
            {
                this.val$popupMenu = jPopupMenu;
                this.this$0 = scriptEditorPanel;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MethodHolder methodHolder = (MethodHolder)((JList)keyEvent.getSource()).getSelectedValue();
                    this.this$0.scriptTextArea.replaceSelection(methodHolder.fullmethod + ";");
                    this.val$popupMenu.setVisible(false);
                } else if (keyEvent.getKeyCode() == 27) {
                    this.val$popupMenu.setVisible(false);
                }
            }
        });
        ((JScrollPane)object).setViewportView(jList);
        ((Container)object2).add((Component)object, "West");
        this.pane.setText("");
        jScrollPane.setViewportView(this.pane);
        ((Container)object2).add((Component)jScrollPane, "Center");
        SwingUtilities.invokeLater(() -> {
            jList.requestFocus();
            int n = jList.getSelectedIndex();
            if (n >= 0) {
                MethodHolder methodHolder = (MethodHolder)vector.get(n);
                this.methodDescription.generateText(this.pane, methodHolder.c, methodHolder.method);
            }
        });
        ((JPopupMenu)object2).show(this.scriptTextArea, point.x + 5, point.y + 12);
    }

    private void writeFunction(StyledDocument styledDocument, PolyNode polyNode, int n) throws Exception {
        if (polyNode != null) {
            ConditionNode conditionNode = null;
            switch (polyNode.getType()) {
                case 61: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, " = ");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 46: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, ".");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 44: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, ", ");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 123: {
                    this.addStr(styledDocument, "{");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    this.addStr(styledDocument, "}");
                    break;
                }
                case 91: {
                    this.addStr(styledDocument, "[");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    this.addStr(styledDocument, "]");
                    break;
                }
                case 64: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, " @ ");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 35: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, " # ");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 2001: {
                    this.addStr(styledDocument, ((ScriptNode)polyNode).getToken().toLowerCase(), null);
                    this.addStr(styledDocument, "(");
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    this.addStr(styledDocument, ")");
                    break;
                }
                case 2002: {
                    this.addStr(styledDocument, ((VariableNode)polyNode).getVariableName().toLowerCase(), this.variableStyle);
                    break;
                }
                case 2003: {
                    this.addStr(styledDocument, ((VariableNode)polyNode).getVariableName().toLowerCase(), this.variableStyle);
                    break;
                }
                case 2004: {
                    this.addStr(styledDocument, ((ScriptNode)polyNode).getToken(), this.tagStyle);
                    break;
                }
                case 1002: {
                    this.addStr(styledDocument, "\"", this.stringStyle);
                    this.addStr(styledDocument, ((ScriptNode)polyNode).getToken(), this.stringStyle);
                    this.addStr(styledDocument, "\"", this.stringStyle);
                    break;
                }
                case 1001: {
                    this.addStr(styledDocument, "\n/*", this.commentStyle);
                    this.addStr(styledDocument, ((ScriptNode)polyNode).getToken(), this.commentStyle);
                    this.addStr(styledDocument, "*/\n", this.commentStyle);
                    break;
                }
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 60: 
                case 62: 
                case 94: 
                case 124: {
                    this.writeFunction(styledDocument, polyNode.getLeft(), n);
                    this.addStr(styledDocument, " " + (char)polyNode.getType() + " ", null);
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                    break;
                }
                case 3: 
                case 6: {
                    this.addStr(styledDocument, NiceDataFormat.toString(polyNode.getNum()), null);
                    break;
                }
                case 3001: {
                    conditionNode = (ConditionNode)polyNode;
                    this.addStr(styledDocument, "if", this.statementStyle, n);
                    this.addStr(styledDocument, " (");
                    this.writeFunction(styledDocument, conditionNode.getNode(), n);
                    this.addStr(styledDocument, ")\n");
                    this.writeFunction(styledDocument, conditionNode.getLeft(), n + 1);
                    if (conditionNode.getElseNode() != null) {
                        this.addStr(styledDocument, "else\n", this.statementStyle, n);
                        this.writeFunction(styledDocument, conditionNode.getElseNode(), n + 1);
                    }
                    this.addStr(styledDocument, "end\n", this.statementStyle, n);
                    this.writeFunction(styledDocument, conditionNode.getRight(), n);
                    break;
                }
                case 3003: {
                    conditionNode = (ConditionNode)polyNode;
                    this.addStr(styledDocument, "while", this.statementStyle, n);
                    this.addStr(styledDocument, " (");
                    this.writeFunction(styledDocument, conditionNode.getNode(), n);
                    this.addStr(styledDocument, ")\n");
                    this.writeFunction(styledDocument, conditionNode.getLeft(), n + 1);
                    this.addStr(styledDocument, "end\n", this.statementStyle, n);
                    this.writeFunction(styledDocument, conditionNode.getRight(), n);
                    break;
                }
                case 3004: {
                    ForEachNode forEachNode = (ForEachNode)polyNode;
                    this.addStr(styledDocument, "foreach", this.statementStyle, n);
                    this.addStr(styledDocument, " (");
                    this.writeFunction(styledDocument, forEachNode.getVarNode(), n);
                    this.addStr(styledDocument, " : ");
                    this.writeFunction(styledDocument, forEachNode.getExpr(), n);
                    this.addStr(styledDocument, ")\n");
                    this.writeFunction(styledDocument, forEachNode.getLeft(), n + 1);
                    this.addStr(styledDocument, "end\n", this.statementStyle, n);
                    this.writeFunction(styledDocument, forEachNode.getRight(), n);
                    break;
                }
                case 4001: {
                    if (polyNode.getLeft() != null) {
                        this.addLevel(styledDocument, n);
                        this.writeFunction(styledDocument, polyNode.getLeft(), n);
                        if (!this.onlyComment(polyNode.getLeft())) {
                            this.addStr(styledDocument, ";");
                            if (this.hasMoreLeftNodes(polyNode)) {
                                this.addStr(styledDocument, "\n");
                            }
                        }
                    }
                    this.writeFunction(styledDocument, polyNode.getRight(), n);
                }
            }
        }
    }

    public class LineNr
    extends JPanel {
        private final JTextPane pane;
        private final JScrollPane scrollPane;
        private final Font plain;
        private final Font bold;

        public LineNr(JScrollPane jScrollPane, JTextPane jTextPane) {
            this.scrollPane = jScrollPane;
            this.pane = jTextPane;
            this.setMinimumSize(new Dimension(30, 30));
            this.setPreferredSize(new Dimension(30, 30));
            this.setMinimumSize(new Dimension(30, 30));
            Font font = this.getFont();
            this.bold = new Font(font.getName(), 1, font.getSize());
            this.plain = new Font(font.getName(), 0, font.getSize());
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.pane.viewToModel2D(this.scrollPane.getViewport().getViewPosition());
            int n2 = this.pane.viewToModel2D(new Point(this.scrollPane.getViewport().getViewPosition().x + this.pane.getWidth(), this.scrollPane.getViewport().getViewPosition().y + this.pane.getHeight()));
            Document document = this.pane.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n) + 1;
            int n4 = document.getDefaultRootElement().getElementIndex(n2) + 1;
            int n5 = graphics.getFontMetrics(this.pane.getFont()).getHeight();
            int n6 = graphics.getFontMetrics(this.pane.getFont()).getDescent();
            int n7 = -1;
            try {
                n7 = (int)(this.pane.modelToView2D(n).getY() - (double)this.scrollPane.getViewport().getViewPosition().y + (double)n5 - (double)n6);
            }
            catch (BadLocationException badLocationException) {
                n7 = 0;
            }
            int n8 = n7;
            for (int i = n3; i <= n4; ++i) {
                boolean bl = false;
                for (ErrorHolder errorHolder : ScriptEditorPanel.this.errorList) {
                    if (errorHolder.row + 1 != i) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    graphics.setColor(Color.red);
                    graphics.setFont(this.bold);
                } else {
                    graphics.setColor(Color.black);
                    graphics.setFont(this.plain);
                }
                graphics.drawString(Integer.toString(i), 0, n8);
                n8 += n5;
            }
        }
    }

    private static class ErrorHolder {
        public ErrorNode errorNode;
        public int index;
        public int length;
        public int row;

        public ErrorHolder(ErrorNode errorNode, int n, int n2, int n3) {
            this.errorNode = errorNode;
            this.index = n;
            this.length = n2;
            this.row = n3;
        }
    }

    private class ScriptDocumentListener
    extends KeyAdapter
    implements DocumentListener {
        private ScriptDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!ScriptEditorPanel.this.ishighlighting) {
                ScriptEditorPanel.this.highlightTimer.restart();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!ScriptEditorPanel.this.ishighlighting) {
                ScriptEditorPanel.this.highlightTimer.restart();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '.' || keyEvent.isControlDown() && keyEvent.getKeyCode() == 32) {
                Point point = ScriptEditorPanel.this.scriptTextArea.getCaret().getMagicCaretPosition();
                if (point == null) {
                    point = new Point(0, 0);
                }
                ScriptEditorPanel.this.showInsightPopup(keyEvent.getKeyChar() == '.', point);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!ScriptEditorPanel.this.ishighlighting) {
                ScriptEditorPanel.this.highlightTimer.restart();
            }
        }
    }

    public class TemplateListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(AbstractPaint.createIcon(3, 8));
            return jLabel;
        }
    }
}

