/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;
import se.prediktera.map.main.script.gui.template.AbstractScriptTemplateInfo;

public class ScriptEditorToolbar
extends CleanUpToolBar {
    private final JFlatButton undoButton = new JFlatButton();
    private final JFlatButton redoButton = new JFlatButton();
    private ScriptEditorPanel editorPanel;
    private final JFlatButton searchButton = new JFlatButton();
    private final JFlatButton searchAgainButton = new JFlatButton();
    private final JFlatButton formatButton = new JFlatButton();
    private final JFlatButton cutButton = new JFlatButton();
    private final JFlatButton copyButton = new JFlatButton();
    private final JFlatButton pasteButton = new JFlatButton();
    private final UndoManager undo = new UndoManager();
    private final JFlatButtonComboBox templateComboBox = new JFlatButtonComboBox();
    private final JFlatButton runButton = new JFlatButton();
    private String searchString = "N/A";
    private final UndoManager manager = new MyUndoableEditListener();
    private final Action undoAction = new UndoAction(this.manager);
    private final Action redoAction = new RedoAction(this.manager);
    private ActionListener searchAction;
    private ActionListener searchAgainAction;
    private ActionListener formatAction;
    KeyStroke undoKeyStroke = KeyStroke.getKeyStroke(90, 2);
    KeyStroke redoKeyStroke = KeyStroke.getKeyStroke(89, 2);
    KeyStroke searchKeyStroke = KeyStroke.getKeyStroke(70, 2);
    KeyStroke searchAgainKeyStroke = KeyStroke.getKeyStroke(114, 0);
    KeyStroke formatKeyStroke = KeyStroke.getKeyStroke(79, 2);

    public ScriptEditorToolbar(ScriptEditorPanel scriptEditorPanel) {
        try {
            this.jbInit();
            this.searchAction = actionEvent -> {
                this.searchString = this.editorPanel.search(null);
                this.searchAgainButton.setEnabled(true);
            };
            this.searchAgainAction = actionEvent -> this.editorPanel.search(this.searchString);
            this.formatAction = actionEvent -> this.editorPanel.format();
            this.undoButton.addActionListener(this.undoAction);
            this.undoButton.setEnabled(false);
            this.redoButton.addActionListener(this.redoAction);
            this.redoButton.setEnabled(false);
            this.searchButton.addActionListener(this.searchAction);
            this.searchAgainButton.addActionListener(this.searchAgainAction);
            this.searchAgainButton.setEnabled(false);
            this.formatButton.addActionListener(this.formatAction);
            this.setScriptEditorPanel(scriptEditorPanel);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void addToMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("Edit");
        jMenu.add(this.undoButton.createMenuItem("Undo"));
        jMenu.add(this.redoButton.createMenuItem("Redo"));
        jMenu.addSeparator();
        jMenu.add(this.formatButton.createMenuItem("Format"));
        jMenu.add(new AbstractAction("Select all"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptEditorToolbar.this.editorPanel.getScriptTextArea().selectAll();
            }
        });
        jMenu.add(new AbstractAction("Clear selection"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptEditorToolbar.this.editorPanel.getScriptTextArea().select(0, 0);
            }
        });
        jMenu.addSeparator();
        jMenu.add(this.cutButton.createMenuItem("Cut"));
        jMenu.add(this.copyButton.createMenuItem("Copy"));
        jMenu.add(this.pasteButton.createMenuItem("Paste"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Script");
        jMenu2.add(this.templateComboBox.createMenuItem("Add from template"));
        jMenu2.add(this.runButton.createMenuItem("Run"));
        jMenuBar.add(jMenu2);
    }

    public void addToPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.undoButton.createMenuItem("Undo"));
        jPopupMenu.add(this.redoButton.createMenuItem("Redo"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.formatButton.createMenuItem("Format"));
        jPopupMenu.add(new AbstractAction("Select all"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptEditorToolbar.this.editorPanel.getScriptTextArea().selectAll();
            }
        });
        jPopupMenu.add(new AbstractAction("Clear selection"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptEditorToolbar.this.editorPanel.getScriptTextArea().select(0, 0);
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.cutButton.createMenuItem("Cut"));
        jPopupMenu.add(this.copyButton.createMenuItem("Copy"));
        jPopupMenu.add(this.pasteButton.createMenuItem("Paste"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.templateComboBox.createMenuItem("Add from template"));
    }

    public void setScriptEditorPanel(ScriptEditorPanel scriptEditorPanel) {
        if (this.editorPanel != null) {
            this.editorPanel.getDocument().removeUndoableEditListener(this.manager);
            this.editorPanel.unregisterKeyboardAction(this.undoKeyStroke);
            this.editorPanel.unregisterKeyboardAction(this.redoKeyStroke);
            this.editorPanel.unregisterKeyboardAction(this.searchKeyStroke);
            this.editorPanel.unregisterKeyboardAction(this.searchAgainKeyStroke);
            this.editorPanel.unregisterKeyboardAction(this.formatKeyStroke);
        }
        this.editorPanel = scriptEditorPanel;
        this.editorPanel.getDocument().addUndoableEditListener(this.manager);
        this.editorPanel.registerKeyboardAction(this.undoAction, this.undoKeyStroke, 2);
        this.editorPanel.registerKeyboardAction(this.redoAction, this.redoKeyStroke, 2);
        this.editorPanel.registerKeyboardAction(this.searchAction, this.searchKeyStroke, 2);
        this.editorPanel.registerKeyboardAction(this.searchAgainAction, this.searchAgainKeyStroke, 2);
        this.editorPanel.registerKeyboardAction(this.formatAction, this.formatKeyStroke, 2);
    }

    public void updateState(String string, PolyNode polyNode) {
        boolean bl = polyNode == null || polyNode.hasError();
        this.formatButton.setEnabled(!bl);
        this.runButton.setEnabled(string == null || string.equalsIgnoreCase("custom"));
    }

    @Override
    protected void cleanUpChild() {
    }

    private void jbInit() throws Exception {
        this.undoButton.setToolTipText("Undo to this action");
        this.undoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/undo.png")));
        this.redoButton.setToolTipText("Redo to this action");
        this.redoButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/redo.png")));
        this.searchButton.setToolTipText("Search text");
        this.searchButton.setIcon(new ImageIcon(ScriptEditorToolbar.class.getResource("images/search.gif")));
        this.searchAgainButton.setToolTipText("Search again \"" + this.searchString + "\"");
        this.searchAgainButton.setIcon(new ImageIcon(ScriptEditorToolbar.class.getResource("images/searchagain.gif")));
        this.formatButton.setToolTipText("Auto format");
        this.formatButton.setIcon(new ImageIcon(ScriptEditorToolbar.class.getResource("images/format.gif")));
        this.formatButton.setEnabled(false);
        this.cutButton.setToolTipText("Cut");
        this.cutButton.setIcon(new ImageIcon(Main_GUI.class.getResource("button/cut.gif")));
        this.cutButton.addActionListener(actionEvent -> this.editorPanel.getScriptTextArea().cut());
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setIcon(new ImageIcon(Main_GUI.class.getResource("button/copy.gif")));
        this.copyButton.addActionListener(actionEvent -> this.editorPanel.getScriptTextArea().copy());
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setIcon(new ImageIcon(Main_GUI.class.getResource("button/paste.gif")));
        this.pasteButton.addActionListener(actionEvent -> this.editorPanel.getScriptTextArea().paste());
        this.runButton.setToolTipText("Run");
        this.runButton.setIcon(new ImageIcon(Main_GUI.class.getResource("button/play.gif")));
        this.runButton.setEnabled(false);
        this.runButton.addActionListener(actionEvent -> {
            try {
                String string = this.editorPanel.getScript();
                ScriptManager scriptManager = new ScriptManager(false);
                scriptManager.evaluteScript(string, false);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        });
        this.templateComboBox.setToolTipText("Insert Template");
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.SCRIPT_TEMPLATE_INFO, null);
        for (AbstractInfo abstractInfo : list) {
            AbstractScriptTemplateInfo abstractScriptTemplateInfo = (AbstractScriptTemplateInfo)abstractInfo;
            JFlatButton jFlatButton = new JFlatButton();
            jFlatButton.setToolTipText(abstractScriptTemplateInfo.getWizardInfo());
            jFlatButton.setIcon(AbstractPaint.createIcon(3));
            jFlatButton.addActionListener(actionEvent -> {
                try {
                    int n = this.editorPanel.getScriptTextArea().getCaretPosition();
                    this.editorPanel.getDocument().insertString(n, abstractScriptTemplateInfo.generateScript(), null);
                }
                catch (BadLocationException badLocationException) {
                    ErrorHandler.logAndReportException(badLocationException);
                }
            });
            this.templateComboBox.addButton(jFlatButton);
        }
        this.setBorder(null);
        this.setFloatable(false);
        this.add(this.undoButton);
        this.add(this.redoButton);
        this.addSeparator();
        this.add(this.searchButton);
        this.add(this.searchAgainButton);
        this.add(this.formatButton);
        this.addSeparator();
        this.add(this.cutButton);
        this.add(this.copyButton);
        this.add(this.pasteButton);
        this.addSeparator();
        this.add(this.templateComboBox);
        this.addSeparator();
        this.add(this.runButton);
    }

    protected class MyUndoableEditListener
    extends UndoManager {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!ScriptEditorToolbar.this.editorPanel.isHighLighting()) {
                super.undoableEditHappened(undoableEditEvent);
                ScriptEditorToolbar.this.undo.addEdit(undoableEditEvent.getEdit());
                ScriptEditorToolbar.this.undoButton.setEnabled(true);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private final UndoManager manager;

        public UndoAction(UndoManager undoManager) {
            this.manager = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ScriptEditorToolbar.this.editorPanel.setHighLighting(true);
                this.manager.undo();
                ScriptEditorToolbar.this.editorPanel.setHighLighting(false);
                ScriptEditorToolbar.this.editorPanel.highlight();
                ScriptEditorToolbar.this.undoButton.setEnabled(this.manager.canUndo());
                ScriptEditorToolbar.this.redoButton.setEnabled(this.manager.canRedo());
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        private final UndoManager manager;

        public RedoAction(UndoManager undoManager) {
            this.manager = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ScriptEditorToolbar.this.editorPanel.setHighLighting(true);
                this.manager.redo();
                ScriptEditorToolbar.this.editorPanel.setHighLighting(false);
                ScriptEditorToolbar.this.editorPanel.highlight();
                ScriptEditorToolbar.this.undoButton.setEnabled(this.manager.canUndo());
                ScriptEditorToolbar.this.redoButton.setEnabled(this.manager.canRedo());
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }
}

