/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.gui.ScriptDesktopPanel;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;
import se.prediktera.map.main.script.gui.ScriptMainToolbar;
import se.prediktera.map.main.script.gui.ScriptSettingsPanel;
import se.prediktera.map.main.script.gui.TemplateListPanel;

public class ScriptFilePanel
extends JPanel {
    private final ScriptMainToolbar scriptMainToolBar = new ScriptMainToolbar(this);
    private final JSplitPane settingsPane = new JSplitPane();
    private final JSplitPane splitPane = new JSplitPane();
    private final TemplateListPanel templateListPanel = new TemplateListPanel(this);
    private final ScriptSettingsPanel scriptSettingsPanel = new ScriptSettingsPanel();
    private final ScriptDesktopPanel scriptDesktopPanel;
    private ScriptFile scriptFile = null;
    private final JFrame window;

    public static void showAsFrame(boolean bl) {
        JFrame jFrame = new JFrame();
        Evince.setFrameIcons(jFrame);
        ScriptFilePanel scriptFilePanel = new ScriptFilePanel(jFrame);
        if (bl) {
            jFrame.setDefaultCloseOperation(3);
        }
        Evince.setLookAndFeel();
        jFrame.getContentPane().add(scriptFilePanel);
        jFrame.setSize(850, 700);
        jFrame.setLocationRelativeTo(null);
        jFrame.setExtendedState(6);
        jFrame.setVisible(true);
    }

    public ScriptFilePanel(JFrame jFrame) {
        this.window = jFrame;
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ScriptFilePanel.this.thisWindowClosing();
            }
        });
        jFrame.setTitle(this.getDefaultTitle());
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.scriptMainToolBar.addToMenuBar(jMenuBar);
        jFrame.setJMenuBar(jMenuBar);
        CMenu cMenu = new CMenu("Script", false);
        jMenuBar.add(cMenu);
        this.scriptDesktopPanel = new ScriptDesktopPanel(this, cMenu);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scriptMainToolBar, "North");
        jPanel.add((Component)this.templateListPanel, "Center");
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(this.scriptDesktopPanel);
        this.splitPane.setBorder(null);
        this.settingsPane.setResizeWeight(1.0);
        this.settingsPane.setLeftComponent(this.splitPane);
        this.settingsPane.setRightComponent(this.scriptSettingsPanel);
        this.add((Component)this.settingsPane, "Center");
        this.showTemplateList(true);
        this.showSettingsPanel(false);
        this.scriptDesktopPanel.addEmptyScript();
    }

    public boolean changeCurrentFile(ScriptFile scriptFile) {
        if (this.scriptDesktopPanel.hasScriptFile(scriptFile)) {
            this.scriptDesktopPanel.showScriptEditor(scriptFile);
        } else {
            this.scriptDesktopPanel.addScriptEditor(scriptFile, true);
        }
        return true;
    }

    public void deleteScript() {
        int n;
        if (this.scriptFile != null && (n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete script file", "Confirm delete", 0, 3)) == 0) {
            ScriptManager.deleteScriptFile(this.scriptFile);
            this.scriptDesktopPanel.removeScript(this.scriptFile);
            this.templateListPanel.reloadScript(this.scriptFile);
            this.setScriptFile(null, null);
        }
    }

    public void exportScript() {
        if (this.scriptFile == null) {
            return;
        }
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose file name", this.window);
        jopensaveDialog2.addExtension("xml", "Evince Script XML File (*.xml)");
        jopensaveDialog2.addExtension("txt", "Evince Script Text File (*.txt)");
        if (jopensaveDialog2.saveshow()) {
            File file = jopensaveDialog2.getSelectedFile();
            ScriptFile scriptFile = (ScriptFile)this.scriptFile.clone();
            scriptFile.setFile(file);
            ScriptManager.saveScriptFile(scriptFile);
        }
    }

    public ScriptFile newScript(boolean bl) {
        ScriptFile scriptFile = new ScriptFile();
        scriptFile.setType("Custom");
        String string = this.scriptDesktopPanel.getWindowContainer().getUniqueName("Untitled");
        string = ScriptManager.getUniqueName(string);
        scriptFile.setName(string);
        scriptFile.setScriptInfo("No description");
        scriptFile.setScript("");
        this.templateListPanel.updateList(scriptFile);
        this.scriptDesktopPanel.addScriptEditor(scriptFile, bl);
        return scriptFile;
    }

    public void openScript() {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select script file", IniManager.getMainFrame());
        jopensaveDialog2.addExtension("xml", "Evince Script XML File (*.xml)");
        jopensaveDialog2.addExtension("txt", "Evince Script Text File (*.txt)");
        jopensaveDialog2.addAllSupported();
        if (jopensaveDialog2.openshow()) {
            try {
                ScriptFile scriptFile = new ScriptFile(jopensaveDialog2.getSelectedFile());
                this.changeCurrentFile(scriptFile);
            }
            catch (Exception exception) {
                JOptionPane.showConfirmDialog(this, "Cannot open selected file:\n" + exception.getMessage(), "Cannot open file", -1, 0);
                ErrorHandler.logAndReportException(exception);
            }
        }
    }

    public void saveScript() {
        this.saveScript(this.scriptFile);
    }

    public void saveScript(ScriptFile scriptFile) {
        JComponent jComponent;
        if (scriptFile == null) {
            return;
        }
        boolean bl = false;
        if (scriptFile.getFile() == null) {
            jComponent = new jopensaveDialog("Select file name", this.window);
            ((jopensaveDialog)jComponent).addExtension("xml", "Evince Script XML File (*.xml)");
            ((jopensaveDialog)jComponent).addExtension("txt", "Evince Script Text File (*.txt)");
            try {
                ((JFileChooser)jComponent).setSelectedFile(new File(IniManager.getScriptDir(), scriptFile.getName()));
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
            if (((jopensaveDialog)jComponent).saveshow()) {
                File file = ((JFileChooser)jComponent).getSelectedFile();
                scriptFile.setFile(file);
                bl = true;
            } else {
                return;
            }
        }
        if ((jComponent = this.scriptDesktopPanel.getSelectedScriptEditor()) != null) {
            scriptFile.setScript(((ScriptEditorPanel)jComponent).getScript());
        }
        this.scriptSettingsPanel.setCurrentFile();
        ScriptManager.saveScriptFile(scriptFile);
        if (bl) {
            this.templateListPanel.reloadScript(scriptFile);
        } else {
            this.templateListPanel.updateList(scriptFile);
        }
    }

    public void setScriptFile(ScriptEditorPanel scriptEditorPanel, ScriptFile scriptFile) {
        if (scriptFile != null) {
            this.scriptSettingsPanel.setCurrentFile();
        }
        this.scriptFile = scriptFile;
        this.scriptMainToolBar.setScriptFile(this.scriptFile);
        if (this.scriptFile != null) {
            this.window.setTitle(this.getDefaultTitle() + " - " + this.scriptFile.getFilename());
        } else {
            this.window.setTitle(this.getDefaultTitle());
        }
        this.scriptSettingsPanel.setScriptEditorPanel(scriptEditorPanel, this.scriptFile);
    }

    public void showSettingsPanel(boolean bl) {
        if (bl) {
            this.settingsPane.setDividerLocation(this.getWidth() - 200);
            this.settingsPane.setDividerSize(3);
        } else {
            this.settingsPane.setDividerLocation(Integer.MAX_VALUE);
            this.settingsPane.setDividerSize(0);
        }
    }

    public void showTemplateList(boolean bl) {
        if (bl) {
            this.splitPane.setDividerLocation(200);
            this.splitPane.setDividerSize(3);
        } else {
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
        }
    }

    private String getDefaultTitle() {
        return "Evince Script Editor [BETA]";
    }

    private void thisWindowClosing() {
        this.scriptDesktopPanel.closeAllWindows();
    }
}

