/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.gui.ScriptFilePanel;

public class ScriptMainToolbar
extends JToolBar {
    private final JFlatButton newFlatButton = new JFlatButton();
    private final JFlatButton openFlatButton = new JFlatButton();
    private final JFlatButton deleteFlatButton = new JFlatButton();
    private final JFlatButton exportFlatButton = new JFlatButton();
    private final JFlatButton saveFlatButton = new JFlatButton();
    private final JFlatToggleButton settingsFlatToggleButton = new JFlatToggleButton();

    public ScriptMainToolbar(ScriptFilePanel scriptFilePanel) {
        this.setBorder(null);
        this.setFloatable(false);
        this.newFlatButton.setIcon(new ImageIcon(Evince.class.getResource("icons/common/newFile.png")));
        this.newFlatButton.setToolTipText("New script");
        this.newFlatButton.addActionListener(actionEvent -> scriptFilePanel.newScript(true));
        this.add(this.newFlatButton);
        this.openFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/openFile.png")));
        this.openFlatButton.setToolTipText("Open script");
        this.openFlatButton.addActionListener(actionEvent -> scriptFilePanel.openScript());
        this.add(this.openFlatButton);
        this.saveFlatButton.setIcon(new ImageIcon(Evince.class.getResource("icons/common/saveFile.png")));
        this.saveFlatButton.setToolTipText("Save script");
        this.saveFlatButton.addActionListener(actionEvent -> scriptFilePanel.saveScript());
        this.add(this.saveFlatButton);
        this.addSeparator();
        this.deleteFlatButton.setIcon(new ImageIcon(Evince.class.getResource("gif/delete.png")));
        this.deleteFlatButton.setToolTipText("Delete script");
        this.deleteFlatButton.addActionListener(actionEvent -> scriptFilePanel.deleteScript());
        this.add(this.deleteFlatButton);
        this.exportFlatButton.setIcon(new ImageIcon(ScriptMainToolbar.class.getResource("images/export.gif")));
        this.exportFlatButton.setToolTipText("Export script");
        this.exportFlatButton.addActionListener(actionEvent -> scriptFilePanel.exportScript());
        this.add(this.exportFlatButton);
        this.addSeparator();
        this.settingsFlatToggleButton.setIcon(new ImageIcon(ScriptMainToolbar.class.getResource("images/settings.gif")));
        this.settingsFlatToggleButton.setToolTipText("Show template information");
        this.settingsFlatToggleButton.addActionListener(actionEvent -> scriptFilePanel.showSettingsPanel(this.settingsFlatToggleButton.isSelected()));
        this.add(this.settingsFlatToggleButton);
        this.setScriptFile(null);
    }

    public void addToMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.newFlatButton.createMenuItem());
        jMenu.add(this.openFlatButton.createMenuItem());
        jMenu.add(this.saveFlatButton.createMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.deleteFlatButton.createMenuItem());
        jMenu.add(this.exportFlatButton.createMenuItem());
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(actionEvent -> System.exit(0));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.add(this.settingsFlatToggleButton.createMenuItem("Show script settings"));
        jMenuBar.add(jMenu2);
    }

    public void setScriptFile(ScriptFile scriptFile) {
        this.deleteFlatButton.setEnabled(scriptFile != null);
        this.exportFlatButton.setEnabled(scriptFile != null);
        this.saveFlatButton.setEnabled(scriptFile != null);
    }
}

