/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.gui.ScriptEditorPanel;

public class ScriptSettingsPanel
extends JPanel {
    private final JTextArea descriptionTextArea = new JTextArea();
    private final JLabel nameLabel = new JLabel();
    private final JTextField nameTextField = new JTextField();
    private final JComboBox typeComboBox = new JComboBox();
    private final JComboBox contextComboBox = new JComboBox();
    private final JComboBox iconComboBox = new JComboBox();
    private final JLabel typeLabel = new JLabel();
    private final JLabel descriptionLabel = new JLabel();
    private final JScrollPane descriptionScrollPane = new JScrollPane();
    private final JTextField shortcutTextField = new JTextField();
    private ScriptFile scriptFile;
    private ScriptEditorPanel scriptEditorPanel;

    public ScriptSettingsPanel() {
        for (String string : ScriptManager.TYPES) {
            this.typeComboBox.addItem(string);
        }
        this.setBorder(BorderFactory.createTitledBorder("Template information"));
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.nameTextField, gridBagConstraints2);
        this.typeLabel.setText("Type:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.typeLabel, gridBagConstraints3);
        this.typeComboBox.addItemListener(itemEvent -> this.typeComboBoxItemStateChanged(itemEvent));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.typeComboBox, gridBagConstraints4);
        this.contextComboBox.addItem("None");
        this.contextComboBox.addItem("PlotArea");
        this.contextComboBox.addItem("TableArea");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(6, 6, 0, 6);
        this.add((Component)new JLabel("Context"), gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 5;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.contextComboBox, gridBagConstraints6);
        this.iconComboBox.addItem("None");
        this.iconComboBox.addItem("Include");
        this.iconComboBox.addItem("Exclude");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 6;
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = new Insets(6, 6, 0, 6);
        this.add((Component)new JLabel("Icon"), gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 7;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.iconComboBox, gridBagConstraints8);
        this.descriptionLabel.setText("Description:");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 8;
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints9);
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(5);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.descriptionScrollPane.setPreferredSize(new Dimension(150, 150));
        this.descriptionScrollPane.setMinimumSize(new Dimension(150, 150));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 9;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.anchor = 18;
        gridBagConstraints10.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.descriptionScrollPane, gridBagConstraints10);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 10;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.insets = new Insets(6, 6, 0, 6);
        this.add((Component)new JLabel("Shortcut"), gridBagConstraints11);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 11;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.anchor = 18;
        gridBagConstraints12.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.shortcutTextField, gridBagConstraints12);
        this.setScriptEditorPanel(null, null);
    }

    public String getScriptName() {
        return this.nameTextField.getText();
    }

    public void setCurrentFile() {
        if (this.hasChanged()) {
            this.scriptFile.setName(this.nameTextField.getText());
            this.scriptFile.setScriptInfo(this.descriptionTextArea.getText());
            this.scriptFile.setType((String)this.typeComboBox.getSelectedItem());
            this.scriptFile.setStatus((byte)1);
            if (this.shortcutTextField.getText().length() > 0) {
                this.scriptFile.setShortcut(this.shortcutTextField.getText());
            } else {
                this.scriptFile.setShortcut(null);
            }
        }
    }

    public void setScriptEditorPanel(ScriptEditorPanel scriptEditorPanel, ScriptFile scriptFile) {
        this.scriptEditorPanel = scriptEditorPanel;
        this.scriptFile = scriptFile;
        this.nameTextField.setEnabled(scriptEditorPanel != null);
        this.descriptionTextArea.setEnabled(scriptEditorPanel != null);
        this.typeComboBox.setEnabled(scriptEditorPanel != null);
        if (scriptFile != null) {
            this.nameTextField.setText(scriptFile.getName());
            this.descriptionTextArea.setText(scriptFile.getScriptInfo());
            this.descriptionTextArea.setCaretPosition(0);
            this.setSelectedType(scriptFile.getType());
            this.shortcutTextField.setText(scriptFile.getShortcut());
        } else {
            this.nameTextField.setText("");
            this.descriptionTextArea.setText("");
            this.setSelectedType("Custom");
            this.shortcutTextField.setText("");
        }
    }

    public void setSelectedType(String string) {
        for (int i = 0; i < this.typeComboBox.getItemCount(); ++i) {
            if (!string.equalsIgnoreCase((String)this.typeComboBox.getItemAt(i))) continue;
            this.typeComboBox.setSelectedIndex(i);
            break;
        }
    }

    private boolean hasChanged() {
        if (this.scriptFile != null) {
            return !this.scriptFile.getName().equals(this.nameTextField.getText()) || !this.scriptFile.getScriptInfo().equals(this.descriptionTextArea.getText()) || !this.scriptFile.getType().equalsIgnoreCase((String)this.typeComboBox.getSelectedItem()) || !this.scriptFile.getShortcut().equals(this.shortcutTextField.getText());
        }
        return false;
    }

    private void typeComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.scriptFile != null) {
            this.scriptEditorPanel.setType((String)this.typeComboBox.getSelectedItem());
        }
    }
}

