/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.gui.ScriptFilePanel;

public class TemplateListPanel
extends JPanel {
    private final ScriptFilePanel scriptFilePanel;
    private final JList scriptFileList = new JList();
    private final ArrayList<ScriptFile> scriptList = new ArrayList();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JComboBox filterComboBox = new JComboBox();
    private final JLabel filterLabel = new JLabel();
    private final JLabel nodeTitle = new JLabel();
    private final JLabel nodeInfo = new JLabel();
    private boolean isupdating = false;

    public TemplateListPanel(ScriptFilePanel scriptFilePanel) {
        this.scriptFilePanel = scriptFilePanel;
        this.scriptFileList.setModel(new ScriptListModel());
        this.scriptFileList.setSelectionMode(0);
        this.scriptFileList.addListSelectionListener(listSelectionEvent -> this.scriptFileListValueChanged(listSelectionEvent));
        this.scriptFileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListModel listModel;
                Object e;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = TemplateListPanel.this.scriptFileList.locationToIndex(mouseEvent.getPoint())) >= 0 && (e = (listModel = TemplateListPanel.this.scriptFileList.getModel()).getElementAt(n)) != null && !TemplateListPanel.this.isupdating) {
                    TemplateListPanel.this.scriptFilePanel.changeCurrentFile((ScriptFile)e);
                }
            }
        });
        this.scriptFileList.setCellRenderer(new TemplateListCellRenderer());
        this.scrollPane.setViewportView(this.scriptFileList);
        this.scrollPane.setMinimumSize(new Dimension(150, 23));
        this.scrollPane.setPreferredSize(new Dimension(150, 130));
        this.setBorder(BorderFactory.createTitledBorder("Template list"));
        this.setLayout(new GridBagLayout());
        this.filterComboBox.addItem("All");
        for (String string : ScriptManager.TYPES) {
            this.filterComboBox.addItem(string);
        }
        this.filterComboBox.addItemListener(itemEvent -> this.filterComboBoxItemStateChanged(itemEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.filterComboBox, gridBagConstraints);
        this.filterLabel.setText("Filter:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.filterLabel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = new Insets(6, 0, 2, 0);
        this.add((Component)this.scrollPane, gridBagConstraints3);
        this.nodeTitle.setFont(new Font("Dialog", 1, 11));
        this.nodeInfo.setFont(new Font("Dialog", 0, 10));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints4.anchor = 18;
        jPanel.add((Component)this.nodeTitle, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        jPanel.add((Component)this.nodeInfo, gridBagConstraints5);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new TitledBorder("Quick Information"));
        jScrollPane.setPreferredSize(new Dimension(0, 150));
        jScrollPane.setViewportView(jPanel);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints6);
        this.loadScript(null, null);
    }

    public void loadScript(String string, ScriptFile scriptFile) {
        this.scriptList.clear();
        this.scriptList.addAll(ScriptManager.getScriptFiles(string));
        this.updateList(scriptFile);
    }

    public void reloadScript(ScriptFile scriptFile) {
        this.loadScript((String)this.filterComboBox.getSelectedItem(), scriptFile);
    }

    public void updateList(ScriptFile scriptFile) {
        this.isupdating = true;
        Collections.sort(this.scriptList);
        this.scriptFileList.setModel(new ScriptListModel());
        int n = this.scriptList.indexOf(scriptFile);
        this.scriptFileList.setSelectedIndex(n);
        this.isupdating = false;
    }

    private void filterComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.filterComboBox.getSelectedItem();
            this.loadScript(string.equals("All") ? null : string, null);
        }
    }

    private void scriptFileListValueChanged(ListSelectionEvent listSelectionEvent) {
        ScriptFile scriptFile = (ScriptFile)this.scriptFileList.getSelectedValue();
        if (scriptFile != null) {
            this.nodeTitle.setText(scriptFile.getFilename());
            this.nodeInfo.setText(scriptFile.getInformation());
        } else {
            this.nodeTitle.setText("N/A");
            this.nodeInfo.setText("N/A");
        }
    }

    private class ScriptListModel
    implements ListModel {
        private ScriptListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        public Object getElementAt(int n) {
            return TemplateListPanel.this.scriptList.get(n);
        }

        @Override
        public int getSize() {
            return TemplateListPanel.this.scriptList.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    public class TemplateListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ScriptFile scriptFile = (ScriptFile)object;
            jLabel.setIcon(AbstractPaint.createIcon(11, 10));
            jLabel.setText(scriptFile.getName());
            return jLabel;
        }
    }
}

