/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.script.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptInformationException;
import se.prediktera.map.main.script.report.SubPage;
import se.prediktera.map.main.script.report.XslHelper;

public class ReportHelper {
    private static String[] supportedExt = new String[]{"png", "html", "htm", "css", "csv"};
    public static String LINEBREAK = "\n";

    /*
     * WARNING - void declaration
     */
    public static void createReport(String string, String string2, String string3, Properties properties) {
        File file;
        File file2;
        boolean bl = false;
        boolean bl2 = false;
        String string4 = "stylesheet.css";
        boolean bl3 = false;
        String string5 = "";
        String string6 = "Evince Report";
        String string7 = "Report generated by Prediktera Routine Analysis package";
        String string8 = null;
        String string9 = "eng";
        String[][] stringArrayArray = new String[][]{{"Summary", "Result", "Comment", "Signature"}, {"Sammanst\u00e4llning", "Resultat", "Kommentar", "Signatur"}};
        int n = 32;
        boolean bl4 = false;
        boolean bl5 = false;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "link")) {
                bl2 = ScriptHelper.getPropertyBool(properties, "link");
            }
            if (ScriptHelper.hasKey(properties, "show")) {
                bl = ScriptHelper.getPropertyBool(properties, "show");
            }
            if (ScriptHelper.hasKey(properties, "stylesheet")) {
                string4 = ScriptHelper.getProperty(properties, "stylesheet");
            }
            if (ScriptHelper.hasKey(properties, "appendix")) {
                bl3 = ScriptHelper.getPropertyBool(properties, "appendix");
            }
            if (ScriptHelper.hasKey(properties, "thumbnailsize")) {
                n = ScriptHelper.getPropertyInt(properties, "thumbnailsize");
            }
            if (ScriptHelper.hasKey(properties, "output") && (string5 = ScriptHelper.getProperty(properties, "output")).equals(".")) {
                string5 = "";
            }
            if (ScriptHelper.hasKey(properties, "writexslfo")) {
                bl4 = ScriptHelper.getPropertyBool(properties, "writexslfo");
            }
            if (ScriptHelper.hasKey(properties, "title")) {
                string6 = ScriptHelper.getProperty(properties, "title");
            }
            if (ScriptHelper.hasKey(properties, "description")) {
                string7 = ScriptHelper.getProperty(properties, "description");
            }
            if (ScriptHelper.hasKey(properties, "layouthtml")) {
                string8 = ScriptHelper.getProperty(properties, "layouthtml");
            }
            if (ScriptHelper.hasKey(properties, "negativenumber")) {
                bl5 = ScriptHelper.getPropertyBool(properties, "negativenumber");
            }
            if (ScriptHelper.hasKey(properties, "language")) {
                string9 = ScriptHelper.getProperty(properties, "language");
            }
        }
        int n2 = 0;
        if (!string9.equals("eng")) {
            if (string9.equals("swe")) {
                n2 = 1;
            } else {
                throw new RuntimeException("Language not supported: " + string9);
            }
        }
        if (!(file2 = new File(file = new File(string2), string5)).exists() && !file2.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file2.getAbsolutePath());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head><title>" + string6 + "</title>");
        stringBuffer.append(LINEBREAK);
        stringBuffer.append("<LINK href=\"");
        stringBuffer.append("stylesheet.css");
        stringBuffer.append("\" rel=\"stylesheet\" type=\"text/css\">");
        stringBuffer.append(LINEBREAK);
        stringBuffer.append("<h1>" + string6 + "</h1>");
        stringBuffer.append(LINEBREAK);
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append("<h2>" + stringArrayArray[n2][1] + "</h2>");
            stringBuffer.append(LINEBREAK);
            stringBuffer.append("<p>" + string7 + "</p>");
            stringBuffer.append(LINEBREAK);
        }
        File[] fileArray = file2.listFiles();
        File file3 = null;
        if (fileArray != null) {
            for (File file4 : fileArray) {
                String string10 = file4.getName();
                if (!jopensaveDialog.getFileExtension(file4).equals("csv") && !string10.equals("result.txt")) continue;
                file3 = file4;
            }
        }
        try {
            void var23_26;
            Object exception = null;
            if (bl2 && file3 != null) {
                HashMap<String, SubPage> hashMap = new HashMap<String, SubPage>();
                ReportHelper.linkProjects(hashMap, file, file2, string5);
                stringBuffer.append("<h2>Table</h2>");
                ReportHelper.createTable(stringBuffer, file, file3, hashMap, n, bl5, false);
            }
            if (string8 != null) {
                stringBuffer.append(string8);
            } else {
                stringBuffer.append(ReportHelper.getFileImageReport(file2));
            }
            if (bl2) {
                stringBuffer.append("<br/><br/>");
                stringBuffer.append("<h2>" + stringArrayArray[n2][2] + "</h2>");
                stringBuffer.append("<br/><br/><br/><br/>");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                stringBuffer.append("<br/><br/>");
                stringBuffer.append("<h2>" + stringArrayArray[n2][3] + "</h2>");
                stringBuffer.append(simpleDateFormat.format(new Date()));
                stringBuffer.append("<br/><br/><br/><br/>");
                stringBuffer.append("-----------------------------------------------------");
            }
            stringBuffer.append("</head><body>");
            ReportHelper.writeHtml(file2, string3, string6, string5, stringBuffer, string4, bl2, bl);
            if (var23_26 != null) {
                if (bl3) {
                    stringBuffer.append("<h1>Appendix</h1>");
                    ReportHelper.createSubPageAppendix((HashMap<String, SubPage>)var23_26, stringBuffer);
                }
                if (bl4) {
                    XslHelper.writeXslFoFromHtml(stringBuffer, file);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean createZipArchive(String string, String string2, File file) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ReportHelper.zipFile(zipOutputStream, string, string2, "");
            zipOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return false;
        }
    }

    public static void export(ProgressManager progressManager, String string, Properties properties) throws Exception {
        String string2 = ScriptHelper.getProperty(properties, "output");
        String string3 = ScriptHelper.getProperty(properties, "exportpath");
        File file = new File(string3);
        if (file.isDirectory()) {
            file = new File(string3, string2 + ".zip");
        }
        ReportHelper.createZipArchive(string2, string, file);
    }

    public static void publish(ProgressManager progressManager, String string, Properties properties) throws Exception {
        String string2 = "ftp";
        if (ScriptHelper.hasKey(properties, "type")) {
            string2 = ScriptHelper.getProperty(properties, "type");
        }
        String string3 = ScriptHelper.getProperty(properties, "url");
        String string4 = ScriptHelper.getProperty(properties, "username");
        String string5 = ScriptHelper.getProperty(properties, "password");
        String string6 = ScriptHelper.getProperty(properties, "folder");
        String string7 = ScriptHelper.getProperty(properties, "output");
        boolean bl = false;
        if (ScriptHelper.hasKey(properties, "show")) {
            bl = ScriptHelper.getPropertyBool(properties, "show");
        }
        if (string2.equals("ftp")) {
            FTPClient fTPClient = new FTPClient();
            fTPClient.connect(string3);
            int n = fTPClient.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)n)) {
                progressManager.setInfoText("Publishing report");
                if (!fTPClient.login(string4, string5)) {
                    throw new ScriptInformationException("Wrong username or password ");
                }
                fTPClient.makeDirectory("breeze");
                fTPClient.changeWorkingDirectory("breeze");
                fTPClient.makeDirectory(string6);
                fTPClient.changeWorkingDirectory(string6);
                File[] fileArray = new File(string).listFiles();
                int n2 = 0;
                for (File file : fileArray) {
                    if (!file.isDirectory()) continue;
                    ++n2;
                }
                int n3 = progressManager.setGroupMaximumAndReset(n2);
                for (File file : fileArray) {
                    if (!ReportHelper.publishRecusive(progressManager, fTPClient, file, string7)) continue;
                    progressManager.incStepGroup(n3);
                }
                fTPClient.logout();
            } else {
                throw new ScriptInformationException("Failed to connect to ftp-server");
            }
        }
        if (bl) {
            BrowserLauncher.open(IniManager.getWebSite("breeze/" + string6 + "/" + string7 + "/Breeze - Summary.html"));
        }
    }

    public static void viewReport(String string, String string2, String string3, Properties properties) {
    }

    private static boolean acceptFile(String string, File file) {
        String string2 = file.getName().toLowerCase();
        if (string2.endsWith("_raw.png")) {
            return true;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.getName().equals(string)) {
            return false;
        }
        for (String string3 : supportedExt) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    private static void createSubPageAppendix(HashMap<String, SubPage> hashMap, StringBuffer stringBuffer) {
        Set<Map.Entry<String, SubPage>> set = hashMap.entrySet();
        for (Map.Entry<String, SubPage> entry : set) {
            SubPage subPage = entry.getValue();
            Object object = subPage.getRelPath();
            if (!((String)object).endsWith(IniManager.getFileSeparator())) {
                object = (String)object + IniManager.getFileSeparator();
            }
            String string = subPage.getHtml().toString();
            string = string.replace("img src=\"", "img src=\"" + (String)object);
            stringBuffer.append(string);
        }
    }

    private static void createTable(StringBuffer stringBuffer, File file, File file2, HashMap<String, SubPage> hashMap, int n, boolean bl, boolean bl2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        String string = bufferedReader.readLine();
        stringBuffer.append("<center><table class=\"result\">");
        stringBuffer.append(LINEBREAK);
        int n2 = bl2 ? 2 : 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while (string != null) {
            if (string.length() > 0) {
                if (n3 != 1) {
                    stringBuffer.append("<tr>");
                }
                int n4 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                String string2 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (bl2 && n3 == 0) {
                        arrayList.add(string3);
                        continue;
                    }
                    String string4 = "none";
                    if (n4 == 0) {
                        string2 = string3;
                    }
                    if (n4 < arrayList.size()) {
                        string4 = (String)arrayList.get(n4);
                    }
                    boolean bl3 = string4.equalsIgnoreCase("image");
                    if (string4.equalsIgnoreCase("meta")) {
                        ++n4;
                        continue;
                    }
                    if (n3 < n2) {
                        stringBuffer.append("<th width=\"60\" colspan=\"1\">");
                    } else if (n3 % 2 == 0) {
                        stringBuffer.append("<td width=\"60\" class=\"even\" colspan=\"1\">");
                    } else {
                        stringBuffer.append("<td width=\"60\" class=\"odd\" colspan=\"1\">");
                    }
                    if (n3 >= n2) {
                        SubPage subPage = hashMap.get(string2);
                        if (string4.equals("ID")) {
                            if (subPage != null) {
                                String string5 = string3.replace(" ", "&nbsp;");
                                stringBuffer.append("<a href=\"" + subPage.getRelHtmlPath() + "\">" + string5 + "</a>");
                            }
                        } else if (bl3 || string3.endsWith(".png")) {
                            File file3 = new File(string3);
                            int[] nArray = ReportHelper.readImageSize(file3);
                            if (nArray != null) {
                                double d = (double)n / (double)nArray[0];
                                int n5 = n;
                                int n6 = (int)((double)nArray[1] * d);
                                if (subPage != null) {
                                    stringBuffer.append("<center><a href=\"" + subPage.getRelHtmlPath() + "\"><img src=\"" + string3 + "\" printwidth=\"" + n5 + "\" width=\"" + n5 + "\" printheight=\"" + n6 + "\" height=\"" + n6 + "\"></a></center>");
                                } else {
                                    stringBuffer.append("<center><a href=\"" + file3.getAbsolutePath() + "\"><img src=\"" + string3 + "\" printwidth=\"" + n5 + "\" width=\"" + n5 + "\" printheight=\"" + n6 + "\" height=\"" + n6 + "\"></a></center>");
                                }
                            }
                        } else if (NiceDataFormat.isNumber(string3)) {
                            double d = NiceDataFormat.toNumber(string3);
                            if (!bl && d < 0.01) {
                                d = 0.0;
                            }
                            String string6 = NiceDataFormat.toString(d, 4);
                            string6 = string6.replace("-", "&#8209;");
                            stringBuffer.append(string6);
                        } else {
                            stringBuffer.append(string3.replace(" ", "&nbsp;"));
                        }
                    } else if (!bl3) {
                        stringBuffer.append(string3.replace(" ", "&nbsp;"));
                    }
                    if (n3 < n2) {
                        stringBuffer.append("</th>");
                    } else {
                        stringBuffer.append("</td>");
                    }
                    stringBuffer.append(LINEBREAK);
                    ++n4;
                }
                if (n3 > 0 || !bl2) {
                    stringBuffer.append("</tr>");
                }
                stringBuffer.append(LINEBREAK);
                ++n3;
            }
            string = bufferedReader.readLine();
        }
        stringBuffer.append("</table></center>");
        stringBuffer.append(LINEBREAK);
        bufferedReader.close();
    }

    private static String getFileImageReport(File file) {
        File[] fileArray = file.listFiles();
        StringBuilder stringBuilder = new StringBuilder();
        if (fileArray == null) {
            return "";
        }
        for (File file2 : fileArray) {
            Object object;
            String string = file2.getName();
            String string2 = jopensaveDialog.getFileExtension(file2);
            if (!string2.equalsIgnoreCase("png") || string.equalsIgnoreCase("logo_corner.png") || string.contains("thumbnail")) continue;
            stringBuilder.append("<div>");
            String string3 = string.substring(0, string.lastIndexOf("."));
            stringBuilder.append("<h2>" + string3 + "</h2>");
            File file3 = new File(file, string3 + ".txt");
            if (file3.exists()) {
                stringBuilder.append("<div>");
                stringBuilder.append("<h3>Description</h3><p>");
                try {
                    object = new BufferedReader(new FileReader(file3));
                    String string4 = ((BufferedReader)object).readLine();
                    while (string4 != null) {
                        stringBuilder.append(string4);
                        stringBuilder.append(LINEBREAK);
                        string4 = ((BufferedReader)object).readLine();
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    stringBuilder.append("Error reading file: " + file3.getName());
                    stringBuilder.append(LINEBREAK);
                }
                stringBuilder.append("</p>");
                stringBuilder.append("</div>");
            }
            stringBuilder.append("<div>");
            object = ReportHelper.readImageSize(file2);
            stringBuilder.append("<img src=\"" + string + "\" printwidth=\"" + (double)object[0] / 1.0 + "\" height=\"" + (double)object[1] / 1.0 + "width=\"" + (double)object[0] / 3.0 + "\" printheight=\"" + (double)object[1] / 3.0 + "\">");
            stringBuilder.append(LINEBREAK);
            stringBuilder.append("</div>");
            stringBuilder.append("</div>");
        }
        return stringBuilder.toString();
    }

    private static boolean isSupportedExt(String string) {
        for (String string2 : supportedExt) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static void linkProjects(HashMap<String, SubPage> hashMap, File file, File file2, String string) {
        if (file.isDirectory()) {
            if (!file.equals(file2)) {
                File[] fileArray;
                for (File file3 : fileArray = file.listFiles()) {
                    ReportHelper.linkProjects(hashMap, file3, file2, string);
                }
            }
        } else if (file.getParentFile().getName().equals(string)) {
            String string2 = file.getName();
            String string3 = jopensaveDialog.getFileExtension(file);
            string2 = string2.substring(0, string2.length() - string3.length() - 1);
            if (string3.equalsIgnoreCase("html")) {
                File file4 = file.getParentFile();
                String string4 = FileDataClass.getRelativePath(file2, file4);
                String string5 = FileDataClass.getRelativePath(file2, file);
                StringBuffer stringBuffer = ReportHelper.readHtmlFile(file);
                hashMap.put(file4.getParentFile().getName(), new SubPage(string4, string5, stringBuffer));
            }
        }
    }

    private static boolean publishRecusive(ProgressManager progressManager, FTPClient fTPClient, File file, String string) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray;
            String string2 = file.getName();
            boolean bl = string2.equals(string);
            fTPClient.makeDirectory(string2);
            fTPClient.changeWorkingDirectory(string2);
            for (File file2 : fileArray = file.listFiles()) {
                String string3 = jopensaveDialog.getFileExtension(file2);
                if (ReportHelper.isSupportedExt(string3)) {
                    progressManager.setInfoText("Uploading file: " + file2.getName());
                    if (string3.equalsIgnoreCase("png")) {
                        fTPClient.setFileType(2);
                    } else {
                        fTPClient.setFileType(0);
                    }
                    fTPClient.enterRemotePassiveMode();
                    fTPClient.enterLocalPassiveMode();
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    fTPClient.storeFile(file2.getName(), (InputStream)bufferedInputStream);
                    bufferedInputStream.close();
                    fileInputStream.close();
                }
                if (bl) continue;
                ReportHelper.publishRecusive(progressManager, fTPClient, file2, string);
            }
            fTPClient.changeToParentDirectory();
            return true;
        }
        return false;
    }

    private static StringBuffer readHtmlFile(File file) {
        StringBuffer stringBuffer;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(LINEBREAK);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringBuffer;
    }

    private static int[] readImageSize(File file) {
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream != null) {
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                ImageReader imageReader = null;
                if (!iterator.hasNext()) {
                    imageInputStream.close();
                    throw new IOException("Cannot read file information");
                }
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream, true, true);
                int n = imageReader.getWidth(0);
                int n2 = imageReader.getHeight(0);
                imageReader.dispose();
                imageInputStream.close();
                return new int[]{n, n2};
            }
            return null;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void writeHtml(File file, String string, String string2, String string3, StringBuffer stringBuffer, String string4, boolean bl, boolean bl2) throws IOException {
        File file2 = new File(file, string + ".html");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        bufferedWriter.write("<html><head><title>" + string2 + "</title>");
        bufferedWriter.newLine();
        bufferedWriter.write("<LINK href=\"");
        if (bl) {
            bufferedWriter.write("stylesheet.css");
        } else {
            bufferedWriter.write("../../" + string3 + "/stylesheet.css");
        }
        bufferedWriter.write("\" rel=\"stylesheet\" type=\"text/css\">");
        bufferedWriter.newLine();
        bufferedWriter.write("</head><body>");
        String string5 = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string5, LINEBREAK);
        while (stringTokenizer.hasMoreTokens()) {
            bufferedWriter.write(stringTokenizer.nextToken());
            bufferedWriter.newLine();
        }
        bufferedWriter.append("</body></html>");
        bufferedWriter.flush();
        bufferedWriter.close();
        if (bl) {
            ReportHelper.writeResource(file, string4, "stylesheet.css");
            ReportHelper.writeResource(file, "logo_corner.png");
        }
        if (bl2) {
            try {
                BrowserLauncher.open(file2);
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    private static void writeResource(File file, String string) {
        ReportHelper.writeResource(file, string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResource(File file, String string, String string2) {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            inputStream = ReportHelper.class.getResourceAsStream(string);
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file, string2)));
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        finally {
            try {
                inputStream.close();
                filterOutputStream.close();
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
    }

    private static void zipFile(ZipOutputStream zipOutputStream, String string, String string2, String string3) throws IOException {
        byte[] byArray = new byte[1024];
        File file = new File(string2, string3);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isFile() && ReportHelper.acceptFile(string, file2)) {
                    FileInputStream fileInputStream = null;
                    try {
                        int n;
                        fileInputStream = new FileInputStream(file2);
                        zipOutputStream.putNextEntry(new ZipEntry(string3 + file2.getName()));
                        while ((n = fileInputStream.read(byArray)) > 0) {
                            zipOutputStream.write(byArray, 0, n);
                        }
                        zipOutputStream.closeEntry();
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    continue;
                }
                if (!file2.isDirectory()) continue;
                ReportHelper.zipFile(zipOutputStream, string, string2, string3 + file2.getName() + IniManager.getFileSeparator());
            }
        }
    }
}

