/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.todo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.todo.TodoClass;

public class TodoManager
extends JFrame {
    private static final int[] priorities = new int[]{1, 2, 3, 0};
    private static final String[] priorityArray = new String[]{"None", "1", "2", "3"};
    private static final String[] stateArray = new String[]{"New", "Partly solved", "Solved", "Unable to replicate"};
    public static final String[] stateEncodings = new String[]{"[ ]", "[/]", "[X]", "[?]"};
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JComboBox comboBoxOwnerFilter = new JComboBox();
    private final JCheckBox showFinishedCheckBox = new JCheckBox("Show finished todos", false);
    private final JComboBox comboBoxPriority = new JComboBox();
    private final JComboBox comboBoxState = new JComboBox();
    private final JComboBox comboBoxOwner = new JComboBox();
    private final JScrollPane jScrollPane2 = new JScrollPane();
    private final JTextArea todoTextArea = new JTextArea();
    private final JLabel ownerLabel = new JLabel();
    private final JLabel priorityLabel = new JLabel();
    private final JLabel stateLabel = new JLabel();
    private final JLabel todoLabel = new JLabel();
    private final JTable table = new JTable();
    private TodoClass selectedTodo;
    private Vector<TodoClass> todoVector;
    private final Vector<String> ownerVector = new Vector();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    TodoModel todoModel;
    JButton buttonNew = new JButton();
    JButton buttonApply = new JButton();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane3 = new JScrollPane();
    JTextArea doneTextArea = new JTextArea();
    JLabel jLabel2 = new JLabel();
    JTextField versionTextField = new JTextField();

    public static void main(String[] stringArray) {
        TodoManager todoManager = new TodoManager();
        if (stringArray.length > 0 && stringArray[0].equals("save")) {
            todoManager.save();
        } else if (stringArray.length > 0 && stringArray[0].equals("export")) {
            todoManager.exportToSharePoint();
        } else {
            todoManager.pack();
            todoManager.setLocationRelativeTo(null);
            todoManager.setVisible(true);
        }
    }

    public TodoManager() {
        try {
            this.todoVector = this.parseTodo("TODO.txt", null);
            this.todoVector = this.parseTodo("DONE.txt", this.todoVector);
            this.todoModel = new TodoModel();
            this.table.setModel(this.todoModel);
            this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.showTodo(this.todoModel.getSelectedTodo()));
            TodoListener todoListener = new TodoListener();
            for (String string : priorityArray) {
                this.comboBoxPriority.addItem(string);
            }
            this.comboBoxPriority.addItemListener(todoListener);
            for (String string : stateArray) {
                this.comboBoxState.addItem(string);
            }
            this.comboBoxState.addItemListener(todoListener);
            this.comboBoxOwnerFilter.addItem("ALL");
            for (int i = 0; i < this.ownerVector.size(); ++i) {
                this.comboBoxOwner.addItem(this.ownerVector.elementAt(i));
                this.comboBoxOwnerFilter.addItem(this.ownerVector.elementAt(i));
            }
            this.comboBoxOwner.addItemListener(todoListener);
            this.jbInit();
            this.performFilter();
            this.showTodo(null);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void applyChanges() {
        if (this.selectedTodo == null) {
            this.selectedTodo = new TodoClass();
            this.todoVector.addElement(this.selectedTodo);
        }
        this.selectedTodo.setState(this.comboBoxState.getSelectedIndex());
        this.selectedTodo.setPriority(this.comboBoxPriority.getSelectedIndex());
        this.selectedTodo.setOwner(this.comboBoxOwner.getSelectedItem().toString());
        this.selectedTodo.setTodo(this.todoTextArea.getText());
        this.selectedTodo.setVersion(this.versionTextField.getText());
        this.selectedTodo.setDone(this.doneTextArea.getText());
        this.selectedTodo.setChanged();
        this.performFilter();
        int n = this.todoModel.getRowForTodo(this.selectedTodo);
        if (n >= 0) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    private void exportToSharePoint() {
        try {
            Calendar calendar = Calendar.getInstance();
            FileWriter fileWriter = new FileWriter("C:\\export.csv");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            Iterator<TodoClass> iterator = this.todoVector.iterator();
            bufferedWriter.write("ID;Status;Prioritet;Allvarlighetsgrad;Kategori;Rubrik;Kommentar;Skapad av;Tilldelad;Skapad;\u00c4ndrad;");
            bufferedWriter.newLine();
            int n = 1;
            while (iterator.hasNext()) {
                TodoClass todoClass = iterator.next();
                bufferedWriter.write(String.valueOf(n++));
                bufferedWriter.write(";");
                switch (todoClass.getState()) {
                    case 0: {
                        bufferedWriter.write("Aktiv");
                        break;
                    }
                    case 1: {
                        bufferedWriter.write("P\u00e5b\u00f6rjad");
                        break;
                    }
                    case 2: {
                        bufferedWriter.write("L\u00f6st");
                    }
                }
                bufferedWriter.write(";");
                switch (todoClass.getPriority()) {
                    case 1: {
                        bufferedWriter.write("(1) H\u00f6g");
                        break;
                    }
                    case 2: {
                        bufferedWriter.write("(2) Normal");
                        break;
                    }
                    case 3: {
                        bufferedWriter.write("(3) L\u00e5g");
                    }
                }
                bufferedWriter.write(";");
                bufferedWriter.write("(2) Normal");
                bufferedWriter.write(";");
                if (todoClass.getOwner().equalsIgnoreCase("Framtid") || todoClass.getOwner().equalsIgnoreCase("Nytt") || todoClass.getOwner().equalsIgnoreCase("Fragor") || todoClass.getOwner().equalsIgnoreCase("ChemKeeper") || todoClass.getOwner().equalsIgnoreCase("Oskar & Fredrik") || todoClass.getOwner().equalsIgnoreCase("Optimeringar") || todoClass.getOwner().equalsIgnoreCase("Bevakning")) {
                    bufferedWriter.write(todoClass.getOwner());
                } else {
                    bufferedWriter.write("Ingen kategori");
                }
                bufferedWriter.write(";");
                Object object = todoClass.getTodo();
                if (((String)object).length() > 60) {
                    object = ((String)object).substring(0, 60) + "...";
                }
                bufferedWriter.write((String)object);
                bufferedWriter.write(";");
                bufferedWriter.write(todoClass.getTodo());
                bufferedWriter.write(";");
                if (todoClass.getOwner().equalsIgnoreCase("Framtid") || todoClass.getOwner().equalsIgnoreCase("Nytt") || todoClass.getOwner().equalsIgnoreCase("Fragor") || todoClass.getOwner().equalsIgnoreCase("ChemKeeper") || todoClass.getOwner().equalsIgnoreCase("Oskar & Fredrik") || todoClass.getOwner().equalsIgnoreCase("Optimeringar") || todoClass.getOwner().equalsIgnoreCase("Bevakning")) {
                    bufferedWriter.write(";");
                    bufferedWriter.write(";");
                } else {
                    bufferedWriter.write("WEBB\\" + todoClass.getOwner().toLowerCase());
                    bufferedWriter.write(";");
                    bufferedWriter.write("WEBB\\" + todoClass.getOwner().toLowerCase());
                    bufferedWriter.write(";");
                }
                bufferedWriter.write(todoClass.getChangedString());
                bufferedWriter.write(";");
                if (todoClass.isFinished()) {
                    Date date = todoClass.getChanged();
                    calendar.setTime(date);
                    calendar.add(3, 2);
                    bufferedWriter.write(TodoClass.dateParser.format(calendar.getTime()));
                }
                bufferedWriter.write(";");
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(500, 600));
        this.todoTextArea.setPreferredSize(new Dimension(316, 40));
        this.todoTextArea.setText("jTextArea1");
        this.todoTextArea.setLineWrap(true);
        this.todoTextArea.setWrapStyleWord(true);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionEvent -> {
            this.save();
            this.dispose();
        });
        JButton jButton2 = new JButton("Save");
        jButton2.addActionListener(actionEvent -> this.save());
        JButton jButton3 = new JButton("Close");
        jButton3.addActionListener(actionEvent -> this.dispose());
        this.comboBoxOwnerFilter.addItemListener(itemEvent -> this.performFilter());
        this.showFinishedCheckBox.addItemListener(itemEvent -> this.performFilter());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gridBagLayout1);
        this.buttonNew.setText("New");
        this.buttonNew.addActionListener(actionEvent -> this.showTodo(null));
        this.buttonApply.setText("Apply");
        this.buttonApply.addActionListener(actionEvent -> this.applyChanges());
        this.jLabel1.setText("Done:");
        this.doneTextArea.setPreferredSize(new Dimension(70, 40));
        this.doneTextArea.setText("jTextArea2");
        this.jLabel2.setText("Version");
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)new JLabel("Owner"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel.add((Component)this.comboBoxOwnerFilter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel.add((Component)this.showFinishedCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        this.getContentPane().add((Component)jSplitPane, "Center");
        JPanel jPanel2 = new JPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        this.jScrollPane1.setViewportView(this.table);
        this.jScrollPane1.setPreferredSize(new Dimension(400, 200));
        jSplitPane.add((Component)this.jScrollPane1, "top");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setPreferredSize(new Dimension(400, 400));
        jSplitPane.add((Component)jPanel3, "bottom");
        this.ownerLabel.setText("Owner");
        this.priorityLabel.setText("Priority");
        this.stateLabel.setText("State");
        this.todoLabel.setText("Todo");
        jPanel3.add((Component)this.comboBoxPriority, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.comboBoxOwner, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.ownerLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.priorityLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.stateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.comboBoxState, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.todoLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.jScrollPane2, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
        jPanel3.add((Component)this.jScrollPane3, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.versionTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)this.buttonApply, new GridBagConstraints(1, 7, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 2, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.buttonNew, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.jScrollPane3.setViewportView(this.doneTextArea);
        this.jScrollPane2.setViewportView(this.todoTextArea);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        jSplitPane.setOrientation(0);
    }

    private Vector<TodoClass> parseTodo(String string, Vector<TodoClass> vector) {
        if (vector == null) {
            vector = new Vector();
        }
        String string2 = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String string3;
            InputStream inputStream = this.getClass().getResourceAsStream("../" + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                if (stringTokenizer.countTokens() == 1) {
                    string2 = stringTokenizer.nextToken();
                    if (this.ownerVector.contains(string2)) continue;
                    this.ownerVector.addElement(string2);
                    continue;
                }
                String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "0";
                int n = Integer.parseInt(string4);
                String string5 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "[ ]";
                int n2 = 3;
                for (int i = 0; i < stateEncodings.length; ++i) {
                    if (!string5.equals(stateEncodings[i])) continue;
                    n2 = i;
                    break;
                }
                String string6 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "No comment";
                String string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Unknown";
                Date date = null;
                try {
                    date = simpleDateFormat.parse(string7);
                }
                catch (ParseException parseException) {
                    date = new Date();
                }
                String string8 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                String string9 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                TodoClass todoClass = new TodoClass(string2, n2, n, string6, date, string8, string9);
                vector.addElement(todoClass);
            }
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return vector;
    }

    private void performFilter() {
        Vector<TodoClass> vector = new Vector<TodoClass>();
        for (int i = 0; i < this.todoVector.size(); ++i) {
            String string;
            TodoClass todoClass = this.todoVector.elementAt(i);
            if (!this.showFinishedCheckBox.isSelected() && todoClass.isFinished() || !(string = (String)this.comboBoxOwnerFilter.getSelectedItem()).equals("ALL") && !todoClass.getOwner().equals(string)) continue;
            vector.addElement(todoClass);
        }
        this.table.clearSelection();
        this.todoModel.setFilterVector(vector);
        this.todoModel.fireTableStructureChanged();
    }

    private void save() {
        URL uRL = this.getClass().getResource("../TODO.txt");
        URL uRL2 = this.getClass().getResource("../DONE.txt");
        this.save(uRL, false);
        this.save(uRL2, true);
    }

    private void save(URL uRL, boolean bl) {
        try {
            String string = uRL.getPath().replace("classes", "src");
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < this.comboBoxOwner.getItemCount(); ++i) {
                String string2 = this.comboBoxOwner.getItemAt(i).toString();
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                for (int j = 0; j < stateArray.length; ++j) {
                    if (!(j < 2 ^ bl)) continue;
                    for (int n : priorities) {
                        for (TodoClass todoClass : this.todoVector) {
                            if (!todoClass.getOwner().equals(string2) || todoClass.getState() != j || todoClass.getPriority() != n) continue;
                            todoClass.Save(bufferedWriter);
                            bufferedWriter.newLine();
                        }
                    }
                }
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private void showTodo(TodoClass todoClass) {
        this.selectedTodo = todoClass;
        if (todoClass != null) {
            this.comboBoxState.setSelectedIndex(todoClass.getState());
            this.comboBoxPriority.setSelectedIndex(todoClass.getPriority());
            this.comboBoxOwner.setSelectedItem(todoClass.getOwner());
            this.todoTextArea.setText(todoClass.getTodo());
            this.versionTextField.setText(todoClass.getVersion());
            this.doneTextArea.setText(todoClass.getDone());
        } else {
            int n = this.comboBoxOwnerFilter.getSelectedIndex() - 1;
            if (n < 0) {
                n = 0;
            }
            this.comboBoxState.setSelectedIndex(0);
            this.comboBoxPriority.setSelectedItem(0);
            this.comboBoxOwner.setSelectedIndex(n);
            this.todoTextArea.setText("");
            this.versionTextField.setText(InitClass.getNextVersionString());
            this.doneTextArea.setText("");
        }
    }

    private class TodoModel
    extends DefaultTableModel {
        private Vector<TodoClass> todoFilterVector;

        private TodoModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 0 -> "Owner";
                case 1 -> "Priority";
                case 2 -> "Todo";
                case 3 -> "Changed";
                default -> "";
            };
        }

        @Override
        public int getRowCount() {
            if (this.todoFilterVector == null) {
                return 0;
            }
            return this.todoFilterVector.size();
        }

        public int getRowForTodo(TodoClass todoClass) {
            return this.todoFilterVector.indexOf(todoClass);
        }

        public TodoClass getSelectedTodo() {
            if (TodoManager.this.table.getSelectedRow() >= 0 && TodoManager.this.table.getSelectedRow() < this.todoFilterVector.size()) {
                return this.todoFilterVector.elementAt(TodoManager.this.table.getSelectedRow());
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TodoClass todoClass = this.todoFilterVector.elementAt(n);
            return switch (n2) {
                case 0 -> todoClass.getOwner();
                case 1 -> priorityArray[todoClass.getPriority()];
                case 2 -> todoClass.getTodo();
                case 3 -> todoClass.getChangedString();
                default -> "";
            };
        }

        public void setFilterVector(Vector<TodoClass> vector) {
            this.todoFilterVector = vector;
        }
    }

    private static class TodoListener
    implements ItemListener {
        private TodoListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }
}

