/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.CPopupMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.selection.AbstractSelectionDialog;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.history.HistoryInterface;
import se.prediktera.map.history.HistoryManager;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.AbstractSettingsToolbar;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;

public abstract class AbstractWindow
extends AbstractGUI
implements InteractionInterface,
DataTreeInterface,
MouseListener,
Printable,
GlobalMessageInterface,
HistoryInterface,
DataMatrixListener {
    protected AbstractWindow_GUI window_gui;
    protected ButtonGroup windowButtonGroup = new ButtonGroup();
    private AbstractSelectionDialog selectionDialog;
    private Integer windowID;
    private DataTreeInterface nodeParent;
    private final Vector<DataTreeInterface> treeVector = new Vector();
    private DataTreeManager dataTreeManager;
    protected AbstractInit init;
    protected boolean isCreated = false;
    private boolean interactionByAncestor = true;
    private byte interactionFlag = 1;
    protected HistoryManager historyManager;
    protected long duration;
    private final long timestamp;
    private final String username;
    private int groupIndex = 0;
    private boolean contentReady = true;
    private String contentInformation = "Waiting for content";
    private String tag = null;
    private CustomMenuTrigger customMenuTrigger = null;
    public boolean addscript = false;

    public AbstractWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super("AbstractWindow");
        this.dataTreeManager = randomInputStream.getDataTreeManager();
        this.windowID = randomInputStream.getDataTreeManager().addUniqueID(randomInputStream.getCT().id, this);
        this.init = this.loadInit(randomInputStream, mapProperty);
        this.init();
        this.interactionFlag = 0;
        this.interactionByAncestor = mapProperty.getPropertyBoolean("rbya", true);
        if (mapProperty.getPropertyBoolean("rbyv", false)) {
            this.interactionFlag = (byte)2;
        }
        if (mapProperty.getPropertyBoolean("rbys", false)) {
            this.interactionFlag = 1;
        }
        this.interactionFlag = mapProperty.getPropertyByte("intfl", this.interactionFlag);
        this.duration = mapProperty.getPropertyLong("dur");
        this.timestamp = mapProperty.getPropertyLong("ts");
        this.username = mapProperty.getPropertyStringUTF("un");
        this.historyManager = (HistoryManager)mapProperty.resolveNodeFromName(randomInputStream, "hm");
        this.groupIndex = mapProperty.getPropertyInt("gi");
    }

    public AbstractWindow(String string, AbstractInit abstractInit) {
        this(string, null, abstractInit);
    }

    public AbstractWindow(String string, AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        super(string);
        this.window_gui = abstractWindow_GUI;
        this.init = abstractInit;
        if (abstractWindow_GUI != null) {
            this.project_GUI = abstractWindow_GUI.getProject_GUI();
        }
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
        this.historyManager = new HistoryManager();
        this.addTreeNode(this.historyManager);
        this.init();
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        Object object;
        if (!bl) {
            object = (this.window_gui.isShowing(this) ? "Hide" : "Show") + " Window";
            jPopupMenu.add(new CMenuItem((String)object, true){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        AbstractWindow.this.getAssociatedFrame().setIcon(!AbstractWindow.this.getAssociatedFrame().isIcon());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
            jPopupMenu.addSeparator();
        }
        if (bl && this.selectionDialog != null) {
            this.selectionDialog.addToWindowPopup(point, jPopupMenu);
            jPopupMenu.addSeparator();
            object = new CMenuItem("Selections", true){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractWindow.this.showSelectionDialog();
                }
            };
            ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(70, 2));
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.addSeparator();
        }
        return false;
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.addElement(dataTreeInterface);
    }

    public void close() {
        AbstractWindow_GUI abstractWindow_GUI = this.getWindowGui();
        if (abstractWindow_GUI != null) {
            abstractWindow_GUI.removeFromDesktop(this);
            this.cleanUp();
        }
    }

    @Override
    public void closing() {
        if (this.project_GUI != null) {
            this.project_GUI.setProjectChanged();
        }
        if (this.window_gui != null) {
            this.window_gui.removeWindow(this);
        }
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.contains(dataTreeInterface);
    }

    public void dataGroupChanged(AbstractInnerColumn abstractInnerColumn, byte by) {
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    public void doSelectionDialogInteraction(InteractionInterface interactionInterface) {
        if (this.selectionDialog != null) {
            this.selectionDialog.doInteraction(interactionInterface);
        }
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    public Object get(String string) {
        if (string.equalsIgnoreCase("tag")) {
            return this.tag;
        }
        throw new RuntimeException("Cannot find data with name: " + string);
    }

    public AbstractInit getAbstractInit() {
        return this.init;
    }

    public ButtonGroup getButtonGroup() {
        return this.windowButtonGroup;
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        if (this.dataTreeManager == null && this.nodeParent != null) {
            this.setDataTreeManager(this.nodeParent.getDataTreeManager(), false);
        }
        return this.dataTreeManager;
    }

    @Override
    public String getDescription() {
        return "Created";
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public Double getGroupIndex() {
        return this.groupIndex;
    }

    public int getGroupIndexLocal() {
        return this.groupIndex;
    }

    @Override
    public List getHistory() {
        if (this.historyManager != null) {
            return this.historyManager.getEdits();
        }
        return null;
    }

    @Override
    public Integer getID() {
        if (this.windowID == null && this.getDataTreeManager() != null) {
            this.windowID = this.dataTreeManager.addUniqueID(null, this);
        }
        return this.windowID;
    }

    public byte getInteractionFlag() {
        return this.interactionFlag;
    }

    public int getInteractiveTag() {
        return this.init.getInteractiveTag();
    }

    @Override
    public int getSaveIndex() {
        return -1;
    }

    @Override
    public String getScript() {
        DataTreeInterface dataTreeInterface = this.getAbstractInit().getDataTreeInterface();
        if (dataTreeInterface instanceof FoldMatrix) {
            dataTreeInterface = ((FoldMatrix)dataTreeInterface).getRootReferencedMatrix();
        }
        if (dataTreeInterface != null && dataTreeInterface.getTreeParent() instanceof AbstractDataNode) {
            StringBuilder stringBuilder = new StringBuilder();
            AbstractDataNode abstractDataNode = DataTreeManager.getScriptParent(dataTreeInterface);
            String string = dataTreeInterface.toString();
            if (dataTreeInterface instanceof DataSet) {
                stringBuilder.append("data = ").append(((DataSet)dataTreeInterface).getUniqueName()).append(";");
            } else if (dataTreeInterface instanceof AbstractDataMatrix && ((AbstractDataMatrix)dataTreeInterface).isOrigMatrix()) {
                stringBuilder.append("data = dataset.get(\"originalmatrix\");");
            } else {
                stringBuilder.append("data = ").append(abstractDataNode.getUniqueName()).append(".get(\"").append(string).append("\");");
            }
            Object object = "";
            if (this instanceof AbstractPlot) {
                object = (String)object + "plot = createPlot(\"";
            } else if (this instanceof AbstractTable) {
                object = (String)object + "table = createTable(\"";
            }
            String string2 = this.getDefaultTitle();
            string2 = string2.replace(" ", "").toLowerCase();
            return stringBuilder.append((String)object).append(string2).append("\", data);").toString();
        }
        return null;
    }

    public byte getSelectionType() {
        if (this.selectionDialog == null) {
            return 0;
        }
        return this.selectionDialog.getSelectionType();
    }

    public JPanel getSettingsPanel() {
        return null;
    }

    public AbstractSettingsToolbar getSettingsToolbar() {
        return null;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void getToolbars(Vector<JToolBar> vector) {
        if (this.addscript && this.getWindowGui() != null) {
            String string = this.getWindowGui().getGUI_Name().toLowerCase();
            String string2 = "";
            if (this.getDefaultTitle() != null) {
                string2 = EvinceScriptCommands.removeSpace(this.getDefaultTitle()).toLowerCase();
            }
            JComboBoxCell jComboBoxCell = new JComboBoxCell();
            ScriptManager.addScriptInfoComboBox(jComboBoxCell, string, string2, this);
            if (jComboBoxCell.getItemCount() > 0) {
                JToolBar jToolBar = new JToolBar();
                jToolBar.setFloatable(false);
                JFlatButtonComboBox jFlatButtonComboBox = new JFlatButtonComboBox();
                jToolBar.add(jFlatButtonComboBox);
                for (int i = 0; i < jComboBoxCell.getItemCount(); ++i) {
                    Object e = jComboBoxCell.getItemAt(i);
                    if (!(e instanceof AbstractScriptInfo)) continue;
                    AbstractScriptInfo abstractScriptInfo = (AbstractScriptInfo)e;
                    JFlatButton jFlatButton = new JFlatButton();
                    jFlatButton.setToolTipText(abstractScriptInfo.toString());
                    jFlatButton.addActionListener(actionEvent -> {
                        ScriptManager scriptManager = new ScriptManager(null);
                        scriptManager.addVariable(this, string);
                        AbstractInit abstractInit = this.getAbstractInit();
                        DataTreeInterface dataTreeInterface = abstractInit.getDataTreeInterface();
                        if (dataTreeInterface instanceof AbstractDataMatrix) {
                            scriptManager.addVariable(dataTreeInterface, "data");
                            if (dataTreeInterface instanceof FoldMatrix) {
                                scriptManager.addVariable(((FoldMatrix)dataTreeInterface).getFold(), "dataindex");
                            }
                        }
                        scriptManager.evaluteScript(abstractScriptInfo.getScript(), false);
                    });
                    jFlatButtonComboBox.addButton(jFlatButton);
                }
                vector.add(jToolBar);
            }
        }
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        return this.treeVector.elementAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        return this.treeVector.size();
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public AbstractWindow_GUI getWindowGui() {
        return this.window_gui;
    }

    public boolean hasInteractionByAncestor() {
        return this.interactionByAncestor;
    }

    public boolean hasInteractionWith(AbstractWindow abstractWindow) {
        if (abstractWindow == null || abstractWindow == this) {
            return true;
        }
        if (!abstractWindow.hasInteractivity() || !this.hasInteractivity()) {
            return false;
        }
        if ((abstractWindow.getInteractiveTag() & this.getInteractiveTag() & 0xB) != 0) {
            if (this.getProject_GUI().hasInteractionBetweenCases()) {
                return true;
            }
            return this.init.isRelatedTo(abstractWindow.getAbstractInit());
        }
        return false;
    }

    public boolean hasInteractivity() {
        return this.interactionFlag != 0;
    }

    public boolean hasTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.contains(dataTreeInterface);
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != null) {
            dataTreeInterface.setTreeParent(this);
            this.treeVector.insertElementAt(dataTreeInterface, 0);
        }
    }

    public boolean isContentReady() {
        return this.contentReady;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isVisibleInTree() {
        return true;
    }

    @Override
    public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.window_gui != null) {
            this.window_gui.guiSelected();
        }
        if (this.customMenuTrigger != null) {
            this.customMenuTrigger.trigger(mouseEvent);
        } else {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.customMenuTrigger != null) {
            this.customMenuTrigger.trigger(mouseEvent);
        } else {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void setCustomMenuTrigger(CustomMenuTrigger customMenuTrigger) {
        this.customMenuTrigger = customMenuTrigger;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        if (this.init != null) {
            this.init.setDataTreeInterface(dataTreeEvent.getReplaceDataTreeInterface());
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Container container;
        super.paint(graphics);
        Container container2 = this.getParent();
        if (container2 != null && (container = container2.getParent()) != null) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (component == container2 || !component.isVisible()) continue;
                component.repaint();
            }
        }
    }

    public void postEdit(AbstractHistoryNode abstractHistoryNode) {
        if (this.historyManager != null) {
            this.historyManager.postEdit(abstractHistoryNode);
        }
    }

    public void PostGlobalMessage(byte by, byte by2) {
        if (this.window_gui != null) {
            this.window_gui.PostGlobalMessage(by, by2);
        }
    }

    public void printNow() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName("Evince Printing", null));
        hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        try {
            if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
                printerJob.print(hashPrintRequestAttributeSet);
            }
        }
        catch (PrinterAbortException printerAbortException) {
            JOptionPane.showMessageDialog(IniManager.getMainFrame(), "The print job has been aborted.", "Print aborted", 0);
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(IniManager.getMainFrame(), "An error occurred during printing. Please check\nthat the printer is properly connected and that\nyour settings are correct.\nThe error returned was:\n\t" + printerException.getMessage(), "Print error", 0);
        }
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
    }

    public void registerKeyAction(KeyStroke keyStroke, Action action) {
        InputMap inputMap = this.getInputMap(2);
        String string = "Input_" + inputMap.size();
        inputMap.put(keyStroke, string);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(string, action);
    }

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.removeElement(dataTreeInterface);
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        randomOutputStream.writePropertyByte("intfl", this.interactionFlag);
        randomOutputStream.writePropertyBoolean("rbya", this.interactionByAncestor);
        if (this.init != null) {
            this.init.SaveProperty(randomOutputStream);
        }
        randomOutputStream.writePropertyLong("ts", this.timestamp);
        randomOutputStream.writePropertyStringUTF("un", this.username);
        randomOutputStream.writePropertyLong("dur", this.duration);
        randomOutputStream.writePropertyNode("hm", this.historyManager);
        randomOutputStream.writePropertyInt("gi", this.groupIndex);
        this.SavePropertyLocal(randomOutputStream);
    }

    public abstract void SavePropertyLocal(RandomOutputStream var1) throws IOException;

    @Override
    public void selectedFrameUpdated(BaseInternalFrame baseInternalFrame) {
        if (this.window_gui != null) {
            this.window_gui.selectedWindowUpdated(this);
        }
    }

    public void selectWindow() {
        this.window_gui.selectWindow(this);
    }

    public byte SendGlobalMessage(byte by, byte by2) {
        return 0;
    }

    public void set(String string, Object object) {
        if (!string.equalsIgnoreCase("tag")) {
            throw new RuntimeException("No such data with name: " + string);
        }
        this.tag = object.toString();
    }

    public void setContentInformation(String string) {
        this.contentInformation = string;
    }

    public String getContentInformation() {
        return this.contentInformation;
    }

    public void setContentReady(boolean bl) {
        this.contentReady = bl;
    }

    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (!this.isCreated) {
            this.isCreated = true;
            this.window_gui = abstractWindow_GUI;
            if (abstractWindow_GUI != null) {
                this.project_GUI = abstractWindow_GUI.getProject_GUI();
                if (this.project_GUI != null) {
                    this.project_GUI.setProjectChanged();
                }
                abstractWindow_GUI.registerShortcuts(this);
                final String string = abstractWindow_GUI.getScriptType();
                ArrayList<ScriptFile> arrayList = ScriptManager.getScriptFiles(string);
                for (final ScriptFile scriptFile : arrayList) {
                    KeyStroke keyStroke = scriptFile.getKeyStroke();
                    if (keyStroke == null) continue;
                    AbstractAction abstractAction = new AbstractAction(this){
                        final /* synthetic */ AbstractWindow this$0;
                        {
                            this.this$0 = abstractWindow;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ScriptManager.applyTemplate(this.this$0, this.this$0, string, scriptFile.getScript());
                        }
                    };
                    this.registerKeyAction(keyStroke, abstractAction);
                }
            }
            if (!bl) {
                if (abstractWindow_GUI instanceof Data_GUI && this.hasInteractivity() && this.doInteraction(this)) {
                    this.finishInteraction();
                }
                this.duration = System.currentTimeMillis() - this.timestamp;
            }
        }
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.windowID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.windowID == null && this.dataTreeManager != null) {
            this.windowID = this.dataTreeManager.addUniqueID(null, this);
        }
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            this.getTreeNodeAt(i).setDataTreeManager(dataTreeManager, bl);
        }
    }

    public void setGroupIndexLocal(int n) {
        this.groupIndex = n;
    }

    @Override
    public void setInteractionFlag(byte by) {
        this.interactionFlag = by;
    }

    public void setInteractive(boolean bl) {
        this.interactionFlag = bl ? (byte)1 : 0;
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        this.nodeParent = dataTreeInterface;
        if (dataTreeInterface != null && dataTreeInterface.getDataTreeManager() != null) {
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            if (this.windowID == null) {
                this.windowID = this.dataTreeManager.addUniqueID(null, this);
            }
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                this.getTreeNodeAt(i).setTreeParent(this);
            }
        }
    }

    public boolean showOnlySelected() {
        return this.interactionFlag == 2;
    }

    public boolean showProperties() {
        AbstractWindowProperties abstractWindowProperties = this.createProperties();
        if (abstractWindowProperties != null) {
            abstractWindowProperties.showModal();
            return true;
        }
        return false;
    }

    public void showSelectionDialog() {
        if (this.selectionDialog != null) {
            this.selectionDialog.showModal(this);
        }
    }

    @Override
    public void swapNodes(int n, int n2) {
        DataTreeInterface dataTreeInterface = this.treeVector.get(n);
        this.treeVector.set(n, this.treeVector.get(n2));
        this.treeVector.set(n2, dataTreeInterface);
    }

    @Override
    protected void cleanUpChild() {
        DataTreeInterface dataTreeInterface;
        this.isCreated = false;
        super.cleanUpChild();
        while (!this.treeVector.isEmpty()) {
            dataTreeInterface = this.getTreeNodeAt(0);
            if ((this.dataTreeManager == null || this.dataTreeManager.hasDataMask(dataTreeInterface)) && !dataTreeInterface.cleanUp()) continue;
            this.treeVector.removeElementAt(0);
        }
        if (this.dataTreeManager != null && this.windowID != null) {
            this.dataTreeManager.removeUniqueID(this.windowID);
            this.dataTreeManager = null;
        }
        this.windowID = null;
        if (this.nodeParent != null) {
            this.nodeParent.removeTreeNode(this);
            this.nodeParent = null;
        }
        if (this.selectionDialog != null) {
            this.selectionDialog.cleanUp();
            this.selectionDialog = null;
        }
        this.window_gui = null;
        this.windowButtonGroup = null;
        if (this.init != null) {
            dataTreeInterface = this.init.getDataTreeInterface();
            if (dataTreeInterface != null) {
                dataTreeInterface.removeDataTreeChangeListener(this);
            }
            this.init.cleanUp();
            this.init = null;
        }
    }

    protected abstract AbstractWindowProperties createProperties();

    protected abstract String getDefaultTitle();

    public boolean hasDefaultTitle(String string) {
        return string.equals(this.getDefaultTitle());
    }

    protected String getHelpID() {
        return "Default";
    }

    protected abstract AbstractInit loadInit(RandomInputStream var1, MapProperty var2) throws IOException;

    protected void setSelectionDialog(AbstractSelectionDialog abstractSelectionDialog) {
        if (this.selectionDialog != null) {
            this.selectionDialog.cleanUp();
        }
        this.selectionDialog = abstractSelectionDialog;
    }

    private void init() {
        DataTreeInterface dataTreeInterface;
        this.setPreferredSize(new Dimension(250, 250));
        this.addMouseListener(this);
        CSH.setHelpIDString((Component)this, (String)this.getHelpID());
        if (this.init != null && (dataTreeInterface = this.init.getDataTreeInterface()) != null) {
            dataTreeInterface.addDataTreeChangeListener(this);
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            CPopupMenu cPopupMenu = new CPopupMenu();
            if (this instanceof AbstractControlTable) {
                ((AbstractControlTable)this).addToPopup(mouseEvent, cPopupMenu, true, false);
            } else {
                this.addToPopup(this.project_GUI, this, mouseEvent.getPoint(), cPopupMenu, true);
            }
            Component component = mouseEvent.getComponent();
            if (component instanceof FloatWindow) {
                component = this;
            }
            cPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
        mouseEvent.consume();
    }

    public static interface CustomMenuTrigger {
        public void trigger(MouseEvent var1);
    }
}

