/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.window;

import com.jogamp.opengl.GLException;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.CPopupMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.common.selection.CommonSelection;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopStatusBar;
import se.prediktera.map.common.swing.scrollabledesktop.JScrollableDesktopPane;
import se.prediktera.map.common.swing.scrollabledesktop.TileSorter;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.TransferNode;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.AbstractMainGUI;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Model_GUI;
import se.prediktera.map.main.ProjectPane;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.EmptyWindow;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.layout.PlotWindowInterface;
import se.prediktera.map.plot.layout.SwitchInterface;
import se.prediktera.map.plot.layout.SwitchListener;

public abstract class AbstractWindow_GUI
extends AbstractMainGUI
implements DropTargetListener,
GlobalMessageInterface,
SwitchInterface {
    protected DataContainer windowContainer;
    protected Vector<JToolBar> windowToolbarsVector = new Vector();
    protected JToolBar windowToolbar = new JToolBar();
    protected final JToolBar windowSpecificToolBar = new JToolBar();
    protected JScrollableDesktopPane desktop;
    protected AbstractWindow currentWindow;
    private final String guiname;
    private ProjectPane settingsEast;
    private boolean isCreated = false;
    private byte lastmessagetype = (byte)-1;
    private byte lastmessage = (byte)-1;
    private boolean enabledSyncTree = false;
    private int currentGroupIndex;
    private int groupSize = 1;
    private final List<SwitchListener> switchListenerList = new ArrayList<SwitchListener>();

    public AbstractWindow_GUI(Project_GUI project_GUI, String string, CMenu cMenu) {
        super(project_GUI, string, cMenu);
        AbstractWindow_GUI abstractWindow_GUI;
        this.guiname = string;
        this.jbInit();
        new DropTarget(this, 3, this);
        this.windowContainer = this.createWindowContainer();
        if (this.windowContainer != null) {
            this.windowContainer.setVisibleInTree(false);
        }
        if ((abstractWindow_GUI = this.getOtherGUI()) != null && abstractWindow_GUI.getCurrentWindow() == null) {
            this.selectedWindowUpdated(project_GUI.getEmptyWindow());
        }
    }

    public AbstractWindow_GUI(RandomInputStream randomInputStream, Project_GUI project_GUI, ProgressManager progressManager, CMenu cMenu, String string) throws IOException {
        this(project_GUI, string, cMenu);
        MapProperty mapProperty = randomInputStream.readProperties(string);
        if (mapProperty == null) {
            this.windowContainer = this.createWindowContainer();
        } else {
            this.windowContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "wlc");
            if (this.windowContainer == null) {
                this.windowContainer = this.createWindowContainer();
            }
            this.lastmessagetype = mapProperty.getPropertyByte("lmt", (byte)-1);
            this.lastmessage = mapProperty.getPropertyByte("lm", (byte)-1);
            if (this.supportVersion(randomInputStream.getSaveVersion()) && mapProperty.hasProperty("nrwin")) {
                int n = mapProperty.getLVInt();
                for (int i = 0; i < n; ++i) {
                    AbstractWindow abstractWindow = (AbstractWindow)mapProperty.resolveNodeFromName(randomInputStream, "w" + i);
                    if (abstractWindow == null) continue;
                    DataTreeManager.LoadIntoMemory(this.getProject_GUI(), randomInputStream.getProgressManager(), abstractWindow, true);
                    this.addWindow(abstractWindow, true, false);
                }
            }
            if (mapProperty.hasProperty("fmode")) {
                this.desktop.setAutoMode(mapProperty.getLVByte());
            }
            this.currentWindow = (AbstractWindow)mapProperty.resolveNodeFromName(randomInputStream, "curW");
            this.currentGroupIndex = mapProperty.getPropertyInt("gi");
            this.groupSize = mapProperty.getPropertyInt("gs", 1);
            this.loadLocal(mapProperty);
        }
        this.windowContainer.setVisibleInTree(false);
    }

    @Override
    public void addSwitchListener(SwitchListener switchListener) {
        this.switchListenerList.add(switchListener);
    }

    public void addToDesktop(AbstractWindow abstractWindow, int n) {
        abstractWindow.setAssociatedFrame((BaseInternalFrame)this.desktop.add(abstractWindow, null, this.framePanel, n));
        this.selectWindow(abstractWindow, true);
        if (this.lastmessagetype != -1) {
            abstractWindow.PostGlobalMessage(this.lastmessagetype, this.lastmessage);
        }
    }

    public AbstractWindow addWindow(AbstractWindow abstractWindow, boolean bl) {
        return this.addWindow(abstractWindow, bl, 0, true);
    }

    public AbstractWindow addWindow(AbstractWindow abstractWindow, boolean bl, boolean bl2) {
        return this.addWindow(abstractWindow, bl, 0, bl2);
    }

    public AbstractWindow addWindow(AbstractWindow abstractWindow, boolean bl, int n) {
        return this.addWindow(abstractWindow, bl, n, true);
    }

    public AbstractWindow addWindow(AbstractWindow abstractWindow, boolean bl, int n, boolean bl2) {
        int n2 = 0;
        if (abstractWindow.getAbstractInit() != null) {
            n2 = abstractWindow.getAbstractInit().layer;
        }
        return this.addWindow(abstractWindow, bl, n, n2, bl2);
    }

    public AbstractWindow addWindow(AbstractWindow abstractWindow, boolean bl, int n, int n2, boolean bl2) {
        if (this.desktop == null || this.windowContainer == null) {
            return null;
        }
        if (EventQueue.isDispatchThread()) {
            int n3 = n;
            if (n3 < 0) {
                this.currentGroupIndex = n3 = this.groupSize;
                this.showGroupIndex();
            }
            abstractWindow.setGroupIndexLocal(n3);
            if (this.groupSize <= n3) {
                this.groupSize = n3 + 1;
                ActionEvent actionEvent = new ActionEvent(this, 0, String.valueOf(this.groupSize));
                Iterator<SwitchListener> iterator = this.switchListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().switchGroupChanged(actionEvent);
                }
            }
            if (n3 == this.currentGroupIndex) {
                if (abstractWindow.getAssociatedFrame() == null) {
                    this.addToDesktop(abstractWindow, n2);
                } else {
                    this.selectWindow(abstractWindow);
                }
            } else {
                abstractWindow.setAssociatedFrame((BaseInternalFrame)this.desktop.createInternalFrame(abstractWindow, abstractWindow.getIcon((byte)0), this.framePanel, n2));
            }
            if (!bl) {
                this.windowContainer.addTreeNode(abstractWindow);
            }
            if (bl2 && !abstractWindow.isCreated()) {
                abstractWindow.setCreated(this, bl);
                this.selectedWindowUpdated(abstractWindow);
            }
            if (this.isCreated) {
                this.project_GUI.setProjectChanged();
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.addWindow(abstractWindow, bl, n, n2, bl2));
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(invocationTargetException.getCause());
            }
            catch (InterruptedException interruptedException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(interruptedException);
            }
        }
        return abstractWindow;
    }

    public void addWindowContainer(AbstractWindow abstractWindow) {
        this.windowContainer.addTreeNode(abstractWindow);
    }

    public BaseInternalFrame addWindowOnTop(AbstractWindow abstractWindow) {
        return (BaseInternalFrame)this.desktop.add(abstractWindow, abstractWindow.getIcon((byte)0), this.framePanel, 1);
    }

    public void closeAllWindows() {
        this.closeAllWindows(false);
    }

    public abstract DataContainer createWindowContainer();

    public abstract AbstractWindow createWindowFromWizard(DataTreeInterface var1, WizardInfoInterface var2);

    public Object[] createWindowList() {
        return this.createWindowList(null);
    }

    public Object[] createWindowList(Properties properties) {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        ArrayList<AbstractGUI> arrayList = new ArrayList<AbstractGUI>();
        String string = null;
        if (properties != null) {
            try {
                if (ScriptHelper.hasKey(properties, "tag")) {
                    string = ScriptHelper.getProperty(properties, "tag");
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            AbstractWindow abstractWindow;
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrame;
            AbstractGUI abstractGUI = baseInternalFrame.getFrameGUI();
            if (string != null && !string.equalsIgnoreCase((abstractWindow = (AbstractWindow)abstractGUI).getTag())) continue;
            arrayList.add(abstractGUI);
        }
        Object[] objectArray = new Object[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = arrayList.get(i);
        }
        return objectArray;
    }

    public abstract void dataDropped(DataTreeInterface var1, int var2);

    public boolean doInteraction(InteractionInterface interactionInterface) {
        boolean bl = false;
        AbstractWindow abstractWindow = null;
        if (interactionInterface instanceof AbstractWindow) {
            abstractWindow = (AbstractWindow)interactionInterface;
        } else if (interactionInterface instanceof PlotWindowInterface) {
            abstractWindow = ((PlotWindowInterface)((Object)interactionInterface)).getParentBaseWindow();
        } else if (interactionInterface instanceof CommonSelection) {
            abstractWindow = ((CommonSelection)interactionInterface).getWindow();
        } else if (interactionInterface instanceof AbstractSelectionPage) {
            abstractWindow = ((AbstractSelectionPage)interactionInterface).getWindow();
        }
        for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
            AbstractWindow abstractWindow2;
            DataTreeInterface dataTreeInterface = this.windowContainer.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractWindow) || (abstractWindow2 = (AbstractWindow)dataTreeInterface) == interactionInterface || !abstractWindow2.isCreated() || !abstractWindow2.hasInteractionWith(abstractWindow) || !abstractWindow2.doInteraction(interactionInterface)) continue;
            abstractWindow2.finishInteraction();
            bl = true;
        }
        return bl;
    }

    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
        AbstractWindow abstractWindow = null;
        if (interactionInterface instanceof AbstractWindow) {
            abstractWindow = (AbstractWindow)interactionInterface;
        } else if (interactionInterface instanceof PlotWindowInterface) {
            abstractWindow = ((PlotWindowInterface)((Object)interactionInterface)).getParentBaseWindow();
        } else if (interactionInterface instanceof CommonSelection) {
            abstractWindow = ((CommonSelection)interactionInterface).getWindow();
        }
        for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
            AbstractWindow abstractWindow2;
            DataTreeInterface dataTreeInterface = this.windowContainer.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractWindow) || !(abstractWindow2 = (AbstractWindow)dataTreeInterface).isCreated() || !abstractWindow2.hasInteractionWith(abstractWindow)) continue;
            abstractWindow2.doQuickInteraction(abstractWindow, n, n2, n3, n4);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (!transferable.isDataFlavorSupported(TransferNode.INFO_FLAVOR)) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.acceptDrop(1);
        Thread thread = new Thread(new DropThread(dropTargetDropEvent));
        thread.start();
        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public abstract String getAreaName();

    public AbstractWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public JScrollableDesktopPane getDesktop() {
        return this.desktop;
    }

    public AbstractWindow getSelectedWindow() {
        BaseInternalFrame baseInternalFrame = this.desktop.getSelectedFrame();
        if (baseInternalFrame != null && baseInternalFrame.getFrameGUI() instanceof AbstractWindow) {
            return (AbstractWindow)baseInternalFrame.getFrameGUI();
        }
        return null;
    }

    @Override
    public JComponent getSettingsPanel() {
        return this.settingsEast;
    }

    @Override
    public String getSwitchDescription(int n) {
        return "";
    }

    @Override
    public int getSwitchIndex() {
        return this.currentGroupIndex;
    }

    @Override
    public int getSwitchSize() {
        return this.groupSize;
    }

    public abstract String getTitle(AbstractWindow var1);

    public void getToolbars(Vector<JToolBar> vector) {
        vector.add(this.windowToolbar);
    }

    public String getUniqueWindowName(String string) {
        return this.windowContainer.getUniqueName(string);
    }

    public AbstractWindow getWindowByName(String string) {
        return (AbstractWindow)this.windowContainer.getNodeByName(string);
    }

    public DataContainer getWindowContainer() {
        return this.windowContainer;
    }

    public abstract ImageIcon getWindowIcon();

    public void guiSelected() {
    }

    public boolean hasWindow(AbstractWindow abstractWindow) {
        return this.hasWindow(abstractWindow, false);
    }

    public boolean hasWindow(AbstractWindow abstractWindow, boolean bl) {
        if (abstractWindow == null) {
            return false;
        }
        for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
            AbstractWindow abstractWindow2 = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
            if (!(bl ? abstractWindow2.getClass() == abstractWindow.getClass() && abstractWindow2.getAbstractInit().equals(abstractWindow.getAbstractInit()) : abstractWindow2.equals(abstractWindow))) continue;
            return true;
        }
        return false;
    }

    public boolean isAllCreated() {
        for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.windowContainer.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractWindow) || ((AbstractWindow)dataTreeInterface).isCreated()) continue;
            return false;
        }
        return true;
    }

    public boolean isShowing(AbstractWindow abstractWindow) {
        BaseInternalFrame baseInternalFrame = abstractWindow.getAssociatedFrame();
        return this.desktop.contains(baseInternalFrame) && baseInternalFrame.isShowing();
    }

    public void PostGlobalMessage(byte by, byte by2) {
        if (this.desktop != null) {
            JInternalFrame[] jInternalFrameArray;
            block3: for (JInternalFrame jInternalFrame : jInternalFrameArray = this.desktop.getAllFrames()) {
                BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrame;
                AbstractWindow abstractWindow = (AbstractWindow)baseInternalFrame.getFrameGUI();
                if (abstractWindow == null || abstractWindow.isCleaned()) continue;
                switch (by) {
                    case 0: {
                        if (abstractWindow.SendGlobalMessage(by, by2) != 2) continue block3;
                        this.removeWindow(baseInternalFrame);
                        continue block3;
                    }
                    default: {
                        abstractWindow.SendGlobalMessage(by, by2);
                        this.lastmessagetype = by;
                        this.lastmessage = by2;
                    }
                }
            }
        }
    }

    public void registerShortcuts(AbstractWindow abstractWindow) {
        if (this.desktop != null) {
            this.desktop.getWindowToolbar().registerShortcuts(abstractWindow);
        }
    }

    public void removeFromDesktop(AbstractWindow abstractWindow) {
        this.desktop.remove(abstractWindow.getAssociatedFrame());
        abstractWindow.setAssociatedFrame(null);
    }

    public void removeWindow(AbstractWindow abstractWindow) {
        block4: {
            if (abstractWindow != null) {
                try {
                    abstractWindow.cleanUp();
                }
                catch (GLException gLException) {
                    if (abstractWindow.getParent() == null) break block4;
                    abstractWindow.getParent().remove(abstractWindow);
                }
            }
        }
        if (this.project_GUI != null && this.currentWindow != null && this.currentWindow.equals(abstractWindow) && !this.isCleaned()) {
            this.project_GUI.setSelectedWindow(null);
            this.selectedWindowUpdated(this.project_GUI.getEmptyWindow());
            this.project_GUI.setProjectChanged();
        }
    }

    public void removeWindow(BaseInternalFrame baseInternalFrame) {
        if (baseInternalFrame != null) {
            Runnable runnable = () -> {
                if (baseInternalFrame.getFrameGUI() instanceof AbstractWindow) {
                    this.removeWindow((AbstractWindow)baseInternalFrame.getFrameGUI());
                }
                if (this.desktop != null) {
                    this.desktop.remove(baseInternalFrame);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.beginProperty(this.guiname);
        randomOutputStream.writePropertyNode("wlc", this.windowContainer);
        randomOutputStream.writePropertyByte("lmt", this.lastmessagetype);
        randomOutputStream.writePropertyByte("lm", this.lastmessage);
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        Vector<BaseInternalFrame> vector = new Vector<BaseInternalFrame>();
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            if (!(jInternalFrame instanceof BaseInternalFrame)) continue;
            vector.addElement((BaseInternalFrame)jInternalFrame);
        }
        byte by = this.desktop.getAutoMode();
        if (by == 0 || by == 3) {
            Collections.sort(vector, new TileSorter(by));
        }
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            JInternalFrame jInternalFrame;
            jInternalFrame = (BaseInternalFrame)vector.get(i);
            AbstractGUI abstractGUI = ((BaseInternalFrame)jInternalFrame).getFrameGUI();
            if (!(abstractGUI instanceof AbstractWindow)) continue;
            randomOutputStream.writePropertyNode("w" + i, (AbstractWindow)abstractGUI);
            ++n;
        }
        randomOutputStream.writePropertyInt("nrwin", n);
        randomOutputStream.writePropertyByte("fmode", this.desktop.getAutoMode());
        if (this.currentWindow != null && this.currentWindow.getAssociatedFrame() != null && this.currentWindow.getAssociatedFrame().isSelected()) {
            randomOutputStream.writePropertyNode("curW", this.currentWindow);
        }
        randomOutputStream.writePropertyInt("gi", this.currentGroupIndex);
        randomOutputStream.writePropertyInt("gs", this.groupSize);
        this.saveLocal(randomOutputStream);
        randomOutputStream.endProperty();
    }

    @Override
    public void selectedFrameUpdated(BaseInternalFrame baseInternalFrame) {
        if (this.currentWindow != null) {
            this.selectedWindowUpdated(this.currentWindow);
        }
    }

    public void selectedWindowUpdated(AbstractWindow abstractWindow) {
        this.selectedWindowUpdated(abstractWindow, false);
    }

    public void selectedWindowUpdated(AbstractWindow abstractWindow, boolean bl) {
        Object object;
        if (this.project_GUI != null) {
            this.guiSelected();
        }
        BaseInternalFrame baseInternalFrame = null;
        if (abstractWindow == null) {
            if (this.project_GUI == null) {
                return;
            }
            abstractWindow = this.project_GUI.getEmptyWindow();
        } else {
            if (abstractWindow instanceof AbstractControlTable) {
                abstractWindow = ((AbstractControlTable)abstractWindow).getDataSetTable();
            }
            baseInternalFrame = abstractWindow.getAssociatedFrame();
        }
        boolean bl2 = abstractWindow instanceof EmptyWindow;
        if (!(bl2 || baseInternalFrame != null && baseInternalFrame.getLayer() <= 0)) {
            return;
        }
        AbstractWindow_GUI abstractWindow_GUI = this.getOtherGUI();
        if (abstractWindow_GUI != null && (object = abstractWindow_GUI.getCurrentWindow()) != null && ((AbstractGUI)object).getAssociatedFrame() != null) {
            try {
                ((AbstractGUI)object).getAssociatedFrame().setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!bl && abstractWindow == this.getCurrentWindow()) {
            if (abstractWindow != null) {
                this.setWindowProperties(abstractWindow.getSettingsPanel(), !bl2);
            }
            return;
        }
        this.windowSpecificToolBar.removeAll();
        if (this.menu != null) {
            this.menu.removeAll();
            this.setWindowMenu(this.menu, this.windowToolbar);
        }
        if (baseInternalFrame != null || bl2) {
            this.currentWindow = abstractWindow;
            this.windowToolbarsVector.clear();
            object = this.getTitle(null);
            if (this.project_GUI != null && !this.isCleaned()) {
                object = this.getTitle(abstractWindow);
                this.setSettingsToolbar(abstractWindow.getSettingsToolbar());
                this.desktop.getWindowToolbar().updateWindow(abstractWindow);
                abstractWindow.getToolbars(this.windowToolbarsVector);
                for (int i = 0; i < this.windowToolbarsVector.size(); ++i) {
                    if (i >= this.windowToolbarsVector.size()) continue;
                    try {
                        JToolBar jToolBar = this.windowToolbarsVector.get(i);
                        if (jToolBar.isVisible()) {
                            this.windowSpecificToolBar.add(jToolBar);
                        }
                        this.setWindowMenu(this.menu, jToolBar);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.windowSpecificToolBar.revalidate();
                this.northTitle.setText((String)object);
                this.setWindowProperties(abstractWindow.getSettingsPanel(), !bl2);
            }
        }
        if (this.centerPanel != null) {
            this.centerPanel.repaint();
        }
        if (this.settingsEast != null) {
            this.settingsEast.repaint();
        }
        if (this.northTitle != null) {
            this.northTitle.repaint();
        }
    }

    public void selectWindow(AbstractWindow abstractWindow) {
        this.selectWindow(abstractWindow, false);
    }

    public void setAutoMode(byte by) {
        this.desktop.setAutoMode(by);
    }

    public void setContentReady() {
        for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
            AbstractWindow abstractWindow = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
            if (abstractWindow.isContentReady()) continue;
            abstractWindow.setContentReady(true);
        }
    }

    public void setCreated() {
        Runnable runnable = () -> {
            AbstractWindow abstractWindow = null;
            for (int i = 0; i < this.windowContainer.getTreeNodeCount(); ++i) {
                abstractWindow = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
                abstractWindow.setCreated(this, true);
                if (this.lastmessagetype == -1) continue;
                abstractWindow.PostGlobalMessage(this.lastmessagetype, this.lastmessage);
            }
            if (this.currentWindow != null) {
                abstractWindow = this.currentWindow;
            }
            if (abstractWindow != null) {
                this.selectWindow(abstractWindow, true);
                BaseInternalFrame baseInternalFrame = abstractWindow.getAssociatedFrame();
                if (baseInternalFrame != null) {
                    if (this.currentWindow != null) {
                        this.currentWindow = null;
                        baseInternalFrame.selectFrameAndAssociatedButtons();
                    } else {
                        baseInternalFrame.setAssociatedButtonsAndTitle();
                    }
                }
            }
            this.isCreated = true;
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setEnabledSyncTree(boolean bl) {
        if (!bl) {
            this.showOnlyRelatedTo(null);
            this.enabledSyncTree = bl;
        } else {
            this.enabledSyncTree = bl;
            this.showOnlyRelatedTo(this.project_GUI.getSelectedTreeNode());
        }
    }

    public void setProperties(Properties properties) throws Exception {
        if (ScriptHelper.hasKey(properties, this.getGUI_Name() + "_arrange")) {
            String string = ScriptHelper.getProperty(properties, this.getGUI_Name() + "_arrange");
            if (string.equals("maximize")) {
                this.desktop.setAutoMode((byte)2);
            } else if (string.equals("cascade")) {
                this.desktop.setAutoMode((byte)1);
            } else if (string.equals("horizontal")) {
                this.desktop.setAutoMode((byte)0);
            } else if (string.equals("vertical")) {
                this.desktop.setAutoMode((byte)3);
            }
        }
    }

    public void setWindowProperties(JPanel jPanel, boolean bl) {
        if (this.project_GUI == null || jPanel == null) {
            return;
        }
        AbstractLayerPanel abstractLayerPanel = this.project_GUI.getCurrentLayerPanel();
        if (abstractLayerPanel != null && abstractLayerPanel.isLocked()) {
            abstractLayerPanel.setNextLayerPanel(jPanel, this.settingsEast);
            return;
        }
        this.settingsEast.setCenterPanel(jPanel);
        if (jPanel instanceof AbstractLayerPanel) {
            this.project_GUI.setCurrentLayerPanel((AbstractLayerPanel)jPanel);
        } else {
            this.project_GUI.setCurrentLayerPanel(null);
        }
    }

    public void showGroupIndex() {
        DesktopStatusBar desktopStatusBar = (DesktopStatusBar)this.desktop.getDesktopComponentBar();
        for (int i = this.windowContainer.getTreeNodeCount() - 1; i >= 0; --i) {
            AbstractWindow abstractWindow = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
            BaseInternalFrame baseInternalFrame = abstractWindow.getAssociatedFrame();
            if (this.currentGroupIndex == -1 || abstractWindow.getGroupIndexLocal() == this.currentGroupIndex) {
                if (this.desktop.hasFrame(baseInternalFrame)) continue;
                this.desktop.showFrame(baseInternalFrame);
                desktopStatusBar.addFrame(baseInternalFrame);
                continue;
            }
            this.desktop.hideFrame(baseInternalFrame);
            desktopStatusBar.removeFrame(baseInternalFrame);
        }
        this.desktop.autoTile();
        this.desktop.repaint();
    }

    public void showOnlyRelatedTo(DataTreeInterface dataTreeInterface) {
        if (this.enabledSyncTree) {
            DataTreeInterface dataTreeInterface2 = DataTreeManager.getAncestorNull(dataTreeInterface, AbstractModel.class);
            DataTreeInterface dataTreeInterface3 = DataTreeManager.getAncestorNull(dataTreeInterface, DataSet.class);
            DesktopStatusBar desktopStatusBar = (DesktopStatusBar)this.desktop.getDesktopComponentBar();
            for (int i = this.windowContainer.getTreeNodeCount() - 1; i >= 0; --i) {
                AbstractWindow abstractWindow = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
                BaseInternalFrame baseInternalFrame = abstractWindow.getAssociatedFrame();
                AbstractInit abstractInit = abstractWindow.getAbstractInit();
                boolean bl = false;
                if (abstractInit != null && abstractInit.getDataTreeInterface() != null) {
                    DataTreeInterface dataTreeInterface4 = abstractInit.getDataTreeInterface();
                    bl = dataTreeInterface2 != null ? DataTreeManager.isParentTo(dataTreeInterface2, dataTreeInterface4) : DataTreeManager.isParentTo(dataTreeInterface3, dataTreeInterface4);
                }
                if (bl && !this.desktop.hasFrame(baseInternalFrame)) {
                    this.desktop.showFrame(baseInternalFrame);
                    desktopStatusBar.addFrame(baseInternalFrame);
                    continue;
                }
                if (bl) continue;
                this.desktop.hideFrame(baseInternalFrame);
                desktopStatusBar.removeFrame(baseInternalFrame);
            }
            this.desktop.autoTile();
            this.desktop.repaint();
        }
    }

    @Override
    public void switchIndex(int n) {
        this.currentGroupIndex = n;
        this.showGroupIndex();
    }

    @Override
    public void switchLeft() {
        --this.currentGroupIndex;
        if (this.currentGroupIndex < 0) {
            this.currentGroupIndex = this.groupSize - 1;
        }
        this.showGroupIndex();
    }

    @Override
    public void switchRight() {
        ++this.currentGroupIndex;
        if (this.currentGroupIndex >= this.groupSize) {
            this.currentGroupIndex = 0;
        }
        this.showGroupIndex();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.desktop != null) {
            JInternalFrame[] jInternalFrameArray;
            for (JInternalFrame jInternalFrame : jInternalFrameArray = this.desktop.getAllFrames()) {
                this.removeWindow((BaseInternalFrame)jInternalFrame);
            }
        }
        try {
            for (int i = this.windowContainer.getTreeNodeCount() - 1; i >= 0; --i) {
                ((DataTreeInterface)this.windowContainer.get(i)).cleanUp();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.desktop != null) {
            this.desktop.cleanUp();
            this.desktop = null;
        }
        this.windowToolbarsVector.clear();
    }

    protected void loadLocal(MapProperty mapProperty) throws IOException {
    }

    protected void saveLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    protected abstract boolean supportVersion(long var1);

    private void closeAllWindows(boolean bl) {
        AbstractWindow abstractWindow = null;
        if (bl) {
            abstractWindow = this.currentWindow;
        }
        for (int i = this.windowContainer.getTreeNodeCount() - 1; i >= 0; --i) {
            AbstractWindow abstractWindow2 = (AbstractWindow)this.windowContainer.getTreeNodeAt(i);
            if (abstractWindow2 == abstractWindow) continue;
            BaseInternalFrame baseInternalFrame = abstractWindow2.getAssociatedFrame();
            abstractWindow2.cleanUp();
            this.removeWindow(baseInternalFrame);
        }
        if (this.project_GUI != null) {
            if (!bl) {
                this.project_GUI.setSelectedWindow(null);
                this.selectedWindowUpdated(this.project_GUI.getEmptyWindow());
            }
            this.project_GUI.setProjectChanged();
        }
    }

    private void jbInit() {
        if (this.project_GUI != null) {
            this.settingsEast = this.project_GUI.getSettingsEast();
        }
        this.desktop = new JScrollableDesktopPane(this, new JMenuBar(), true, 0);
        this.windowSpecificToolBar.setBackground(Color.white);
        this.windowSpecificToolBar.setFloatable(false);
        this.windowSpecificToolBar.setBorder(null);
        this.centerPanel.add((Component)this.desktop, "Center");
        DesktopStatusBar desktopStatusBar = (DesktopStatusBar)this.desktop.getDesktopComponentBar();
        if (!(this instanceof Model_GUI)) {
            desktopStatusBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopup(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopup(mouseEvent);
                }

                private void showPopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        CPopupMenu cPopupMenu = new CPopupMenu();
                        cPopupMenu.add(new CMenuItem("Close all windows", false){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                AbstractWindow_GUI.this.closeAllWindows(false);
                            }
                        });
                        cPopupMenu.add(new CMenuItem("Close all windows except selected", false){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                AbstractWindow_GUI.this.closeAllWindows(true);
                            }
                        });
                        cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        mouseEvent.consume();
                    }
                }
            });
        }
        JLabel jLabel = new JLabel(this.getWindowIcon());
        jLabel.setBackground(desktopStatusBar.getFrameInterface().getCellBackground());
        jLabel.setOpaque(true);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    CPopupMenu cPopupMenu = new CPopupMenu();
                    cPopupMenu.add(new CMenuItem("Close all windows", false){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            AbstractWindow_GUI.this.closeAllWindows(false);
                        }
                    });
                    cPopupMenu.add(new CMenuItem("Close all windows except selected", false){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            AbstractWindow_GUI.this.closeAllWindows(true);
                        }
                    });
                    cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            }
        });
        ImageIcon imageIcon = new ImageIcon(Main_GUI.class.getResource("icons/other/setting.png"));
        JFlatButton jFlatButton = new JFlatButton(imageIcon);
        jFlatButton.addActionListener(actionEvent -> {
            BaseInternalFrame baseInternalFrame = this.desktop.getSelectedFrame();
            if (baseInternalFrame == null) {
                return;
            }
            AbstractGUI abstractGUI = baseInternalFrame.getFrameGUI();
            if (abstractGUI instanceof AbstractWindow) {
                ((AbstractWindow)abstractGUI).showProperties();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 6, 0, 12), 0, 0);
        this.northTitle.addComponent(jLabel, gridBagConstraints);
        this.northTitle.addToolbar(this.desktop.getWindowToolbar(), 1, 0.0f);
        this.northTitle.addToolbar(this.windowSpecificToolBar, 2, 0.0f);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.northTitle.addComponent(jFlatButton, gridBagConstraints2);
        this.northTitle.addTitlePanel(desktopStatusBar);
        this.northTitle.getTitlePanel().setBorder(BorderFactory.createEtchedBorder());
        this.northTitle.createFramePanel(desktopStatusBar);
        this.windowToolbar.setFloatable(false);
    }

    private void selectWindow(AbstractWindow abstractWindow, boolean bl) {
        if (abstractWindow != null && (this.desktop.getSelectedFrame() != abstractWindow.getAssociatedFrame() || bl)) {
            this.desktop.setSelectedFrame(abstractWindow.getAssociatedFrame());
        }
    }

    private class DropThread
    implements Runnable {
        private final int dropAction;
        private DataTreeInterface dataNode = null;

        public DropThread(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            TransferNode transferNode = null;
            try {
                transferNode = (TransferNode)transferable.getTransferData(TransferNode.INFO_FLAVOR);
                this.dataNode = ((AbstractWindow_GUI)AbstractWindow_GUI.this).project_GUI.dataTreeManager.getDataTreeInterface(transferNode.getNodeID());
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            this.dropAction = dropTargetDropEvent.getDropAction();
        }

        @Override
        public void run() {
            AbstractWindow_GUI.this.dataDropped(this.dataNode, this.dropAction);
        }
    }
}

