/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.main.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.scrollabledesktop.JScrollableDesktopPane;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.main.window.EmptyWindow;
import se.prediktera.map.main.window.JFlatToggleSwitchButtonComboBox;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.register.RegisterKeyManager;

public class WindowToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private final JFlatButtonComboBox buttonComboBox = new JFlatButtonComboBox();
    private final JFlatToggleButton buttonSyncTree = new JFlatToggleButton();
    private final JFlatButton buttonPrint = new JFlatButton();
    private final JFlatButton maximizePlots = new JFlatButton();
    private final JFlatButton tilehorPlots = new JFlatButton();
    private final JFlatButton tileverPlots = new JFlatButton();
    private final JFlatButton cascadePlots = new JFlatButton();
    private final JFlatToggleSwitchButtonComboBox switchButtonComboBox;
    private JScrollableDesktopPane desktop;
    private AbstractWindow_GUI window_GUI;

    public WindowToolbar(JScrollableDesktopPane jScrollableDesktopPane, AbstractWindow_GUI abstractWindow_GUI) {
        this.desktop = jScrollableDesktopPane;
        this.window_GUI = abstractWindow_GUI;
        this.switchButtonComboBox = new JFlatToggleSwitchButtonComboBox(abstractWindow_GUI);
        this.jbInit();
    }

    public void registerShortcuts(AbstractWindow abstractWindow) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowToolbar.this.buttonPrint.doClick();
            }
        };
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(80, 2), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowToolbar.this.maximizePlots.doClick();
            }
        };
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(49, 2), abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowToolbar.this.tileverPlots.doClick();
            }
        };
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(50, 2), abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowToolbar.this.tilehorPlots.doClick();
            }
        };
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(51, 2), abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowToolbar.this.cascadePlots.doClick();
            }
        };
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(52, 2), abstractAction5);
    }

    public void setAutoMode(byte by) {
        switch (by) {
            case 2: {
                this.buttonComboBox.setSelectedButton(this.maximizePlots);
                break;
            }
            case 0: {
                this.buttonComboBox.setSelectedButton(this.tilehorPlots);
                break;
            }
            case 3: {
                this.buttonComboBox.setSelectedButton(this.tileverPlots);
                break;
            }
            case 1: {
                this.buttonComboBox.setSelectedButton(this.cascadePlots);
                break;
            }
        }
    }

    public void updateWindow(AbstractWindow abstractWindow) {
        boolean bl = !(abstractWindow instanceof AbstractTable) && !(abstractWindow instanceof AbstractModelContainerWindow) && abstractWindow != null;
        boolean bl2 = bl && !(abstractWindow instanceof EmptyWindow);
        this.buttonPrint.setEnabled(bl2);
        this.buttonPrint.setVisible(bl);
    }

    @Override
    protected void cleanUpChild() {
        this.desktop = null;
        this.window_GUI = null;
    }

    private void jbInit() {
        this.maximizePlots.setToolTipText("Maximize Windows");
        this.maximizePlots.setIcon(new ImageIcon(Main_GUI.class.getResource("button/maximize.png")));
        this.maximizePlots.addActionListener(actionEvent -> this.desktop.setAutoMode((byte)2));
        this.tilehorPlots.setToolTipText("Tile Windows Vertically");
        this.tilehorPlots.setIcon(new ImageIcon(Main_GUI.class.getResource("button/tilehor.png")));
        this.tilehorPlots.addActionListener(actionEvent -> this.desktop.setAutoMode((byte)0));
        this.tileverPlots.setToolTipText("Tile Windows Horizontally");
        this.tileverPlots.setIcon(new ImageIcon(Main_GUI.class.getResource("button/tilever.png")));
        this.tileverPlots.addActionListener(actionEvent -> this.desktop.setAutoMode((byte)3));
        this.cascadePlots.setToolTipText("Cascade Windows");
        this.cascadePlots.setIcon(new ImageIcon(Main_GUI.class.getResource("button/cascade.png")));
        this.cascadePlots.addActionListener(actionEvent -> this.desktop.setAutoMode((byte)1));
        this.buttonComboBox.addButton(this.maximizePlots);
        this.buttonComboBox.addButton(this.tilehorPlots);
        this.buttonComboBox.addButton(this.tileverPlots);
        this.buttonComboBox.addButton(this.cascadePlots);
        this.buttonComboBox.setToolTipText("Arrange");
        this.buttonPrint.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/printer.png")));
        this.buttonPrint.setActionCommand("print");
        this.buttonPrint.setToolTipText("Print");
        this.buttonPrint.addActionListener(actionEvent -> this.desktop.printSelectedWindow());
        this.buttonSyncTree.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/syncronize.png")));
        this.buttonSyncTree.setActionCommand("sync");
        this.buttonSyncTree.setToolTipText("Only show windows related to selected Model");
        this.buttonSyncTree.addActionListener(actionEvent -> this.window_GUI.setEnabledSyncTree(this.buttonSyncTree.isSelected()));
        this.setBorder(null);
        this.setFloatable(false);
        this.add((Component)this.buttonComboBox, null);
        this.add((Component)this.switchButtonComboBox, null);
        if (this.window_GUI instanceof Plot_GUI || this.window_GUI instanceof Data_GUI) {
            this.add((Component)this.buttonPrint, null);
            if (RegisterKeyManager.isPredikteraLicense()) {
                this.add(this.buttonSyncTree);
            }
        }
        this.updateWindow(null);
    }
}

