/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.CRadioButtonMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.TreeHeader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationDataNode;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JLabelArea;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Graph_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.FileDataClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.script.StringDataClass;
import se.prediktera.map.model.AbstractBasicModel;
import se.prediktera.map.model.AbstractModelResults;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelInterface;
import se.prediktera.map.model.ModelListener;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.register.RegisterKeyManager;

public abstract class AbstractModel
extends AbstractBasicModel
implements ModelInterface {
    public static final ImageIcon modelIcon = AbstractPaint.createIcon(3);
    public static final ImageIcon modelViewIcon = new ImageIcon(Main_GUI.class.getResource("gif/model_layout_button.png"));
    public static final ImageIcon modelExternalIcon = AbstractPaint.createIcon(14);
    public static boolean CALCV = false;
    protected DataSet dataSet;
    private final ArrayList<ModelListener> listeners = new ArrayList();
    private boolean usedcrit = false;
    private double tValue = 1.96;
    private double dcritP = 0.05;
    private double hotellingt2P = 0.05;
    private double dcritX = Double.MAX_VALUE;
    private double dcritY = Double.MAX_VALUE;
    private boolean usehotellingt2 = false;
    private double hotellingt2 = Double.MAX_VALUE;
    private boolean external;
    private double calculatedS0;
    private boolean isSavingModel = false;
    private boolean[] includedArray = null;
    private String description;
    private AbstractModel replaceModel;
    private int replaceModelID;
    private String replaceClassName;
    private double cutOffLow;
    private boolean datasetchanged = false;
    private boolean enabled = false;
    private DataContainer outputContainer = null;
    private OutputClass outputClass = null;
    protected boolean recalcautofit = false;
    private boolean dcritXmanually = false;
    private boolean dcritYmanually = false;
    private boolean hotellingT2manually = false;
    private CutOffCallback cutOffCallback;

    public AbstractModel() {
        super("AbstractModel", false);
    }

    public AbstractModel(DataSet dataSet) {
        super("AbstractModel", false);
        this.dataSet = dataSet;
        this.createOutputContainer();
    }

    public AbstractModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "dataSet");
        this.usedcrit = mapProperty.getPropertyBoolean("usedcrit", true);
        this.dcritX = mapProperty.getPropertyDouble("dcrit", Double.MAX_VALUE);
        this.dcritY = mapProperty.getPropertyDouble("dcritY", Double.MAX_VALUE);
        this.usehotellingt2 = mapProperty.getPropertyBoolean("usehotelling", false);
        this.hotellingt2 = mapProperty.getPropertyDouble("hotellingt2", Double.MAX_VALUE);
        if (!mapProperty.hasProperty("manual")) {
            this.setManual(randomInputStream.getProgressManager(), false);
        }
        this.external = mapProperty.getPropertyBoolean("external");
        this.description = mapProperty.getPropertyStringUTF(this.description);
        this.includedArray = mapProperty.getPropertyBooleanArray("includedArray");
        this.outputContainer = (DataContainer)mapProperty.resolveNodeFromName(randomInputStream, "outputc");
        this.outputClass = (OutputClass)mapProperty.resolveNodeFromName(randomInputStream, "output");
        this.replaceModel = (AbstractModel)mapProperty.resolveNodeFromName(randomInputStream, "rcmodel");
        this.replaceModelID = mapProperty.getPropertyInt("rcid");
        this.replaceClassName = mapProperty.getPropertyStringUTF("rcname");
        this.datasetchanged = mapProperty.getPropertyBoolean("dchanged");
        this.enabled = mapProperty.getPropertyBoolean("enabled", true);
    }

    public void addDModXYandDcrit(ModelMatrix modelMatrix, AbstractMVmatrix abstractMVmatrix, int n) throws Exception {
        DenseVector denseVector = this.calcDModXY(abstractMVmatrix, n);
        modelMatrix.addRow(denseVector);
        ModelMatrix modelMatrix2 = modelMatrix.getAdditionalMatrix();
        if (modelMatrix2 == null) {
            modelMatrix2 = new ModelMatrix(modelMatrix.getDataInfo(0), modelMatrix);
            modelMatrix2.setName("Dcrit");
            modelMatrix2.setVisibleInTree(false);
            modelMatrix.addTreeNode(modelMatrix2);
        }
        modelMatrix2.addRow(this.calculateDcritFromTvalue(denseVector));
    }

    public void addHotellingT2(ModelMatrix modelMatrix, ModelMatrix modelMatrix2, ModelMatrix modelMatrix3) throws Exception {
        if (modelMatrix != null) {
            this.calculateHotellingT2(modelMatrix, modelMatrix2, modelMatrix3);
            ModelMatrix modelMatrix4 = modelMatrix.getAdditionalMatrix();
            if (modelMatrix4 == null) {
                modelMatrix4 = new ModelMatrix(modelMatrix.getDataInfo(0), modelMatrix);
                modelMatrix4.setName("Value");
                modelMatrix4.setVisibleInTree(false);
                modelMatrix.addTreeNode(modelMatrix4);
            }
            modelMatrix4.addRow(this.calculateHotellingT2FromPValue());
        }
    }

    public void calculateHotellingT2(ModelMatrix modelMatrix, ModelMatrix modelMatrix2, ModelMatrix modelMatrix3) {
        if (modelMatrix != null) {
            modelMatrix.setVisibleInTree(Evince.isHotellingT2Feature());
            DenseVector denseVector = new DenseVector(modelMatrix2.getK());
            for (int i = 0; i < modelMatrix2.getN(); ++i) {
                double d = modelMatrix3.getScalar(i);
                for (int j = 0; j < denseVector.size(); ++j) {
                    double d2 = modelMatrix2.getValue(i, j);
                    denseVector.set(j, denseVector.get(j) + Math.pow(d2, 2.0) / d);
                }
            }
            modelMatrix.addRow(denseVector);
        }
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void addPrediction(ProgressManager progressManager, AbstractPrediction abstractPrediction) {
        InnerColumnPredClass innerColumnPredClass = abstractPrediction.getPredictionCategory(false);
        this.addPrediction(progressManager, abstractPrediction.getDataSet(), innerColumnPredClass, this.getReplaceClassName(), null);
    }

    public void addPrediction(ProgressManager progressManager, DataSet dataSet, InnerColumnPredClass innerColumnPredClass, String string) {
        this.addPrediction(progressManager, dataSet, innerColumnPredClass, string, null);
    }

    public void addPrediction(ProgressManager progressManager, DataSet dataSet, InnerColumnPredClass innerColumnPredClass, String string, Properties properties) {
        AbstractPrediction abstractPrediction = (AbstractPrediction)this.createPrediction(progressManager, dataSet, properties);
        InnerColumnPredClass innerColumnPredClass2 = abstractPrediction.getPredictionCategory(false);
        if (innerColumnPredClass2 != null) {
            innerColumnPredClass.replaceClassWithPrediction(string, innerColumnPredClass2);
        }
    }

    public void addToPopupMenu(Project_GUI project_GUI, CMenu cMenu) {
    }

    public void addToPopupMenu(final Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        if (project_GUI == null) {
            return;
        }
        if (this.dataSet != null) {
            jPopupMenu.add(project_GUI.getData_GUI().getTableMenu(this));
            jPopupMenu.add(project_GUI.getPlot_GUI().getPlotMenu(this));
            jPopupMenu.addSeparator();
            jMenuItem = new CMenu("Apply Template", true);
            ScriptManager.addScriptToMenu((CMenu)jMenuItem, this, this.dataSet, "model", this.getModelName());
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        if (this.supportPrediction()) {
            jMenuItem = new CMenuItem((Object)project_GUI, true);
            jMenuItem.setText("Save As...");
            jMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
            jMenuItem.addActionListener(actionEvent -> this.saveModel(project_GUI));
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new CMenuItem(this, "Delete", new ImageIcon(Main_GUI.class.getResource("gif/delete.png"))){
            final /* synthetic */ AbstractModel this$0;
            {
                this.this$0 = abstractModel;
                super(string, imageIcon);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete \"" + String.valueOf(this.this$0) + "\"?", "Really delete?", 2);
                if (n == 0) {
                    DataTreeManager dataTreeManager = this.this$0.getDataTreeManager();
                    this.this$0.cleanUp();
                    if (project_GUI != null) {
                        project_GUI.purgeSignal();
                        dataTreeManager.updateHistory();
                    }
                }
            }
        };
        jPopupMenu.add(jMenuItem);
        jMenuItem = new CMenuItem("Rename", true);
        jMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for the model:", AbstractModel.this.toString());
                if (string != null) {
                    AbstractModel.this.setName(string);
                    AbstractModel.this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)AbstractModel.this, string));
                }
            }
        });
        jPopupMenu.add(jMenuItem);
    }

    public void applyChanges(ProgressManager progressManager) {
        this.applyChanges(progressManager, null);
    }

    public void applyChanges(ProgressManager progressManager, Properties properties) {
        int n = this.getDeciseconds();
        if (ScriptHelper.hasKey(properties, "deciseconds")) {
            this.setDeciseconds(ScriptHelper.getPropertyInt(properties, "deciseconds"));
        }
        if (ScriptHelper.hasKey(properties, "autofit")) {
            this.recalcautofit = ScriptHelper.getPropertyBool(properties, "autofit");
        }
        this.setChanged(progressManager);
        this.setDeciseconds(n);
        this.recalcautofit = false;
    }

    public abstract void applyTransformationX(AbstractDataMatrix var1);

    public abstract void applyTransformationY(AbstractDataMatrix var1);

    public DenseVector calcDModXY(AbstractMVmatrix abstractMVmatrix, int n) throws Exception {
        int n2 = abstractMVmatrix.getN();
        int n3 = abstractMVmatrix.getK();
        double d = n3 - n;
        DenseVector denseVector = this.calcDModXY(abstractMVmatrix, n2, n3, d);
        this.calculatedS0 = Math.sqrt(this.calculatedS0 / ((double)(n2 - n - 1) * d));
        if (CALCV) {
            double d2 = Math.sqrt((double)n2 / (double)(n2 - n - 1));
            denseVector.scale(d2 / this.calculatedS0);
        } else {
            denseVector.scale(1.0 / this.calculatedS0);
        }
        return denseVector;
    }

    public void setComponents(ProgressManager progressManager, int n) {
        int n2 = n - this.getComponentsInt();
        if (n2 != 0) {
            this.changeComponent(progressManager, n2);
        }
    }

    public void changeComponent(ProgressManager progressManager, int n) {
    }

    public int[] createIncIdxArray() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = null;
        if (this.dataSet != null) {
            int n;
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            for (n = 0; n < innerColumnBoolean.getSize(); ++n) {
                if (!innerColumnBoolean2.getValueBool(n) || !innerColumnBoolean.getValueBool(n)) continue;
                arrayList.add(n);
            }
            nArray = new int[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public String[] createIncDescriptionArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (this.dataSet != null) {
            int n;
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            InnerColumnString innerColumnString = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
            for (n = 0; n < innerColumnBoolean.getSize(); ++n) {
                if (!innerColumnBoolean2.getValueBool(n) || !innerColumnBoolean.getValueBool(n)) continue;
                String string = innerColumnString.getValueLocal(n);
                arrayList.add(string.replace(',', '.'));
            }
            stringArray = new String[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray[n] = (String)arrayList.get(n);
            }
        }
        return stringArray;
    }

    public boolean[] createIncludedArray() {
        if (this.dataSet != null) {
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean2.getValueBool(i)) continue;
                arrayList.add(innerColumnBoolean.getValueBool(i));
            }
            boolean[] blArray = null;
            Case case_ = this.getCase();
            if (case_ != null) {
                blArray = case_.getIncludedArray();
            }
            this.includedArray = blArray != null ? (boolean[])blArray.clone() : new boolean[arrayList.size()];
            int n = 0;
            for (int i = 0; i < this.includedArray.length; ++i) {
                if (blArray != null && !blArray[i]) continue;
                this.includedArray[i] = (Boolean)arrayList.get(n++);
            }
        }
        return this.includedArray;
    }

    public DataTreeInterface createPrediction(ProgressManager progressManager, DataSet dataSet) {
        return this.createPrediction(progressManager, dataSet, null);
    }

    public DataTreeInterface createPrediction(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        if (progressManager != null) {
            progressManager.setInfoText("Predicting with model: " + String.valueOf(this));
        }
        this.checkTrainSet(dataSet);
        AbstractPrediction abstractPrediction = this.createPredictionLocal(progressManager, dataSet, properties);
        if (dataSet != this.dataSet) {
            DataContainer dataContainer = (DataContainer)dataSet.getNodeByName("Predictions");
            if (dataContainer == null) {
                dataContainer = new DataContainer("Predictions", 14);
                dataSet.addTreeNode(dataContainer);
            }
            dataContainer.addTreeNode(abstractPrediction);
            DataContainer dataContainer2 = (DataContainer)this.getNodeByName("External predictions");
            if (dataContainer2 == null) {
                dataContainer2 = new DataContainer("External predictions", 13);
                this.addTreeNode(dataContainer2);
            }
            dataContainer2.addTreeNode(abstractPrediction, dataSet);
        } else {
            this.addTreeNode(abstractPrediction);
        }
        return abstractPrediction;
    }

    public abstract AbstractPrediction createPredictionLocal(ProgressManager var1, DataSet var2, Properties var3);

    @Override
    public abstract AbstractTModel createTableModel();

    public void delete() {
        Case case_ = this.getCase();
        Project_GUI project_GUI = this.getProject_GUI();
        if (case_ != null && case_.isExternal()) {
            case_.purge();
        } else {
            this.cleanUp();
        }
        if (project_GUI != null && Project_GUI.getMode() == 0) {
            project_GUI.purgeSignal();
        }
    }

    protected boolean resetModel(ProgressManager progressManager, boolean bl) {
        this.calculatedS0 = 0.0;
        return false;
    }

    @Override
    public void doUpdate(ProgressManager progressManager) {
        super.doUpdate(progressManager);
        this.setDatasetchanged(false);
    }

    @Override
    public void endUpdateRecursive() {
        super.endUpdateRecursive();
        this.fireUpdatedEvent();
    }

    public Object get(String string) {
        if (string.equalsIgnoreCase("type")) {
            return new StringDataClass(this.getModelName());
        }
        if (string.equalsIgnoreCase("name")) {
            return this.toString();
        }
        if (string.equalsIgnoreCase("dataset")) {
            return this.dataSet;
        }
        if (string.equalsIgnoreCase("xtraining")) {
            return this.dataSet.getMatrix(0);
        }
        if (string.equalsIgnoreCase("originalmatrix")) {
            return this.dataSet.getOriginalMatrix();
        }
        if (string.equalsIgnoreCase("case")) {
            return this.dataSet.getCase();
        }
        if (string.equalsIgnoreCase("prediction")) {
            return this.getLocalPredictionNode();
        }
        if (string.equalsIgnoreCase("dcrit")) {
            return this.getDcritX();
        }
        if (string.equalsIgnoreCase("components")) {
            return (double)this.getComponentsInt();
        }
        if (string.equalsIgnoreCase("variablenames")) {
            CharSequence[] charSequenceArray = this.getVariableArray();
            String string2 = String.join((CharSequence)";", charSequenceArray);
            return string2;
        }
        if (string.equalsIgnoreCase("id")) {
            return String.valueOf(this.getID());
        }
        AbstractDataMatrix abstractDataMatrix = this.getMatrixByName(string);
        if (abstractDataMatrix != null) {
            return abstractDataMatrix;
        }
        throw new RuntimeException("No such data matrix: " + string);
    }

    public double getCalculatedS0() {
        return this.calculatedS0;
    }

    public InnerColumnClass getClassByName(String string) {
        return null;
    }

    public String getClassName() {
        return null;
    }

    public ClassTypes getClassTypes() {
        return this.getClassTypesByName(this.getClassName());
    }

    public ClassTypes getClassTypesByName(String string) {
        InnerColumnClass innerColumnClass = this.getClassByName(string);
        if (innerColumnClass != null) {
            return innerColumnClass.getObject();
        }
        return null;
    }

    public String getComponentDescription(int n) {
        AbstractModelResults abstractModelResults = this.getResults();
        if (abstractModelResults != null) {
            return abstractModelResults.getComponentDescription(n);
        }
        return "N/A";
    }

    public Double getComponents() {
        return this.getComponentsInt();
    }

    public int getComponentsInt() {
        AbstractModelResults abstractModelResults = this.getResults();
        if (abstractModelResults != null) {
            return this.getResults().getRound();
        }
        return 0;
    }

    public double getCutOffHigh() {
        return 2.147483647E9;
    }

    public double getCutOffLow() {
        return this.cutOffLow;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public boolean getDatasetchanged() {
        return this.datasetchanged;
    }

    public int getDatatypeNIRStartIndex() {
        if (this.dataSet != null) {
            try {
                InnerColumnClass innerColumnClass = this.dataSet.getCategory(this.dataSet.getVarDataInfo(), "Datatype");
                short s = innerColumnClass.getObject().getTypeDescriptionIndex("NIR");
                for (int i = 0; i < innerColumnClass.getSize(); ++i) {
                    if (innerColumnClass.getValueLocal(i) != s) continue;
                    return i;
                }
            }
            catch (DataSet.NoSuchCategoryException noSuchCategoryException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getDatatypeNIRCount() {
        return this.getDatatypeNIRCount(false);
    }

    public int getDatatypeNIRCount(boolean bl) {
        VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
        try {
            int n = 0;
            InnerColumnClass innerColumnClass = this.dataSet.getCategory(variablesInfo, "Datatype");
            short s = innerColumnClass.getObject().getTypeDescriptionIndex("NIR");
            for (int i = 0; i < innerColumnClass.getSize(); ++i) {
                if (innerColumnClass.getValueLocal(i) != s || bl && !innerColumnBoolean.getValueBool(i)) continue;
                ++n;
            }
            return n;
        }
        catch (DataSet.NoSuchCategoryException noSuchCategoryException) {
            int n = 0;
            InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean2.getValueBool(i) || bl && !innerColumnBoolean.getValueBool(i)) continue;
                ++n;
            }
            return n;
        }
    }

    public double getDcritX() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("ObsDMX");
        if (this.hasDcritX() || modelMatrix == null) {
            return this.dcritX;
        }
        this.dcritX = this.calculateDcritFromTvalue(modelMatrix);
        return this.dcritX;
    }

    public boolean isDcriXmanually() {
        return this.dcritXmanually;
    }

    public double getDcritY() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("ObsDMY");
        if (this.hasDcritY() || modelMatrix == null) {
            return this.dcritY;
        }
        this.dcritY = this.calculateDcritFromTvalue(modelMatrix);
        return this.dcritY;
    }

    public boolean isDcriYmanually() {
        return this.dcritYmanually;
    }

    public double getHotellingt2() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("Hotelling T2");
        if (this.hasHotellingT2() || modelMatrix == null) {
            return this.hotellingt2;
        }
        this.hotellingt2 = this.calculateHotellingT2FromPValue();
        return this.hotellingt2;
    }

    public boolean isHotellingT2manually() {
        return this.hotellingT2manually;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public DataContainer getExternalPredictions() {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataContainer) || ((DataContainer)dataTreeInterface).getType() != 13) continue;
            return (DataContainer)dataTreeInterface;
        }
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        if (this.isExternal()) {
            return modelExternalIcon;
        }
        return modelIcon;
    }

    public boolean[] getIncludedArray() {
        return this.includedArray;
    }

    public WizardInfoInterface getInfo() {
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.MODEL_INFO);
        for (AbstractInfo abstractInfo : list) {
            if (!((AbstractModelInfo)abstractInfo).getType().equalsIgnoreCase(this.getModelName())) continue;
            return (WizardInfoInterface)((Object)abstractInfo);
        }
        return null;
    }

    public abstract AbstractPrediction getLocalPredictionNode();

    public AbstractPrediction getLocalTrainingPredictionNode() {
        return null;
    }

    public abstract AbstractDataMatrix getMatrixByName(String var1);

    public abstract String getModelName();

    public OutputClass getOutput() {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputClass;
    }

    public DataContainer getOutputContainer() {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputContainer;
    }

    public AbstractPrediction getPrediction(Double d) {
        return this.getLocalPredictionNode();
    }

    public AbstractPrediction getPrediction(String string) {
        return this.getLocalPredictionNode();
    }

    public double[] getRating() {
        return null;
    }

    public String getReplaceClassName() {
        return this.replaceClassName;
    }

    public AbstractModel getReplaceModel() {
        return this.replaceModel;
    }

    public int getReplaceModelID() {
        return this.replaceModelID;
    }

    public abstract AbstractModelResults getResults();

    public AbstractModel getRootModel() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof AbstractModel) {
            return ((AbstractModel)dataTreeInterface).getRootModel();
        }
        return this;
    }

    @Override
    public ModelMatrix getScores() {
        return null;
    }

    public ModelMatrix getR2X() {
        return null;
    }

    @Override
    public String getScript() {
        if (this.dataSet != null && this.getResults() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getUniqueName());
            stringBuilder.append(" = ");
            stringBuilder.append(this.dataSet.getUniqueName());
            stringBuilder.append(".createModel(\"");
            stringBuilder.append(this.getModelName().toLowerCase());
            stringBuilder.append("\", ");
            stringBuilder.append(this.getResults().getRound());
            stringBuilder.append(");");
            stringBuilder.append(this.getUniqueName());
            stringBuilder.append(".setName(\"");
            stringBuilder.append(this);
            stringBuilder.append("\");");
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public String getScriptName() {
        return this.getModelName().toLowerCase() + "model";
    }

    public int getSingeYindx() {
        int[] nArray = this.getYindx();
        if (nArray != null) {
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public AbstractModel getSubModel(Double d) {
        return null;
    }

    public AbstractModel getSubModel(String string) {
        return null;
    }

    public AbstractModel getSubModel(StringDataClass stringDataClass) {
        return this.getSubModel(stringDataClass.getValue());
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public double getTValue() {
        return this.tValue;
    }

    @Override
    public byte getType() {
        return 10;
    }

    public String[] getVariableArray() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("c");
        if (modelMatrix != null) {
            String[] stringArray = new String[modelMatrix.getK()];
            for (int i = 0; i < modelMatrix.getK(); ++i) {
                int n;
                String string = modelMatrix.getColumnDescription(i, 0);
                int n2 = string.indexOf(":");
                if (n2 > 0) {
                    string = string.substring(string.indexOf(":") + 2);
                }
                if ((n = string.lastIndexOf(".")) > 0) {
                    string = string.substring(0, string.lastIndexOf("."));
                }
                stringArray[i] = string;
            }
            return stringArray;
        }
        if (this.getModelName().equals("PCA")) {
            return new String[]{"In Model", "Out Model"};
        }
        if (this.getModelName().equals("SIMCA")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof AbstractModel)) continue;
                arrayList.add(this.getTreeNodeAt(i).toString());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public abstract int[] getYindx();

    public double[] getYmax() {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputClass.getYmax();
    }

    public Double getYmax(Double[] doubleArray) {
        return this.getYmax(doubleArray, null);
    }

    public Double getYmax(Double[] doubleArray, Properties properties) {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputClass.getYmax(doubleArray[0].intValue() - 1, properties);
    }

    public double[] getYmin() {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputClass.getYmin();
    }

    public Double getYmin(Double[] doubleArray) {
        return this.getYmin(doubleArray, null);
    }

    public Double getYmin(Double[] doubleArray, Properties properties) {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        return this.outputClass.getYmin(doubleArray[0].intValue() - 1, properties);
    }

    public double getYmin(int n) {
        double[] dArray = this.getOutput().getYmin();
        if (n < dArray.length) {
            return dArray[n];
        }
        return 0.0;
    }

    public double getYmax(int n) {
        double[] dArray = this.getOutput().getYmax();
        if (n < dArray.length) {
            return dArray[n];
        }
        return 0.0;
    }

    public boolean isConcentration() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isModelContainer() {
        return false;
    }

    public boolean isReduced() {
        return this.getNodeByName("T") == null;
    }

    public boolean isSingleY() {
        return this.getYindx() != null;
    }

    public boolean isUnfolded() {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixByName("T");
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.isUnFolded();
        }
        return false;
    }

    public boolean isUseDcrit() {
        return this.usedcrit;
    }

    public boolean isUseHotelling() {
        return this.usehotellingt2;
    }

    public Object[] list(String string) {
        if (string.equalsIgnoreCase("variablenames")) {
            return this.getVariableArray();
        }
        if (string.equalsIgnoreCase("model")) {
            return new Object[]{this};
        }
        AbstractModelResults abstractModelResults = this.getResults();
        Object[] objectArray = new String[abstractModelResults.getRound()];
        for (int i = 0; i < abstractModelResults.getRound(); ++i) {
            objectArray[i] = String.valueOf(i + 1);
        }
        return objectArray;
    }

    public void modelChanged(AbstractModel abstractModel) {
    }

    public DenseVector predictDModXY(AbstractMVmatrix abstractMVmatrix, int n, double d) {
        int n2 = abstractMVmatrix.getN();
        int n3 = abstractMVmatrix.getK();
        double d2 = n3 - n;
        DenseVector denseVector = this.calcDModXY(abstractMVmatrix, n2, n3, d2);
        denseVector.scale(1.0 / d);
        return denseVector;
    }

    public void recalculateCriticalValues() {
        this.recalculateDcrit();
        this.recalculateHotellingT2();
        this.statisticSignal();
    }

    public void recalculateDcrit() {
        this.setDcritX(this.calculateDcritFromTvalue((ModelMatrix)this.getMatrixByName("ObsDMX")));
        this.dcritXmanually = false;
    }

    public void recalculateHotellingT2() {
        this.setHotellingt2(this.calculateHotellingT2FromPValue());
        this.hotellingT2manually = false;
    }

    public double calculateHotellingT2FromPValue() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("T");
        double d = modelMatrix.getN();
        double d2 = modelMatrix.getK();
        int n = (int)(d2 - d);
        if (n > 0) {
            FDistribution fDistribution = new FDistribution((double)((int)d), (double)n);
            double d3 = fDistribution.inverseCumulativeProbability(1.0 - this.hotellingt2P);
            return d * (d2 - 1.0) / (d2 - d) * d3;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public abstract void reverseTransformationsX(DenseMatrix var1, int[] var2, boolean var3);

    public abstract void reverseTransformationsY(DenseMatrix var1, int[] var2, boolean var3);

    public DataTreeInterface save(ProgressManager progressManager, FileDataClass fileDataClass) throws Exception {
        return this.save(progressManager, fileDataClass, null);
    }

    public DataTreeInterface save(ProgressManager progressManager, FileDataClass fileDataClass, Properties properties) throws Exception {
        return this.save(progressManager, fileDataClass.getAbsolutePath(), properties);
    }

    public DataTreeInterface save(ProgressManager progressManager, String string) {
        return this.save(progressManager, string, null);
    }

    public DataTreeInterface save(ProgressManager progressManager, String string, Properties properties) {
        SaveType saveType = SaveType.REDUCED;
        if (properties != null && ScriptHelper.hasKey(properties, "savetype")) {
            String string2 = ScriptHelper.getProperty(properties, "savetype");
            if (string2.equalsIgnoreCase("model")) {
                saveType = SaveType.NORMAL;
            } else if (string2.equalsIgnoreCase("reduced")) {
                saveType = SaveType.REDUCED;
            } else if (string2.equalsIgnoreCase("complete")) {
                saveType = SaveType.COMPLETE;
            } else if (string2.equalsIgnoreCase("complete_no_originaldata")) {
                saveType = SaveType.COMPLETE_NO_ORIGINALDATA;
            } else {
                throw new RuntimeException("No such savetype: " + string2);
            }
        }
        this.saveModel(progressManager, null, new File(string), saveType);
        return null;
    }

    public File saveModel(final Project_GUI project_GUI) {
        Serializable serializable;
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose name for model", IniManager.getMainFrame());
        jopensaveDialog2.addExtension("mdl", "Evince Model Files (*.mdl)");
        File file = IniManager.getWorkDir((byte)5);
        if (file != null) {
            serializable = new File(file.getAbsolutePath() + IniManager.getFileSeparator() + String.valueOf(this));
            jopensaveDialog2.setCurrentDirectory(file);
            jopensaveDialog2.setSelectedFile((File)serializable);
        }
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(EvinceBorderFactory.createEvinceBorder("Model settings"));
        final JCheckBox jCheckBox = new JCheckBox("Save additional data");
        jCheckBox.setSelected(true);
        jCheckBox.setEnabled(!this.isReduced());
        final JRadioButton jRadioButton = new JRadioButton("Reduced");
        jRadioButton.setEnabled(jCheckBox.isSelected());
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton("Complete");
        jRadioButton2.setEnabled(jCheckBox.isSelected());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jCheckBox.addItemListener(itemEvent -> {
            jRadioButton.setEnabled(jCheckBox.isSelected());
            jRadioButton2.setEnabled(jCheckBox.isSelected());
        });
        int n = 0;
        ((Container)serializable).add(jCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        ((Container)serializable).add(jRadioButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 6), 0, 0));
        ((Container)serializable).add(new JLabelArea("Select Reduced to include additional model related data (T and DmodX)"), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 1, new Insets(6, 18, 6, 6), 0, 0));
        ((Container)serializable).add(jRadioButton2, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 6), 0, 0));
        ((Container)serializable).add(new JLabelArea("Select Complete for the possibility to update your saved model"), new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 18, 1, new Insets(6, 18, 6, 6), 0, 0));
        jopensaveDialog2.setAccessory((JComponent)serializable);
        if (jopensaveDialog2.saveshow()) {
            final File file2 = jopensaveDialog2.getSelectedFile();
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ AbstractModel this$0;
                {
                    this.this$0 = abstractModel;
                }

                @Override
                public Object doWork() {
                    try {
                        SaveType saveType = SaveType.NORMAL;
                        if (jCheckBox.isSelected()) {
                            saveType = jRadioButton.isSelected() ? SaveType.REDUCED : SaveType.COMPLETE;
                        }
                        this.this$0.saveModel(this, project_GUI, file2, saveType);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                    }
                    return null;
                }
            };
            IniManager.setWorkDir((byte)5, jopensaveDialog2.getCurrentDirectory());
            progressManagerImpl.invokeNow();
            return file2;
        }
        return null;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dataSet", this.dataSet);
        randomOutputStream.writePropertyBoolean("usedcrit", this.usedcrit);
        randomOutputStream.writePropertyDouble("dcrit", this.dcritX);
        randomOutputStream.writePropertyDouble("dcritY", this.dcritY);
        randomOutputStream.writePropertyBoolean("usehotelling", this.usehotellingt2);
        randomOutputStream.writePropertyDouble("hotellingt2", this.hotellingt2);
        randomOutputStream.writePropertyBoolean("external", this.external);
        randomOutputStream.writePropertyStringUTF("description", this.description);
        randomOutputStream.writePropertyNode("outputc", this.outputContainer);
        randomOutputStream.writePropertyNode("output", this.outputClass);
        randomOutputStream.writePropertyNode("rcmodel", this.replaceModel);
        if (this.replaceModel != null && this.replaceModel.getID() != null) {
            randomOutputStream.writePropertyInt("rcid", this.replaceModel.getID());
        } else {
            randomOutputStream.writePropertyInt("rcid", this.replaceModelID);
        }
        randomOutputStream.writePropertyBoolean("dchanged", this.datasetchanged);
        randomOutputStream.writePropertyBoolean("enabled", this.enabled);
        randomOutputStream.writePropertyStringUTF("rcname", this.replaceClassName);
        if (this.isSavingModel && this.dataSet != null) {
            String[] stringArray;
            this.includedArray = this.createIncludedArray();
            Case case_ = this.getCase();
            if (case_ != null && case_.getCalibrationType() != 0) {
                randomOutputStream.writePropertyByte("calibrationType", case_.getCalibrationType());
                randomOutputStream.writePropertyBoolean("calibrationCap", case_.getCalibrationCap());
            }
            for (String string : stringArray = new String[]{"T", "Ycalc", "ObsDMX", "ObsDMY", "Xtraining"}) {
                Object object;
                String string2 = EvinceScriptCommands.removeSpace(string.toString().toLowerCase());
                DataTreeInterface dataTreeInterface = null;
                if (string2.equals("xtraining")) {
                    object = this.getDataSet();
                    if (object != null) {
                        dataTreeInterface = ((DataSet)object).getMatrix(0);
                    }
                } else {
                    dataTreeInterface = this.getNodeByName(string2);
                }
                if (!(dataTreeInterface instanceof AbstractDataMatrix) || (object = (Object)((AbstractDataMatrix)dataTreeInterface).calculateMinMax()) == null) continue;
                randomOutputStream.writePropertyDouble(string2 + "_min", (double)object[0]);
                randomOutputStream.writePropertyDouble(string2 + "_max", (double)object[1]);
            }
        }
        randomOutputStream.writePropertyBooleanArray("includedArray", this.includedArray);
    }

    public void set(String string, Double d) {
        if (string.equalsIgnoreCase("usedcrit")) {
            this.setUseDcrit(d > 0.0);
        } else if (string.equalsIgnoreCase("usehotelling")) {
            this.setUseHotelling(d > 0.0);
        } else if (string.equalsIgnoreCase("dcrit")) {
            this.setDcritX(d);
        } else if (string.equalsIgnoreCase("enabled")) {
            this.setEnabled(d > 0.0);
        } else if (string.equalsIgnoreCase("pvalue")) {
            this.setDcritP(d);
            this.recalculateDcrit();
        } else {
            throw new RuntimeException("No such name: " + string);
        }
    }

    public void setCutOffHigh(double d) {
    }

    public void setCutOffLow(double d) {
        this.cutOffLow = d;
    }

    public void setDatasetchanged(boolean bl) {
        if (this.datasetchanged != bl) {
            this.datasetchanged = bl;
            this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)this, 2));
        }
    }

    public void setDcritP(double d) {
        this.dcritP = d;
    }

    public void setHotellingt2P(double d) {
        this.hotellingt2P = d;
    }

    public void setDcritX(double d) {
        if (this.dcritX != d) {
            this.dcritX = d;
            this.modelCutoffChanged();
            this.dcritXmanually = true;
        }
    }

    public void setDcritXmanually(boolean bl) {
        this.dcritXmanually = bl;
    }

    public void setDcritY(double d) {
        if (this.dcritY != d) {
            this.dcritY = d;
            this.statisticSignal();
            this.dcritYmanually = true;
        }
    }

    public void setDcritYmanually(boolean bl) {
        this.dcritYmanually = bl;
    }

    public void setHotellingt2(double d) {
        if (this.hotellingt2 != d) {
            this.hotellingt2 = d;
            this.modelCutoffChanged();
            this.hotellingT2manually = true;
        }
    }

    public void setHotellingT2manually(boolean bl) {
        this.hotellingT2manually = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.dataTreeManager != null) {
            this.dataTreeManager.updateHistory();
        }
    }

    public void setExternal() {
        this.external = true;
    }

    public void setOutput(OutputClass outputClass) {
        this.outputClass = outputClass;
    }

    public void setProtected(ProgressManager progressManager) throws Exception {
        this.setProtected(progressManager, null);
    }

    public void setProtected(ProgressManager progressManager, Properties properties) throws Exception {
        AbstractDataMatrix abstractDataMatrix;
        boolean bl = false;
        if (properties != null && ScriptHelper.hasKey(properties, "slim")) {
            bl = ScriptHelper.getPropertyBool(properties, "slim");
        }
        this.setProtected(true, progressManager);
        if (bl && (abstractDataMatrix = this.getMatrixByName("Xres")) != null) {
            abstractDataMatrix.resize(0, 0);
        }
    }

    public void setRecalcautofit(boolean bl) {
        this.recalcautofit = bl;
    }

    public void setReplaceClassName(String string) {
        this.replaceClassName = string;
    }

    public void setReplaceModel(AbstractModel abstractModel) {
        this.replaceModel = abstractModel;
    }

    public void setTValue(double d) {
        this.tValue = d;
    }

    public void setUseDcrit(boolean bl) {
        this.usedcrit = bl;
        this.modelCutoffChanged();
    }

    public void setUseHotelling(boolean bl) {
        this.usehotellingt2 = bl;
        this.modelCutoffChanged();
    }

    public boolean supportPrediction() {
        return true;
    }

    public void updateOutput() {
        if (this.outputContainer == null) {
            this.createOutputContainer();
        }
        for (int i = 0; i < this.outputContainer.getTreeNodeCount(); ++i) {
            OutputClass outputClass = (OutputClass)this.outputContainer.getTreeNodeAt(i);
            outputClass.updateOutput(i == 0);
        }
    }

    protected CMenu addCommonToMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        CMenu cMenu = new CMenu("Prediction Cut-off", true);
        CRadioButtonMenuItem cRadioButtonMenuItem = new CRadioButtonMenuItem((this.isUseDcrit() ? "Disable" : "Enable") + " - X Model Distance (Dcrit)", false);
        cRadioButtonMenuItem.setSelected(this.isUseDcrit());
        cRadioButtonMenuItem.addItemListener(itemEvent -> this.setUseDcrit(cRadioButtonMenuItem.isSelected()));
        cMenu.add(cRadioButtonMenuItem);
        CMenuItem cMenuItem = new CMenuItem("Set X Model Distance (Dcrit) value", false);
        cMenuItem.addActionListener(actionEvent -> {
            String string = (String)JOptionPane.showInputDialog(project_GUI, "Set X Model Distance (Dcrit):", "X Model distance (Dcrit)", 3, null, null, NiceDataFormat.toString(this.getDcritX()));
            if (string != null && NiceDataFormat.isNumber(string)) {
                this.setDcritX(NiceDataFormat.toNumber(string));
            }
        });
        cMenu.add(cMenuItem);
        if (Evince.isHotellingT2Feature()) {
            cMenu.addSeparator();
            jMenuItem = new CRadioButtonMenuItem((this.isUseHotelling() ? "Disable" : "Enable") + " - Hotelling T2", false);
            jMenuItem.setSelected(this.isUseHotelling());
            jMenuItem.addItemListener(arg_0 -> this.lambda$addCommonToMenu$2((CRadioButtonMenuItem)jMenuItem, arg_0));
            cMenu.add(jMenuItem);
            CMenuItem cMenuItem2 = new CMenuItem("Set Hotelling T2 value", false);
            cMenuItem2.addActionListener(actionEvent -> {
                String string = (String)JOptionPane.showInputDialog(project_GUI, "Set Hotelling T2 value:", "Hotelling T2 value", 3, null, null, NiceDataFormat.toString(this.getHotellingt2()));
                if (string != null && NiceDataFormat.isNumber(string)) {
                    this.setHotellingt2(NiceDataFormat.toNumber(string));
                }
            });
            cMenu.add(cMenuItem2);
        }
        jPopupMenu.add(cMenu);
        jMenuItem = new JMenuItem("Properties");
        jMenuItem.addActionListener(actionEvent -> this.createPropertiesWindow(project_GUI, this.getDataSet()));
        jPopupMenu.add(jMenuItem);
        return cMenu;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dataSet = null;
        this.replaceModel = null;
        this.includedArray = null;
        if (this.outputContainer != null) {
            this.outputContainer.cleanUp();
            this.outputContainer = null;
        }
        if (this.outputClass != null) {
            this.outputClass.cleanUp();
            this.outputClass = null;
        }
        this.listeners.clear();
    }

    protected void createPredictionOnFile(Project_GUI project_GUI) {
        Case case_ = new Case(0, 0);
        if (ImportHelper.importData(project_GUI, case_, this, null)) {
            case_.setExternal();
            project_GUI.getRootNode().addTreeNode(case_);
        }
    }

    protected void fireUpdatedEvent() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelUpdated();
        }
        this.setProjectChanged();
    }

    public void setCutOffCallback(CutOffCallback cutOffCallback) {
        this.cutOffCallback = cutOffCallback;
    }

    protected void modelCutoffChanged() {
        this.setProjectChanged();
        this.statisticSignal();
        this.dataTreeManager.updateHistory();
        if (this.cutOffCallback != null) {
            this.cutOffCallback.valueChanged();
        }
    }

    protected void saveModel(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n, SaveType saveType) throws IOException {
        if (dataTreeInterface.getSaveIndex() < n) {
            TreeHeader treeHeader = new TreeHeader(dataTreeInterface);
            treeHeader.save(randomOutputStream);
            randomOutputStream.beginNodeProperty();
            int n2 = 0;
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
                if (!this.supportInterface(dataTreeInterface2, saveType)) continue;
                randomOutputStream.writePropertyNode("childs" + n2++, dataTreeInterface2);
            }
            randomOutputStream.writePropertyInt("childs", n2);
            dataTreeInterface.SaveProperty(randomOutputStream, n);
            randomOutputStream.endProperty();
            if (dataTreeInterface instanceof MemoryInterface) {
                DataTreeManager.SaveMemoryInterface((MemoryInterface)((Object)dataTreeInterface), randomOutputStream, n);
            }
            treeHeader.writeCRC(randomOutputStream);
        }
        if (dataTreeInterface.isNode()) {
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface3 = dataTreeInterface.getTreeNodeAt(i);
                if (!this.supportInterface(dataTreeInterface3, saveType)) continue;
                this.saveModel(dataTreeInterface3, randomOutputStream, n, saveType);
            }
        }
    }

    protected boolean supportInterface(DataTreeInterface dataTreeInterface, SaveType saveType) {
        DataContainer dataContainer;
        if (dataTreeInterface instanceof DataSet) {
            DataSet dataSet = (DataSet)dataTreeInterface;
            Case case_ = this.dataSet.getCase();
            return dataSet.equals(this.dataSet) || dataSet.equals(case_.getOriginalDataSet());
        }
        if (dataTreeInterface instanceof AbstractModel) {
            AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
            if (this.isModelContainer()) {
                return DataTreeManager.isParentTo(this, dataTreeInterface);
            }
            if (abstractModel.isModelContainer() && abstractModel.hasChild(this)) {
                return true;
            }
            return this.equals(dataTreeInterface);
        }
        if (dataTreeInterface instanceof AbstractPrediction) {
            return false;
        }
        return !(dataTreeInterface instanceof DataContainer) || (dataContainer = (DataContainer)dataTreeInterface).getType() != 14 && dataContainer.getType() != 13;
    }

    private DenseVector calcDModXY(final AbstractMVmatrix abstractMVmatrix, int n, final int n2, final double d) {
        final DenseVector denseVector = new DenseVector(n);
        final List<Double> list = Collections.synchronizedList(new ArrayList());
        new Threader(this){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                double d5 = 0.0;
                for (int i = n; i < n22; ++i) {
                    double d2 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        double d3 = abstractMVmatrix.getValue(i, j);
                        d2 += d3 * d3;
                    }
                    d5 += d2;
                    double d4 = Math.sqrt(d2 / (d - (double)abstractMVmatrix.getMissingCountForRow(i)));
                    denseVector.set(i, d4);
                }
                list.add(d5);
            }
        }.execute(n);
        for (Double d2 : list) {
            this.calculatedS0 += d2.doubleValue();
        }
        return denseVector;
    }

    private double calculateDcritFromTvalue(DenseVector denseVector) {
        this.tValue = AbstractModel.calculateTvalue(this.dcritP);
        if (denseVector != null) {
            double d = 0.0;
            for (int i = 0; i < denseVector.size(); ++i) {
                d += denseVector.get(i);
            }
            d /= (double)denseVector.size();
            double d2 = 0.0;
            for (int i = 0; i < denseVector.size(); ++i) {
                double d3 = denseVector.get(i) - d;
                d2 += d3 * d3;
            }
            d2 = Math.sqrt(d2 / (double)(denseVector.size() - 1));
            return d + this.tValue * d2;
        }
        return Double.MAX_VALUE;
    }

    private double calculateDcritFromTvalue(ModelMatrix modelMatrix) {
        if (modelMatrix != null) {
            DenseVector denseVector = modelMatrix.getLastRM();
            return this.calculateDcritFromTvalue(denseVector);
        }
        return Double.MAX_VALUE;
    }

    private double[] calculateDcritMeanVariance(DenseVector denseVector) {
        if (denseVector != null) {
            double d = 0.0;
            for (int i = 0; i < denseVector.size(); ++i) {
                d += denseVector.get(i);
            }
            d /= (double)denseVector.size();
            double d2 = 0.0;
            for (int i = 0; i < denseVector.size(); ++i) {
                double d3 = denseVector.get(i) - d;
                d2 += d3 * d3;
            }
            d2 = Math.sqrt(d2 / (double)(denseVector.size() - 1));
            return new double[]{d, d2};
        }
        return new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
    }

    private static double calculatePvalue(double d) {
        return 1.0 - new TDistribution(2.147483647E9).cumulativeProbability(d);
    }

    private double calculatePvalueFromDcrit(double d, DenseVector denseVector) {
        double[] dArray = this.calculateDcritMeanVariance(denseVector);
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = (d - d2) / d3;
        return AbstractModel.calculatePvalue(d4);
    }

    private double calculatePvalueFromDcrit(double d, double[] dArray) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = (d - d2) / d3;
        return AbstractModel.calculatePvalue(d4);
    }

    private double calculatePvalueFromDcrit(double d, ModelMatrix modelMatrix) {
        if (modelMatrix != null) {
            DenseVector denseVector = modelMatrix.getLastRM();
            return this.calculatePvalueFromDcrit(d, denseVector);
        }
        return Double.MAX_VALUE;
    }

    private double calculateT2() {
        ModelMatrix modelMatrix = (ModelMatrix)this.getMatrixByName("T");
        int n = modelMatrix.getN();
        int n2 = modelMatrix.getK();
        double[] dArray = new double[n2];
        Arrays.fill(dArray, 0.0);
        for (int i = 0; i < n; ++i) {
            DenseVector denseVector = modelMatrix.getRM(i);
            for (int j = 0; j < dArray.length; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + Math.pow(denseVector.get(j), 2.0);
            }
        }
        return 0.0;
    }

    public static double calculateTvalue(double d) {
        TDistribution tDistribution = new TDistribution(2.147483647E9);
        return tDistribution.inverseCumulativeProbability(1.0 - d / 2.0);
    }

    private void checkTrainSet(DataSet dataSet) {
        int n;
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getGroupColumnByType(4).getPrimaryColumn();
        boolean bl = false;
        for (n = 0; n < innerColumnBoolean.getSize(); ++n) {
            if (!innerColumnBoolean.getValueBool(n)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < innerColumnBoolean.getSize(); ++n) {
                innerColumnBoolean.setValueBool(n, true);
            }
            dataSet.updateReferences();
        }
    }

    private void createOutputContainer() {
        this.outputContainer = new DataContainer("Output Container", -1);
        this.outputContainer.setVisibleInTree(RegisterKeyManager.isPredikteraDevelopmentLicense());
        this.addTreeNode(this.outputContainer);
        this.outputClass = new OutputClass(this, "Default");
        this.outputContainer.addTreeNode(this.outputClass);
    }

    private void createPropertiesWindow(Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
        project_GUI.getModel_GUI().createWindowFromWizard((DataTreeInterface)this.getDataSet(), this);
    }

    private boolean hasDcritX() {
        return this.dcritX != Double.MAX_VALUE;
    }

    private boolean hasDcritY() {
        return this.dcritY != Double.MAX_VALUE;
    }

    public boolean hasHotellingT2() {
        return this.hotellingt2 != Double.MAX_VALUE;
    }

    public void saveModel(ProgressManager progressManager, Project_GUI project_GUI, File file, SaveType saveType) {
        Object object;
        progressManager.setInfoText("Saving model into file...");
        if (this.isModelContainer()) {
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                object = this.getTreeNodeAt(i);
                if (!(object instanceof AbstractModel)) continue;
                AbstractModel abstractModel = (AbstractModel)object;
                abstractModel.getDcritX();
                abstractModel.getDcritY();
            }
        } else {
            this.getDcritX();
            this.getDcritY();
        }
        File file2 = this.dataTreeManager.getFirstSaveFile(this);
        if (project_GUI != null && project_GUI.isFullmodel() && file.equals(file2)) {
            progressManager.Finish();
            JOptionPane.showConfirmDialog(project_GUI, "Cannot save model to same destination without first saving model as project", "Cannot save model", -1, 1);
            return;
        }
        try {
            this.isSavingModel = true;
            boolean bl = saveType.isComplete();
            object = file.getParentFile();
            ((File)object).mkdirs();
            File file3 = File.createTempFile("temp", "save", (File)object);
            RandomOutputStream randomOutputStream = new RandomOutputStream(file3, true, progressManager);
            randomOutputStream.setStorePosition(false);
            randomOutputStream.setDatabaseID(1);
            randomOutputStream.writeHeader(bl ? 8 : 1);
            randomOutputStream.writeIndexTable();
            randomOutputStream.setStartIndex((byte)2, randomOutputStream.getFilePointer());
            randomOutputStream.writeUTF("N/A");
            randomOutputStream.setEndIndex((byte)2, randomOutputStream.getFilePointer());
            randomOutputStream.setStartIndex((byte)1, randomOutputStream.getFilePointer());
            PropagationDataNode propagationDataNode = null;
            propagationDataNode = bl ? this.getCase() : this;
            this.saveModel(propagationDataNode, randomOutputStream, DataTreeManager.incSaveIndex(), saveType);
            randomOutputStream.setRootID(this.getID());
            randomOutputStream.setEndIndex((byte)1, randomOutputStream.getFilePointer());
            if (bl && project_GUI != null) {
                Graph_GUI graph_GUI = project_GUI.getGraph_GUI();
                randomOutputStream.setStartIndex((byte)8, randomOutputStream.getFilePointer());
                graph_GUI.Save(randomOutputStream);
                project_GUI.saveProperties(randomOutputStream);
                randomOutputStream.setEndIndex((byte)8, randomOutputStream.getFilePointer());
            }
            randomOutputStream.writeIndexTable();
            randomOutputStream.close();
            file.delete();
            file3.renameTo(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.isSavingModel = false;
        }
    }

    public int[] createIncludedIndexArray() {
        int n = this.getDatatypeNIRStartIndex();
        int[] nArray = this.createIncIdxArray();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] - n;
        }
        return nArray;
    }

    public String[] getClassNames() {
        ClassTypes classTypes = this.getClassByName(this.getClassName()).getObject();
        String[] stringArray = new String[classTypes.size()];
        for (int i = 0; i < classTypes.size(); ++i) {
            stringArray[i] = classTypes.getTypeDescription(i);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        System.out.println(AbstractModel.calculateTvalue(0.01));
        System.out.println(AbstractModel.calculateTvalue(1.0E-6));
    }

    private /* synthetic */ void lambda$addCommonToMenu$2(CRadioButtonMenuItem cRadioButtonMenuItem, ItemEvent itemEvent) {
        this.setUseHotelling(cRadioButtonMenuItem.isSelected());
    }

    public static enum SaveType {
        NORMAL,
        REDUCED,
        COMPLETE,
        COMPLETE_NO_ORIGINALDATA;


        public boolean isComplete() {
            return this.equals((Object)COMPLETE) || this.equals((Object)COMPLETE_NO_ORIGINALDATA);
        }
    }

    public static interface CutOffCallback {
        public void valueChanged();
    }
}

