/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.propagation.PropagationProperties;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.treetable.AbstractTreeTableModel;
import se.prediktera.map.common.swing.treetable.JTreeTable;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Model_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelTreeTableModel;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.plot.plotgenerator.AbstractPlotInfo;

public abstract class AbstractModelContainerWindow
extends AbstractWindow
implements DataTreeListener {
    public static final byte STRUCTURE = -1;
    public static final byte INSERTED = 0;
    public static final byte REMOVED = 1;
    public static final byte UPDATED = 2;
    public static final byte COMPONENTCHANGED = 3;
    private static final Color MAIN_COLOR = new Color(225, 255, 225);
    private static final Color SELECTED_MAIN_COLOR = MAIN_COLOR.darker();
    protected JTreeTable treeTable;
    protected JToolBar informationToolbar = new JToolBar();
    protected PropagationProperties propagationProp = new PropagationProperties(null);
    protected JFlatButton buttonSave = new JFlatButton();
    protected JFlatButton buttonRemove = new JFlatButton();
    protected JFlatButton buttonRename = new JFlatButton();
    protected Case dataSetContainer;
    protected String[] cNames;
    protected DataContainer informationContainer;
    protected DataTreeInterface currentInformation;
    private ModelTreeTableModel analysTreeTableModel;
    private Font bold;
    private Font plain;

    private static void setColorToComponent(Component component, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                component.setBackground(SELECTED_MAIN_COLOR);
                component.setForeground(Color.white);
            } else {
                component.setBackground(UIManager.getColor("Tree.selectionBackground"));
                component.setForeground(UIManager.getColor("Tree.selectionForeground"));
            }
        } else {
            if (bl2) {
                component.setBackground(MAIN_COLOR);
            } else {
                component.setBackground(UIManager.getColor("Tree.textBackground"));
            }
            component.setForeground(UIManager.getColor("Tree.textForeground"));
        }
    }

    public AbstractModelContainerWindow(String string, Case case_, DataContainer dataContainer, String[] stringArray) {
        super("", (AbstractInit)null);
        this.dataSetContainer = case_;
        this.cNames = stringArray;
        this.setInformationContainer(dataContainer, string);
        this.jbInit();
    }

    public abstract void addToPopupMenu(JMenu var1, DataSet var2);

    public void changeInteractiveSelection(byte by) {
    }

    public abstract AbstractPlotInfo createModelCollectionPlots();

    public abstract AbstractModelInfo createModelInfo();

    public AbstractWindow createNewModel() {
        return this.createNewModel(false);
    }

    public AbstractWindow createNewModel(boolean bl) {
        DataSet dataSet = (DataSet)this.dataSetContainer.getDsContainer().getTreeNodeAt(0);
        if (dataSet != null) {
            Model_GUI model_GUI = (Model_GUI)this.window_gui;
            return model_GUI.createWindowFromWizard((DataTreeInterface)dataSet, this.createModelInfo(), bl);
        }
        return null;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    @Override
    public void finishInteraction() {
    }

    public DataTreeInterface getCurrentInformation() {
        return this.currentInformation;
    }

    public DataContainer getDataContainer() {
        if (this.informationContainer != null && this.informationContainer.isCleaned()) {
            this.informationContainer.toString();
        }
        return this.informationContainer;
    }

    public Case getDataSetContainer() {
        return this.dataSetContainer;
    }

    @Override
    public String getDefaultTitle() {
        return null;
    }

    @Override
    public String getGUI_Name() {
        if (this.informationContainer != null) {
            return this.informationContainer.toString();
        }
        return "";
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return AbstractModel.modelIcon;
    }

    @Override
    public String getInformation() {
        return "";
    }

    public InteractionArray getInteractionArray(int n) {
        return null;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        super.getToolbars(vector);
        vector.addElement(this.informationToolbar);
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public boolean isClosable() {
        return false;
    }

    public boolean isSelected(Object object) {
        if (object instanceof AbstractModel && this.treeTable != null) {
            int[] nArray;
            JTree jTree = this.treeTable.getTree();
            for (int n : nArray = this.treeTable.getSelectedRows()) {
                Object object2;
                TreePath treePath = jTree.getPathForRow(n);
                if (!(treePath != null && treePath.getPathCount() == 2 ? (object2 = this.treeTable.getValueAt(n, 1)) == object : treePath != null && (object2 = treePath.getPathComponent(1)) == object)) continue;
                return true;
            }
        }
        return false;
    }

    public void nodeChanged() {
        this.updateTable(null, (byte)2);
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        this.updateTable(null, (byte)2);
    }

    @Override
    public void prepareInteraction() {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return 0;
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
        if (dataTreeEvent.getProperty() == 1) {
            this.updateTable(dataTreeEvent.getDataTreeInterface(), (byte)0);
        } else if (dataTreeEvent.getProperty() == 2) {
            this.updateTable(dataTreeEvent.getDataTreeInterface(), (byte)1);
        } else {
            this.updateTable(null, (byte)2);
        }
    }

    public void PurgeSignal() {
        for (int i = this.informationContainer.getTreeNodeCount() - 1; i >= 0; --i) {
            DataTreeInterface dataTreeInterface = this.informationContainer.getTreeNodeAt(i);
            if (dataTreeInterface == null || !dataTreeInterface.isCleaned()) continue;
            this.deleteInformation(dataTreeInterface);
        }
        if (this.currentInformation != null && this.currentInformation.isCleaned()) {
            this.setCurrentInformation(false, null);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    public void selectInformation(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface != this.currentInformation && this.treeTable != null) {
            if (dataTreeInterface == null) {
                this.treeTable.clearSelection();
            } else {
                for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
                    Object object = this.treeTable.getValueAt(i, 1);
                    if (object == null || !object.equals(dataTreeInterface)) continue;
                    this.treeTable.setRowSelectionInterval(i, i);
                    break;
                }
            }
            this.setCurrentInformation(false, dataTreeInterface);
            this.project_GUI.updateDataTree(dataTreeInterface);
        }
    }

    public void selectLastModel() {
        Object object;
        int n = this.treeTable.getRowCount();
        if (n > 0 && (object = this.treeTable.getValueAt(n - 1, 1)) instanceof DataTreeInterface) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)object;
            this.treeTable.setRowSelectionInterval(n - 1, n - 1);
            this.setCurrentInformation(false, dataTreeInterface);
            this.project_GUI.updateDataTree(dataTreeInterface);
        }
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        super.SendGlobalMessage(by, by2);
        if (by == 0) {
            this.PurgeSignal();
        }
        return 0;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        if (this.informationContainer.size() > 0) {
            this.setCurrentInformation(false, this.informationContainer.getTreeNodeAt(0));
            this.treeTable.setRowSelectionInterval(0, 0);
        } else {
            this.setCurrentInformation(false, null);
        }
    }

    public void setInformationContainer(DataContainer dataContainer, String string) {
        if (dataContainer == null) {
            dataContainer = this.createContainer(string);
        }
        if (this.informationContainer != null) {
            DataTreeInterface dataTreeInterface;
            this.informationContainer.removeDataTreeChangeListener(this);
            for (int i = 0; i < this.informationContainer.getTreeNodeCount(); ++i) {
                dataTreeInterface = this.informationContainer.getTreeNodeAt(i);
                if (dataTreeInterface.isCleaned()) continue;
                dataContainer.addTreeNode(dataTreeInterface);
            }
            dataTreeInterface = this.informationContainer.getTreeParent();
            if (dataTreeInterface instanceof Case) {
                Case case_ = (Case)dataTreeInterface;
                case_.replaceNode(this.informationContainer, dataContainer);
            }
        }
        this.informationContainer = dataContainer;
        this.informationContainer.addDataTreeChangeListener(this);
        if (this.analysTreeTableModel != null) {
            this.analysTreeTableModel.setRoot(this.informationContainer);
        }
    }

    public abstract boolean supportInfo(AbstractModelInfo var1);

    @Override
    public String toString() {
        return this.informationContainer == null ? "" : this.informationContainer.toString();
    }

    public void updateTable(DataTreeInterface dataTreeInterface, byte by) {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getSelectedTreePath();
            JTree jTree = this.treeTable.getTree();
            AbstractTreeTableModel abstractTreeTableModel = (AbstractTreeTableModel)jTree.getModel();
            abstractTreeTableModel.nodeStructureChanged(new Object[]{this.informationContainer});
            this.treeTable.scrollToVisible(treePath);
            this.treeTable.updateTable();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.informationContainer != null) {
            this.informationContainer.removeDataTreeChangeListener(this);
            this.informationContainer = null;
        }
        this.cNames = null;
        if (this.treeTable != null) {
            this.treeTable.cleanUp();
        }
        this.propagationProp.cleanUp();
        this.propagationProp = null;
        this.treeTable = null;
        this.analysTreeTableModel = null;
        this.dataSetContainer = null;
        this.currentInformation = null;
    }

    protected void correctTableColumnWidth() {
        for (int i = 0; i < this.treeTable.getColumnCount(); ++i) {
            int n = switch (i) {
                case 0 -> 30;
                case 1 -> 250;
                case 2 -> 250;
                case 3 -> 50;
                default -> 100;
            };
            this.treeTable.getColumnModel().getColumn(i).setPreferredWidth(n);
        }
    }

    protected abstract DataContainer createContainer(String var1);

    @Override
    protected AbstractWindowProperties createProperties() {
        return null;
    }

    protected abstract ModelTreeTableModel createTreeTableModel();

    protected DataContainer getAllSelectedItems() {
        int[] nArray;
        DataContainer dataContainer = new DataContainer("Models", 1);
        for (int n : nArray = this.treeTable.getSelectedRows()) {
            dataContainer.add((DataTreeInterface)this.treeTable.getValueAt(n, 1));
        }
        return dataContainer;
    }

    protected DataContainer getAllSelectedMainItems() {
        DataContainer dataContainer = new DataContainer("Models", 1);
        if (this.treeTable != null) {
            int[] nArray;
            JTree jTree = this.treeTable.getTree();
            for (int n : nArray = this.treeTable.getSelectedRows()) {
                Object object;
                TreePath treePath = jTree.getPathForRow(n);
                if (treePath == null) continue;
                if (treePath.getPathCount() == 2) {
                    object = this.treeTable.getValueAt(n, 1);
                    if (!(object instanceof DataTreeInterface)) continue;
                    dataContainer.add((DataTreeInterface)object);
                    continue;
                }
                object = treePath.getPathComponent(1);
                if (!(object instanceof DataTreeInterface) || dataContainer.contains(object)) continue;
                dataContainer.add((DataTreeInterface)object);
            }
        }
        return dataContainer;
    }

    protected DataContainer getAllSelectedModelItems() {
        int[] nArray;
        DataContainer dataContainer = new DataContainer("Models", 1);
        for (int n : nArray = this.treeTable.getSelectedRows()) {
            if (!(this.treeTable.getValueAt(n, 1) instanceof AbstractModel)) continue;
            dataContainer.add((DataTreeInterface)this.treeTable.getValueAt(n, 1));
        }
        return dataContainer;
    }

    protected abstract String getModeltype();

    protected int getNrMainItems() {
        int n = 0;
        JTree jTree = this.treeTable.getTree();
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            if (jTree.getPathForRow(i).getPathCount() != 2) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected AbstractInit loadInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return null;
    }

    protected AbstractWindowProperties loadProperties(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return null;
    }

    protected abstract void setCurrentInformation(boolean var1, DataTreeInterface var2);

    protected void treeSelected() {
        DataContainer dataContainer = this.getAllSelectedMainItems();
        if (dataContainer.size() > 0) {
            int n = this.treeTable.getSelectedRow();
            Object object = this.treeTable.getValueAt(n, 1);
            if (object instanceof AbstractModel) {
                this.setCurrentInformation(dataContainer.size() > 1, (AbstractModel)object);
            }
            this.project_GUI.updateDataTree((DataTreeInterface)dataContainer.get(0));
        } else {
            this.setCurrentInformation(false, null);
        }
    }

    void renameSelectedItems() {
        DataContainer dataContainer = this.getAllSelectedMainItems();
        if (!dataContainer.isEmpty()) {
            for (DataTreeInterface dataTreeInterface : dataContainer) {
                DataTreeClass dataTreeClass;
                String string;
                if (!(dataTreeInterface instanceof DataTreeClass) || (string = JOptionPane.showInputDialog(this, "Rename object to:", (dataTreeClass = (DataTreeClass)dataTreeInterface).toString())) == null) continue;
                dataTreeClass.setName(string);
                this.updateTable(dataTreeClass, (byte)2);
            }
            this.setCurrentInformation(false, this.currentInformation);
            this.project_GUI.purgeSignal();
        }
    }

    private void deleteInformation(DataTreeInterface dataTreeInterface) {
        int n = this.informationContainer.indexOf(dataTreeInterface);
        this.informationContainer.removeTreeNode(dataTreeInterface);
        if (n < this.informationContainer.size()) {
            this.setCurrentInformation(false, this.informationContainer.getTreeNodeAt(n));
        } else if (n > 0) {
            this.setCurrentInformation(false, this.informationContainer.getTreeNodeAt(n - 1));
        } else {
            this.setCurrentInformation(false, null);
        }
        this.updateTable(dataTreeInterface, (byte)1);
    }

    private boolean isRowSelected(int n) {
        TreePath treePath;
        TreePath treePath2 = this.treeTable.getTree().getPathForRow(n);
        for (int i = n + 1; i < this.treeTable.getRowCount() && treePath2.isDescendant(treePath = this.treeTable.getTree().getPathForRow(i)); ++i) {
            if (!this.treeTable.isRowSelected(i)) continue;
            return true;
        }
        return false;
    }

    private void jbInit() {
        Font font = this.getFont();
        this.bold = new Font(font.getName(), 1, font.getSize());
        this.plain = new Font(font.getName(), 0, font.getSize());
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().setBackground(Color.white);
        this.analysTreeTableModel = this.createTreeTableModel();
        this.treeTable = new JTreeTable(this.analysTreeTableModel);
        this.treeTable.setSelectionMode(2);
        this.informationToolbar.addSeparator();
        this.informationToolbar.setFloatable(false);
        this.informationToolbar.setBorder(null);
        this.buttonSave.setText("Save As...");
        this.buttonSave.setToolTipText(this.buttonSave.getText());
        this.buttonSave.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.buttonSave.addActionListener(actionEvent -> ((AbstractModel)this.currentInformation).saveModel(this.project_GUI));
        this.buttonRemove.setText("Delete Selected Model(s)");
        this.buttonRemove.setToolTipText(this.buttonRemove.getText());
        this.buttonRemove.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/delete.png")));
        this.buttonRemove.addActionListener(actionEvent -> this.removeSelectedItems());
        this.buttonRename.setText("Rename Selected Model(s)");
        this.buttonRename.setToolTipText(this.buttonRename.getText());
        this.buttonRename.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        this.buttonRename.addActionListener(actionEvent -> this.renameSelectedItems());
        this.treeTable.setDefaultRenderer(Object.class, new TreeTableCellRenderer());
        this.treeTable.setDefaultRenderer(Integer.class, new TreeTableCellRenderer());
        this.treeTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.treeSelected());
        this.treeTable.setCellSelectionEnabled(false);
        this.treeTable.setColumnSelectionAllowed(false);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = AbstractModelContainerWindow.this.treeTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = AbstractModelContainerWindow.this.treeTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 == 0 || n2 >= 0 && mouseEvent.getClickCount() == 2) {
                        if (AbstractModelContainerWindow.this.treeTable.getTree().isExpanded(n)) {
                            AbstractModelContainerWindow.this.treeTable.getTree().collapseRow(n);
                        } else {
                            AbstractModelContainerWindow.this.treeTable.getTree().expandRow(n);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        this.correctTableColumnWidth();
        jScrollPane.setViewportView(this.treeTable);
    }

    private void removeSelectedItems() {
        DataContainer dataContainer;
        int n = JOptionPane.showConfirmDialog(this, "Are you really sure you want to delete all selected items?", "Delete comfirmation", 0, 3, null);
        if (n == 0 && !(dataContainer = this.getAllSelectedMainItems()).isEmpty()) {
            for (DataTreeInterface dataTreeInterface : dataContainer) {
                this.deleteInformation(dataTreeInterface);
                dataTreeInterface.cleanUp();
            }
            this.project_GUI.purgeSignal();
        }
    }

    class TreeTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public TreeTableCellRenderer() {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (AbstractModelContainerWindow.this.treeTable == null || AbstractModelContainerWindow.this.treeTable.getTree() == null) {
                return this;
            }
            TreePath treePath = AbstractModelContainerWindow.this.treeTable.getTree().getPathForRow(n);
            int n3 = 1;
            if (treePath != null) {
                n3 = treePath.getPathCount();
            }
            if (n3 == 2) {
                this.setFont(AbstractModelContainerWindow.this.bold);
            } else {
                this.setFont(AbstractModelContainerWindow.this.plain);
            }
            if (n2 == 1) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(0);
            }
            if (!bl) {
                bl = AbstractModelContainerWindow.this.isRowSelected(n);
            }
            AbstractModelContainerWindow.setColorToComponent(this, bl, n3 == 2);
            this.setText(object.toString());
            return this;
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }
}

