/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;

public abstract class AbstractPrediction
extends DataContainer
implements DataTreeExtLibInterface {
    protected static final ImageIcon predictionIcon = new ImageIcon(Main_GUI.class.getResource("gif/prediction.gif"));
    protected static final ImageIcon predictionExpandedIcon = new ImageIcon(Main_GUI.class.getResource("gif/prediction_open.gif"));
    protected DataSet dataSet;
    protected AbstractModel model;
    protected boolean ispredtestset = true;
    protected boolean keep_predclass = false;

    public AbstractPrediction(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "dS");
        this.model = (AbstractModel)mapProperty.resolveNodeFromName(randomInputStream, "model");
        this.ispredtestset = mapProperty.getPropertyBoolean("iptt", true);
        this.keep_predclass = mapProperty.getPropertyBoolean("kpc");
    }

    public AbstractPrediction(String string, DataSet dataSet, AbstractModel abstractModel) {
        this(string, dataSet, abstractModel, true);
    }

    public AbstractPrediction(String string, DataSet dataSet, AbstractModel abstractModel, boolean bl) {
        super(string, (byte)3);
        this.dataSet = dataSet;
        this.model = abstractModel;
        this.ispredtestset = bl;
    }

    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        if (project_GUI == null) {
            return;
        }
        if (this.dataSet != null) {
            jPopupMenu.add(project_GUI.getData_GUI().getTableMenu(this));
            jPopupMenu.add(project_GUI.getPlot_GUI().getPlotMenu(this));
            jPopupMenu.addSeparator();
            CMenu cMenu = new CMenu("Apply Template", true);
            ScriptManager.addScriptToMenu(cMenu, this, this.dataSet, "prediction", this.toString());
            jPopupMenu.add(cMenu);
        }
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSet != null) {
            DataTreeClass dataTreeClass;
            ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
            if (observationInfo != null && !this.keep_predclass && (dataTreeClass = (PredictionClasses)observationInfo.getGroupColumnByType(11)) != null && this.model != null) {
                String string = "Pred. " + String.valueOf(this.model);
                ((PredictionClasses)dataTreeClass).removePredictionClass(this.model, string);
            }
            if (this.dataSet.isExternal() && (dataTreeClass = this.dataSet.getCase()) != null) {
                dataTreeClass.cleanUp();
                this.purgeSignal();
            }
            this.dataSet = null;
        }
        this.model = null;
    }

    public BasicTreeInterface get(String string) {
        if (string.equalsIgnoreCase("dataset")) {
            return this.dataSet;
        }
        AbstractDataMatrix abstractDataMatrix = this.getMatrixByName(string);
        if (abstractDataMatrix != null) {
            return abstractDataMatrix;
        }
        throw new RuntimeException("Data " + string + " not found");
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public AbstractDataMatrix getDataSetMatrixToPredictInX() {
        if (this.dataSet != null) {
            if (this.ispredtestset && !this.dataSet.isExternal() && this.equalDataSet() && !this.model.isExternal()) {
                return this.dataSet.getMatrix(1);
            }
            return this.dataSet.getMatrix(0);
        }
        return null;
    }

    public AbstractDataMatrix getDataSetMatrixToPredictInY() {
        if (this.dataSet != null) {
            if (this.ispredtestset && !this.dataSet.isExternal() && this.equalDataSet()) {
                return this.dataSet.getMatrix(3);
            }
            return this.dataSet.getMatrix(2);
        }
        return null;
    }

    public abstract ModelMatrix getDModX();

    public abstract ModelMatrix getHotellingT2();

    @Override
    public ImageIcon getIcon(byte by) {
        if (by == 0) {
            return predictionIcon;
        }
        return predictionExpandedIcon;
    }

    public abstract AbstractDataMatrix getMatrixByName(String var1);

    public AbstractModel getModel() {
        return this.model;
    }

    public boolean hasPredictions() {
        return this.isVisibleInTree();
    }

    public boolean isExternal() {
        if (this.dataSet != null) {
            return this.dataSet.isExternal();
        }
        return false;
    }

    public boolean isPredTestSet() {
        return this.ispredtestset;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dS", this.dataSet);
        randomOutputStream.writePropertyNode("model", this.model);
        randomOutputStream.writePropertyBoolean("iptt", this.ispredtestset);
        randomOutputStream.writePropertyBoolean("kpc", this.keep_predclass);
    }

    @Override
    public String toString() {
        AbstractDataNode abstractDataNode;
        Object object;
        if (this.model != null && (object = this.getTreeParent()) instanceof AbstractDataNode && (abstractDataNode = (AbstractDataNode)object).getType() == 14) {
            object = this.model.toString();
            Case case_ = this.model.getCase();
            if (case_ != null) {
                return (String)object + " (" + String.valueOf(case_) + ")";
            }
            return object;
        }
        return "Predictions (" + String.valueOf(this.dataSet) + ")";
    }

    @Override
    public String toStringShortcut() {
        return this.dataSet.toString();
    }

    protected boolean equalDataSet() {
        return this.dataSet.equals(this.model.getDataSet());
    }

    protected InnerColumnPredClass getPredictionCategory(boolean bl) {
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
        if (predictionClasses == null) {
            if (bl) {
                predictionClasses = new PredictionClasses(observationInfo.getRowCount());
                observationInfo.addTreeNode(predictionClasses);
            } else {
                return null;
            }
        }
        String string = "Pred. " + this.model.toString();
        return predictionClasses.getPredictionClass(this.model, string);
    }

    protected void setPredTestSet(boolean bl) {
        this.ispredtestset = bl;
    }
}

