/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.GA;

import java.util.Properties;
import java.util.Random;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.model.GA.AbstractIndivide;
import se.prediktera.map.model.GA.IndivideFactoryInterface;

public class DemoFactory
extends CleanUpClass
implements IndivideFactoryInterface<Individe> {
    private final double searchvalue;

    public DemoFactory(double d) {
        this.searchvalue = d;
    }

    @Override
    public AbstractIndivide<Individe> createIndivide(Random random) {
        Individe individe = new Individe();
        individe.genome = random.nextDouble() * this.searchvalue / 2.0;
        return individe;
    }

    @Override
    public AbstractIndivide<Individe> crossOver(Random random, Individe individe, Individe individe2, double d) {
        Individe individe3 = new Individe();
        individe3.genome = (individe2.genome + individe.genome) / 2.0;
        return individe3;
    }

    @Override
    public void mutate(Individe individe, Random random, double d) {
        individe.genome += this.searchvalue / 2.0 * (random.nextDouble() - 0.5);
    }

    @Override
    protected void cleanUpChild() {
    }

    public class Individe
    extends AbstractIndivide {
        private double genome;

        @Override
        public double evaluate(ProgressManager progressManager, Properties properties) {
            this.fitnessValue = DemoFactory.this.searchvalue * DemoFactory.this.searchvalue - (DemoFactory.this.searchvalue - this.genome) * (DemoFactory.this.searchvalue - this.genome);
            return this.fitnessValue;
        }

        public double getGenome() {
            return this.genome;
        }

        @Override
        public void print(int n) {
            System.out.println("Generation: " + (n + 1) + "\tFitness value: " + NiceDataFormat.toString(this.getFitnessValue()) + "\tGenome: " + NiceDataFormat.toString(this.genome));
        }
    }
}

