/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.GA;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.model.GA.AbstractIndivide;
import se.prediktera.map.model.GA.DemoFactory;
import se.prediktera.map.model.GA.IndivideFactoryInterface;

public class GeneticAlgorithm
extends CleanUpClass {
    private List<AbstractIndivide> populationList;
    private IndivideFactoryInterface ifactory;
    private final int populationsize;
    private final Random random;
    private AbstractIndivide bestIndivide;
    private int generation;

    public static void main(String[] stringArray) {
        GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm(new DemoFactory(20.0), 10);
        geneticAlgorithm.start(100);
    }

    public GeneticAlgorithm(IndivideFactoryInterface individeFactoryInterface, int n) {
        this.ifactory = individeFactoryInterface;
        this.populationsize = n;
        this.random = new Random(System.currentTimeMillis());
    }

    public AbstractIndivide getBestIndivide() {
        return this.bestIndivide;
    }

    public void print() {
        System.out.println("#### Generation: " + (this.generation + 1) + " ####");
        for (AbstractIndivide abstractIndivide : this.populationList) {
            abstractIndivide.print(this.generation);
        }
        System.out.println("Best individe:");
        this.bestIndivide.print(this.generation);
    }

    public void start(int n) {
        this.start(null, n);
    }

    public void start(ProgressManager progressManager, int n) {
        try {
            Properties properties = new Properties();
            this.generatePopulation();
            int n2 = 0;
            if (progressManager != null) {
                n2 = progressManager.setGroupMaximumAndReset(n);
                progressManager.setInfoText("Optimizing with Genetic Algorithm");
            }
            for (int i = 0; i < n; ++i) {
                properties.put("setchanged", "false");
                double d = this.evaluatePopulation(progressManager, properties);
                this.print();
                if (!(this.bestIndivide.getFitnessValue() >= 4000.0)) {
                    double d2 = (double)i / (double)n;
                    this.breedPopulation(d, d2);
                    if (progressManager != null) {
                        progressManager.incStepGroup(n2);
                    }
                    properties.put("setchanged", "true");
                    this.bestIndivide.evaluate(progressManager, properties);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.ifactory != null) {
            this.ifactory.cleanUp();
            this.ifactory = null;
        }
    }

    private void breedPopulation(double d, double d2) {
        ArrayList<AbstractIndivide> arrayList = new ArrayList<AbstractIndivide>(this.populationsize);
        arrayList.add(this.bestIndivide);
        AbstractIndivide abstractIndivide = null;
        block0: for (int i = 0; i < this.populationsize - 1; ++i) {
            double d3 = this.random.nextDouble() * d;
            double d4 = 0.0;
            for (AbstractIndivide abstractIndivide2 : this.populationList) {
                if (!(d3 < (d4 += abstractIndivide2.getFitnessValue()))) continue;
                if (abstractIndivide != null) {
                    AbstractIndivide<AbstractIndivide> abstractIndivide3 = this.ifactory.crossOver(this.random, abstractIndivide, abstractIndivide2, d2);
                    if (this.random.nextDouble() < 0.3) {
                        this.ifactory.mutate(abstractIndivide3, this.random, d2);
                    }
                    arrayList.add(abstractIndivide3);
                }
                abstractIndivide = abstractIndivide2;
                continue block0;
            }
        }
        this.populationList = arrayList;
        ++this.generation;
    }

    private double evaluatePopulation(ProgressManager progressManager, Properties properties) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        this.bestIndivide = null;
        for (AbstractIndivide abstractIndivide : this.populationList) {
            double d3 = abstractIndivide.evaluate(progressManager, properties);
            d += d3;
            if (!(d2 < d3)) continue;
            d2 = d3;
            this.bestIndivide = abstractIndivide;
        }
        return d;
    }

    private void generatePopulation() {
        this.populationList = new ArrayList<AbstractIndivide>(this.populationsize);
        for (int i = 0; i < this.populationsize; ++i) {
            AbstractIndivide abstractIndivide = this.ifactory.createIndivide(this.random);
            this.populationList.add(abstractIndivide);
        }
        this.generation = 0;
    }
}

