/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;

public class ModelHelper {
    public static int[] createYindx(DataSet dataSet, int n) {
        AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
        int n2 = abstractDataMatrix.getK();
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (n == i) {
                nArray[i] = n3;
                continue;
            }
            nArray[i] = -1;
            ++n3;
        }
        nArray[nArray.length - 1] = n3;
        return nArray;
    }

    public static List<InnerColumnClass> getActiveClasses(DataSet dataSet) {
        return ModelHelper.getActiveClasses(dataSet, false);
    }

    public static boolean hasModelClass(DataSet dataSet) {
        return !ModelHelper.getActiveClasses(dataSet, true).isEmpty();
    }

    private static List<InnerColumnClass> getActiveClasses(DataSet dataSet, boolean bl) {
        ArrayList<InnerColumnClass> arrayList = new ArrayList<InnerColumnClass>();
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        if (observationInfo != null) {
            InnerColumnBooleanIncExc innerColumnBooleanIncExc = ModelHelper.getIncExcColumn(observationInfo);
            Transformations transformations = observationInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4 || !ModelHelper.hasActiveMember(transformations.getInnerColumn(i), innerColumnBooleanIncExc)) continue;
                arrayList.add((InnerColumnClass)transformations.getInnerColumn(i));
                if (!bl) continue;
                return arrayList;
            }
        }
        return arrayList;
    }

    private static InnerColumnBooleanIncExc getIncExcColumn(AbstractDataInfo abstractDataInfo) {
        for (int i = 0; i < abstractDataInfo.getAllColumnCount(); ++i) {
            if (!(abstractDataInfo.getAllInnerColumn(i) instanceof InnerColumnBooleanIncExc)) continue;
            return (InnerColumnBooleanIncExc)abstractDataInfo.getAllInnerColumn(i);
        }
        return null;
    }

    private static boolean hasActiveMember(AbstractInnerColumn abstractInnerColumn, InnerColumnBooleanIncExc innerColumnBooleanIncExc) {
        if (innerColumnBooleanIncExc != null && abstractInnerColumn instanceof InnerColumnClass) {
            InnerColumnClass innerColumnClass = (InnerColumnClass)abstractInnerColumn;
            int n = innerColumnClass.getSize();
            for (int i = 0; i < n; ++i) {
                if ((Integer)innerColumnClass.getValue(i) == 0 || !innerColumnBooleanIncExc.getValueBool(i)) continue;
                return true;
            }
        }
        return false;
    }
}

