/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.propagation.PropagationDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public class ModelManager {
    public static void addModelIntoProject(Project_GUI project_GUI, AbstractModel abstractModel) {
        if (abstractModel.getDataSet() != null) {
            DataSet dataSet = abstractModel.getDataSet();
            Case case_ = dataSet.getCase();
            case_.setModel();
            case_.setName(dataSet.toString());
            project_GUI.getRootNode().addTreeNode(case_);
        } else {
            project_GUI.getRootNode().addTreeNode(abstractModel);
        }
    }

    public static void collectModels(DataTreeInterface dataTreeInterface, List<AbstractModel> list) {
        ModelManager.collectModels(dataTreeInterface, list, false, true);
    }

    public static void collectModels(DataTreeInterface dataTreeInterface, List<AbstractModel> list, boolean bl, boolean bl2) {
        if (dataTreeInterface == null || !dataTreeInterface.isVisibleInTree() || dataTreeInterface.isCleaned()) {
            return;
        }
        if (dataTreeInterface instanceof AbstractModel) {
            AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
            ModelManager.collectModel(list, abstractModel, bl2);
        }
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            ModelManager.collectModels(dataTreeInterface.getTreeNodeAt(i), list, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectModels(ProgressManager progressManager, File file, List<AbstractModel> list) {
        block19: {
            RandomInputStream randomInputStream = null;
            try {
                int n;
                randomInputStream = new RandomInputStream(file, progressManager);
                DataTreeManager dataTreeManager = new DataTreeManager(true);
                randomInputStream.setDataTreeManager(dataTreeManager);
                randomInputStream.readFileFramework(true, false);
                DataTreeInterface dataTreeInterface = randomInputStream.resolveRoot();
                if (dataTreeInterface == null) break block19;
                if (dataTreeInterface instanceof AbstractModel) {
                    ModelManager.collectModels(dataTreeInterface, list);
                } else {
                    for (n = 0; n < dataTreeInterface.getTreeNodeCount(); ++n) {
                        Case case_;
                        DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(n);
                        if (!(dataTreeInterface2 instanceof Case) || !(case_ = (Case)dataTreeInterface2).isVisibleInTree()) continue;
                        ModelManager.collectModels(case_, list);
                        for (AbstractModel abstractModel : list) {
                            abstractModel.setExternal();
                        }
                        break;
                    }
                }
                if (dataTreeInterface instanceof DataContainer) {
                    ((DataContainer)dataTreeInterface).setRootNode(dataTreeManager);
                }
                for (n = dataTreeInterface.getTreeNodeCount() - 1; n >= 0; --n) {
                    if (!dataTreeInterface.getTreeNodeAt(n).isNode()) continue;
                    DataTreeManager.LoadIntoMemory(null, progressManager, dataTreeInterface.getTreeNodeAt(n), false);
                }
            }
            catch (IOException iOException) {
                try {
                    if (randomInputStream != null) {
                        randomInputStream.close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            finally {
                try {
                    if (randomInputStream != null) {
                        randomInputStream.close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static AbstractModel getModelByID(List<AbstractModel> list, int n) {
        for (AbstractModel abstractModel : list) {
            if (abstractModel.getID() != n) continue;
            Project_GUI project_GUI = Main_GUI.get().getCurrentProject();
            abstractModel.setDataTreeManager(project_GUI.getDataTreeManager(), true);
            return abstractModel;
        }
        return null;
    }

    public static AbstractModel getModelByID(ProgressManager progressManager, File file, int n) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        ModelManager.collectModels(progressManager, file, arrayList);
        return ModelManager.getModelByID(arrayList, n);
    }

    public static AbstractModel loadModel(ProgressManager progressManager, DataTreeManager dataTreeManager, File file) {
        AbstractModel abstractModel;
        if (!file.exists()) {
            throw new RuntimeException("Model path does not exist: " + file.getAbsolutePath());
        }
        if (progressManager != null) {
            progressManager.setInfoText("Loading model: " + file.getName());
        }
        if (dataTreeManager == null) {
            dataTreeManager = new DataTreeManager(true);
        }
        try {
            RandomInputStream randomInputStream = new RandomInputStream(file, progressManager);
            randomInputStream.setDataTreeManager(new DataTreeManager(true));
            randomInputStream.readFileFramework(true);
            abstractModel = (AbstractModel)randomInputStream.resolveRoot();
            if (abstractModel != null) {
                PropagationDataNode propagationDataNode = abstractModel;
                if (abstractModel.getCase() != null) {
                    propagationDataNode = abstractModel.getCase();
                }
                DataTreeManager.LoadIntoMemory(null, progressManager, propagationDataNode, false);
                propagationDataNode.setDataTreeManager(dataTreeManager, true);
            }
            randomInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return abstractModel;
    }

    public static AbstractModel loadModel(ProgressManager progressManager, DataTreeManager dataTreeManager, String string) throws IOException {
        File file = new File(string);
        return ModelManager.loadModel(progressManager, dataTreeManager, file);
    }

    public static AbstractModel loadModelIntoProject(ProgressManager progressManager, File file) {
        Project_GUI project_GUI = Main_GUI.get().getCurrentProject();
        return ModelManager.loadModelIntoProject(progressManager, project_GUI, file);
    }

    public static AbstractModel loadModelIntoProject(ProgressManager progressManager, Project_GUI project_GUI, File file) {
        AbstractModel abstractModel = ModelManager.loadModel(progressManager, project_GUI.getDataTreeManager(), file);
        ModelManager.addModelIntoProject(project_GUI, abstractModel);
        return abstractModel;
    }

    public static AbstractPrediction predictWithModelList(ProgressManager progressManager, List<AbstractModel> list, DataSet dataSet, Properties properties) {
        AbstractPrediction abstractPrediction = null;
        ModelManager.sortModelList(list);
        for (AbstractModel abstractModel : list) {
            if (abstractPrediction == null) {
                abstractPrediction = (AbstractPrediction)abstractModel.createPrediction(progressManager, dataSet, properties);
                continue;
            }
            InnerColumnPredClass innerColumnPredClass = abstractPrediction.getPredictionCategory(false);
            abstractModel.addPrediction(progressManager, dataSet, innerColumnPredClass, abstractModel.getReplaceClassName(), properties);
        }
        return abstractPrediction;
    }

    public static void saveSBC(Project_GUI project_GUI, AbstractDataMatrix abstractDataMatrix) {
        try {
            int n = abstractDataMatrix.getN();
            for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                ModelMatrix modelMatrix = new ModelMatrix(null, (int[])null);
                modelMatrix.setName("B-scaled");
                DenseVector denseVector = new DenseVector(n);
                for (int j = 0; j < n; ++j) {
                    denseVector.set(j, abstractDataMatrix.getValue(j, i));
                }
                modelMatrix.addRow(denseVector);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public static void sortModelList(List<AbstractModel> list) {
        Collections.sort(list, (abstractModel, abstractModel2) -> {
            if (ModelManager.isConnectedTo(abstractModel, abstractModel2)) {
                return 1;
            }
            if (ModelManager.isConnectedTo(abstractModel2, abstractModel)) {
                return -1;
            }
            return 0;
        });
    }

    private static void collectModel(List<AbstractModel> list, AbstractModel abstractModel, boolean bl) {
        if (abstractModel.isEnabled()) {
            String string = abstractModel.getModelName();
            if (string.equals("PLS-DA") || string.equals("PLS") || string.equals("PCA") || string.equals("SIMCA") || abstractModel.getReplaceModel() != null) {
                DataTreeInterface dataTreeInterface;
                AbstractModel abstractModel2;
                if (!list.contains(abstractModel)) {
                    list.add(abstractModel);
                }
                if (bl && (abstractModel2 = abstractModel.getReplaceModel()) != null && ((dataTreeInterface = abstractModel2.getTreeParent()) == null || dataTreeInterface.toString().equals("Project Root"))) {
                    ModelManager.collectModel(list, abstractModel2, bl);
                }
            } else if (string.equals("Model Container")) {
                list.add(abstractModel);
            }
        }
    }

    private static boolean isConnectedTo(AbstractModel abstractModel, AbstractModel abstractModel2) {
        if (abstractModel.getReplaceModel() != null) {
            if (abstractModel.getReplaceModel().equals(abstractModel2)) {
                return true;
            }
            return ModelManager.isConnectedTo(abstractModel.getReplaceModel(), abstractModel2);
        }
        return false;
    }

    public ModelManager(boolean bl) {
        if (bl) {
            ExtClassLoader.findExtendedLibrariesByClassDir();
        }
    }
}

