/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.awt.Component;
import java.io.File;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;

public class ModelParameterExport {
    public static void export(Component component, final AbstractModel abstractModel) {
        final jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Export model data", component);
        jopensaveDialog2.setFileSelectionMode(1);
        if (jopensaveDialog2.saveshow()) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    ModelParameterExport.saveParameters(1.getProgressManager(), abstractModel, jopensaveDialog2.getSelectedFile());
                    return null;
                }
            };
            progressManagerImpl.setIndeterminate(true);
            progressManagerImpl.invokeNow();
        }
    }

    public static void saveParameters(ProgressManager progressManager, AbstractModel abstractModel, File file) {
        try {
            DenseMatrix denseMatrix = ModelParameterExport.calculateBprim(abstractModel);
            if (denseMatrix != null) {
                ModelParameterExport.createMvmatrix((Matrix)ModelParameterExport.transpose(denseMatrix)).save(progressManager, new File(file, "B.csv").getAbsolutePath(), "csv");
            }
            AbstractDataMatrix abstractDataMatrix = abstractModel.getMatrixByName("Xres");
            ModelParameterExport.saveTransformation(progressManager, file, abstractDataMatrix, "Center", "Mean values of X");
            ModelParameterExport.saveTransformation(progressManager, file, abstractDataMatrix, "UV Scale", "1 div (standard deviation of X)");
            AbstractDataMatrix abstractDataMatrix2 = abstractModel.getMatrixByName("Yres");
            if (abstractDataMatrix2 != null) {
                ModelParameterExport.saveTransformation(progressManager, file, abstractDataMatrix2, "Center", "Mean values of Y");
                ModelParameterExport.saveTransformation(progressManager, file, abstractDataMatrix2, "UV Scale", "1 div (standard deviation of Y)");
            }
        }
        catch (NotConvergedException notConvergedException) {
            throw new RuntimeException(notConvergedException);
        }
    }

    private static MVmatrix createMvmatrix(Matrix matrix) {
        MVmatrix mVmatrix = new MVmatrix(matrix.numRows(), matrix.numColumns());
        for (int i = 0; i < matrix.numColumns(); ++i) {
            for (int j = 0; j < matrix.numRows(); ++j) {
                mVmatrix.setValue(j, i, matrix.get(j, i));
            }
        }
        return mVmatrix;
    }

    private static void saveTransformation(ProgressManager progressManager, File file, AbstractDataMatrix abstractDataMatrix, String string, String string2) {
        DataTreeInterface dataTreeInterface = abstractDataMatrix.getNodeByName(string);
        if (dataTreeInterface != null && dataTreeInterface.getTreeNodeCount() >= 2) {
            AbstractDataMatrix abstractDataMatrix2 = (AbstractDataMatrix)dataTreeInterface.getTreeNodeAt(1);
            abstractDataMatrix2.save(progressManager, new File(file, string2 + ".csv").getAbsolutePath(), "csv");
        }
    }

    public static DenseMatrix calculateBprim(AbstractModel abstractModel) throws NotConvergedException {
        DenseMatrix denseMatrix = ModelParameterExport.getModelData(abstractModel, "P");
        DenseMatrix denseMatrix2 = ModelParameterExport.getModelData(abstractModel, "W");
        DenseMatrix denseMatrix3 = ModelParameterExport.getModelData(abstractModel, "C");
        DenseMatrix denseMatrix4 = ModelParameterExport.transpose(denseMatrix);
        DenseMatrix denseMatrix5 = new DenseMatrix(denseMatrix4.numRows(), denseMatrix2.numColumns());
        denseMatrix4.mult((Matrix)denseMatrix2, (Matrix)denseMatrix5);
        DenseMatrix denseMatrix6 = ModelParameterExport.pseudoInverse(denseMatrix5);
        DenseMatrix denseMatrix7 = ModelParameterExport.transpose(denseMatrix3);
        DenseMatrix denseMatrix8 = new DenseMatrix(denseMatrix6.numRows(), denseMatrix7.numColumns());
        denseMatrix6.mult((Matrix)denseMatrix7, (Matrix)denseMatrix8);
        DenseMatrix denseMatrix9 = new DenseMatrix(denseMatrix2.numRows(), denseMatrix8.numColumns());
        denseMatrix2.mult((Matrix)denseMatrix8, (Matrix)denseMatrix9);
        return ModelParameterExport.transpose(denseMatrix9);
    }

    public static DenseMatrix transpose(DenseMatrix denseMatrix) {
        DenseMatrix denseMatrix2 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix.numRows());
        denseMatrix.transpose((Matrix)denseMatrix2);
        return denseMatrix2;
    }

    public static DenseMatrix getModelData(AbstractModel abstractModel, String string) {
        return ModelParameterExport.getModelData((ModelMatrix)abstractModel.get(string));
    }

    public static DenseMatrix getModelData(ModelMatrix modelMatrix) {
        return (DenseMatrix)new MVmatrix(modelMatrix.getDoubleData()).getInternalMatrixPublic();
    }

    public static DenseMatrix pseudoInverse(DenseMatrix denseMatrix) throws NotConvergedException {
        SVD sVD = SVD.factorize((Matrix)denseMatrix.copy());
        DenseMatrix denseMatrix2 = sVD.getU();
        DenseMatrix denseMatrix3 = sVD.getVt();
        double[] dArray = sVD.getS();
        DenseMatrix denseMatrix4 = new DenseMatrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 1.0E-6)) continue;
            denseMatrix4.set(i, i, 1.0 / dArray[i]);
        }
        DenseMatrix denseMatrix5 = new DenseMatrix(denseMatrix3.numColumns(), denseMatrix3.numRows());
        denseMatrix3.transpose((Matrix)denseMatrix5);
        DenseMatrix denseMatrix6 = new DenseMatrix(denseMatrix5.numRows(), denseMatrix4.numColumns());
        denseMatrix5.mult((Matrix)denseMatrix4, (Matrix)denseMatrix6);
        DenseMatrix denseMatrix7 = new DenseMatrix(denseMatrix6.numRows(), denseMatrix2.numRows());
        denseMatrix6.mult(denseMatrix2.transpose(), (Matrix)denseMatrix7);
        return denseMatrix7;
    }
}

