/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.model.ModelInterface;

public class ModelWrapper
extends DataTreeClass {
    private int start_index;
    private int end_index;
    private int components;
    private final ModelInterface modelInteface;

    public ModelWrapper(ModelInterface modelInterface, int n, int n2, int n3) {
        super(modelInterface.toString());
        this.modelInteface = modelInterface;
        this.start_index = n;
        this.end_index = n2;
        this.components = n3;
    }

    public ModelWrapper(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.modelInteface = (ModelInterface)mapProperty.resolveNodeFromName(randomInputStream, "mi");
        if (mapProperty.hasProperty("si")) {
            this.start_index = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("ei")) {
            this.end_index = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("comp")) {
            this.components = mapProperty.getLVInt();
        }
    }

    public int getComponents() {
        return this.components;
    }

    public int getEndIndex() {
        return this.end_index;
    }

    public ModelInterface getModelInterface() {
        return this.modelInteface;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    public int getStartIndex() {
        return this.start_index;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("mi", this.modelInteface);
        randomOutputStream.writePropertyInt("si", this.start_index);
        randomOutputStream.writePropertyInt("ei", this.end_index);
        randomOutputStream.writePropertyInt("comp", this.components);
    }
}

