/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public class PredictionHelper {
    public static void addPredictionToComboBox(DataTreeInterface dataTreeInterface, JComboBox jComboBox) {
        PredictionHelper.addPredictionToComboBox(dataTreeInterface, jComboBox, null);
    }

    public static void addPredictionToComboBox(DataTreeInterface dataTreeInterface, JComboBox jComboBox, Boolean bl) {
        for (AbstractPrediction abstractPrediction : PredictionHelper.getPredictions(dataTreeInterface, bl)) {
            jComboBox.addItem(abstractPrediction);
        }
    }

    public static List<AbstractPrediction> getPredictions(DataTreeInterface dataTreeInterface) {
        return PredictionHelper.getPredictions(dataTreeInterface, null);
    }

    public static List<AbstractPrediction> getPredictions(DataTreeInterface dataTreeInterface, Boolean bl) {
        AbstractDataNode abstractDataNode;
        ArrayList<AbstractPrediction> arrayList = new ArrayList<AbstractPrediction>();
        if (dataTreeInterface instanceof AbstractModel) {
            abstractDataNode = (AbstractModel)dataTreeInterface;
            PredictionHelper.checkAndAddPrediction(((AbstractModel)abstractDataNode).getLocalTrainingPredictionNode(), arrayList, bl);
            PredictionHelper.checkAndAddPrediction(((AbstractModel)abstractDataNode).getLocalPredictionNode(), arrayList, bl);
        }
        PredictionHelper.checkAndAddPrediction(dataTreeInterface, arrayList, bl);
        abstractDataNode = null;
        if (dataTreeInterface instanceof AbstractModel) {
            abstractDataNode = ((AbstractModel)dataTreeInterface).getExternalPredictions();
        } else if (dataTreeInterface instanceof DataContainer) {
            abstractDataNode = (DataContainer)dataTreeInterface;
        }
        if (abstractDataNode != null && (((DataContainer)abstractDataNode).getType() == 13 || ((DataContainer)abstractDataNode).getType() == 14)) {
            for (int i = 0; i < abstractDataNode.getTreeNodeCount(); ++i) {
                PredictionHelper.checkAndAddPrediction(abstractDataNode.getTreeNodeAt(i), arrayList, bl);
            }
        }
        return arrayList;
    }

    private static void checkAndAddPrediction(DataTreeInterface dataTreeInterface, List<AbstractPrediction> list, Boolean bl) {
        AbstractPrediction abstractPrediction = PredictionHelper.supportPrediction(dataTreeInterface, bl);
        if (abstractPrediction != null) {
            list.add(abstractPrediction);
        }
    }

    private static AbstractPrediction supportPrediction(DataTreeInterface dataTreeInterface, Boolean bl) {
        AbstractModel abstractModel;
        AbstractPrediction abstractPrediction;
        if (dataTreeInterface instanceof AbstractPrediction && (abstractPrediction = (AbstractPrediction)dataTreeInterface).hasPredictions() && abstractPrediction.getModel() != null && ((abstractModel = abstractPrediction.getModel()).getModelName().equals("PLS-DA") || abstractModel.getModelName().equals("SIMCA") || abstractModel.getModelName().equals("PLS")) && (bl == null || bl.equals(abstractModel.isUnfolded()))) {
            return abstractPrediction;
        }
        return null;
    }
}

