/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.modelgenerator;

import java.io.IOException;
import java.util.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;

public class ModelInit
extends AbstractInit {
    public String categoryName = null;
    public String yCategoryName = null;
    public boolean singleY = false;
    public byte crossvalidationType;
    public int nr_groups = 7;
    public boolean calc_ci = false;
    public boolean typeisfull = false;
    public String cvCategoryName = null;
    public Long randomSeed = null;
    public boolean rethrowExceptions = false;
    private DataContainer dataContainer;
    private Vector windowVector;
    private AbstractModelContainerWindow containerWindow;
    private String modelName;
    private String modelType;
    private boolean equalsize = false;
    private InnerColumnClass icClass;
    private boolean confidenceInterval = true;
    public boolean removeZeroVariance = true;
    public boolean calcDmodx = true;

    public ModelInit(DataTreeInterface dataTreeInterface) {
        super("ModelInit", dataTreeInterface);
        this.setDataTreeInterface(dataTreeInterface);
    }

    public ModelInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractInit cloneCurrent() {
        ModelInit modelInit = new ModelInit(this.dataTreeInterface);
        this.copyInitTo(modelInit);
        return modelInit;
    }

    @Override
    public void copyInitTo(AbstractInit abstractInit) {
        super.copyInitTo(abstractInit);
        ModelInit modelInit = (ModelInit)abstractInit;
        modelInit.categoryName = this.categoryName;
        modelInit.yCategoryName = this.yCategoryName;
        modelInit.singleY = this.singleY;
        modelInit.crossvalidationType = this.crossvalidationType;
        modelInit.nr_groups = this.nr_groups;
        modelInit.calc_ci = this.calc_ci;
        modelInit.randomSeed = this.randomSeed;
        modelInit.typeisfull = this.typeisfull;
        modelInit.cvCategoryName = this.cvCategoryName;
        modelInit.confidenceInterval = this.confidenceInterval;
        modelInit.equalsize = this.equalsize;
        modelInit.icClass = this.icClass;
    }

    public InnerColumnClass getClassColumn(String string) {
        DataSet dataSet = null;
        if (this.dataTreeInterface instanceof DataSet) {
            dataSet = (DataSet)this.dataTreeInterface;
        } else if (this.dataTreeInterface instanceof AbstractModel) {
            dataSet = ((AbstractModel)this.dataTreeInterface).getDataSet();
        }
        if (dataSet != null) {
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            Transformations transformations = observationInfo.getTransformationNode();
            Object icType = transformations.getInnerColumnByName(string);
            if (icType instanceof InnerColumnClass) {
                return (InnerColumnClass)icType;
            }
            PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
            return predictionClasses.getPredictionClass(null, string);
        }
        return null;
    }

    public AbstractModelContainerWindow getContainerWindow() {
        return this.containerWindow;
    }

    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    public DataSet getDataSet() {
        if (this.getDataTreeInterface() instanceof AbstractModel) {
            return ((AbstractModel)this.getDataTreeInterface()).getDataSet();
        }
        return (DataSet)this.getDataTreeInterface();
    }

    public DataContainer getDataSetContainer() {
        DataSet dataSet = this.getDataSet();
        if (dataSet == null || dataSet.getCase() == null) {
            return null;
        }
        return dataSet.getCase().getDsContainer();
    }

    public InnerColumnClass getIcClass() {
        return this.icClass;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Vector getWindowVector() {
        return this.windowVector;
    }

    public boolean hasConfidenceInterval() {
        return this.confidenceInterval;
    }

    public boolean isEqualsize() {
        return this.equalsize;
    }

    public boolean isModelContainer() {
        return this.categoryName != null || this.singleY;
    }

    public void setConfidenceInterval(boolean bl) {
        this.confidenceInterval = bl;
    }

    public void setContainerWindow(AbstractModelContainerWindow abstractModelContainerWindow) {
        this.containerWindow = abstractModelContainerWindow;
    }

    public void setDataContainer(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public final void setDataTreeInterface(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractModel || dataTreeInterface instanceof DataSet) {
            super.setDataTreeInterface(dataTreeInterface);
        }
    }

    public void setEqualsize(boolean bl) {
        this.equalsize = bl;
    }

    public void setIcClass(InnerColumnClass innerColumnClass) {
        this.icClass = innerColumnClass;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public void setModelType(String string) {
        this.modelType = string;
    }

    public void setWindowVector(Vector vector) {
        this.windowVector = vector;
    }
}

