/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.output;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;

public class OutputClass
extends DataTreeClass {
    private AbstractModel model;
    private double[] yminvalue = null;
    private double[] ymaxvalue = null;
    private double[] ymeanvalue = null;
    private double[] yscale = null;
    private int[] color = null;
    private boolean[] background = null;
    private String namedmodx = "No class";
    private int colordmodx = Color.red.getRGB();

    public OutputClass(AbstractModel abstractModel, String string) {
        super("Output");
        this.model = abstractModel;
        this.setName(string);
    }

    public OutputClass(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.model = (AbstractModel)mapProperty.resolveNodeFromName(randomInputStream, "model");
        this.yminvalue = mapProperty.getPropertyDoubleArray("yminvalue");
        this.ymaxvalue = mapProperty.getPropertyDoubleArray("ymaxvalue");
        this.ymeanvalue = mapProperty.getPropertyDoubleArray("ymeanvalue");
        this.yscale = mapProperty.getPropertyDoubleArray("yscale");
        this.color = mapProperty.getPropertyIntArray("color", null);
        this.background = mapProperty.getPropertyBooleanArray("bg", null);
        this.namedmodx = mapProperty.getPropertyStringUTF("namedmodx", this.namedmodx);
        this.colordmodx = mapProperty.getPropertyInt("colordmodx", this.colordmodx);
    }

    public Color getColor(int n) {
        if (this.color == null) {
            this.updateOutput();
        }
        if (this.color != null) {
            return new Color(this.color[n]);
        }
        return null;
    }

    public int getColordmodx() {
        return this.colordmodx;
    }

    public AbstractModel getModel() {
        return this.model;
    }

    public String getNamedmodx() {
        return this.namedmodx;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    public double[] getYmax() {
        if (this.ymaxvalue == null) {
            this.updateOutput();
        }
        return this.ymaxvalue;
    }

    private int getIndex(String string) {
        String[] stringArray = this.model.getVariableArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public Double getYmax(String string) {
        return this.getYmax(this.getIndex(string), null);
    }

    public Double getYmax(int n, Properties properties) {
        if (this.ymaxvalue == null) {
            this.updateOutput();
        }
        if (this.ymaxvalue != null) {
            return this.ymaxvalue[n];
        }
        return null;
    }

    public double[] getYmeanValue() {
        if (this.ymeanvalue == null) {
            this.updateOutput();
        }
        return this.ymeanvalue;
    }

    public Double getYmin(String string) {
        return this.getYmin(this.getIndex(string), null);
    }

    public double[] getYmin() {
        if (this.yminvalue == null) {
            this.updateOutput();
        }
        return this.yminvalue;
    }

    public Double getYmin(int n, Properties properties) {
        if (this.yminvalue == null) {
            this.updateOutput();
        }
        if (this.yminvalue != null) {
            return this.yminvalue[n];
        }
        return null;
    }

    public double[] getYscale() {
        if (this.yscale == null) {
            this.updateOutput();
        }
        return this.yscale;
    }

    public boolean hasColor() {
        ModelMatrix modelMatrix;
        if (this.color == null && this.model != null && this.model.getModelName().equalsIgnoreCase("pls-da") && (modelMatrix = (ModelMatrix)this.model.getMatrixByName("c")) != null) {
            int n = modelMatrix.getK();
            this.color = new int[n];
            for (int i = 0; i < this.color.length; ++i) {
                Color color = PerfectSpread.generateColor(i);
                this.color[i] = color.getRGB();
            }
        }
        return this.color != null;
    }

    public boolean isBackground(int n) {
        if (this.background == null) {
            this.updateOutput();
        }
        if (this.background != null) {
            return this.background[n];
        }
        return true;
    }

    public void setBackground(int n, boolean bl) {
        if (this.background == null) {
            if (this.color != null) {
                this.background = new boolean[this.color.length];
            } else {
                this.updateOutput();
            }
        }
        if (this.background != null) {
            this.background[n] = bl;
        }
    }

    public void setColor(int n, Color color) {
        this.color[n] = color.getRGB();
    }

    public void setColordmodx(int n) {
        this.colordmodx = n;
    }

    public void setNamedmodx(String string) {
        this.namedmodx = string;
    }

    public void updateOutput() {
        this.updateOutput(true);
    }

    public void updateOutput(boolean bl) {
        DataSet dataSet = this.model.getDataSet();
        if (dataSet != null) {
            if (this.model.getModelName().equalsIgnoreCase("pca")) {
                int n = this.model.getComponentsInt();
                this.yminvalue = new double[n];
                this.ymaxvalue = new double[n];
                this.ymeanvalue = new double[n];
                this.yscale = new double[n];
                Arrays.fill(this.yminvalue, 2.147483647E9);
                Arrays.fill(this.ymaxvalue, -2.147483647E9);
                Arrays.fill(this.ymeanvalue, 0.0);
                Arrays.fill(this.yscale, 0.1);
                ModelMatrix modelMatrix = (ModelMatrix)this.model.getMatrixByName("t");
                boolean bl2 = modelMatrix.hasMissing();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < modelMatrix.getK(); ++j) {
                        if (bl2 && modelMatrix.isMissing(i, j)) continue;
                        double d = modelMatrix.getValue(i, j);
                        if (this.yminvalue[i] > d) {
                            this.yminvalue[i] = d;
                        }
                        if (this.ymaxvalue[i] < d) {
                            this.ymaxvalue[i] = d;
                        }
                        int n2 = i;
                        this.ymeanvalue[n2] = this.ymeanvalue[n2] + d;
                    }
                }
            } else {
                Object object;
                ModelMatrix modelMatrix = (ModelMatrix)this.model.getMatrixByName("c");
                if (modelMatrix == null) {
                    return;
                }
                int[] nArray = this.model.getYindx();
                int n = modelMatrix.getK();
                if (this.yminvalue != null && !bl) {
                    if (this.yminvalue.length == n) {
                        return;
                    }
                    object = new double[n];
                    double[] dArray = new double[n];
                    var8_17 = new double[n];
                    double[] dArray2 = new double[n];
                    System.arraycopy(this.yminvalue, 0, object, 0, Math.min(this.yminvalue.length, ((double[])object).length));
                    System.arraycopy(this.ymaxvalue, 0, dArray, 0, Math.min(this.ymaxvalue.length, dArray.length));
                    System.arraycopy(this.ymeanvalue, 0, var8_17, 0, Math.min(this.ymeanvalue.length, ((double[])var8_17).length));
                    System.arraycopy(this.yscale, 0, dArray2, 0, Math.min(this.yscale.length, dArray2.length));
                    this.yminvalue = object;
                    this.ymaxvalue = dArray;
                    this.ymeanvalue = var8_17;
                    this.yscale = dArray2;
                } else {
                    this.yminvalue = new double[n];
                    this.ymaxvalue = new double[n];
                    this.ymeanvalue = new double[n];
                    this.yscale = new double[n];
                    Arrays.fill(this.yminvalue, 2.147483647E9);
                    Arrays.fill(this.ymaxvalue, -2.147483647E9);
                    Arrays.fill(this.ymeanvalue, 0.0);
                    Arrays.fill(this.yscale, 0.1);
                    if (n > 0) {
                        object = dataSet.getMatrix(2);
                        int n3 = this.calcMinMax((AbstractDataMatrix)object, nArray);
                        var8_17 = dataSet.getMatrix(3);
                        if (var8_17 != null) {
                            n3 += this.calcMinMax((AbstractDataMatrix)var8_17, nArray);
                        }
                        int n4 = 0;
                        while (n4 < n) {
                            int n5 = n4++;
                            this.ymeanvalue[n5] = this.ymeanvalue[n5] / (double)n3;
                        }
                    }
                }
                object = this.model.getClassName();
                if (object != null) {
                    ClassTypes classTypes = this.model.getClassTypesByName((String)object);
                    int n6 = n + (this.model.isUseDcrit() ? 1 : 0);
                    this.color = new int[n6];
                    this.background = new boolean[n6];
                    for (int i = 0; i < n; ++i) {
                        int n7;
                        String string = modelMatrix.getColumnDescription(i, 0);
                        int n8 = string.indexOf(":");
                        if (n8 > 0) {
                            string = string.substring(string.indexOf(":") + 2);
                        }
                        if ((n7 = string.lastIndexOf(".")) > 0) {
                            string = string.substring(0, string.lastIndexOf("."));
                        }
                        ClassSettings classSettings = null;
                        if (classTypes != null) {
                            classSettings = classTypes.getClassSettingsByName(string);
                        }
                        if (classSettings != null) {
                            this.color[i] = classSettings.getColor().getRGB();
                        }
                        this.background[i] = true;
                    }
                    if (this.model.isUseDcrit()) {
                        this.color[n] = Color.red.getRGB();
                        this.background[n] = true;
                    }
                }
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.yminvalue = null;
        this.ymaxvalue = null;
        this.ymeanvalue = null;
        this.yscale = null;
        this.color = null;
        this.background = null;
        this.model = null;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyNode("model", this.model);
        randomOutputStream.writePropertyDoubleArray("yminvalue", this.yminvalue);
        randomOutputStream.writePropertyDoubleArray("ymaxvalue", this.ymaxvalue);
        randomOutputStream.writePropertyDoubleArray("ymeanvalue", this.ymeanvalue);
        randomOutputStream.writePropertyDoubleArray("yscale", this.yscale);
        randomOutputStream.writePropertyIntArray("color", this.color);
        randomOutputStream.writePropertyBooleanArray("bg", this.background);
        randomOutputStream.writePropertyStringUTF("namedmodx", this.namedmodx);
        randomOutputStream.writePropertyInt("colordmodx", this.colordmodx);
    }

    private int calcMinMax(AbstractDataMatrix abstractDataMatrix, int[] nArray) {
        boolean bl = abstractDataMatrix.hasMissing();
        for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
            if (nArray != null && nArray[i] <= 0) continue;
            int n = i;
            if (nArray != null) {
                n -= nArray[i];
            }
            for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                if (bl && abstractDataMatrix.isMissing(j, i)) continue;
                double d = abstractDataMatrix.getValue(j, i);
                if (this.yminvalue[n] > d) {
                    this.yminvalue[n] = d;
                }
                if (this.ymaxvalue[n] < d) {
                    this.ymaxvalue[n] = d;
                }
                int n2 = n;
                this.ymeanvalue[n2] = this.ymeanvalue[n2] + d;
            }
        }
        return abstractDataMatrix.getN();
    }
}

