/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.output;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelManager;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.model.output.OutputPanel;

public class OutputDialog
extends CleanUpDialog {
    private AbstractModel model;
    private final Vector<AbstractModel> modelListVector = new Vector();
    private JButton addOutputButton;
    private JPanel bottomPanel;
    private JPanel centerPanel;
    private JButton closeButton;
    private JList modelList;
    private JLabel modelListLabel;
    private JScrollPane modelListScrollPane;
    private JButton okButton;
    private JTabbedPane outputTabbedPane;
    private JButton removeOutputButton;

    public static boolean showDialog(Window window, AbstractModel abstractModel) {
        OutputDialog outputDialog = new OutputDialog(window, abstractModel);
        outputDialog.pack();
        outputDialog.setLocationRelativeTo(null);
        outputDialog.setVisible(true);
        return true;
    }

    public OutputDialog(Window window, AbstractModel abstractModel) {
        super(window, "Model output settings");
        this.setModal(true);
        this.initComponents();
        this.addOutputPanels(abstractModel);
        this.setPreferredSize(new Dimension(550, 400));
        DataTreeInterface dataTreeInterface = abstractModel.getCase();
        if (dataTreeInterface == null) {
            dataTreeInterface = abstractModel.getTreeParent();
        }
        if (dataTreeInterface != null) {
            ModelManager.collectModels(dataTreeInterface, this.modelListVector);
            this.modelList.setListData(this.modelListVector);
            this.modelList.setSelectedValue(abstractModel, true);
        }
        this.modelList.setSelectionMode(0);
        this.modelList.addListSelectionListener(listSelectionEvent -> {
            AbstractModel abstractModel;
            if (!listSelectionEvent.getValueIsAdjusting() && (abstractModel = (AbstractModel)this.modelList.getSelectedValue()) != null) {
                this.addOutputPanels(abstractModel);
            }
        });
    }

    @Override
    protected void cleanUpChild() {
        this.model = null;
    }

    private void addOutputButtonActionPerformed(ActionEvent actionEvent) {
        OutputClass outputClass = new OutputClass(this.model, "N/A");
        outputClass.updateOutput();
        this.model.getOutputContainer().addTreeNode(outputClass);
        this.outputTabbedPane.addTab(outputClass.getName(), new OutputPanel(outputClass));
    }

    private void addOutputPanels(AbstractModel abstractModel) {
        if (this.model != null) {
            this.saveOutputPanels();
        }
        this.model = abstractModel;
        this.outputTabbedPane.removeAll();
        DataContainer dataContainer = abstractModel.getOutputContainer();
        for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
            OutputClass outputClass = (OutputClass)dataContainer.getTreeNodeAt(i);
            this.outputTabbedPane.addTab(outputClass.getName(), new OutputPanel(outputClass));
        }
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.cleanUp();
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.modelListScrollPane = new JScrollPane();
        this.modelList = new JList();
        this.centerPanel = new JPanel();
        this.addOutputButton = new JButton();
        this.removeOutputButton = new JButton();
        this.outputTabbedPane = new JTabbedPane();
        this.modelListLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.bottomPanel.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(81, 26));
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.bottomPanel.add((Component)this.okButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.setPreferredSize(new Dimension(81, 26));
        this.closeButton.addActionListener(actionEvent -> this.closeButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.bottomPanel.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.bottomPanel, gridBagConstraints);
        this.modelListScrollPane.setPreferredSize(new Dimension(150, 0));
        this.modelListScrollPane.setViewportView(this.modelList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.modelListScrollPane, gridBagConstraints);
        this.centerPanel.setLayout(new GridBagLayout());
        this.addOutputButton.setIcon(new ImageIcon(Evince.class.getResource("gif/compplus.gif")));
        this.addOutputButton.setText("Add");
        this.addOutputButton.addActionListener(actionEvent -> this.addOutputButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.centerPanel.add((Component)this.addOutputButton, gridBagConstraints);
        this.removeOutputButton.setIcon(new ImageIcon(Evince.class.getResource("gif/compminus.gif")));
        this.removeOutputButton.setText("Remove");
        this.removeOutputButton.addActionListener(actionEvent -> this.removeOutputButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.centerPanel.add((Component)this.removeOutputButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.centerPanel.add((Component)this.outputTabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.centerPanel, gridBagConstraints);
        this.modelListLabel.setFont(new Font("Tahoma", 1, 11));
        this.modelListLabel.setText("Choose model from list:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.modelListLabel, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.saveOutputPanels();
        this.cleanUp();
    }

    private void removeOutputButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void saveOutputPanels() {
        DataContainer dataContainer = this.model.getOutputContainer();
        for (int i = 0; i < this.outputTabbedPane.getTabCount(); ++i) {
            OutputPanel outputPanel = (OutputPanel)this.outputTabbedPane.getComponentAt(i);
            outputPanel.setModelValues((OutputClass)dataContainer.getTreeNodeAt(i));
        }
        Project_GUI project_GUI = this.model.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.setProjectChanged();
        }
    }
}

