/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.output;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;

public class OutputPanel
extends JPanel {
    private final ArrayList<JTextFieldButtonUppDown> minArray = new ArrayList();
    private final ArrayList<JTextFieldButtonUppDown> maxArray = new ArrayList();
    private final ArrayList<ScalePanel> colorArray = new ArrayList();
    private final ArrayList<JCheckBox> backgroundArray = new ArrayList();
    private final JTextField dmodxTextField = new JTextField();
    private final ScalePanel dmodxColorScalePanel = new ScalePanel(null);
    private final JCheckBox dmodxBackgroundCheckBox = new JCheckBox("Bg");
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel valuePanel;

    public OutputPanel(OutputClass outputClass) {
        this.initComponents();
        try {
            this.updateMinMaxPanel(outputClass);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void setModelValues(OutputClass outputClass) {
        outputClass.setName(this.nameTextField.getText());
        double[] dArray = outputClass.getYmin();
        double[] dArray2 = outputClass.getYmax();
        for (int i = 0; i < this.minArray.size(); ++i) {
            JComponent jComponent;
            if (dArray != null) {
                jComponent = this.minArray.get(i);
                dArray[i] = ((JTextFieldButtonUppDown)jComponent).getNumber();
            }
            if (dArray2 != null) {
                jComponent = this.maxArray.get(i);
                dArray2[i] = ((JTextFieldButtonUppDown)jComponent).getNumber();
            }
            if (!outputClass.hasColor()) continue;
            jComponent = this.colorArray.get(i);
            outputClass.setColor(i, ((ScalePanel)jComponent).getFixedColor());
            JCheckBox jCheckBox = this.backgroundArray.get(i);
            outputClass.setBackground(i, jCheckBox.isSelected());
        }
        AbstractModel abstractModel = outputClass.getModel();
        if (abstractModel.isUseDcrit()) {
            outputClass.setNamedmodx(this.dmodxTextField.getText());
            outputClass.setColordmodx(this.dmodxColorScalePanel.getFixedColor().getRGB());
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.valuePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.valuePanel, gridBagConstraints);
    }

    private void updateMinMaxPanel(OutputClass outputClass) throws Exception {
        String string;
        int n;
        this.nameTextField.setText(outputClass.getName());
        this.valuePanel.setLayout(new GridBagLayout());
        AbstractModel abstractModel = outputClass.getModel();
        String[] stringArray = null;
        if (abstractModel.getModelName().equalsIgnoreCase("pca")) {
            n = abstractModel.getComponentsInt();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "Component " + (i + 1);
            }
        } else {
            ModelMatrix modelMatrix = (ModelMatrix)abstractModel.get("C");
            n = modelMatrix.getK();
            stringArray = new String[n];
            for (int i = 0; i < modelMatrix.getK(); ++i) {
                stringArray[i] = modelMatrix.getColumnDescription(i, 0);
            }
        }
        double[] dArray = outputClass.getYmin();
        double[] dArray2 = outputClass.getYmax();
        boolean bl = outputClass.hasColor();
        int n2 = 0;
        int n3 = 0;
        this.valuePanel.add((Component)new JBoldLabel("Name"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 0), 0, 0));
        if (bl) {
            this.valuePanel.add((Component)new JBoldLabel("Color"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 0), 0, 0));
            this.valuePanel.add((Component)new JBoldLabel("Background"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 0), 0, 0));
        }
        this.valuePanel.add((Component)new JBoldLabel("Min"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 0), 0, 0));
        this.valuePanel.add((Component)new JBoldLabel("Max"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 0), 0, 0));
        ++n2;
        int n4 = 0;
        while (n4 < n) {
            JComponent jComponent;
            int n5;
            string = stringArray[n4];
            if (abstractModel.getModelName().equals("PLS-DA") && (n5 = string.indexOf(":")) >= 0) {
                string = string.substring(n5 + 1);
            }
            n3 = 0;
            this.valuePanel.add((Component)new JLabel(string), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
            if (bl) {
                Color color = outputClass.getColor(n4);
                jComponent = new ScalePanel(new PlotContinuousColor("fixed", color));
                this.valuePanel.add((Component)jComponent, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 12, 0, 0), 0, 0));
                this.colorArray.add((ScalePanel)jComponent);
                JCheckBox jCheckBox = new JCheckBox("Bg");
                jCheckBox.setSelected(outputClass.isBackground(n4));
                this.valuePanel.add((Component)jCheckBox, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 12, 0, 0), 0, 0));
                this.backgroundArray.add(jCheckBox);
            }
            JTextFieldButtonUppDown jTextFieldButtonUppDown = new JTextFieldButtonUppDown(true);
            this.minArray.add(jTextFieldButtonUppDown);
            jTextFieldButtonUppDown.setNumber(dArray != null ? dArray[n4] : 0.0);
            this.valuePanel.add((Component)jTextFieldButtonUppDown, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
            jComponent = new JTextFieldButtonUppDown(true);
            this.maxArray.add((JTextFieldButtonUppDown)jComponent);
            ((JTextFieldButtonUppDown)jComponent).setNumber(dArray2 != null ? dArray2[n4] : 1.0);
            this.valuePanel.add((Component)jComponent, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 12), 0, 0));
            ++n4;
            ++n2;
        }
        if (abstractModel.isUseDcrit()) {
            n3 = 0;
            this.valuePanel.add((Component)new JLabel("DmodX"), new GridBagConstraints(n3++, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
            Color color = new Color(outputClass.getColordmodx());
            this.dmodxColorScalePanel.setContinuesColor(new PlotContinuousColor("fixed", color));
            this.valuePanel.add((Component)this.dmodxColorScalePanel, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 12, 0, 0), 0, 0));
            this.valuePanel.add((Component)this.dmodxBackgroundCheckBox, new GridBagConstraints(n3++, n2, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 12, 0, 0), 0, 0));
            string = outputClass.getNamedmodx();
            this.dmodxTextField.setText(string);
            this.valuePanel.add((Component)this.dmodxTextField, new GridBagConstraints(n3++, n2, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 6, 12), 0, 0));
            ++n2;
        }
        this.valuePanel.add((Component)new JLabel(""), new GridBagConstraints(n3 - 1, n2, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 12, 0, 12), 0, 0));
    }

    private class JBoldLabel
    extends JLabel {
        public JBoldLabel(String string) {
            super(string);
            Font font = this.getFont();
            this.setFont(new Font(font.getName(), 1, font.getSize()));
        }
    }
}

