/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.model.predictiontable;

import java.util.ArrayList;
import java.util.List;

public class SharedPredictionTable<T> {
    private final int numberClasses;
    private final List<T>[][] objectMatrix;
    private final List<T> correctlyList = new ArrayList<T>();
    private final List<T> inCorrectlyList = new ArrayList<T>();
    private final int[][] matrix;
    private boolean hasActual = false;

    public SharedPredictionTable(int n, int n2) {
        this.numberClasses = n;
        this.matrix = new int[n + 1][n2 + 1];
        this.objectMatrix = new ArrayList[n + 1][n2 + 1];
        for (int i = 0; i < this.objectMatrix.length; ++i) {
            for (int j = 0; j < this.objectMatrix[i].length; ++j) {
                this.objectMatrix[i][j] = new ArrayList<T>();
            }
        }
    }

    public void add(int n, int n2, T t) {
        this.hasActual = true;
        int[] nArray = this.matrix[n];
        nArray[0] = nArray[0] + 1;
        this.objectMatrix[n][0].add(t);
        int[] nArray2 = this.matrix[n];
        int n3 = n2 + 1;
        nArray2[n3] = nArray2[n3] + 1;
        this.objectMatrix[n][n2 + 1].add(t);
        if (n == n2) {
            this.correctlyList.add(t);
        } else {
            this.inCorrectlyList.add(t);
        }
        this.add(n2, t);
    }

    public void add(int n, T t) {
        int[] nArray = this.matrix[this.numberClasses];
        nArray[0] = nArray[0] + 1;
        this.objectMatrix[this.numberClasses][0].add(t);
        int n2 = n + 1;
        if (n2 < this.matrix[this.numberClasses].length) {
            int[] nArray2 = this.matrix[this.numberClasses];
            int n3 = n2;
            nArray2[n3] = nArray2[n3] + 1;
            this.objectMatrix[this.numberClasses][n2].add(t);
        }
    }

    public boolean hasActual() {
        return this.hasActual;
    }

    public int getNumberClasses() {
        return this.numberClasses;
    }

    public int get(int n, int n2) {
        return this.matrix[n][n2 + 1];
    }

    public int get(int n) {
        return this.matrix[n][0];
    }

    public int getTotal() {
        return this.matrix[this.numberClasses][0];
    }

    public int getTotal(int n) {
        return this.matrix[this.numberClasses][n + 1];
    }

    public int getCorrectly() {
        return this.correctlyList.size();
    }

    public List<T> getAllObjects() {
        ArrayList<T> arrayList = new ArrayList<T>(this.correctlyList);
        arrayList.addAll(this.inCorrectlyList);
        return arrayList;
    }

    public List<T> getCorrectlyObjects() {
        return this.correctlyList;
    }

    public int getIncorrectly() {
        return this.inCorrectlyList.size();
    }

    public List<T> getIncorrectlyObjects() {
        return this.inCorrectlyList;
    }

    public List<T> getObject(int n, int n2) {
        return this.objectMatrix[n][n2];
    }

    public List<T> getTotalObject(int n) {
        return this.objectMatrix[this.numberClasses][n];
    }
}

