/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.awt.SVGExtensionHandler;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.PlotSelectionDialog;
import se.prediktera.map.plot.axisplot.windows.TagHelper;

public abstract class AbstractPlot
extends AbstractWindow {
    public static final byte XAXIS = 0;
    public static final byte YAXIS = 1;
    public static final byte ZAXIS = 2;
    public static ImageIcon plotIcon = new ImageIcon(Main_GUI.class.getResource("gif/plot_layout_button.png"));
    private PlotPopupMenu plotPopupMenu = new PlotPopupMenu(this);

    public AbstractPlot(Plot_GUI plot_GUI, PlotInit plotInit) {
        super("AbstractPlot[" + (plotInit == null ? "Null" : plotInit.title) + "]", plot_GUI, plotInit);
    }

    public AbstractPlot(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        this.plotPopupMenu.addToWindowPopup(this, jPopupMenu);
        return true;
    }

    public void changeInteractiveSelection(byte by) {
    }

    @Override
    public String getGUI_Name() {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && plotInit.title != null) {
            String string = plotInit.title;
            string = string.replace("\n", " - ");
            return TagHelper.formatText(plotInit.getDataTreeInterface(), string);
        }
        return "No title";
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return plotIcon;
    }

    @Override
    public byte getNodeType() {
        return 2;
    }

    public Plot_GUI getPlot_GUI() {
        return (Plot_GUI)this.window_gui;
    }

    public PlotInit getPlotInit() {
        return (PlotInit)this.init;
    }

    public AbstractDataMatrix getInitMatrix(int n) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null) {
            return plotInit.getMatrix(n);
        }
        return null;
    }

    public int getPlotMatrixType() {
        if (this.init == null) {
            return -1;
        }
        return this.getPlotInit().plotType;
    }

    @Override
    public boolean hasInteractionWith(AbstractWindow abstractWindow) {
        if (abstractWindow instanceof AbstractPlot) {
            PlotInit plotInit = (PlotInit)abstractWindow.getAbstractInit();
            if (plotInit == null) {
                return false;
            }
            if (((plotInit.getInteractiveTag() & this.getInteractiveTag()) != 0 || plotInit.range_plot != this.getPlotInit().range_plot) && this.hasInteractivity()) {
                if (this.getProject_GUI().hasInteractionBetweenCases()) {
                    return true;
                }
                return this.init.isRelatedTo(plotInit);
            }
            return false;
        }
        return super.hasInteractionWith(abstractWindow);
    }

    public BufferedImage makeBufferedImageScreenShot(int n, int n2, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.makeScreenShot(graphics2D, n, n2, bl);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void makeScreenShot(Graphics2D graphics2D, int n, int n2, boolean bl) {
        this.makeScreenShot(graphics2D, n, n2, bl, !(graphics2D instanceof SVGGraphics2D), false);
    }

    public abstract void makeScreenShot(Graphics2D var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public SVGGraphics2D makeSVGScreenShot() {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setPrecision(4);
        sVGGeneratorContext.setComment("Created with Evince");
        sVGGeneratorContext.setExtensionHandler((ExtensionHandler)new SVGExtensionHandler());
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, false);
        Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
        sVGGraphics2D.setSVGCanvasSize(dimension);
        this.makeScreenShot((Graphics2D)sVGGraphics2D, dimension.width, dimension.height, false);
        return sVGGraphics2D;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d = pageFormat.getImageableWidth();
            double d2 = pageFormat.getImageableHeight();
            int n2 = (int)(d < d2 ? d : d2);
            if (!this.handleDirectPrintout()) {
                BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                this.makeScreenShot(graphics2D2, n2, n2, false, false, false);
                graphics2D2.dispose();
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            } else {
                this.makeScreenShot(graphics2D, n2, n2, false, false, true);
            }
            return 0;
        }
        return 1;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        this.SaveProperty(randomOutputStream);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        if (UpdateHelper.Product.isRunningProductEvince()) {
            this.setSelectionDialog(this.createSelectionDialog());
        }
    }

    public boolean supportSVG() {
        return true;
    }

    @Override
    public String toString() {
        return this.getGUI_Name();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.plotPopupMenu != null) {
            this.plotPopupMenu.cleanUp();
            this.plotPopupMenu = null;
        }
    }

    protected PlotSelectionDialog createSelectionDialog() {
        return new PlotSelectionDialog(this);
    }

    protected boolean handleDirectPrintout() {
        return true;
    }

    @Override
    protected AbstractInit loadInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        return new PlotInit(randomInputStream, mapProperty);
    }

    protected abstract void SaveProperty(RandomOutputStream var1) throws IOException;
}

