/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ColorCache {
    private static Map<Integer, Element> colorTable = new Hashtable<Integer, Element>(500);
    private static Element lastElement = null;
    private static final int USEDNOW = 25;

    public static final void clearLRU() {
        int n = 1 + (colorTable.size() - 250) / 10;
        Iterator<Element> iterator = colorTable.values().iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            element.used -= n;
            if (element.used >= 0) continue;
            iterator.remove();
        }
    }

    public static final Color getColor(int n) {
        if (lastElement != null && ColorCache.lastElement.color.getRGB() == n) {
            ColorCache.lastElement.used = 25;
            return ColorCache.lastElement.color;
        }
        int n2 = n;
        Element element = colorTable.get(n2);
        if (element == null) {
            if (colorTable.size() > 250) {
                ColorCache.clearLRU();
            }
            element = new Element(new Color(n));
            colorTable.put(n2, element);
        } else {
            element.used = 25;
        }
        lastElement = element;
        return element.color;
    }

    private ColorCache() {
    }

    private static final class Element {
        private final Color color;
        private int used = 25;

        public Element(Color color) {
            this.color = color;
        }
    }
}

