/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.model.AbstractModel;

public class PlotInit
extends AbstractInit {
    public static final byte CLASS_BY_NONE = 0;
    public static final byte LAYER_BY_OBS_CLASS = 1;
    public static final byte COLOR_BY_OBS_CLASS = 2;
    public static final byte SHAPE_BY_OBS_CLASS = 3;
    public static final byte LAYER_BY_VAR_CLASS = 4;
    private AbstractDataMatrix[] dataMatrix = new AbstractDataMatrix[3];
    public int plotType = -1;
    public String plotName = null;
    public int[] axisPos = new int[]{0, 1, 2, -1};
    public byte createclassby;
    public InnerColumnClass classColumn;
    public int classColumnIndex;
    public int initshape = 0;
    public Color initcolor = null;
    public int ccolortype = -1;
    public int ccolorindex = -1;
    public int initsize = -1;
    public String title;
    public String[] axislable = new String[4];
    public boolean autoCreateLayer = true;
    public Double[][] minmax = new Double[3][2];
    public int description = -1;
    public int spektral_stacked_size = 0;
    public boolean spektral_same_yaxis_range = false;
    public boolean range_plot = false;
    public Dimension dimension = null;
    public boolean dofold = false;
    public boolean rotatefold = false;
    public boolean aspectratio = false;
    public Color selectionColor = null;
    public AbstractModel model = null;
    public String plotSettings = "";
    public boolean supportSecondaryIndex = false;
    public int bins = -1;
    public int axisType = 0;

    public PlotInit(DataTreeInterface dataTreeInterface) {
        super("PlotInit", dataTreeInterface);
        this.setDataTreeInterface(dataTreeInterface);
    }

    public PlotInit(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        for (int i = 0; i < 3; ++i) {
            this.dataMatrix[i] = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "pidM" + i);
        }
        this.axisPos = mapProperty.getPropertyIntArray("apos", this.axisPos);
        this.plotType = mapProperty.getPropertyInt("pitag");
        this.plotName = mapProperty.getPropertyStringUTF("pname");
        this.spektral_stacked_size = mapProperty.getPropertyInt("sps");
        this.range_plot = mapProperty.getPropertyBoolean("rp");
        this.title = mapProperty.getPropertyStringUTF("ptitle");
        this.ccolortype = mapProperty.getPropertyInt("cct", -1);
        this.ccolorindex = mapProperty.getPropertyInt("cci", -1);
        this.dofold = mapProperty.getPropertyBoolean("fd");
        this.initsize = mapProperty.getPropertyInt("is", -1);
        this.plotSettings = mapProperty.getPropertyStringUTF("psettings");
        if (this.plotSettings == null) {
            this.plotSettings = "";
        }
        if (mapProperty.getPropertyBoolean("yc")) {
            this.plotSettings = this.plotSettings + "protectedycalc";
        }
        this.model = (AbstractModel)mapProperty.resolveNodeFromName(randomInputStream, "model");
        this.axisType = mapProperty.getPropertyInt("atype");
    }

    @Override
    public AbstractInit cloneCurrent() {
        int n;
        PlotInit plotInit = new PlotInit(this.dataTreeInterface);
        this.copyInitTo(plotInit);
        plotInit.plotType = this.plotType;
        plotInit.plotName = this.plotName;
        plotInit.createclassby = this.createclassby;
        plotInit.classColumn = this.classColumn;
        plotInit.classColumnIndex = this.classColumnIndex;
        plotInit.initshape = this.initshape;
        plotInit.initcolor = this.initcolor;
        plotInit.ccolortype = this.ccolortype;
        plotInit.ccolorindex = this.ccolorindex;
        plotInit.initsize = this.initsize;
        plotInit.title = this.title;
        plotInit.dofold = this.dofold;
        plotInit.rotatefold = this.rotatefold;
        plotInit.plotSettings = this.plotSettings;
        plotInit.description = this.description;
        plotInit.dataMatrix = (AbstractDataMatrix[])this.dataMatrix.clone();
        for (n = 0; n < this.axisPos.length; ++n) {
            plotInit.axisPos[n] = this.axisPos[n];
            plotInit.axislable[n] = this.axislable[n];
        }
        plotInit.spektral_stacked_size = this.spektral_stacked_size;
        plotInit.spektral_same_yaxis_range = this.spektral_same_yaxis_range;
        plotInit.range_plot = this.range_plot;
        plotInit.autoCreateLayer = this.autoCreateLayer;
        plotInit.axisType = this.axisType;
        if (plotInit.dataTreeInterface instanceof FoldMatrix) {
            plotInit.dataTreeInterface = ((FoldMatrix)plotInit.dataTreeInterface).getReferencedMatrix();
        }
        for (n = 0; n < plotInit.dataMatrix.length; ++n) {
            AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(n);
            if (!(abstractDataMatrix instanceof FoldMatrix)) continue;
            plotInit.setMatrix(n, ((FoldMatrix)abstractDataMatrix).getReferencedMatrix());
        }
        return plotInit;
    }

    public boolean doFold() {
        return this.dofold;
    }

    public AbstractDataInfo getDataInfo(int n) {
        if (this.dataMatrix[0] != null) {
            if (this.dofold) {
                return this.dataMatrix[0].getDataInfo(0);
            }
            return this.dataMatrix[0].getDataInfo(n);
        }
        return null;
    }

    public int getGroupID() {
        if (this.getMatrix(0) instanceof AbstractDataMatrix) {
            return this.getMatrix(0).getGroupID();
        }
        return 0;
    }

    @Override
    public int getInteractiveTag() {
        return this.getPrimaryMatrixTag() | this.getSecondaryMatrixTag();
    }

    public final AbstractDataMatrix getMatrix(int n) {
        if (n >= this.dataMatrix.length || this.dataMatrix[n] == null && n > 0) {
            return this.getMatrix(n - 1);
        }
        return this.dataMatrix[n];
    }

    public int getMatrixTag(boolean bl) {
        if (this.dataTreeInterface instanceof AbstractDataMatrix) {
            return this.getMatrixTagFromMatrix((AbstractDataMatrix)this.dataTreeInterface, bl);
        }
        if (this.dataTreeInterface instanceof AbstractModel) {
            AbstractDataMatrix abstractDataMatrix = this.getMatrix(0);
            if (abstractDataMatrix != null) {
                return this.getMatrixTagFromMatrix(abstractDataMatrix, bl);
            }
            return 3;
        }
        return 1;
    }

    private int getMatrixTagFromMatrix(AbstractDataMatrix abstractDataMatrix, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.plotType == 1;
        if (abstractDataMatrix.isModel() && (abstractDataMatrix.getMatrixTag() & 2) == 0) {
            boolean bl4 = bl2 = !bl2;
        }
        if (bl2) {
            return !bl ? abstractDataMatrix.getColumnType() : abstractDataMatrix.getRowType();
        }
        return !bl ? abstractDataMatrix.getRowType() : abstractDataMatrix.getColumnType();
    }

    public AbstractModel getModel() {
        return this.model;
    }

    public int getPlotIndex() {
        if (this.plotType == 2) {
            return 1;
        }
        return 0;
    }

    public int getPrimaryMatrixTag() {
        return this.getMatrixTag(true);
    }

    public int getSecondaryMatrixTag() {
        return this.getMatrixTag(false);
    }

    public boolean isClassColumnPrediction() {
        if (this.classColumn != null) {
            return this.classColumn.getParent() instanceof PredictionClasses;
        }
        return false;
    }

    public boolean isFoldable() {
        if (this.dataTreeInterface instanceof AbstractDataMatrix) {
            return ((AbstractDataMatrix)this.dataTreeInterface).isFoldable();
        }
        return false;
    }

    public boolean isFoldMatrix() {
        return this.dataTreeInterface instanceof FoldMatrix;
    }

    @Override
    public boolean isRelatedTo(AbstractInit abstractInit) {
        block5: {
            block4: {
                if (this.dataMatrix == null) {
                    return false;
                }
                if (!(abstractInit instanceof DataInit)) break block4;
                DataInit dataInit = (DataInit)abstractInit;
                for (int i = 0; i < 3; ++i) {
                    if (this.dataMatrix[i] == null || !this.dataMatrix[i].isRelatedTo(dataInit.getDataTreeInterface())) continue;
                    return true;
                }
                break block5;
            }
            if (!(abstractInit instanceof PlotInit)) break block5;
            PlotInit plotInit = (PlotInit)abstractInit;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.dataMatrix[i] == null || plotInit.dataMatrix[j] == null || !this.dataMatrix[i].isRelatedTo(plotInit.dataMatrix[j])) continue;
                    return true;
                }
            }
        }
        return super.isRelatedTo(abstractInit);
    }

    public boolean isSecondaryMatrixTagObsVar() {
        int n = this.getSecondaryMatrixTag();
        return (n & 1) > 0 || (n & 2) > 0;
    }

    public boolean rotateFold() {
        return this.rotatefold;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        for (int i = 0; i < 3; ++i) {
            randomOutputStream.writePropertyNode("pidM" + i, this.dataMatrix[i]);
        }
        randomOutputStream.writePropertyIntArray("apos", this.axisPos);
        randomOutputStream.writePropertyInt("pitag", this.plotType);
        randomOutputStream.writePropertyStringUTF("pname", this.plotName);
        randomOutputStream.writePropertyInt("sps", this.spektral_stacked_size);
        randomOutputStream.writePropertyBoolean("rp", this.range_plot);
        randomOutputStream.writePropertyStringUTF("ptitle", this.title);
        randomOutputStream.writePropertyInt("cct", this.ccolortype);
        randomOutputStream.writePropertyInt("cci", this.ccolorindex);
        randomOutputStream.writePropertyBoolean("fd", this.dofold);
        randomOutputStream.writePropertyInt("is", this.initsize);
        randomOutputStream.writePropertyStringUTF("psettings", this.plotSettings);
        randomOutputStream.writePropertyNode("model", this.model);
        randomOutputStream.writePropertyInt("atype", this.axisType);
    }

    public void setAllMatrix(AbstractDataMatrix abstractDataMatrix) {
        if (this.dataMatrix == null) {
            this.dataMatrix = new AbstractDataMatrix[3];
        }
        this.dataMatrix[0] = abstractDataMatrix;
        this.dataMatrix[1] = abstractDataMatrix;
        this.dataMatrix[2] = abstractDataMatrix;
    }

    @Override
    public void setDataTreeInterface(DataTreeInterface dataTreeInterface) {
        super.setDataTreeInterface(dataTreeInterface);
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            this.setAllMatrix(abstractDataMatrix);
            if (this.plotType < 0) {
                this.plotType = abstractDataMatrix instanceof MVmatrix && abstractDataMatrix.getRowType() == 2 || (abstractDataMatrix.getMatrixTag() & 1) == 1 ? 1 : 2;
            }
        }
    }

    public final void setMatrix(int n, AbstractDataMatrix abstractDataMatrix) {
        this.dataMatrix[n] = abstractDataMatrix;
    }

    public void setModel(AbstractModel abstractModel) {
        this.model = abstractModel;
    }

    public void setStartAxis(int n) {
        int n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            this.axisPos[n3] = this.axisPos[n3] - n;
        }
    }

    public int getReduce() {
        Case case_;
        AbstractDataMatrix abstractDataMatrix = this.getMatrix(0);
        if (abstractDataMatrix != null && (case_ = abstractDataMatrix.getCase()) != null) {
            return case_.getReduce();
        }
        return 1;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        Arrays.fill(this.dataMatrix, null);
        this.dataMatrix = null;
        this.classColumn = null;
    }
}

