/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import se.prediktera.map.com.bitmap.BmpEncoder;
import se.prediktera.map.com.gif.GifEncoder;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.ImgSel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.ResolutionDialog;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class PlotPopupMenu
extends CleanUpClass
implements ClipboardOwner {
    private AbstractPlot panel;

    private static void saveFailed(File file) {
        JOptionPane.showMessageDialog(Main_GUI.get(), "Failed to save " + file.getAbsolutePath() + "\nPlease check file write permission or the chosen save path.", "Failed to save file", 0);
    }

    public PlotPopupMenu(AbstractPlot abstractPlot) {
        this.panel = abstractPlot;
    }

    public void addToWindowPopup(final AbstractPlot abstractPlot, JPopupMenu jPopupMenu) {
        Object object;
        CleanUpInterface cleanUpInterface;
        if (this.panel instanceof AbstractPlotLayout) {
            cleanUpInterface = this.panel.getPlotInit();
            object = ((AbstractInit)cleanUpInterface).getDataTreeInterface();
            final String string = EvinceScriptCommands.removeSpace(((PlotInit)cleanUpInterface).plotName);
            CMenu cMenu = new CMenu("Apply Template", true);
            ScriptManager.addScriptToMenu(cMenu, this.panel, (DataTreeInterface)object, "plot", string);
            jPopupMenu.add(cMenu);
            CMenuItem cMenuItem = new CMenuItem(this, "Save As Template", true){
                final /* synthetic */ PlotPopupMenu this$0;
                {
                    this.this$0 = plotPopupMenu;
                    super(string3, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string2 = JOptionPane.showInputDialog(this.this$0.panel, (Object)"Enter template name:");
                    if (string2 != null && string2.length() > 0) {
                        ScriptFile scriptFile = new ScriptFile();
                        scriptFile.setName(string2);
                        scriptFile.setScriptInfo("Plot Template");
                        scriptFile.setType("plot");
                        scriptFile.setSubType(string);
                        scriptFile.setScript(((AbstractPlotLayout)this.this$0.panel).getMainWindow().getScript(true));
                        ScriptManager.saveScriptFile(scriptFile);
                    }
                }
            };
            jPopupMenu.add(cMenuItem);
            jPopupMenu.addSeparator();
        }
        cleanUpInterface = new CMenuItem("Copy Plot to Clipboard", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolutionDialog resolutionDialog = new ResolutionDialog(PlotPopupMenu.this.panel.getWidth(), PlotPopupMenu.this.panel.getHeight(), "Copy");
                if (resolutionDialog.showModal()) {
                    BufferedImage bufferedImage = PlotPopupMenu.this.panel.makeBufferedImageScreenShot(resolutionDialog.getResolutionWidth(), resolutionDialog.getResolutionHeight(), resolutionDialog.isIncludeSelection());
                    PlotPopupMenu.copyToClipboard(bufferedImage);
                }
            }
        };
        ((JMenuItem)((Object)cleanUpInterface)).setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jPopupMenu.add((JMenuItem)((Object)cleanUpInterface));
        object = new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png"));
        jPopupMenu.add(new CMenuItem(this, "Save As...", (ImageIcon)object){
            final /* synthetic */ PlotPopupMenu this$0;
            {
                this.this$0 = plotPopupMenu;
                super(string, imageIcon);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotPopupMenu.showSaveDialog(abstractPlot, null);
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new CMenuItem("Properties", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotPopupMenu.this.panel.showProperties();
            }
        });
    }

    @Override
    public void cleanUpChild() {
        this.panel = null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void copyToClipboard(AbstractPlot abstractPlot) {
        PlotPopupMenu.copyToClipboard(abstractPlot.makeBufferedImageScreenShot(abstractPlot.getWidth(), abstractPlot.getHeight(), true));
    }

    public static void copyToClipboard(ImageSaveCallback imageSaveCallback, int n, int n2, boolean bl) {
        PlotPopupMenu.copyToClipboard(imageSaveCallback.makeBufferedImageScreenShot(n, n2, bl));
    }

    public static void copyToClipboard(BufferedImage bufferedImage) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ImgSel(bufferedImage), null);
    }

    public static void showSaveDialog(final AbstractPlot abstractPlot, String string) {
        PlotPopupMenu.showSaveDialog(IniManager.getMainFrame(), string, abstractPlot.supportSVG(), abstractPlot.getWidth(), abstractPlot.getHeight(), true, new ImageSaveCallback(){

            @Override
            public void saveSVG(File file) {
                PlotPopupMenu.saveSVG(abstractPlot.makeSVGScreenShot(), file);
            }

            @Override
            public BufferedImage makeBufferedImageScreenShot(int n, int n2, boolean bl) {
                return abstractPlot.makeBufferedImageScreenShot(n, n2, bl);
            }
        });
    }

    public static void showSaveDialog(Frame frame, String string, boolean bl, int n, int n2, boolean bl2, ImageSaveCallback imageSaveCallback) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save image", IniManager.getMainFrame());
        jopensaveDialog2.addExtension("png", "PNG Image (*.png)");
        jopensaveDialog2.addExtension("jpg", "JPEG Image (*.jpg)");
        if (bl) {
            jopensaveDialog2.addExtension("svg", "Scalable Vector Graphics (*.svg)");
        }
        jopensaveDialog2.addExtension("tiff", "TIFF Image (*.tiff)");
        jopensaveDialog2.addExtension("gif", "GIF Image (*.gif)");
        jopensaveDialog2.setCurrentDirectory(IniManager.getWorkDir((byte)2));
        if (string != null) {
            jopensaveDialog2.setSelectedFile(new File(string));
        }
        ResolutionDialog.ResolutionPanel resolutionPanel = null;
        if (bl2) {
            resolutionPanel = new ResolutionDialog.ResolutionPanel(n, n2);
            jopensaveDialog2.setPreview(resolutionPanel, false);
        }
        if (jopensaveDialog2.saveshow()) {
            IniManager.setWorkDir((byte)2, jopensaveDialog2.getCurrentDirectory());
            File file = jopensaveDialog2.getSelectedFile();
            jopensaveDialog2.setCurrentDirectory(IniManager.getWorkDir((byte)2));
            ExtensionFilter extensionFilter = (ExtensionFilter)jopensaveDialog2.getFileFilter();
            String string2 = extensionFilter.getExtension(0);
            if ("svg".equals(string2)) {
                imageSaveCallback.saveSVG(file);
            } else if (resolutionPanel != null) {
                PlotPopupMenu.save(imageSaveCallback.makeBufferedImageScreenShot(resolutionPanel.getResolutionWidth(), resolutionPanel.getResolutionHeight(), resolutionPanel.isIncludeSelection()), file, string2);
            } else {
                PlotPopupMenu.save(imageSaveCallback.makeBufferedImageScreenShot(n, n2, true), file, string2);
            }
        }
    }

    public static void save(BufferedImage bufferedImage, File file, String string) {
        if ("jpg".equals(string)) {
            PlotPopupMenu.saveJPEG(bufferedImage, file);
        } else if ("tiff".equals(string)) {
            PlotPopupMenu.saveTIFF(bufferedImage, file);
        } else if ("png".equals(string)) {
            PlotPopupMenu.savePNG(bufferedImage, file);
        } else if ("gif".equals(string)) {
            PlotPopupMenu.saveGIF(bufferedImage, file);
        }
    }

    public static void saveBMP(Image image, File file) {
        try {
            BmpEncoder bmpEncoder = new BmpEncoder();
            bmpEncoder.saveBitmap(file, image, 578, 458);
        }
        catch (IOException iOException) {
            PlotPopupMenu.saveFailed(file);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public static void saveGIF(BufferedImage bufferedImage, File file) {
        try {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 13);
            Graphics graphics = bufferedImage2.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            graphics.dispose();
            GifEncoder gifEncoder = new GifEncoder(bufferedImage2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            gifEncoder.Write(fileOutputStream);
            fileOutputStream.close();
        }
        catch (GifEncoder.ColorException colorException) {
            JOptionPane.showMessageDialog(IniManager.getMainFrame(), "The plot contains too many colors for this format! A GIF can only contain 256 colors.", colorException.getMessage(), 0);
        }
        catch (IOException iOException) {
            PlotPopupMenu.saveFailed(file);
        }
        catch (AWTException aWTException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(aWTException);
        }
    }

    public static void saveJPEG(BufferedImage bufferedImage, File file) {
        try {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), Color.WHITE, null);
            graphics2D.dispose();
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(1.0f);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("jpg");
            ImageWriter imageWriter = iterator.next();
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
            imageWriter.setOutput(fileImageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage2, null, null), jPEGImageWriteParam);
            imageWriter.dispose();
            fileImageOutputStream.close();
        }
        catch (IOException iOException) {
            PlotPopupMenu.saveFailed(file);
        }
    }

    public static void savePNG(BufferedImage bufferedImage, File file) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            PlotPopupMenu.saveFailed(file);
        }
    }

    public static void saveSVG(SVGGraphics2D sVGGraphics2D, File file) {
        try {
            String string = System.getProperty("useCss", "true");
            boolean bl = string.equalsIgnoreCase("true");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            sVGGraphics2D.stream((Writer)outputStreamWriter, bl);
            fileOutputStream.close();
        }
        catch (UnsupportedEncodingException | SVGGraphics2DIOException throwable) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(throwable);
        }
        catch (IOException iOException) {
            PlotPopupMenu.saveFailed(file);
        }
    }

    public static void saveTIFF(BufferedImage bufferedImage, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TIFFTranscoder tIFFTranscoder = new TIFFTranscoder();
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
            tIFFTranscoder.writeImage(bufferedImage, transcoderOutput);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            PlotPopupMenu.saveFailed(file);
        }
        catch (TranscoderException transcoderException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(transcoderException);
        }
    }

    public static void printImage(AbstractPlotLayout abstractPlotLayout) {
        PlotPopupMenu.printImage(abstractPlotLayout.makeBufferedImageScreenShot(abstractPlotLayout.getWidth(), abstractPlotLayout.getHeight(), true));
    }

    public static void printImage(BufferedImage bufferedImage) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(UpdateHelper.Product.getFullname());
        printerJob.setPrintable(new ImagePrinter(bufferedImage));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Logg.error("Printing error", printerException);
            }
        }
    }

    public static interface ImageSaveCallback {
        public void saveSVG(File var1);

        public BufferedImage makeBufferedImageScreenShot(int var1, int var2, boolean var3);
    }

    public static class ImagePrinter
    implements Printable {
        private final BufferedImage image;

        public ImagePrinter(BufferedImage bufferedImage) {
            this.image = bufferedImage;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n != 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double d2 = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            double d3 = Math.min(d, d2);
            int n2 = (int)((double)this.image.getWidth() * d3);
            int n3 = (int)((double)this.image.getHeight() * d3);
            double d4 = pageFormat.getImageableX() + (pageFormat.getImageableWidth() - (double)n2) / 2.0;
            double d5 = pageFormat.getImageableY() + (pageFormat.getImageableHeight() - (double)n3) / 2.0;
            graphics2D.drawImage(this.image, (int)d4, (int)d5, n2, n3, null);
            return 0;
        }
    }
}

