/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.Component;
import java.util.List;
import javax.help.CSH;
import se.prediktera.map.common.AbstractPanelInfo;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.selection.AbstractSelectionDialog;
import se.prediktera.map.data.datasettable.BorderSelectionPage;
import se.prediktera.map.data.datasettable.RepresentativeSelectionPage;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2D;

public class PlotSelectionDialog
extends AbstractSelectionDialog {
    private RepresentativeSelectionPage representativeSelectionPage;
    private BorderSelectionPage borderSelectionPage;

    public PlotSelectionDialog(AbstractPlot abstractPlot) {
        super(abstractPlot);
        try {
            DataSet dataSet = this.getDataSet(abstractPlot);
            DataTreeInterface dataTreeInterface = abstractPlot.getPlotInit().getDataTreeInterface();
            if (dataSet != null && dataTreeInterface != null && dataTreeInterface.toString().equals("T")) {
                this.representativeSelectionPage = new RepresentativeSelectionPage(abstractPlot, dataSet, this.getModel(abstractPlot));
                this.addTab("By Model", this.representativeSelectionPage);
            }
            if (abstractPlot instanceof Contour2D || abstractPlot.hasDefaultTitle("RGB Image")) {
                this.borderSelectionPage = new BorderSelectionPage(abstractPlot, dataSet);
                this.addTab("By Border Pixels", this.borderSelectionPage);
            }
            this.addExternTabs(abstractPlot);
            this.pack();
            this.setLocationRelativeTo(null);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        CSH.setHelpIDString((Component)this, (String)"evincePlotselections");
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.representativeSelectionPage != null) {
            this.representativeSelectionPage.cleanUp();
            this.representativeSelectionPage = null;
        }
        if (this.borderSelectionPage != null) {
            this.borderSelectionPage.cleanUp();
            this.borderSelectionPage = null;
        }
    }

    private void addExternTabs(AbstractPlot abstractPlot) {
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.PANEL_INFO);
        for (AbstractInfo abstractInfo : list) {
            AbstractPanelInfo abstractPanelInfo = (AbstractPanelInfo)abstractInfo;
            if (abstractPanelInfo.getType() != 0 || !abstractPanelInfo.supportObject(abstractPlot)) continue;
            this.addTab(abstractPanelInfo.toString(), abstractPanelInfo.createPanel(abstractPlot));
        }
    }
}

