/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.IniManager;

public class ResolutionDialog
extends CleanUpDialog {
    private boolean modalresult = false;
    private final JButton buttonContinue = new JButton();
    private final ResolutionPanel resolutionPanel;

    public ResolutionDialog(int n, int n2, String string) {
        this(IniManager.getMainFrame(), n, n2, string);
    }

    public ResolutionDialog(Frame frame, int n, int n2, String string) {
        super(frame, "Image properties", true);
        this.resolutionPanel = new ResolutionPanel(n, n2);
        JButton jButton = new JButton("Cancel");
        jButton.setPreferredSize(new Dimension(79, 27));
        jButton.setMnemonic('C');
        jButton.addActionListener(actionEvent -> {
            this.modalresult = false;
            this.dispose();
        });
        this.buttonContinue.setText(string);
        this.buttonContinue.setPreferredSize(new Dimension(79, 27));
        this.buttonContinue.setMargin(new Insets(2, 2, 2, 2));
        this.buttonContinue.setMnemonic('S');
        this.buttonContinue.addActionListener(actionEvent -> {
            this.modalresult = true;
            this.dispose();
        });
        FlowLayout flowLayout = new FlowLayout();
        JPanel jPanel = new JPanel(flowLayout);
        flowLayout.setAlignment(2);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonContinue, null);
        jPanel.add((Component)jButton, null);
        jPanel2.add((Component)this.resolutionPanel, "North");
        jPanel2.add((Component)jPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public boolean showModal() {
        this.buttonContinue.requestFocus();
        super.setVisible(true);
        return this.modalresult;
    }

    public int getResolutionHeight() {
        return this.resolutionPanel.getResolutionHeight();
    }

    public int getResolutionWidth() {
        return this.resolutionPanel.getResolutionWidth();
    }

    public boolean isIncludeSelection() {
        return this.resolutionPanel.isIncludeSelection();
    }

    @Override
    protected void cleanUpChild() {
    }

    public static void main(String[] stringArray) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog();
        jopensaveDialog2.setPreview(new ResolutionPanel(0, 0), false);
        jopensaveDialog2.openshow();
    }

    public static class ResolutionPanel
    extends CleanUpPanel
    implements PreviewInterface {
        private final JSlider resolutionSlider = new JSlider();
        private final ManualPanel manualPanel = new ManualPanel();
        private final JCheckBox includeSelection = new JCheckBox("Include selection", true);
        private final int imageWidth;
        private final int imageHeight;

        public ResolutionPanel(int n, int n2) {
            super(new BorderLayout());
            this.imageWidth = n;
            this.imageHeight = n2;
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            ((Dictionary)hashtable).put(0, new JLabel("Low (Screen size)"));
            ((Dictionary)hashtable).put(1, new JLabel("Medium"));
            ((Dictionary)hashtable).put(2, new JLabel("High"));
            this.resolutionSlider.setPreferredSize(new Dimension(250, 50));
            this.resolutionSlider.setMajorTickSpacing(1);
            this.resolutionSlider.setMaximum(2);
            this.resolutionSlider.setPaintLabels(true);
            this.resolutionSlider.setPaintTicks(true);
            this.resolutionSlider.setLabelTable(hashtable);
            this.resolutionSlider.setValue(0);
            this.resolutionSlider.addChangeListener(changeEvent -> this.manualPanel.initSize());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder("Image Resolution Options"));
            this.add((Component)jPanel, "North");
            if (n > 0) {
                this.add((Component)this.manualPanel, "Center");
            }
            this.add((Component)this.includeSelection, "South");
            jPanel.add((Component)this.resolutionSlider, "Center");
            this.manualPanel.initSize();
        }

        @Override
        protected void cleanUpChild() {
        }

        public int getResolution() {
            return this.resolutionSlider.getValue() + 1;
        }

        public int getResolutionHeight() {
            return this.manualPanel.getImageHeight();
        }

        public int getResolutionWidth() {
            return this.manualPanel.getImageWidth();
        }

        public boolean isIncludeSelection() {
            return this.includeSelection.isSelected();
        }

        private int getResolutionValue() {
            return this.resolutionSlider.getValue() * 2 + 1;
        }

        @Override
        public void configure(File file) {
        }

        private class ManualPanel
        extends JPanel {
            private JCheckBox constrainCheckBox;
            private JValidateNumberField heightTextfield;
            private JValidateNumberField widthTextfield;
            private JCheckBox manualCheckBox;
            private double wDivH;
            private double hDivW;

            public ManualPanel() {
                super(new GridBagLayout());
                this.wDivH = 1.0;
                this.hDivW = 1.0;
                this.initComponents();
            }

            public int getImageHeight() {
                try {
                    return Integer.parseInt(this.heightTextfield.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return (int)this.heightTextfield.getNumber();
                }
            }

            public int getImageWidth() {
                try {
                    return Integer.parseInt(this.widthTextfield.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return (int)this.widthTextfield.getNumber();
                }
            }

            public final void initSize() {
                double d = ResolutionPanel.this.imageWidth;
                double d2 = ResolutionPanel.this.imageHeight;
                if (d2 > 0.0) {
                    this.wDivH = d / d2;
                }
                if (d > 0.0) {
                    this.hDivW = d2 / d;
                }
                this.widthTextfield.setNumber(d * (double)ResolutionPanel.this.getResolutionValue());
                this.heightTextfield.setNumber(d2 * (double)ResolutionPanel.this.getResolutionValue());
            }

            private void initComponents() {
                this.manualCheckBox = new JCheckBox("Use manual size");
                this.manualCheckBox.addItemListener(itemEvent -> {
                    this.widthTextfield.setEnabled(this.manualCheckBox.isSelected());
                    this.heightTextfield.setEnabled(this.manualCheckBox.isSelected());
                    this.constrainCheckBox.setEnabled(this.manualCheckBox.isSelected());
                    ResolutionPanel.this.resolutionSlider.setEnabled(!this.manualCheckBox.isSelected());
                    if (!this.manualCheckBox.isSelected()) {
                        this.initSize();
                    }
                });
                this.widthTextfield = new JValidateNumberField(1.0, 2.147483647E9, false);
                ProportionListener proportionListener = new ProportionListener();
                this.widthTextfield.getDocument().addDocumentListener(proportionListener);
                this.widthTextfield.setEnabled(false);
                this.heightTextfield = new JValidateNumberField(1.0, 2.147483647E9, false);
                this.heightTextfield.getDocument().addDocumentListener(proportionListener);
                this.heightTextfield.setEnabled(false);
                this.constrainCheckBox = new JCheckBox();
                this.constrainCheckBox.setSelected(true);
                this.constrainCheckBox.setEnabled(false);
                this.constrainCheckBox.addItemListener(itemEvent -> {
                    this.wDivH = this.widthTextfield.getNumber() / this.heightTextfield.getNumber();
                    this.hDivW = this.heightTextfield.getNumber() / this.widthTextfield.getNumber();
                });
                this.setBorder(BorderFactory.createTitledBorder("Manual Image Size"));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)this.manualCheckBox, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)new JLabel("Width:"), gridBagConstraints);
                this.widthTextfield.setMinimumSize(new Dimension(80, 19));
                this.widthTextfield.setPreferredSize(new Dimension(80, 19));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)this.widthTextfield, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)new JLabel("pixels"), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)new JLabel("Height"), gridBagConstraints);
                this.heightTextfield.setMinimumSize(new Dimension(80, 19));
                this.heightTextfield.setPreferredSize(new Dimension(80, 19));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)this.heightTextfield, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)new JLabel("pixels"), gridBagConstraints);
                this.constrainCheckBox.setText("Constrain Proportions");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                this.add((Component)this.constrainCheckBox, gridBagConstraints);
            }

            private class ProportionListener
            implements DocumentListener {
                private boolean writelock = false;

                private ProportionListener() {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.proportionChanged(documentEvent);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.proportionChanged(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.proportionChanged(documentEvent);
                }

                private void proportionChanged(DocumentEvent documentEvent) {
                    if (ManualPanel.this.constrainCheckBox.isSelected() && !this.writelock) {
                        this.writelock = true;
                        if (documentEvent.getDocument().equals(ManualPanel.this.widthTextfield.getDocument())) {
                            ManualPanel.this.heightTextfield.setNumber(ManualPanel.this.widthTextfield.getNumber() * ManualPanel.this.hDivW);
                        } else {
                            ManualPanel.this.widthTextfield.setNumber(ManualPanel.this.heightTextfield.getNumber() * ManualPanel.this.wDivH);
                        }
                        this.writelock = false;
                    }
                }
            }
        }
    }
}

