/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.StringFun;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.scatter.ScatterLayer;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.ZoneSurface;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;
import se.prediktera.map.plot.axisplot.settings.ComboBoxStatistics;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.map.plot.axisplot.windows.LegendHolderInterface;
import se.prediktera.map.plot.axisplot.windows.LegendInterface;

public abstract class AbstractAxisLayer
extends AbstractLayer
implements SettingsBoxInterface,
LegendHolderInterface,
DataMatrixListener {
    protected static final int BY_INSETS = 0;
    protected static final int C_INSETS = 1;
    private static boolean isSynchingMainLayer = false;
    protected Map<Byte, AbstractPlotSettingsBox> settingsBoxMap = new HashMap<Byte, AbstractPlotSettingsBox>();
    protected LeafList zoneList = null;
    protected ComboBoxColor boxColor;
    protected ComboBoxComment boxComment;
    protected ComboBoxStatistics boxStatistics;
    private final boolean issublayer;
    protected AbstractAxisPlot axisPlot;
    protected AbstractDataInfo[] dataInfo = new AbstractDataInfo[2];
    private int[] primaryIndexArray = null;
    private AbstractPlotSettingsBox[] axisBoxes = null;
    private PlotInit localPlotInit;
    private int latestAxisEventId = -1;
    private boolean markNoneWhiteAreas;
    private boolean interaction = true;
    private boolean showLayerDescription = true;

    public AbstractAxisLayer(PlotInit plotInit, AbstractAxisPlot abstractAxisPlot, LeafList leafList, LeafList leafList2, int n) {
        super(n);
        this.localPlotInit = plotInit;
        this.zoneList = leafList;
        this.axisPlot = abstractAxisPlot;
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            if (!(abstractDataMatrix instanceof FoldMatrix) && plotInit.isFoldable() && plotInit.doFold()) {
                abstractDataMatrix = new FoldMatrix(abstractDataMatrix, plotInit.rotateFold());
                int n2 = plotInit.plotType;
                plotInit.setDataTreeInterface(abstractDataMatrix);
                plotInit.plotType = n2;
            }
            if (abstractDataMatrix instanceof FoldMatrix) {
                this.addTreeNode(abstractDataMatrix);
            }
            abstractDataMatrix.addDataTreeChangeListener(this);
        }
        this.init();
        boolean bl = this.issublayer = leafList2 != null;
        if (this.issublayer) {
            this.includePoints(leafList2, null);
        }
        this.InitLayer();
    }

    public AbstractAxisLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (randomInputStream.getSaveVersion() != 90L) {
            this.localPlotInit = new PlotInit(randomInputStream, mapProperty);
        }
        this.issublayer = mapProperty.getPropertyBoolean("isub", false);
        this.axisPlot = (AbstractAxisPlot)mapProperty.resolveNodeFromName(randomInputStream, "axisPlot");
        this.InitLayer();
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
            mapProperty.setPrefix(String.valueOf(abstractPlotSettingsBox.getType()));
            abstractPlotSettingsBox.LoadProperty(randomInputStream, mapProperty);
        }
        mapProperty.setPrefix("");
    }

    public AbstractAxisLayer addSubLayer(String string, LeafList leafList) {
        return this.moveIntoNewLayer(leafList, string, true);
    }

    @Override
    public void beginCalculations() {
        AbstractPlotSettingsBox abstractPlotSettingsBox;
        AbstractPlotSettingsBox abstractPlotSettingsBox2;
        AbstractPlotSettingsBox abstractPlotSettingsBox3 = this.settingsBoxMap.get((byte)0);
        if (abstractPlotSettingsBox3 != null) {
            abstractPlotSettingsBox3.getMatrix().beginCalculations();
        }
        if ((abstractPlotSettingsBox2 = this.settingsBoxMap.get((byte)1)) != null) {
            abstractPlotSettingsBox2.getMatrix().beginCalculations();
        }
        if ((abstractPlotSettingsBox = this.settingsBoxMap.get((byte)9)) != null) {
            abstractPlotSettingsBox.getMatrix().beginCalculations();
        }
    }

    public AbstractDensityField calcDensity() {
        return null;
    }

    public void collectLegendBoxes(JComboBox jComboBox) {
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
            if (!(abstractPlotSettingsBox instanceof LegendInterface)) continue;
            jComboBox.addItem(abstractPlotSettingsBox);
        }
    }

    public void collectLegendInterface(JPopupMenu jPopupMenu) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get((byte)3);
        if (abstractPlotSettingsBox != null) {
            int n = 1;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.layerNode.getParent();
            if (defaultMutableTreeNode != null) {
                n = defaultMutableTreeNode.getIndex(this.layerNode) + 1;
            }
            CMenuItem cMenuItem = new CMenuItem("Layer " + n + " (" + String.valueOf(this) + ")", false);
            cMenuItem.setObject(abstractPlotSettingsBox);
            jPopupMenu.add((Component)cMenuItem, false);
        }
    }

    public void collectLegendLayers(JComboBox jComboBox) {
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
            if (!(abstractPlotSettingsBox instanceof LegendInterface)) continue;
            jComboBox.addItem(this);
            return;
        }
    }

    @Override
    public void copySettingsFrom(AbstractLayer abstractLayer) {
        if (abstractLayer instanceof AbstractAxisLayer) {
            AbstractAxisLayer abstractAxisLayer = (AbstractAxisLayer)abstractLayer;
            for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
                AbstractPlotSettingsBox abstractPlotSettingsBox2 = abstractAxisLayer.settingsBoxMap.get(abstractPlotSettingsBox.getType());
                if (abstractPlotSettingsBox2 != null) {
                    abstractPlotSettingsBox.copySettingsFrom(abstractPlotSettingsBox2);
                    continue;
                }
                if (!(abstractPlotSettingsBox instanceof ComboBoxAxis)) continue;
                ((ComboBoxAxis)abstractPlotSettingsBox).setSelectedChild();
            }
        }
    }

    public final List<ZoneLeaf> createRootLeaf(int n) {
        int n2;
        int n3;
        int n4;
        if (n >= 0 && n == this.latestAxisEventId) {
            return this.getRootList();
        }
        this.latestAxisEventId = n;
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[3];
            this.axisBoxes[0] = this.settingsBoxMap.get((byte)0);
            this.axisBoxes[1] = this.settingsBoxMap.get((byte)1);
            this.axisBoxes[2] = this.settingsBoxMap.get((byte)2);
        }
        ComboBoxAxis comboBoxAxis = null;
        boolean bl = this.axisBoxes[0] instanceof ComboBoxAxis;
        boolean bl2 = this.axisBoxes[1] instanceof ComboBoxAxis;
        boolean bl3 = this.axisBoxes[2] instanceof ComboBoxAxis;
        if (bl) {
            comboBoxAxis = (ComboBoxAxis)this.axisBoxes[0];
        } else if (bl2) {
            comboBoxAxis = (ComboBoxAxis)this.axisBoxes[1];
        } else if (bl3) {
            comboBoxAxis = (ComboBoxAxis)this.axisBoxes[2];
        } else {
            return new LinkedList<ZoneLeaf>();
        }
        int n5 = comboBoxAxis.getMinIndex();
        int n6 = comboBoxAxis.getMaxIndex();
        ComboBoxAxis comboBoxAxis2 = null;
        ComboBoxAxis comboBoxAxis3 = null;
        if (bl2) {
            comboBoxAxis2 = (ComboBoxAxis)this.axisBoxes[1];
            if (comboBoxAxis2.getMinIndex() > n5) {
                n5 = comboBoxAxis2.getMinIndex();
            }
            if (comboBoxAxis2.getMaxIndex() < n6) {
                n6 = comboBoxAxis2.getMaxIndex();
            }
        }
        if (bl3) {
            comboBoxAxis3 = (ComboBoxAxis)this.axisBoxes[2];
            if (comboBoxAxis3.getMinIndex() > n5) {
                n5 = comboBoxAxis3.getMinIndex();
            }
            if (comboBoxAxis3.getMaxIndex() < n6) {
                n6 = comboBoxAxis3.getMaxIndex();
            }
        }
        if (n5 > n6 || bl && !comboBoxAxis.isCreated() || bl2 && !comboBoxAxis2.isCreated() || bl3 && !comboBoxAxis3.isCreated()) {
            this.zoneList = null;
            return new LinkedList<ZoneLeaf>();
        }
        AbstractDataMatrix abstractDataMatrix = bl ? comboBoxAxis.getMatrix() : null;
        AbstractDataMatrix abstractDataMatrix2 = bl2 ? comboBoxAxis2.getMatrix() : abstractDataMatrix;
        AbstractDataMatrix abstractDataMatrix3 = bl3 ? comboBoxAxis3.getMatrix() : abstractDataMatrix2;
        boolean bl4 = !bl || comboBoxAxis.getObservationTag();
        boolean bl5 = bl2 ? comboBoxAxis2.getObservationTag() : bl4;
        boolean bl6 = bl3 ? comboBoxAxis3.getObservationTag() : bl5;
        boolean bl7 = abstractDataMatrix == abstractDataMatrix2 && abstractDataMatrix2 == abstractDataMatrix3 && bl4 == bl5 && bl5 == bl6;
        LeafList leafList = this.zoneList;
        this.zoneList = null;
        if (leafList == null || this.hasMissing(abstractDataMatrix) || this.hasMissing(abstractDataMatrix2) || this.hasMissing(abstractDataMatrix3)) {
            leafList = new LeafList(n6 - n5 + 1);
        }
        boolean bl8 = false;
        if (bl7) {
            n4 = 0;
            for (n3 = 0; n3 < leafList.size(); ++n3) {
                int n7;
                var21_21 = (ZoneLeaf)leafList.get(n3);
                int n8 = var21_21.getPrimaryIndex();
                int n9 = n7 = bl4 ? abstractDataMatrix3.getNrefOrig(n8) : abstractDataMatrix3.getKrefOrig(n8);
                if (!(bl && this.isMissing(comboBoxAxis, n7, var21_21) || bl2 && this.isMissing(comboBoxAxis2, n7, var21_21)) && (!bl3 || !this.isMissing(comboBoxAxis3, n7, var21_21))) continue;
                leafList.set(n3, null);
                bl8 = true;
                if (++n4 <= 500) continue;
                leafList.clear();
                bl8 = false;
                break;
            }
        } else {
            n4 = 0;
            for (n3 = 0; n3 < leafList.size(); ++n3) {
                var21_21 = (ZoneLeaf)leafList.get(n3);
                if (!(bl && this.isMissing(comboBoxAxis, var21_21) || bl2 && this.isMissing(comboBoxAxis2, var21_21)) && (!bl3 || !this.isMissing(comboBoxAxis3, var21_21))) continue;
                leafList.set(n3, null);
                bl8 = true;
                if (++n4 <= 500) continue;
                leafList.clear();
                bl8 = false;
                break;
            }
        }
        n4 = -1;
        n3 = 0;
        for (n2 = n5; n2 <= n6; ++n2) {
            ZoneLeaf zoneLeaf;
            if (n4 < 0 && n3 < leafList.size() && (zoneLeaf = (ZoneLeaf)leafList.get(n3)) == null) {
                n4 = n3++;
                while (n3 < leafList.size() && leafList.get(n3) == null) {
                    ++n3;
                }
            }
            if (bl && this.isMissing(comboBoxAxis, n2) || bl2 && this.isMissing(comboBoxAxis2, n2) || bl3 && this.isMissing(comboBoxAxis3, n2)) continue;
            if (n3 < leafList.size()) {
                ZoneLeaf zoneLeaf2;
                if ((zoneLeaf2 = (ZoneLeaf)leafList.get(n3++)) == null || n2 == zoneLeaf2.getPrimaryIndex()) {
                    n4 = -1;
                    continue;
                }
                if (n2 < zoneLeaf2.getPrimaryIndex()) {
                    ZoneLeaf zoneLeaf3 = comboBoxAxis.newLeaf(n2);
                    this.initLeaf(zoneLeaf3);
                    if (n4 < 0) {
                        leafList.add(n3 - 1, zoneLeaf3);
                        continue;
                    }
                    leafList.set(n4, zoneLeaf3);
                    if (++n4 < leafList.size() && leafList.get(n4) == null) continue;
                    n4 = -1;
                    continue;
                }
                n4 = -1;
                continue;
            }
            ZoneLeaf zoneLeaf4 = comboBoxAxis.newLeaf(n2);
            this.initLeaf(zoneLeaf4);
            if (n4 < 0) {
                leafList.add(zoneLeaf4);
                ++n3;
                continue;
            }
            leafList.set(n4, zoneLeaf4);
            if (++n4 < leafList.size() && leafList.get(n4) == null) continue;
            n4 = -1;
        }
        if (bl8) {
            for (n2 = leafList.size() - 1; n2 >= 0; --n2) {
                if (leafList.get(n2) != null) continue;
                leafList.remove(n2);
            }
        }
        this.setZoneList(leafList);
        this.setAxisRange();
        if (this.zoneList != null) {
            return this.zoneList;
        }
        return null;
    }

    private boolean hasMissing(AbstractDataMatrix abstractDataMatrix) {
        return abstractDataMatrix != null && abstractDataMatrix.hasMissing();
    }

    public abstract AbstractAxisLayer createSubLayer(LeafList var1, int var2, PlotInit var3);

    public void drawStatistics(Graphics2D graphics2D, double d, double d2) {
        this.drawStatistics(graphics2D, d, d2, false);
    }

    public void drawStatistics(Graphics2D graphics2D, double d, double d2, boolean bl) {
        if (this.boxStatistics != null) {
            this.boxStatistics.draw(graphics2D, d, d2, bl);
        }
    }

    @Override
    public void endCalculations() {
        try {
            AbstractPlotSettingsBox abstractPlotSettingsBox;
            AbstractPlotSettingsBox abstractPlotSettingsBox2;
            AbstractPlotSettingsBox abstractPlotSettingsBox3 = this.settingsBoxMap.get((byte)0);
            if (abstractPlotSettingsBox3 != null) {
                abstractPlotSettingsBox3.getMatrix().endCalculations();
            }
            if ((abstractPlotSettingsBox2 = this.settingsBoxMap.get((byte)1)) != null) {
                abstractPlotSettingsBox2.getMatrix().endCalculations();
            }
            if ((abstractPlotSettingsBox = this.settingsBoxMap.get((byte)9)) != null) {
                abstractPlotSettingsBox.getMatrix().endCalculations();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    @Override
    public void eventFinished(DataTreeEvent dataTreeEvent) {
    }

    public Object get(String string) {
        if (string.equalsIgnoreCase("matrix") || string.equalsIgnoreCase("data")) {
            return this.getPlotInit().getMatrix(0);
        }
        throw new RuntimeException("No such name " + string);
    }

    public AbstractAxisLayer getAxisParent() {
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof AbstractAxisLayer) {
            return (AbstractAxisLayer)dataTreeInterface;
        }
        return null;
    }

    public AbstractAxisPlot getAxisPlot() {
        return this.axisPlot;
    }

    public double getAxisValue(byte by, int n, int n2) {
        ComboBoxAxis comboBoxAxis = this.getAxisBox(by);
        if (comboBoxAxis != null) {
            return comboBoxAxis.getAxisValue(n, n2);
        }
        return 0.0;
    }

    public ScalePanel getColorScalePanel() {
        return this.boxColor.getScalePanel();
    }

    public AbstractPlotSettingsBox getComboBox(byte by) {
        return this.settingsBoxMap.get(by);
    }

    @Override
    public LegendInterface getComboBoxLegend(byte by) {
        return (LegendInterface)((Object)this.getComboBox(by));
    }

    public String getComment(ZoneLeaf zoneLeaf) {
        return this.getComment(zoneLeaf, null);
    }

    public String getComment(ZoneLeaf zoneLeaf, String string) {
        if (this.boxComment == null) {
            return null;
        }
        String string2 = this.boxComment.getComment(zoneLeaf);
        if (string != null && string2 != null) {
            return StringFun.cutIntoRows(string2, string);
        }
        return string2;
    }

    public Double getCount() {
        return this.getLayerSize();
    }

    public void setShowLayerDescription(boolean bl) {
        this.showLayerDescription = bl;
    }

    public String getDataDescription(byte by, boolean bl) {
        AbstractPlotSettingsBox abstractPlotSettingsBox;
        if (this.showLayerDescription && (abstractPlotSettingsBox = this.settingsBoxMap.get(by)) != null && abstractPlotSettingsBox.getSelectedIndex() >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = abstractPlotSettingsBox.getItemAt(abstractPlotSettingsBox.getSelectedIndex());
            if (object != null) {
                AbstractModel abstractModel;
                String string;
                String string2;
                stringBuilder.append(object);
                AbstractDataMatrix abstractDataMatrix = abstractPlotSettingsBox.getMatrix();
                if (bl && abstractDataMatrix instanceof ModelMatrix && abstractDataMatrix.getTreeParent() instanceof AbstractModel && ((string2 = abstractDataMatrix.toString()).equals("T") || string2.equals("P")) && (string = (abstractModel = (AbstractModel)abstractDataMatrix.getTreeParent()).getComponentDescription(abstractPlotSettingsBox.getAxisIndex())) != null) {
                    stringBuilder.append(" (");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public AbstractDataInfo getDataInfoFromAxis(AbstractDataMatrix abstractDataMatrix, int n) {
        int n2;
        PlotInit plotInit = this.axisPlot.getPlotInit();
        if (plotInit == null || abstractDataMatrix == null) {
            return this.getDataInfoFromAxis(n);
        }
        int n3 = n2 = abstractDataMatrix instanceof FoldMatrix || abstractDataMatrix.isModelMatrix() ? 0 : plotInit.getPlotIndex();
        if (n == 0) {
            return abstractDataMatrix.getDataInfo(n2);
        }
        return abstractDataMatrix.getDataInfo(1 - n2);
    }

    public AbstractDataInfo getDataInfoFromAxis(int n) {
        if (this.dataInfo == null) {
            return null;
        }
        return this.dataInfo[n];
    }

    public String getDescription(int n, byte by, int n2) {
        AbstractDataMatrix abstractDataMatrix;
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && (abstractDataMatrix = plotInit.getMatrix(by)) != null) {
            boolean bl = this.isObservation_Tag(abstractDataMatrix, plotInit.plotType);
            if ((plotInit.plotType & abstractDataMatrix.getMatrixTag()) == 0) {
                bl = !bl;
            }
            boolean bl2 = bl = bl == (by == 0);
            if (bl) {
                int n3 = abstractDataMatrix.getNrefOrig(n2);
                if (n3 == -1) {
                    return "Unknown";
                }
                return abstractDataMatrix.getRowDescription(n3, n);
            }
            int n4 = abstractDataMatrix.getKrefOrig(n2);
            if (n4 == -1) {
                return "Unknown";
            }
            return abstractDataMatrix.getColumnDescription(n4, n);
        }
        return String.valueOf(n);
    }

    public String getDescription(int n, ZoneLeaf zoneLeaf) {
        return this.getDescription(n, (byte)0, zoneLeaf.getPrimaryIndex());
    }

    public int getDescriptionCount() {
        AbstractDataMatrix abstractDataMatrix;
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && (abstractDataMatrix = plotInit.getMatrix(0)) != null) {
            boolean bl = this.isObservation_Tag(abstractDataMatrix, plotInit.plotType);
            if ((plotInit.plotType & abstractDataMatrix.getMatrixTag()) == 0) {
                boolean bl2 = bl = !bl;
            }
            if (bl) {
                return abstractDataMatrix.getRowDescriptionCount();
            }
            return abstractDataMatrix.getColumnDescriptionCount();
        }
        return 0;
    }

    public abstract Font getDescriptionFont();

    public String getDescriptionTitle(int n) {
        AbstractDataMatrix abstractDataMatrix;
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && (abstractDataMatrix = plotInit.getMatrix(0)) != null) {
            boolean bl = this.isObservation_Tag(abstractDataMatrix, plotInit.plotType);
            if ((plotInit.plotType & abstractDataMatrix.getMatrixTag()) == 0) {
                boolean bl2 = bl = !bl;
            }
            if (bl) {
                return abstractDataMatrix.getRowDescriptionTitle(n);
            }
            return abstractDataMatrix.getColumnDescriptionTitle(n);
        }
        return String.valueOf(n);
    }

    public Color getFixedColor() {
        return this.boxColor.getFixedColor();
    }

    public int getFoldMatrixType() {
        ComboBoxRange comboBoxRange = (ComboBoxRange)this.settingsBoxMap.get((byte)9);
        if (comboBoxRange != null) {
            AbstractDataMatrix abstractDataMatrix = comboBoxRange.getMatrix();
            return abstractDataMatrix.getRowType();
        }
        return 1;
    }

    public int getFoldN() {
        ComboBoxRange comboBoxRange = (ComboBoxRange)this.settingsBoxMap.get((byte)9);
        if (comboBoxRange != null) {
            return comboBoxRange.getMatrix().getFoldN();
        }
        return -1;
    }

    public ContinuousColorInterface getLayerColor() {
        return this.boxColor.getContinuesColor();
    }

    public int getLayerSize() {
        if (this.zoneList == null) {
            return 0;
        }
        return this.zoneList.size();
    }

    public Iterator<ZoneLeaf> getLeafIterator() {
        if (this.zoneList == null) {
            return new LinkedList().iterator();
        }
        return this.zoneList.iterator(this);
    }

    public int getListSize() {
        if (this.zoneList != null) {
            return this.zoneList.size();
        }
        return 0;
    }

    public AbstractAxisLayer getMainLayer() {
        AbstractAxisLayer abstractAxisLayer = this;
        for (AbstractAxisLayer abstractAxisLayer2 = this.getAxisParent(); abstractAxisLayer2 != null; abstractAxisLayer2 = abstractAxisLayer2.getAxisParent()) {
            abstractAxisLayer = abstractAxisLayer2;
        }
        return abstractAxisLayer;
    }

    public abstract double[] getMinmax(int var1);

    public int getNrObjects() {
        if (this.zoneList != null) {
            return this.zoneList.size();
        }
        return 0;
    }

    public int getNrVisibleObjects() {
        int n = 0;
        if (this.zoneList != null) {
            for (ZoneLeaf zoneLeaf : this.zoneList) {
                if (!zoneLeaf.isVisible()) continue;
                ++n;
            }
        }
        return n;
    }

    public PlotInit getPlotInit() {
        if (this.localPlotInit != null) {
            return this.localPlotInit;
        }
        if (this.axisPlot != null) {
            return this.axisPlot.getPlotInit();
        }
        return null;
    }

    public int[] getPrimaryIndexArray() {
        AbstractAxisLayer abstractAxisLayer;
        if (this.issublayer && (abstractAxisLayer = this.getAxisParent()) != null) {
            return abstractAxisLayer.getPrimaryIndexArray();
        }
        return this.primaryIndexArray;
    }

    public int getPrimaryIndexOrig(byte by, int n) {
        ComboBoxAxis comboBoxAxis = this.getAxisBox(by);
        if (comboBoxAxis != null) {
            return comboBoxAxis.getOrigIndexPrimary(n);
        }
        return -1;
    }

    public double getRangeValue(byte by, int n, int n2, int n3) {
        ComboBoxRange comboBoxRange;
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[1];
            this.axisBoxes[0] = this.settingsBoxMap.get((byte)9);
        }
        if ((comboBoxRange = (ComboBoxRange)this.axisBoxes[0]) != null) {
            return comboBoxRange.getAxisValue(by, n, n2, n3);
        }
        return 0.0;
    }

    public double getRangeValueFromDataIndex(byte by, int n, int n2, int n3) {
        ComboBoxRange comboBoxRange;
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[1];
            this.axisBoxes[0] = this.settingsBoxMap.get((byte)9);
        }
        if ((comboBoxRange = (ComboBoxRange)this.axisBoxes[0]) != null) {
            return comboBoxRange.getAxisValueFromDataIndex(by, n, n2, n3);
        }
        return 0.0;
    }

    public double getRangeValueFromIndex(byte by, int n, int n2, int n3) {
        ComboBoxRange comboBoxRange;
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[1];
            this.axisBoxes[0] = this.settingsBoxMap.get((byte)9);
        }
        if ((comboBoxRange = (ComboBoxRange)this.axisBoxes[0]) != null) {
            return comboBoxRange.getAxisValue(by, n, n2, n3);
        }
        return 0.0;
    }

    public String formatTooltipOrNull(double d) {
        ComboBoxColor comboBoxColor = (ComboBoxColor)this.settingsBoxMap.get((byte)3);
        if (comboBoxColor != null) {
            return comboBoxColor.formatTooltipOrNull(d);
        }
        return null;
    }

    public List<ZoneLeaf> getRootList() {
        if (this.settingsBoxMap.containsKey((byte)9) && this.isSubLayer() && this.getAxisParent() != null) {
            return this.getMainLayer().getRootList();
        }
        if (this.zoneList == null) {
            return new LinkedList<ZoneLeaf>();
        }
        return this.zoneList;
    }

    public String getScript(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
            String string2 = abstractPlotSettingsBox.getScript(bl);
            if (string2 == null) continue;
            stringBuilder.append(string + "." + string2);
        }
        return stringBuilder.toString();
    }

    public int getSecondaryIndexOrig(byte by, int n) {
        ComboBoxAxis comboBoxAxis = this.getAxisBox(by);
        if (comboBoxAxis != null) {
            return comboBoxAxis.getOrigIndexSecondary(n);
        }
        return -1;
    }

    public LeafList getSelection(String string) {
        if (string.equalsIgnoreCase("last")) {
            LeafList leafList = new LeafList(1);
            if (this.zoneList != null) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)this.zoneList.get(this.zoneList.size() - 1);
                leafList.add(zoneLeaf);
                return leafList;
            }
        } else {
            if (string.equalsIgnoreCase("all")) {
                return new LeafList(this.zoneList);
            }
            if (string.equalsIgnoreCase("selected")) {
                return new LeafList(this.axisPlot.selectionList);
            }
        }
        return null;
    }

    public Map<Byte, AbstractPlotSettingsBox> getSettingsBoxMap() {
        return this.settingsBoxMap;
    }

    public AbstractPlotSettingsBox getSettingsBox(Byte by) {
        return this.settingsBoxMap.get(by);
    }

    public int getSize(int n) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit == null) {
            return 0;
        }
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        if (abstractDataMatrix == null) {
            return 0;
        }
        int[] nArray = null;
        if (abstractDataMatrix.getRowType() == n) {
            nArray = abstractDataMatrix instanceof FoldMatrixInterface ? ((FoldMatrixInterface)((Object)abstractDataMatrix)).getPref() : abstractDataMatrix.getNref();
        } else if (abstractDataMatrix.getColumnType() == n) {
            nArray = abstractDataMatrix.getKref();
        } else {
            return 0;
        }
        if (nArray != null && nArray.length > 0) {
            return nArray[nArray.length - 1] + 1;
        }
        return abstractDataMatrix.getOrigSize(n);
    }

    public AbstractStatisticsInfo getStatisticsAt(double d, double d2, AbstractAxisPlot abstractAxisPlot) {
        AbstractStatisticsInfo abstractStatisticsInfo;
        int n;
        Object object;
        if (this.boxStatistics != null && (object = this.boxStatistics.getSelectedComboItem().getObject()) instanceof AbstractStatisticsInfo && (n = (abstractStatisticsInfo = (AbstractStatisticsInfo)object).hasStatisticAtGlobal(d, d2, abstractAxisPlot)) >= 0) {
            return abstractStatisticsInfo;
        }
        return null;
    }

    public LeafList getSubList(int n, int n2) {
        LeafList leafList = new LeafList(n2 - n + 1);
        leafList.addAll(this.zoneList.subList(n, n2 + 1));
        return leafList;
    }

    public LeafList getZoneList() {
        return this.zoneList;
    }

    public boolean hasAxisData() {
        return this.zoneList != null && !this.zoneList.isEmpty();
    }

    public boolean hasObject(Object object) {
        if (this.isCleaned() || this.settingsBoxMap == null) {
            return false;
        }
        if (object instanceof AbstractDataMatrix || object instanceof AbstractModel) {
            Iterator<AbstractPlotSettingsBox> iterator = this.settingsBoxMap.values().iterator();
            while (iterator.hasNext()) {
                AbstractDataMatrix abstractDataMatrix = iterator.next().getMatrix();
                if (abstractDataMatrix instanceof FoldMatrix) {
                    abstractDataMatrix = ((ReferenceMatrix)abstractDataMatrix).getReferencedMatrix();
                }
                if (abstractDataMatrix == object) {
                    return true;
                }
                if (abstractDataMatrix == null || !abstractDataMatrix.isModelMatrix() || !(object instanceof AbstractModel) || abstractDataMatrix.getModel() != object) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStatistics() {
        Object object;
        return this.boxStatistics != null && (object = this.boxStatistics.getSelectedComboItem().getObject()) instanceof AbstractStatisticsInfo;
    }

    public void includePoints(List<ZoneLeaf> list, AbstractAxisLayer abstractAxisLayer) {
        for (int i = 0; i < list.size(); ++i) {
            ZoneLeaf zoneLeaf = list.get(i);
            if (abstractAxisLayer != null && zoneLeaf.getLayer() != abstractAxisLayer) continue;
            zoneLeaf.setLayer(this);
        }
        this.updateCalculations(null, true);
        if (this.isCreated) {
            this.axisPlot.contentPaint((byte)7);
        }
    }

    public void initLeaf(ZoneLeaf zoneLeaf) {
        Iterator<AbstractPlotSettingsBox> iterator = this.settingsBoxMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().initLeaf(zoneLeaf);
        }
    }

    public boolean is3d() {
        return this.axisPlot instanceof FloatWindowPlot3D;
    }

    public boolean isFoldMatrix() {
        ComboBoxRange comboBoxRange = (ComboBoxRange)this.settingsBoxMap.get((byte)9);
        if (comboBoxRange != null) {
            return comboBoxRange.getMatrix() instanceof FoldMatrixInterface;
        }
        return false;
    }

    @Override
    public boolean isLayerReady() {
        if (!super.isLayerReady()) {
            return false;
        }
        for (byte by = 0; by <= 2; by = (byte)(by + 1)) {
            AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
            if (abstractPlotSettingsBox == null || abstractPlotSettingsBox.isFinished()) continue;
            return false;
        }
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get((byte)9);
        if (abstractPlotSettingsBox == null) {
            return true;
        }
        return abstractPlotSettingsBox.isFinished();
    }

    public boolean isMissing(byte by, int n, int n2) {
        ComboBoxAxis comboBoxAxis = this.getAxisBox(by);
        if (comboBoxAxis != null) {
            return comboBoxAxis.isMissingPrimary(n);
        }
        return false;
    }

    public boolean isRangeMissing(byte by, int n, int n2, int n3) {
        ComboBoxRange comboBoxRange;
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[1];
            this.axisBoxes[0] = this.settingsBoxMap.get((byte)9);
        }
        if ((comboBoxRange = (ComboBoxRange)this.axisBoxes[0]) != null) {
            return comboBoxRange.isMissing(by, n, n2, n3);
        }
        return false;
    }

    public boolean isRotated() {
        FoldMatrix foldMatrix;
        AbstractDataMatrix abstractDataMatrix;
        ComboBoxRange comboBoxRange = (ComboBoxRange)this.settingsBoxMap.get((byte)9);
        return comboBoxRange != null && (abstractDataMatrix = comboBoxRange.getMatrix()) instanceof FoldMatrix && (foldMatrix = (FoldMatrix)abstractDataMatrix).isRotate();
    }

    public boolean isSubLayer() {
        return this.issublayer;
    }

    @Override
    public void LoadData(RandomInputStream randomInputStream) throws IOException {
        this.init();
        if (!this.isSubLayer()) {
            randomInputStream.beginDataBlock("Loading plot into memory", false);
            long l = randomInputStream.getFilePointer();
            byte by = randomInputStream.ReadBlockByte();
            this.primaryIndexArray = randomInputStream.ReadBlockIntArray();
            if (randomInputStream.getSaveVersion() < 89L) {
                int[] nArray = randomInputStream.ReadBlockIntArray();
                if (this.primaryIndexArray == null) {
                    this.primaryIndexArray = nArray;
                }
            }
            this.loadZoneList(randomInputStream, by);
            randomInputStream.endDataBlock();
            randomInputStream.seek(l);
        }
    }

    @Override
    public void matrixChanged(DataMatrixEvent dataMatrixEvent) {
    }

    public AbstractAxisLayer moveIntoNewLayer(LeafList leafList, String string, boolean bl) {
        PlotAxisLayerPanel plotAxisLayerPanel = this.axisPlot.getSettingsPanel();
        return this.moveIntoNewLayer(leafList, string, plotAxisLayerPanel.getSubNumber(this), bl);
    }

    public AbstractAxisLayer moveIntoNewLayer(LeafList leafList, String string, int n, boolean bl) {
        AbstractAxisLayer abstractAxisLayer = this.createSubLayer(leafList, n, (PlotInit)this.getPlotInit().cloneCurrent());
        abstractAxisLayer.setLayerName(string);
        if (bl) {
            this.getAxisPlot().beginUpdate();
        }
        PlotAxisLayerPanel plotAxisLayerPanel = this.axisPlot.getSettingsPanel();
        plotAxisLayerPanel.addSubLayer(this, abstractAxisLayer, true, false);
        plotAxisLayerPanel.selectLayer(abstractAxisLayer);
        abstractAxisLayer.copySettingsFrom(this);
        if (bl) {
            this.axisPlot.endUpdate((byte)7);
        }
        return abstractAxisLayer;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        if (this.localPlotInit != null) {
            this.localPlotInit.setDataTreeInterface(dataTreeEvent.getReplaceDataTreeInterface());
        }
    }

    @Override
    public void propertyChanged(DataTreeEvent dataTreeEvent) {
    }

    @Override
    public boolean PurgeSignal() {
        Iterator<AbstractPlotSettingsBox> iterator = this.settingsBoxMap.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().PurgeSignal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void SaveData(RandomOutputStream randomOutputStream) throws IOException {
        if (!this.isSubLayer()) {
            randomOutputStream.beginDataBlock();
            byte by = this.zoneList == null || this.zoneList.isEmpty() ? (byte)0 : ((ZoneLeaf)this.zoneList.get(0)).getType();
            randomOutputStream.WriteBlockByte(by);
            randomOutputStream.WriteBlockIntArray(this.primaryIndexArray);
            this.saveZoneList(randomOutputStream);
            randomOutputStream.endDataBlock();
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        if (this.settingsBoxMap != null) {
            for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
                randomOutputStream.setPrefix(String.valueOf(abstractPlotSettingsBox.getType()));
                abstractPlotSettingsBox.SaveProperty(randomOutputStream);
            }
            randomOutputStream.setPrefix("");
        }
        this.localPlotInit.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("isub", this.issublayer);
        randomOutputStream.writePropertyNode("axisPlot", this.axisPlot);
        randomOutputStream.writePropertyBoolean("array", true);
    }

    public LeafList selectByClass(InnerColumnClass innerColumnClass, int n, boolean bl) {
        List<ZoneLeaf> list = this.getRootList();
        LeafList leafList = new LeafList();
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            int n3;
            ZoneLeaf zoneLeaf = list.get(i);
            if (zoneLeaf.getType() == 0) {
                int n4 = bl ? zoneLeaf.getPrimaryIndex() : zoneLeaf.getSecondaryIndex();
                n3 = -1;
                if (n4 >= 0) {
                    n3 = innerColumnClass.getValueShort(n4);
                }
                if (n3 != n) continue;
                leafList.add(zoneLeaf);
                continue;
            }
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            if (bl) {
                n3 = 0;
                n2 = zoneArray.getNoChildren();
                for (int j = 0; j < n2; ++j) {
                    int n5 = zoneArray.getPrimaryIndex(j);
                    short s = innerColumnClass.getValueShort(n5);
                    zoneArray.setTagged(j, s == n);
                    if (n3 != 0 || s != n) continue;
                    leafList.add(zoneArray);
                    n3 = 1;
                }
                continue;
            }
            n3 = zoneArray.getSecondaryIndex();
            n2 = -1;
            if (n3 >= 0) {
                n2 = innerColumnClass.getValueShort(n3);
            }
            if (n2 != n) continue;
            leafList.add(zoneArray);
            zoneArray.setTagged(true);
        }
        return leafList;
    }

    public void selectLayer(List<ZoneLeaf> list) {
        block6: {
            block5: {
                if (this.isSubLayer()) break block5;
                if (this.zoneList == null) break block6;
                for (ZoneLeaf zoneLeaf : this.zoneList) {
                    if (zoneLeaf.isSelected()) continue;
                    zoneLeaf.setSelected(true);
                    list.add(zoneLeaf);
                }
                break block6;
            }
            if (this.zoneList != null) {
                for (ZoneLeaf zoneLeaf : this.zoneList) {
                    if (zoneLeaf.getType() == 0) {
                        if (zoneLeaf.isSelected() || zoneLeaf.getLayer() != this) continue;
                        zoneLeaf.setSelected(true);
                        list.add(zoneLeaf);
                        continue;
                    }
                    zoneLeaf.setSelected(this, true);
                    ((ZoneArray)zoneLeaf).tagSelected();
                    if (list.contains(zoneLeaf) || ((ZoneArray)zoneLeaf).getFirstTagged() < 0) continue;
                    list.add(zoneLeaf);
                }
            }
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof AbstractAxisLayer)) continue;
                ((AbstractAxisLayer)this.getTreeNodeAt(i)).selectLayer(list);
            }
        }
    }

    public void setAxisRange() {
        for (byte by = 0; by <= 2; by = (byte)(by + 1)) {
            AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
            if (abstractPlotSettingsBox == null) continue;
            abstractPlotSettingsBox.setAllCreated();
        }
    }

    public void setColor(Object[] objectArray) {
        this.setSettingsBoxOption((byte)3, objectArray);
    }

    public void setComment(Object[] objectArray) throws Exception {
        this.setSettingsBoxOption((byte)10, objectArray);
    }

    public void setContentReady(boolean bl) {
        int n = this.settingsBoxMap.size();
        int n2 = 0;
        for (byte by = 14; n2 < n && by >= 0; by = (byte)(by - 1)) {
            if (by == 3) {
                n2 = (byte)(n2 + 1);
                continue;
            }
            AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
            if (abstractPlotSettingsBox == null) continue;
            n2 = (byte)(n2 + 1);
            abstractPlotSettingsBox.setContentReady(bl);
        }
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get((byte)3);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.setContentReady(bl);
        }
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        AbstractAxisLayer abstractAxisLayer;
        if (this.zoneList == null && (abstractAxisLayer = this.getAxisParent()) != null) {
            this.zoneList = abstractAxisLayer.zoneList;
        }
        this.init();
        int n = this.settingsBoxMap.size();
        int n2 = 0;
        for (byte by = 14; n2 < n && by >= 0; by = (byte)(by - 1)) {
            if (by == 3) {
                n2 = (byte)(n2 + 1);
                continue;
            }
            AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
            if (abstractPlotSettingsBox == null) continue;
            n2 = (byte)(n2 + 1);
            abstractPlotSettingsBox.setCreated(abstractWindow_GUI, bl);
        }
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get((byte)3);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.setCreated(abstractWindow_GUI, bl);
        }
        this.setAxisRange();
        super.setCreated(abstractWindow_GUI, bl);
    }

    public String setDataRange(Object[] objectArray) {
        byte by;
        if (objectArray.length == 0) {
            throw new RuntimeException("Invalid number of arguments");
        }
        String string = objectArray[0].toString();
        if (string.equalsIgnoreCase("X")) {
            by = 0;
        } else if (string.equalsIgnoreCase("Y")) {
            by = 1;
        } else if (string.equalsIgnoreCase("Z")) {
            by = 2;
        } else if (string.equalsIgnoreCase("RANGE")) {
            by = 9;
        } else {
            throw new RuntimeException("Invalid axis arguments: " + string + ", should be X, Y, Z or Range");
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return String.valueOf(this.setSettingsBoxOption(by, objectArray2));
    }

    public void setFromInit() {
        if (this.boxColor != null) {
            this.boxColor.setFromInit();
        }
    }

    public void setLabel(Object[] objectArray) throws Exception {
        this.setSettingsBoxOption((byte)6, objectArray);
    }

    public void setLayerVisible(Double d) {
        if (this.setLayerVisible(d.intValue() != 0) && this.axisPlot != null && this.axisPlot.getSettingsPanel() instanceof AbstractLayerPanel) {
            ((AbstractLayerPanel)this.axisPlot.getSettingsPanel()).layerVisibleChanged(this);
        }
    }

    public void setLine(Object[] objectArray) {
        this.setSettingsBoxOption((byte)7, objectArray);
    }

    public void setPrimaryIndexArray(int[] nArray) {
        this.primaryIndexArray = nArray;
    }

    public Object setSettingsBoxOption(byte by, Object[] objectArray) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
        Object[] objectArray2 = ScriptHelper.splitPropertiesFromParam(objectArray);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.setOption((Object[])objectArray2[0], (Properties)objectArray2[1]);
            return abstractPlotSettingsBox.getSelectedItem();
        }
        return null;
    }

    public Object getSettingBoxSelectedItem(byte by) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
        if (abstractPlotSettingsBox != null) {
            return abstractPlotSettingsBox.getSelectedItem();
        }
        return null;
    }

    public void setShape(Object[] objectArray) {
        this.setSettingsBoxOption((byte)5, objectArray);
    }

    public abstract void setShowLines(boolean var1);

    public void setSize(Object[] objectArray) {
        this.setSettingsBoxOption((byte)4, objectArray);
    }

    public void setStatistics(Object[] objectArray) {
        this.setSettingsBoxOption((byte)13, objectArray);
    }

    public void SettingsBoxChangeEvent(AbstractPlotSettingsBox abstractPlotSettingsBox, boolean bl) {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractAxisLayer)) continue;
            ((AbstractAxisLayer)this.getTreeNodeAt(i)).SettingsBoxSetChange(abstractPlotSettingsBox, bl);
        }
        List list = this.axisPlot.getMainLayerSynchMap();
        if (this.isCreated && !isSynchingMainLayer && !this.isSubLayer() && list != null && list.contains(abstractPlotSettingsBox.getType())) {
            isSynchingMainLayer = true;
            DataTreeInterface dataTreeInterface = this.getTreeParent();
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
                if (!(dataTreeInterface2 instanceof AbstractAxisLayer) || dataTreeInterface2.equals(this)) continue;
                ((AbstractAxisLayer)dataTreeInterface2).SettingsBoxSetChange(abstractPlotSettingsBox, bl);
            }
            isSynchingMainLayer = false;
        }
    }

    public void SettingsBoxSetChange(AbstractPlotSettingsBox abstractPlotSettingsBox, boolean bl) {
        AbstractPlotSettingsBox abstractPlotSettingsBox2 = this.settingsBoxMap.get(abstractPlotSettingsBox.getType());
        if (abstractPlotSettingsBox2 != null) {
            abstractPlotSettingsBox2.copySettingsFrom(abstractPlotSettingsBox);
        }
    }

    public void SettingsBoxSetChange(byte by, int n, int n2) {
        AbstractPlotSettingsBox abstractPlotSettingsBox = this.settingsBoxMap.get(by);
        if (abstractPlotSettingsBox != null) {
            abstractPlotSettingsBox.setSelected(n, n2, false);
        }
    }

    public LeafList setZoneList(LeafList leafList) {
        this.zoneList = leafList;
        return this.zoneList;
    }

    public void tagLeaves() {
        List<ZoneLeaf> list = this.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).tagByLayer(this);
        }
    }

    public void updateCalculations(AbstractPlotSettingsBox abstractPlotSettingsBox, boolean bl) {
        for (AbstractPlotSettingsBox abstractPlotSettingsBox2 : this.settingsBoxMap.values()) {
            if (abstractPlotSettingsBox2.getType() <= 2 || abstractPlotSettingsBox != null && (abstractPlotSettingsBox.equals(abstractPlotSettingsBox2) || !abstractPlotSettingsBox2.isCreated())) continue;
            abstractPlotSettingsBox2.updateCalculation(bl);
        }
    }

    @Override
    protected void cleanUpChild() {
        Object object;
        super.cleanUpChild();
        if (this.settingsBoxMap != null) {
            object = this.settingsBoxMap.values().iterator();
            while (object.hasNext()) {
                object.next().cleanUp();
            }
            this.settingsBoxMap.clear();
        }
        if (this.dataInfo != null) {
            Arrays.fill(this.dataInfo, null);
        }
        if (this.zoneList != null && !this.isSubLayer()) {
            this.zoneList.clear();
        }
        if (this.localPlotInit != null && (object = this.localPlotInit.getDataTreeInterface()) instanceof AbstractDataMatrix) {
            ((AbstractDataMatrix)object).removeDataTreeChangeListener(this);
        }
    }

    protected Insets getInsets(int n) {
        return switch (n) {
            case 0 -> new Insets(2, 2, 2, 2);
            case 1 -> new Insets(2, 2, 2, 2);
            default -> null;
        };
    }

    protected void init() {
        if (this.dataInfo[0] == null && this.dataInfo[1] == null) {
            PlotInit plotInit = this.axisPlot.getPlotInit();
            int n = plotInit.getDataTreeInterface() instanceof AbstractDataMatrix && ((AbstractDataMatrix)plotInit.getDataTreeInterface()).isModelMatrix() ? 0 : plotInit.getPlotIndex();
            this.dataInfo[0] = plotInit.getDataInfo(n);
            this.dataInfo[1] = plotInit.getDataInfo(1 - n);
        }
    }

    protected void InitLayer() {
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxColor.addItem(new ComboItem(VALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxColor.addItem(new ComboItem(DENSITYSTRING, 8));
        if (this instanceof ScatterLayer) {
            this.boxColor.addItem(new ComboItem(COMPONENTSSTRING, 26));
        }
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }

    protected abstract void InitLayerChild();

    protected void loadZoneList(RandomInputStream randomInputStream, byte by) throws IOException {
        int n = randomInputStream.ReadBlockInt();
        this.zoneList = new LeafList(n);
        for (int i = 0; i < n; ++i) {
            ZoneLeaf zoneLeaf = null;
            zoneLeaf = by == 0 ? new ZoneLeaf(this, randomInputStream) : (by == 1 ? new ZoneArray(this, randomInputStream) : new ZoneSurface(this, randomInputStream));
            if (randomInputStream.getSaveVersion() < 97L && !this.isLayerVisible()) {
                zoneLeaf.setVisible(true);
            }
            if (zoneLeaf.isSelected()) {
                this.axisPlot.selectionList.add(zoneLeaf);
            }
            this.zoneList.add(zoneLeaf);
        }
    }

    protected void saveZoneList(RandomOutputStream randomOutputStream) throws IOException {
        if (this.zoneList == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            randomOutputStream.WriteBlockInt(this.zoneList.size());
            Iterator iterator = this.zoneList.iterator();
            while (iterator.hasNext()) {
                ((ZoneLeaf)iterator.next()).Save(randomOutputStream);
            }
        }
    }

    void recalculate() {
        for (AbstractPlotSettingsBox abstractPlotSettingsBox : this.settingsBoxMap.values()) {
            abstractPlotSettingsBox.Calculate();
        }
    }

    private ComboBoxAxis getAxisBox(byte by) {
        if (this.axisBoxes == null) {
            this.axisBoxes = new AbstractPlotSettingsBox[3];
        }
        if (this.axisBoxes[by] == null) {
            this.axisBoxes[by] = this.settingsBoxMap.get(by);
        }
        return (ComboBoxAxis)this.axisBoxes[by];
    }

    private boolean isMissing(ComboBoxAxis comboBoxAxis, int n) {
        if ((n = comboBoxAxis.getOrigIndexPrimary(n)) < 0) {
            return true;
        }
        return comboBoxAxis.isMissingPrimary(n);
    }

    private boolean isMissing(ComboBoxAxis comboBoxAxis, int n, ZoneLeaf zoneLeaf) {
        boolean bl = true;
        boolean bl2 = false;
        if (n >= 0) {
            bl = comboBoxAxis.isMissingPrimary(n);
            bl2 = comboBoxAxis.isFilterPrimary(n);
        }
        zoneLeaf.setMissing(comboBoxAxis.getAxis(), bl || bl2);
        return bl;
    }

    private boolean isMissing(ComboBoxAxis comboBoxAxis, ZoneLeaf zoneLeaf) {
        return this.isMissing(comboBoxAxis, comboBoxAxis.getOrigIndexPrimary(zoneLeaf.getPrimaryIndex()), zoneLeaf);
    }

    private final boolean isObservation_Tag(AbstractDataMatrix abstractDataMatrix, int n) {
        if (n == 4 || abstractDataMatrix instanceof MatrixContainer || abstractDataMatrix instanceof ReferenceMatrix && ((ReferenceMatrix)abstractDataMatrix).getDeepestReference() instanceof MatrixContainer) {
            return true;
        }
        return !abstractDataMatrix.isModel() && n != 2;
    }

    public void setMarkNoneWhiteAreas(boolean bl) {
        this.markNoneWhiteAreas = bl;
    }

    public boolean isMarkNoneWhiteAreas() {
        return this.markNoneWhiteAreas;
    }

    public void setInteraction(boolean bl) {
        this.interaction = bl;
    }

    public boolean isInteraction() {
        return this.interaction;
    }
}

