/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionGroupInterface;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.propagation.PropagationDataNode;
import se.prediktera.map.common.swing.flat.TextIcon;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoListener;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Test;
import se.prediktera.map.datasetcontainer.datainfo.obsinfo.Train;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixListener;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.SelectionHelper;
import se.prediktera.map.main.SelectionInterface;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.plot.ImgSel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.ResolutionDialog;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.FloatPlotWindow;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.FloatWindowQuickSpectral;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.plot2D.serie.contribution.ContributionDragListener;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.FloatWindowContour3D;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxDialog;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.LegendInterface;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.axisplot.windows.ZoneRelativeLayout;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.plot.layout.LayoutException;
import se.prediktera.map.register.RegisterKeyManager;

public abstract class AbstractAxisPlot
extends FloatPlotWindow
implements DataInfoListener,
SelectionInterface {
    public static final byte XAXIS = 0;
    public static final byte YAXIS = 1;
    public static final byte ZAXIS = 2;
    protected double xGap;
    protected boolean rangesLocked = false;
    private final ArrayList<AxisRange> xRanges = new ArrayList();
    private final ArrayList<AxisRange> yRanges = new ArrayList();
    private final ArrayList<AxisRange> zRanges = new ArrayList();
    protected SelectionList selectionList = new SelectionList();
    protected PlotAxisLayerPanel plotAxisLayerPanel;
    protected BooleanArray selectionArray = null;
    public boolean isOptimize3D = false;
    protected Color plotBgColor = Color.white;
    protected Color axisColor = Color.black;
    protected Color gridColor = Color.lightGray;
    protected Color objectBorderColor = Color.black;
    protected Color zeroColor = Color.black;
    protected Color selectionColor = PerfectSpread.createTransparentColor(Color.BLACK, 100);
    protected BasicStroke axisStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    protected BasicStroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    private int eventid = -1;
    private boolean recalcLoaded = false;
    private double tickDensityX = 1.5;
    private double tickDensityY = 1.5;
    private boolean showGrid = true;
    private boolean showTicks = true;
    private boolean showZeroLines = true;
    private boolean showBorders = true;
    private final ArrayList<LegendWindow> legendList = new ArrayList();
    protected boolean keepAspectRatio = false;
    private boolean autoCreateLayerFromClass = false;
    protected ZoneLeaf quickLeaf = new ZoneLeaf(Color.black, 0, -1, -1, null);

    public AbstractAxisPlot(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, d, d2, d3, d4);
        this.plotAxisLayerPanel = new PlotAxisLayerPanel((AbstractWindow)abstractPlotBaseWindow, this, this.showLayerPanel());
        this.setupModelLink();
        if (plotInit != null) {
            for (int i = 0; i < 3; ++i) {
                this.getRanges(i).add(new AxisRange(plotInit.minmax[i]));
            }
            if (plotInit.selectionColor != null) {
                this.selectionColor = plotInit.selectionColor;
            }
        }
    }

    public AbstractAxisPlot(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        int n;
        String string = mapProperty.getPrefix();
        for (int i = 0; i < 3; ++i) {
            mapProperty.setPrefix(string + i);
            if (!mapProperty.hasProperty("nRan")) continue;
            int n2 = mapProperty.getLVInt();
            ArrayList<AxisRange> arrayList = this.getRanges(i);
            for (n = 0; n < n2; ++n) {
                mapProperty.setPrefix(string + i + n);
                arrayList.add(new AxisRange(randomInputStream, mapProperty));
            }
        }
        mapProperty.setPrefix(string);
        if (mapProperty.hasProperty("plotBgC")) {
            this.setPlotBgColor(new Color(mapProperty.getLVInt()));
        }
        if (mapProperty.hasProperty("axisC")) {
            this.setAxisColor(new Color(mapProperty.getLVInt()));
        }
        float f = mapProperty.getPropertyFloat("awidth", 1.0f);
        this.axisStroke = new BasicStroke(f, 0, 0, 10.0f);
        if (mapProperty.hasProperty("gridC")) {
            this.setGridColor(new Color(mapProperty.getLVInt()));
        }
        float f2 = mapProperty.getPropertyFloat("gwidth", 1.0f);
        this.gridStroke = new BasicStroke(f2, 0, 0, 10.0f);
        if (mapProperty.hasProperty("borderC")) {
            this.setObjectBorderColor(new Color(mapProperty.getLVInt()));
        }
        if (mapProperty.hasProperty("zeroC")) {
            this.setZeroColor(new Color(mapProperty.getLVInt()));
        }
        if (mapProperty.hasProperty("selC")) {
            this.setSelectionColor(new Color(mapProperty.getLVInt()));
        }
        this.showBorders = mapProperty.getPropertyBoolean("sborder", true);
        this.showGrid = mapProperty.getPropertyBoolean("sgrids", true);
        this.showTicks = mapProperty.getPropertyBoolean("sticks", true);
        this.showZeroLines = mapProperty.getPropertyBoolean("zlines", true);
        this.tickDensityX = mapProperty.getPropertyDouble("xden", this.tickDensityX);
        this.tickDensityY = mapProperty.getPropertyDouble("yden", this.tickDensityY);
        int n3 = mapProperty.getPropertyInt("legendNo", 1);
        for (n = 0; n < n3; ++n) {
            LegendWindow legendWindow = (LegendWindow)mapProperty.resolveNodeFromName(randomInputStream, "legendW" + String.valueOf(n == 0 ? "" : Integer.valueOf(n + 1)));
            if (legendWindow == null) continue;
            legendWindow.setParentBaseWindow(this.plot);
            this.legendList.add(legendWindow);
        }
        boolean bl = this.recalcLoaded = randomInputStream.getSaveVersion() < 90L && (this instanceof FloatWindowSpectral || this instanceof FloatWindowContour3D);
        if (this.recalcLoaded) {
            PlotInit plotInit = this.getPlotInit();
            if (plotInit.plotType == 1) {
                plotInit.plotType = 2;
            } else if (plotInit.plotType == 2) {
                plotInit.plotType = 1;
            }
        }
        this.keepAspectRatio = mapProperty.getPropertyBoolean("aspRat");
        this.autoCreateLayerFromClass = mapProperty.getPropertyBoolean("autoclass");
        this.plotAxisLayerPanel = new PlotAxisLayerPanel(this, this.showLayerPanel(), randomInputStream, mapProperty);
        this.setupModelLink();
    }

    @Override
    public DataTreeInterface addLayer(AbstractDataMatrix abstractDataMatrix) {
        return this.plotAxisLayerPanel.addMatrixAsLayer(abstractDataMatrix);
    }

    @Override
    public LegendWindow addLegend(Object[] objectArray) {
        Object object;
        Object[] objectArray2 = ScriptHelper.splitPropertiesFromParam(objectArray);
        objectArray = (Object[])objectArray2[0];
        Properties properties = (Properties)objectArray2[1];
        if (objectArray.length == 0 || objectArray.length > 3) {
            throw new RuntimeException("Invalid number of parameters: " + objectArray.length);
        }
        int n = 0;
        AbstractAxisLayer abstractAxisLayer = null;
        if (objectArray[n] instanceof AbstractAxisLayer) {
            abstractAxisLayer = (AbstractAxisLayer)objectArray[0];
            if (objectArray.length == 1) {
                throw new RuntimeException("Invalid number of parameters: " + objectArray.length);
            }
        } else {
            abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(0);
        }
        int n2 = ++n;
        ++n;
        String string = objectArray[n2].toString().toLowerCase();
        byte by = 0;
        if (string.equals("color") || string.equals("shape") || string.equals("layer")) {
            if (string.equals("shape")) {
                by = 1;
            } else if (string.equals("layer")) {
                by = 2;
            }
        } else {
            throw new RuntimeException("Illegal priority parameter: " + by);
        }
        int n3 = 3;
        if (objectArray.length == n + 1) {
            n3 = -1;
            object = objectArray[n].toString().toLowerCase();
            for (int i = 0; i < ZoneRelativeLayout.LAYOUT.length; ++i) {
                if (!ZoneRelativeLayout.LAYOUT[i].equals(object)) continue;
                n3 = i;
                break;
            }
            if (n3 == -1) {
                throw new RuntimeException("Illegal layout parameter: " + (String)object);
            }
        }
        object = abstractAxisLayer.getSettingsBoxMap();
        LegendInterface legendInterface = (LegendInterface)((Object)object.get((byte)3));
        LegendWindow legendWindow = new LegendWindow(this.getParentBaseWindow());
        legendWindow.setBackground(this.getPlotBgColor());
        legendWindow.setForeground(this.getPlotLayout().getForeground());
        legendWindow.setPriority(by);
        if (properties != null) {
            legendWindow.setProperties(properties);
        }
        this.updateLegend(legendWindow, n3);
        legendWindow.setLegendInterface(legendInterface);
        return legendWindow;
    }

    @Override
    public List<LegendWindow> getLegendList() {
        return this.legendList;
    }

    public void addMatrixAsLayer(AbstractDataMatrix abstractDataMatrix) {
        this.plotAxisLayerPanel.addMatrixAsLayer(abstractDataMatrix);
    }

    @Override
    public boolean addToPopup(final Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        CleanUpInterface cleanUpInterface;
        JComponent jComponent;
        CleanUpInterface cleanUpInterface2;
        CleanUpInterface cleanUpInterface3;
        Object object;
        Object object2;
        int n;
        DataMatrixListener dataMatrixListener;
        DataTreeInterface dataTreeInterface2;
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && plotInit.getDataTreeInterface() != null) {
            dataTreeInterface2 = plotInit.getDataTreeInterface();
            if (dataTreeInterface2 instanceof FoldMatrix) {
                dataTreeInterface2 = ((FoldMatrix)dataTreeInterface2).getReferencedMatrix();
            }
            int n2 = plotInit.getMatrix(0).getMatrixTag();
            dataMatrixListener = this.getDataSet();
            if (!(dataMatrixListener == null || ((DataSet)dataMatrixListener).isExternal() || (n2 & 1) != 1 && (n2 & 2) != 2)) {
                boolean bl2 = (n2 & 1) == 1;
                n = ((PropagationDataNode)((Object)dataMatrixListener)).isProtected() ? 1 : 0;
                final AbstractDataInfo abstractDataInfo = plotInit.getDataInfo(bl2 ? 0 : 1);
                if (jPopupMenu.getComponentCount() != 0) {
                    jPopupMenu.addSeparator();
                }
                object2 = new CMenuItem(this, "Include", true){
                    final /* synthetic */ AbstractAxisPlot this$0;
                    {
                        this.this$0 = abstractAxisPlot;
                        super(string, bl);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BooleanArray booleanArray = this.this$0.getIncludeExcludeArray();
                        abstractDataInfo.setIncluded(booleanArray, true, false);
                        this.this$0.redoInteraction();
                    }
                };
                ((AbstractButton)object2).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/inc.png")));
                ((JMenuItem)object2).setEnabled(n == 0 && !this.selectionList.isEmpty());
                jPopupMenu.add((JMenuItem)object2);
                object = new CMenuItem(this, "Include Only", true){
                    final /* synthetic */ AbstractAxisPlot this$0;
                    {
                        this.this$0 = abstractAxisPlot;
                        super(string, bl);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BooleanArray booleanArray = this.this$0.getIncludeExcludeArray();
                        abstractDataInfo.setIncluded(booleanArray, true, true);
                        this.this$0.redoInteraction();
                    }
                };
                ((AbstractButton)object).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/inc.png")));
                ((JMenuItem)object).setEnabled(n == 0 && !this.selectionList.isEmpty());
                jPopupMenu.add((JMenuItem)object);
                cleanUpInterface3 = new CMenuItem(this, "Exclude", true){
                    final /* synthetic */ AbstractAxisPlot this$0;
                    {
                        this.this$0 = abstractAxisPlot;
                        super(string, bl);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BooleanArray booleanArray = this.this$0.getIncludeExcludeArray();
                        abstractDataInfo.setIncluded(booleanArray, false, false);
                        this.this$0.redoInteraction();
                    }
                };
                ((AbstractButton)((Object)cleanUpInterface3)).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/exc.png")));
                ((JMenuItem)((Object)cleanUpInterface3)).setEnabled(n == 0 && !this.selectionList.isEmpty());
                jPopupMenu.add((JMenuItem)((Object)cleanUpInterface3));
                if (abstractDataInfo instanceof ObservationInfo) {
                    jPopupMenu.addSeparator();
                    cleanUpInterface2 = new CMenuItem(this, "Train", true, (DataSet)dataMatrixListener, abstractDataInfo){
                        final /* synthetic */ DataSet val$dataSet;
                        final /* synthetic */ AbstractDataInfo val$dataInfo;
                        final /* synthetic */ AbstractAxisPlot this$0;
                        {
                            this.val$dataSet = dataSet;
                            this.val$dataInfo = abstractDataInfo;
                            this.this$0 = abstractAxisPlot;
                            super(string, bl);
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.this$0.setTrainTest(this.val$dataSet, this.val$dataInfo, true);
                        }
                    };
                    ((AbstractButton)((Object)cleanUpInterface2)).setIcon(new TextIcon("Tr", Color.black));
                    ((JMenuItem)((Object)cleanUpInterface2)).setEnabled(n == 0 && !this.selectionList.isEmpty());
                    jPopupMenu.add((JMenuItem)((Object)cleanUpInterface2));
                    jComponent = new CMenuItem(this, "Test", true, (DataSet)dataMatrixListener, abstractDataInfo){
                        final /* synthetic */ DataSet val$dataSet;
                        final /* synthetic */ AbstractDataInfo val$dataInfo;
                        final /* synthetic */ AbstractAxisPlot this$0;
                        {
                            this.val$dataSet = dataSet;
                            this.val$dataInfo = abstractDataInfo;
                            this.this$0 = abstractAxisPlot;
                            super(string, bl);
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.this$0.setTrainTest(this.val$dataSet, this.val$dataInfo, false);
                        }
                    };
                    ((AbstractButton)jComponent).setIcon(new TextIcon("Te", Color.black));
                    ((JMenuItem)jComponent).setEnabled(n == 0 && !this.selectionList.isEmpty());
                    jPopupMenu.add((JMenuItem)jComponent);
                }
                jPopupMenu.addSeparator();
                cleanUpInterface2 = new CMenuItem(this, "Apply Changes", true, (DataSet)dataMatrixListener){
                    final /* synthetic */ DataSet val$dataSet;
                    final /* synthetic */ AbstractAxisPlot this$0;
                    {
                        this.val$dataSet = dataSet;
                        this.this$0 = abstractAxisPlot;
                        super(string, bl);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$dataSet.doUpdate(null);
                    }
                };
                ((JMenuItem)((Object)cleanUpInterface2)).setAccelerator(KeyStroke.getKeyStroke(116, 0));
                ((AbstractButton)((Object)cleanUpInterface2)).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
                ((JMenuItem)((Object)cleanUpInterface2)).setEnabled(n == 0 && ((PropagationDataNode)((Object)dataMatrixListener)).hasChanged());
                jPopupMenu.add((JMenuItem)((Object)cleanUpInterface2));
                jComponent = project_GUI.getData_GUI().getTableForDataSet((DataSet)dataMatrixListener);
                if (jComponent != null) {
                    jPopupMenu.addSeparator();
                    cleanUpInterface = new CMenu("Modifications", false);
                    ((AbstractButton)((Object)cleanUpInterface)).setIcon(AbstractPaint.createIcon(2));
                    jPopupMenu.add((JMenuItem)((Object)cleanUpInterface));
                    ((JMenuItem)((Object)cleanUpInterface)).setEnabled(n == 0);
                    CMenu cMenu = new CMenu("Add", false);
                    cMenu.setIcon(AbstractPaint.createIcon(2));
                    ((DataSetTable)jComponent).addTransformationsToPopup(cMenu);
                    ((JMenu)((Object)cleanUpInterface)).add(cMenu);
                    CMenu cMenu2 = new CMenu("Remove", false);
                    cMenu2.setIcon(AbstractPaint.createIcon(2));
                    ((DataSetTable)jComponent).addRemoveTransformationsToPopup(cMenu2);
                    ((JMenu)((Object)cleanUpInterface)).add(cMenu2);
                }
                if (jPopupMenu.getComponentCount() != 0) {
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(SelectionHelper.createMenu(project_GUI, this, abstractDataInfo, this.selectionList, bl2));
            }
        }
        if ((dataTreeInterface2 = this.plotAxisLayerPanel.getMainLayer(0)) != null) {
            CMenuItem cMenuItem = new CMenuItem("Add Legend", true);
            cMenuItem.addActionListener(actionEvent -> this.addDefaultLegend());
            jPopupMenu.add(cMenuItem);
        }
        CMenu cMenu = new CMenu("Advanced", true);
        dataMatrixListener = this.getSelectionMainLayer();
        if (dataMatrixListener != null) {
            CMenuItem cMenuItem = new CMenuItem("Change Settings for Selection", true);
            cMenuItem.addActionListener(actionEvent -> {
                SettingsBoxDialog settingsBoxDialog = new SettingsBoxDialog(this, this.selectionList);
                settingsBoxDialog.setVisible(true);
            });
            cMenu.add(cMenuItem);
            cMenuItem.setEnabled(!this.selectionList.isEmpty());
        }
        if (this.plotAxisLayerPanel != null) {
            this.plotAxisLayerPanel.addToPopup(cMenu, bl, true);
        }
        cMenu.addSeparator();
        CMenu cMenu3 = new CMenu("Select Points from Layer...", true);
        n = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n; ++i) {
            object2 = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (((AbstractAxisLayer)object2).isSubLayer() || !((AbstractLayer)object2).isLayerVisible() || !((AbstractAxisLayer)object2).isLayerReady()) continue;
            object = new JMenu(((AbstractLayer)object2).toString());
            cMenu3.add((JMenuItem)object);
            cleanUpInterface3 = new CMenuItem(object2, "All");
            ((AbstractButton)((Object)cleanUpInterface3)).addActionListener(actionEvent -> this.selectLayer((AbstractAxisLayer)((CMenuItem)actionEvent.getSource()).getObject(), (actionEvent.getModifiers() & 1) == 1));
            ((JMenu)object).add((JMenuItem)((Object)cleanUpInterface3));
            if (((AbstractLayer)object2).getTreeNodeCount() <= 0) continue;
            ((JMenu)object).addSeparator();
            for (int j = 0; j < ((AbstractLayer)object2).getTreeNodeCount(); ++j) {
                cleanUpInterface = ((AbstractLayer)object2).getTreeNodeAt(j);
                if (!(cleanUpInterface instanceof AbstractAxisLayer) || !((AbstractLayer)(jComponent = (AbstractAxisLayer)cleanUpInterface)).isLayerVisible() || !((AbstractAxisLayer)jComponent).isLayerReady()) continue;
                cleanUpInterface = new CMenuItem(jComponent);
                ((AbstractButton)((Object)cleanUpInterface)).addActionListener(actionEvent -> this.selectLayer((AbstractAxisLayer)((CMenuItem)actionEvent.getSource()).getObject(), (actionEvent.getModifiers() & 1) == 1));
                ((JMenu)object).add((JMenuItem)((Object)cleanUpInterface));
            }
        }
        cMenu.add(cMenu3);
        if (dataMatrixListener != null) {
            CMenu cMenu4 = new CMenu("Move Selection into Layer...", true);
            cMenu4.add(new CMenuItem(this, "New", false, (AbstractAxisLayer)dataMatrixListener){
                final /* synthetic */ AbstractAxisLayer val$mainLayer;
                final /* synthetic */ AbstractAxisPlot this$0;
                {
                    this.val$mainLayer = abstractAxisLayer;
                    this.this$0 = abstractAxisPlot;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractAxisLayer abstractAxisLayer;
                    AbstractAxisLayer abstractAxisLayer2 = abstractAxisLayer = (AbstractAxisLayer)this.this$0.plotAxisLayerPanel.getSelectedLayer();
                    while (abstractAxisLayer2.getAxisParent() != null) {
                        abstractAxisLayer2 = abstractAxisLayer2.getAxisParent();
                    }
                    if (abstractAxisLayer2 == this.val$mainLayer) {
                        this.this$0.moveSelectionIntoNewLayer(abstractAxisLayer);
                    } else {
                        this.this$0.moveSelectionIntoNewLayer(this.val$mainLayer);
                    }
                }
            });
            cMenu4.addSeparator();
            cMenu4.add(new CMenuItem(this, ((AbstractLayer)((Object)dataMatrixListener)).toString(), (AbstractAxisLayer)dataMatrixListener){
                final /* synthetic */ AbstractAxisLayer val$mainLayer;
                final /* synthetic */ AbstractAxisPlot this$0;
                {
                    this.val$mainLayer = abstractAxisLayer;
                    this.this$0 = abstractAxisPlot;
                    super(object);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.moveSelectionIntoLayer(this.val$mainLayer);
                }
            });
            for (int i = 0; i < ((AbstractLayer)((Object)dataMatrixListener)).getTreeNodeCount(); ++i) {
                cleanUpInterface3 = ((AbstractLayer)((Object)dataMatrixListener)).getTreeNodeAt(i);
                if (!(cleanUpInterface3 instanceof AbstractAxisLayer)) continue;
                object = (AbstractAxisLayer)cleanUpInterface3;
                cMenu4.add(new CMenuItem(object){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AbstractAxisPlot.this.moveSelectionIntoLayer((AbstractAxisLayer)this.getObject());
                    }
                });
            }
            cMenu.add(cMenu4);
            cMenu4.setEnabled(!this.isProtected() && !this.selectionList.isEmpty());
        }
        if (this.plotAxisLayerPanel != null) {
            cMenu.addSeparator();
            this.plotAxisLayerPanel.addToPopup(cMenu, bl, false);
        }
        if (!(this instanceof FloatWindowQuickSpectral)) {
            if (jPopupMenu.getComponentCount() != 0) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(cMenu);
        }
        CMenu cMenu5 = null;
        object2 = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.ANALYSIS_INFO);
        object = object2.iterator();
        while (object.hasNext()) {
            cleanUpInterface3 = (AbstractInfo)object.next();
            cleanUpInterface2 = (AbstractAnalysisInfo)cleanUpInterface3;
            if (!((AbstractAnalysisInfo)cleanUpInterface2).supportShowDialog(this)) continue;
            if (cMenu5 == null) {
                cMenu5 = new CMenu("Analysis", true);
                jPopupMenu.add(cMenu5);
            }
            cMenu5.add(new CMenuItem(this, cleanUpInterface2, true){
                final /* synthetic */ AbstractAxisPlot this$0;
                {
                    this.this$0 = abstractAxisPlot;
                    super(object, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((AbstractAnalysisInfo)((CMenuItem)actionEvent.getSource()).getObject()).showAnalysisDialog(project_GUI, this.this$0);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                }
            });
        }
        return true;
    }

    public void redoInteraction() {
        Project_GUI project_GUI = this.plot.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.doInteractionOnly();
        }
    }

    public void addToSelectionlist(ZoneLeaf zoneLeaf) {
        this.selectionList.add(zoneLeaf);
    }

    public void adjustToAspectRatioGlobal() {
        if (this.keepAspectRatio) {
            this.adjustToAspectRatio();
        }
    }

    @Override
    public void autoCreateLayerFromClass(String string, boolean bl) {
        int n;
        this.autoCreateLayerFromClass = true;
        AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(0);
        if (bl && this.plotAxisLayerPanel.hasSubLayers(abstractAxisLayer)) {
            int n2 = JOptionPane.showConfirmDialog(this, "Creating new sub-layers for this class will remove existing sub-layers from a previous class.\nPress OK to continue.", "Confirmation", 2, 1);
            if (n2 != 0) {
                return;
            }
            this.plotAxisLayerPanel.removeSubLayers(abstractAxisLayer);
        }
        AbstractAxisLayer abstractAxisLayer2 = null;
        for (n = 0; n < abstractAxisLayer.getTreeNodeCount(); ++n) {
            if (!(abstractAxisLayer.getTreeNodeAt(n) instanceof AbstractAxisLayer) || !abstractAxisLayer.getTreeNodeAt(n).toString().equals(string)) continue;
            abstractAxisLayer2 = (AbstractAxisLayer)abstractAxisLayer.getTreeNodeAt(n);
            break;
        }
        if (abstractAxisLayer2 == null) {
            n = this.plotAxisLayerPanel.getSubNumber(abstractAxisLayer);
            this.moveSelectionIntoNewLayer(abstractAxisLayer, string, n);
        } else {
            this.moveSelectionIntoLayer(abstractAxisLayer2);
        }
    }

    public void calculateAndRepaintSetAxis(boolean bl, boolean bl2) {
        if (this.isOptimize3D || this.isCreated()) {
            boolean bl3 = bl2 && this.isAutoRescale();
            this.updateLables();
            this.calculateAxisTicks(0, bl2, bl3);
            this.calculateAxisTicks(1, bl2, bl3);
            this.calculateAxisTicks(2, bl2, bl3);
            if (this.keepAspectRatio) {
                this.adjustToAspectRatio();
            }
            if (bl) {
                this.repaintPlot((byte)7);
            }
        }
    }

    public void calculateAndRepaintSetAxisEvent(boolean bl, boolean bl2, int n) {
        if (this.eventid != n) {
            this.eventid = n;
            this.calculateAndRepaintSetAxis(bl, bl2);
        }
    }

    public void calculateAxisTicks(byte by) {
        double d = this.getTickDensity(by);
        ArrayList<AxisRange> arrayList = this.getRanges(by);
        double d2 = d;
        d2 = by == 0 ? (d2 *= (double)this.getPlotWidth()) : (by == 1 ? (d2 *= (double)this.getPlotHeight()) : (d2 *= (double)this.getPlotDepth()));
        if (d2 > 0.0) {
            for (AxisRange axisRange : arrayList) {
                double d3 = axisRange.setAxisTicks(d2);
                if (by != 0) continue;
                this.xGap = d3;
            }
        }
    }

    public void calculateAxisTicks(int n, boolean bl, boolean bl2) {
        if (this.rangesLocked) {
            return;
        }
        if (bl || bl2) {
            ArrayList<AxisRange> arrayList = this.getRanges(n);
            for (int i = 0; i < arrayList.size(); ++i) {
                AxisRange axisRange = arrayList.get(i);
                if (bl) {
                    axisRange.calculate(this.getMinmax(n, i), this.isAutoRescale());
                }
                if (!bl2) continue;
                axisRange.zoomAll();
            }
            if (this.keepAspectRatio) {
                this.adjustToAspectRatio();
            }
        }
        this.calculateAxisTicks((byte)n);
    }

    public void calculateAxisTicksGlobal(int n, boolean bl, boolean bl2) {
        this.updateLables();
        this.calculateAxisTicks(n, bl, bl2);
    }

    public boolean calculateBuildAndRepaint() {
        this.calculateAndRepaintSetAxis(false, true);
        return this.repaintPlot((byte)7);
    }

    public void clearSelection() {
        if (this.selectionList != null) {
            this.selectionList.clear();
            if (this.plot.hasInteractivity()) {
                this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
            }
        }
    }

    @Override
    public void collectLegendInterface(JPopupMenu jPopupMenu) {
        this.plotAxisLayerPanel.collectLegendInterface(jPopupMenu);
    }

    public void collectLegendLayers(JComboBox jComboBox) {
        this.plotAxisLayerPanel.collectLegendLayers(jComboBox);
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        if (this.isCleaned()) {
            return false;
        }
        byte by = dataInfoEvent.getType();
        if (by == 11 || by == 12) {
            this.contentPaint((byte)7);
        }
        return true;
    }

    @Override
    public void deleteSelectedFields() {
        Iterator<LegendWindow> iterator = this.legendList.iterator();
        while (iterator.hasNext()) {
            LegendWindow legendWindow = iterator.next();
            if (this.plot.hasWindow(legendWindow)) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        AbstractAxisLayer abstractAxisLayer;
        int[] nArray;
        boolean bl;
        InteractionArray interactionArray;
        if (this.plotAxisLayerPanel.getLayerCount() <= 0) {
            return false;
        }
        int n = this.plotAxisLayerPanel.getMainLayerCount();
        boolean bl2 = this.isFoldMatrix();
        boolean bl3 = this.hasInteractSecond();
        int n2 = this.getPrimaryMatrixTag();
        int n3 = this.getSecondaryMatrixTag();
        InteractionArray interactionArray2 = this.getInteractionArray(n2);
        if (!this.shouldInteract(interactionArray2, interactionArray = this.getInteractionArray(n3))) {
            return false;
        }
        byte by = this.plot.getInteractionFlag();
        boolean bl4 = (by & 1) != 0;
        boolean bl5 = bl = (by & 2) != 0;
        if (interactionArray2 != null) {
            if (bl4) {
                this.selectionList.clear();
            }
            for (int i = 0; i < n; ++i) {
                AbstractAxisLayer abstractAxisLayer2 = this.plotAxisLayerPanel.getMainLayer(i);
                if (!abstractAxisLayer2.isInteraction()) continue;
                if (bl2) {
                    this.doInteractionByFold(abstractAxisLayer2, interactionArray2);
                    continue;
                }
                List<ZoneLeaf> list = abstractAxisLayer2.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneLeaf zoneLeaf = list.get(j);
                    boolean bl6 = bl3 ? interactionArray2.get(zoneLeaf.getSecondaryIndex()) : interactionArray2.get(zoneLeaf.getPrimaryIndex());
                    if (bl) {
                        zoneLeaf.setVisible(bl6);
                        continue;
                    }
                    zoneLeaf.setSelected(bl6);
                    if (!bl6) continue;
                    this.selectionList.add(zoneLeaf);
                }
            }
        }
        if (interactionArray != null && bl4 && bl3 && (nArray = (abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(0)).getPrimaryIndexArray()) != null) {
            for (Object object : (AbstractAxisLayer)nArray) {
                this.selectionArray.set((int)object, interactionArray.get((int)object));
            }
        }
        return interactionArray2 != null || interactionArray != null;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
        if (RegisterKeyManager.isPredikteraDevelopmentLicense() && this instanceof FloatWindowScatter && this.plotAxisLayerPanel.getMainLayerCount() > 0) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(0);
            this.quickLeaf.setIndex(n2, -1);
            this.quickLeaf.setLayer(abstractAxisLayer);
            this.repaint();
        }
    }

    @Override
    public void finishInteraction() {
        byte by = this.plot.getInteractionFlag();
        if (by == 1) {
            this.interactiveSelectionFinished((byte)2);
        } else {
            this.interactiveSelectionFinished((byte)7);
        }
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public float getAxisWidth() {
        return this.axisStroke.getLineWidth();
    }

    public AbstractDataInfo getDataInfo() {
        PlotInit plotInit = this.getPlotInit();
        int n = plotInit.getMatrix(0).getMatrixTag();
        boolean bl = (n & 1) == 1;
        return plotInit.getDataInfo(bl ? 0 : 1);
    }

    public DataSet getDataSet() {
        PlotInit plotInit = this.getPlotInit();
        DataSet dataSet = null;
        if (plotInit != null && plotInit.getDataTreeInterface() != null) {
            DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
            if (dataTreeInterface instanceof FoldMatrix) {
                dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
            }
            if (dataTreeInterface != null) {
                boolean bl;
                DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeParent();
                boolean bl2 = this.hasZoneArray() ? !this.isRowPrimary() : (bl = this.isRowPrimary());
                if (dataTreeInterface2 instanceof AbstractModel) {
                    dataSet = ((AbstractModel)dataTreeInterface2).getDataSet();
                } else if (dataTreeInterface2 instanceof DataContainer && dataTreeInterface2.getTreeParent() instanceof AbstractModel) {
                    dataSet = ((AbstractModel)dataTreeInterface2.getTreeParent()).getDataSet();
                } else if (dataTreeInterface2 instanceof DataContainer && dataTreeInterface2.getTreeParent() instanceof DataSet) {
                    dataSet = (DataSet)dataTreeInterface2.getTreeParent();
                } else {
                    if (dataTreeInterface2 instanceof Case) {
                        return ((Case)dataTreeInterface2).getOriginalDataSet();
                    }
                    AbstractDataInfo abstractDataInfo = plotInit.getDataInfo(bl ? 0 : 1);
                    if (abstractDataInfo != null) {
                        dataSet = abstractDataInfo.getDataSet();
                    }
                }
            }
        }
        return dataSet;
    }

    public int getFontSize(byte by) {
        FloatTextWindow floatTextWindow = this.getLabelWindow(by);
        if (floatTextWindow != null) {
            return floatTextWindow.getFloatFont().getSize();
        }
        return 10;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public float getGridWidth() {
        return this.gridStroke.getLineWidth();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(380);
        stringBuilder.append("<HTML><BODY>");
        int n = this.getNrObjects();
        int n2 = this.getNrVisibleObjects();
        int n3 = this.getSelectedObjectCount();
        double d = n == 0 ? 0.0 : (double)n3 * 1000.0 / (double)n * 0.1;
        PlotInit plotInit = this.getPlotInit();
        stringBuilder.append("<B>Plot - ").append(this.plot.toString()).append("</B><br>");
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        if (abstractDataMatrix != null) {
            stringBuilder.append(abstractDataMatrix.getCase()).append("<br>");
        }
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        if (abstractDataMatrix != null) {
            DataTreeInterface dataTreeInterface = abstractDataMatrix.getTreeParent();
            if (dataTreeInterface != null) {
                stringBuilder.append("<tr><td>Parent:</td><td>").append(dataTreeInterface).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>Data:</td><td>").append(abstractDataMatrix).append("</td></tr>");
        }
        stringBuilder.append("<TR><TD>Objects:</TD><TD>").append(n).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Visible:</TD><TD>").append(n2).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Selected:</TD><TD>").append(n3).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Percentile:</TD><TD>").append(NiceDataFormat.toString(d));
        stringBuilder.append("%</TD></TR>");
        this.addCustomInformation(stringBuilder);
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public InteractionArray getInteractionArray(int n) {
        Project_GUI project_GUI;
        Plot_GUI plot_GUI = this.plot.getPlot_GUI();
        if (plot_GUI != null && (project_GUI = plot_GUI.getProject_GUI()) != null) {
            return project_GUI.getInteractionArray(n, this.getGroupID());
        }
        return null;
    }

    public boolean getKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public String getLabel(byte by) {
        FloatTextWindow floatTextWindow = this.getLabelWindow(by);
        if (floatTextWindow != null) {
            return floatTextWindow.getFloatText();
        }
        return "";
    }

    public FloatTextWindow getLabelWindow(byte by) {
        return this.getLabelWindow(by, false);
    }

    public FloatTextWindow getLabelWindow(byte by, boolean bl) {
        return ((AbstractPlotBaseWindow)this.plot).getLabelWindow(by, bl);
    }

    @Override
    public AbstractAxisLayer getLayer(Double d) {
        return this.plotAxisLayerPanel.getMainLayer(d.intValue() - 1);
    }

    public final AbstractAxisLayer getLayer(int n) {
        if (this.plotAxisLayerPanel != null) {
            return this.plotAxisLayerPanel.getLayerAtIndex(n);
        }
        return null;
    }

    public final int getLayerCount() {
        if (this.plotAxisLayerPanel != null) {
            return this.plotAxisLayerPanel.getLayerCount();
        }
        return 0;
    }

    public ArrayList<LegendWindow> getLegends() {
        return this.legendList;
    }

    public List getMainLayerSynchMap() {
        return null;
    }

    public double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        boolean bl = true;
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n3; ++i) {
            double[] dArray2;
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null || !abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.hasAxisData() || (dArray2 = abstractAxisLayer.getMinmax(n))[0] > dArray2[1]) continue;
            if (bl) {
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                bl = false;
                continue;
            }
            if (dArray[0] > dArray2[0]) {
                dArray[0] = dArray2[0];
            }
            if (!(dArray[1] < dArray2[1])) continue;
            dArray[1] = dArray2[1];
        }
        return dArray;
    }

    public int getNrObjects() {
        int n = 0;
        if (this.plotAxisLayerPanel != null) {
            int n2 = this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n2; ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(i);
                if (abstractAxisLayer == null) continue;
                n += abstractAxisLayer.getNrObjects();
            }
        }
        return n;
    }

    public int getNrVisibleObjects() {
        int n = 0;
        if (this.plotAxisLayerPanel != null) {
            int n2 = this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n2; ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer == null || !abstractAxisLayer.isTopLayer()) continue;
                n += abstractAxisLayer.getNrVisibleObjects();
            }
        }
        return n;
    }

    public Color getObjectBorderColor() {
        return this.objectBorderColor;
    }

    public Color getPlotBgColor() {
        return this.plotBgColor;
    }

    public Plot_GUI getPlotGui() {
        if (this.plot == null) {
            return null;
        }
        return this.plot.getPlot_GUI();
    }

    public PlotInit getPlotInit() {
        if (this.plot == null) {
            return null;
        }
        return this.plot.getPlotInit();
    }

    public int getPlotUnderCoords(double d, double d2) {
        return 0;
    }

    public int getPrimaryMatrixTag() {
        if (this.isFoldMatrix()) {
            return this.getFoldMatrixType();
        }
        if (this.swapInteractionTag()) {
            return this.getPlotInit().getSecondaryMatrixTag();
        }
        return this.getPlotInit().getPrimaryMatrixTag();
    }

    public final AxisRange getRange(int n, int n2) {
        ArrayList<AxisRange> arrayList = this.getRanges(n);
        if (n2 <= 0 || n2 >= arrayList.size()) {
            return arrayList.get(0);
        }
        return arrayList.get(n2);
    }

    public final ArrayList<AxisRange> getRanges(int n) {
        if (n == 0) {
            return this.xRanges;
        }
        if (n == 1) {
            return this.yRanges;
        }
        return this.zRanges;
    }

    @Override
    public String getScript(boolean bl) {
        return this.plotAxisLayerPanel.getScript(bl);
    }

    public int getSecondaryMatrixTag() {
        if (this.isFoldMatrix()) {
            return 16;
        }
        if (this.swapInteractionTag()) {
            return this.getPlotInit().getPrimaryMatrixTag();
        }
        return this.getPlotInit().getSecondaryMatrixTag();
    }

    public int getSelectedObjectCount() {
        return this.selectionList.size();
    }

    public BooleanArray getSelectionArray() {
        return this.selectionArray;
    }

    public Color getSelectionColor() {
        return PerfectSpread.createTransparentColor(this.selectionColor, 255);
    }

    public AbstractAxisLayer getSelectionMainLayer() {
        AbstractAxisLayer abstractAxisLayer = null;
        for (ZoneLeaf zoneLeaf : this.selectionList) {
            AbstractAxisLayer abstractAxisLayer2 = zoneLeaf.getLayer();
            while (abstractAxisLayer2.getAxisParent() != null) {
                abstractAxisLayer2 = abstractAxisLayer2.getAxisParent();
            }
            if (abstractAxisLayer == null) {
                abstractAxisLayer = abstractAxisLayer2;
                continue;
            }
            if (abstractAxisLayer == abstractAxisLayer2) continue;
            return null;
        }
        return abstractAxisLayer;
    }

    @Override
    public PlotAxisLayerPanel getSettingsPanel() {
        return this.plotAxisLayerPanel;
    }

    public double getTickDensity(byte by) {
        return switch (by) {
            case 0 -> this.tickDensityX;
            case 1 -> this.tickDensityY;
            default -> 1.0;
        };
    }

    public FloatTextWindow getTitleWindow() {
        return ((AbstractPlotBaseWindow)this.plot).getTitleWindow();
    }

    public double getXabs() {
        return this.getRange(0, 0).getAbs();
    }

    public double getXmax() {
        return this.getRange(0, 0).getMax();
    }

    public double getXmin() {
        return this.getRange(0, 0).getMin();
    }

    public double getYabs() {
        return this.getRange(1, 0).getAbs();
    }

    public double getYmax() {
        return this.getRange(1, 0).getMax();
    }

    public double getYmin() {
        return this.getRange(1, 0).getMin();
    }

    public Color getZeroColor() {
        return this.zeroColor;
    }

    @Override
    public boolean hasInteractSecond() {
        return !this.isFoldMatrix() && this.hasZoneArray();
    }

    public boolean hasObject(Object object) {
        if (this.isCleaned() || this.plotAxisLayerPanel == null) {
            return false;
        }
        int n = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null || !abstractAxisLayer.hasObject(object)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedItems() {
        return this.selectionList != null && this.selectionList.size() > 0;
    }

    public final boolean hasVisibleLayer() {
        if (this.plotAxisLayerPanel != null) {
            return this.plotAxisLayerPanel.hasVisibleLayer();
        }
        return false;
    }

    public boolean hasZoneArrayGlobal() {
        return this.hasZoneArray();
    }

    public void hideComboBoxOfType(byte by) {
        for (int i = 0; i < this.plotAxisLayerPanel.getLayerCount(); ++i) {
            AbstractPlotSettingsBox abstractPlotSettingsBox;
            AbstractPlotSettingsBox abstractPlotSettingsBox2;
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null) {
                abstractAxisLayer = (AbstractAxisLayer)this.plotAxisLayerPanel.getLayerAtRow(i);
            }
            if (abstractAxisLayer == null || !((abstractPlotSettingsBox2 = abstractAxisLayer.getSettingsBoxMap().get(by)) instanceof AbstractPlotSettingsBox) || (abstractPlotSettingsBox = abstractPlotSettingsBox2).getParent() == null) continue;
            abstractPlotSettingsBox.getParent().setVisible(false);
        }
    }

    public void includeExclude(boolean bl) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && plotInit.getDataTreeInterface() != null) {
            DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
            if (dataTreeInterface instanceof FoldMatrix) {
                dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
            }
            int n = plotInit.getMatrix(0).getMatrixTag();
            DataSet dataSet = this.getDataSet();
            if (!(dataSet == null || dataSet.isExternal() || (n & 1) != 1 && (n & 2) != 2)) {
                boolean bl2 = (n & 1) == 1;
                AbstractDataInfo abstractDataInfo = plotInit.getDataInfo(bl2 ? 0 : 1);
                BooleanArray booleanArray = this.getIncludeExcludeArray();
                abstractDataInfo.setIncluded(booleanArray, bl, false);
            }
        }
    }

    @Override
    public boolean isAutoCreateLayerFromClass() {
        return this.autoCreateLayerFromClass;
    }

    public boolean isAutoRescale() {
        return this.plotAxisLayerPanel.isAutoRescale();
    }

    @Override
    public boolean isProtected() {
        return this.getPlotInit().plotSettings.contains("protected");
    }

    public boolean isRowPrimary() {
        AbstractDataMatrix abstractDataMatrix;
        boolean bl = this.getPlotInit().plotType == 1;
        DataTreeInterface dataTreeInterface = this.getPlotInit().getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractDataMatrix && (abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface).isModel() && (abstractDataMatrix.getMatrixTag() & 2) == 0) {
            return !bl;
        }
        return bl;
    }

    public void layerByClass(AbstractAxisLayer abstractAxisLayer, InnerColumnClass innerColumnClass, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        boolean bl2;
        if (!this.deleteExistingSubLayers(abstractAxisLayer)) {
            return;
        }
        this.beginUpdate();
        ClassTypes classTypes = innerColumnClass.getObject();
        int n5 = classTypes.size();
        int n6 = this.getPrimaryMatrixTag();
        boolean bl3 = bl == (n6 == 1);
        int n7 = this.plotAxisLayerPanel.getFoldN();
        ArrayList<LeafList> arrayList = new ArrayList<LeafList>(n5);
        for (int i = n5; i > 0; --i) {
            arrayList.add(new LeafList());
        }
        ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer.getSettingsBoxMap().get((byte)3);
        boolean bl4 = bl2 = comboBoxColor != null && comboBoxColor.getSelectedType() != 8;
        if (bl2) {
            comboBoxColor.setSelected(1, 0);
            comboBoxColor.setFixedColor(PerfectSpread.generateColor(0));
        }
        List<ZoneLeaf> list = abstractAxisLayer.getRootList();
        for (n4 = 0; n4 < list.size(); ++n4) {
            int n8;
            object = list.get(n4);
            if (!bl3 || ((ZoneLeaf)object).getType() == 0) {
                int n9 = bl3 ? ((ZoneLeaf)object).getPrimaryIndex() : ((ZoneLeaf)object).getSecondaryIndex();
                n8 = -1;
                if (n9 < 0 || (n8 = (int)innerColumnClass.getValueShort(n9)) < 0 || n8 >= arrayList.size()) continue;
                ((LeafList)arrayList.get(n8)).add(object);
                continue;
            }
            ZoneArray zoneArray = (ZoneArray)object;
            n8 = zoneArray.getNoChildren();
            int n10 = ((ZoneLeaf)object).getSecondaryIndex();
            for (n3 = 0; n3 < n8; ++n3) {
                LeafList leafList;
                n2 = this.isFoldMatrix() ? zoneArray.getPrimaryIndex(n3) * n7 + n10 : zoneArray.getPrimaryIndex(n3);
                if (n2 < 0 || (n = innerColumnClass.getValueShort(n2)) < 0 || n >= arrayList.size() || !(leafList = (LeafList)arrayList.get(n)).isEmpty() && leafList.get(leafList.size() - 1) == zoneArray) continue;
                leafList.add(zoneArray);
            }
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            ComboBoxColor comboBoxColor2;
            Object object2;
            object = (LeafList)arrayList.get(n4);
            if (((ArrayList)object).isEmpty()) continue;
            if (((ZoneLeaf)((ArrayList)object).get(0)).getType() != 0) {
                if (bl3) {
                    object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        ZoneLeaf zoneLeaf = (ZoneLeaf)object2.next();
                        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                        n2 = zoneArray.getNoChildren();
                        n3 = zoneArray.getSecondaryIndex();
                        for (int i = 0; i < n2; ++i) {
                            n = this.isFoldMatrix() ? zoneArray.getPrimaryIndex(i) * n7 + n3 : zoneArray.getPrimaryIndex(i);
                            short s = innerColumnClass.getValueShort(n);
                            zoneArray.setTagged(i, n4 == s);
                        }
                    }
                } else {
                    object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        ZoneLeaf zoneLeaf = (ZoneLeaf)object2.next();
                        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                        zoneArray.setTagged(true);
                    }
                }
            }
            if ((comboBoxColor2 = (ComboBoxColor)((AbstractAxisLayer)(object2 = abstractAxisLayer.moveIntoNewLayer((LeafList)object, classTypes.getTypeDescription(n4), n4 + 1, false))).getSettingsBoxMap().get((byte)3)) == null || !bl2) continue;
            comboBoxColor2.setFixedColor(PerfectSpread.generateColor(n4));
            comboBoxColor2.setSelectedChild();
        }
        this.endUpdate((byte)7);
        this.plotAxisLayerPanel.expandChildRowsForLayer(abstractAxisLayer);
        this.plotAxisLayerPanel.updateTable();
    }

    public Object[] list(String string) {
        if (string.equalsIgnoreCase("layer")) {
            int n = this.plotAxisLayerPanel.getMainLayerCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.plotAxisLayerPanel.getMainLayer(i);
            }
            return objectArray;
        }
        return null;
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (this.keepAspectRatio) {
            this.adjustToAspectRatio();
        }
        super.makeScreenShot(graphics2D, bl, bl2);
    }

    public void modelUpdated() {
    }

    public void moveSelectionIntoLayer(AbstractAxisLayer abstractAxisLayer) {
        abstractAxisLayer.includePoints(new LeafList(this.selectionList), null);
    }

    public AbstractAxisLayer moveSelectionIntoNewLayer(AbstractAxisLayer abstractAxisLayer) {
        int n = this.plotAxisLayerPanel.getSubNumber(abstractAxisLayer);
        String string = JOptionPane.showInputDialog("Select name for the new layer", (Object)(String.valueOf(abstractAxisLayer) + "." + n));
        if (string != null) {
            return this.moveSelectionIntoNewLayer(abstractAxisLayer, string, n);
        }
        return null;
    }

    public AbstractAxisLayer moveSelectionIntoNewLayer(AbstractAxisLayer abstractAxisLayer, String string, int n) {
        return abstractAxisLayer.moveIntoNewLayer(new LeafList(this.selectionList), string, n, true);
    }

    public void PanContinues(double d, double d2, int n) {
        this.getRange(0, n).pan(d);
        this.getRange(1, n).pan(d2);
    }

    @Override
    public void prepareInteraction() {
        InteractionArray interactionArray;
        boolean bl = this.isFoldMatrix();
        boolean bl2 = this.hasInteractSecond();
        int n = this.getPrimaryMatrixTag();
        int n2 = this.getSecondaryMatrixTag();
        int n3 = this.getGroupID();
        int n4 = this.getSize(n);
        if (n4 <= 0) {
            return;
        }
        byte by = this.getParentBaseWindow().getSelectionType();
        if (by == 3) {
            this.getInteractionArray(this.getInteractionRoot(n), n, 0, n3);
            if (bl2) {
                this.getInteractionArray(this.getInteractionRoot(n2), n2, 0, n3);
            }
            return;
        }
        InteractionArray interactionArray2 = this.getInteractionArray(this.getInteractionRoot(n), n, n4, n3);
        InteractionArray interactionArray3 = interactionArray = bl2 ? this.getInteractionArray(this.getInteractionRoot(n2), n2, this.getSize(n2), n3) : null;
        if (by == 0) {
            this.setPrimaryArray(interactionArray2);
            if (bl2 && interactionArray != null) {
                for (int i = 0; i < this.selectionArray.size(); ++i) {
                    interactionArray.set(i, this.selectionArray.get(i));
                }
            }
        } else {
            int n5;
            int n6 = this.plotAxisLayerPanel.getMainLayerCount();
            for (n5 = 0; n5 < n6; ++n5) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(n5);
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int i = 0; i < list.size(); ++i) {
                    int n7;
                    ZoneArray zoneArray;
                    int n8;
                    int n9;
                    ZoneLeaf zoneLeaf = list.get(i);
                    if (by == 1 || !zoneLeaf.isSelected()) {
                        if (bl2 || bl) {
                            n9 = zoneLeaf.getSecondaryIndex();
                            if (bl) {
                                n8 = this.plotAxisLayerPanel.getFoldN();
                                zoneArray = (ZoneArray)zoneLeaf;
                                for (n7 = 0; n7 < zoneArray.getNoChildren(); ++n7) {
                                    if (!zoneArray.isVisibleAndNotMissing(n7)) continue;
                                    interactionArray2.set(zoneArray.getPrimaryIndex(n7) * n8 + n9);
                                }
                                continue;
                            }
                            interactionArray2.set(n9);
                            continue;
                        }
                        interactionArray2.set(zoneLeaf.getPrimaryIndex());
                        continue;
                    }
                    if (by != 2 || !bl) continue;
                    n9 = this.plotAxisLayerPanel.getFoldN();
                    n8 = zoneLeaf.getSecondaryIndex();
                    zoneArray = (ZoneArray)zoneLeaf;
                    for (n7 = 0; n7 < zoneArray.getNoChildren(); ++n7) {
                        if (!zoneArray.isVisibleAndNotMissing(n7) || zoneArray.isSelected(n7)) continue;
                        interactionArray2.set(zoneArray.getPrimaryIndex(n7) * n9 + n8);
                    }
                }
            }
            if (bl2) {
                for (n5 = 0; n5 < this.selectionArray.size(); ++n5) {
                    interactionArray.set(n5, by == 1 || !this.selectionArray.get(n5));
                }
            }
        }
        if (n == 1 && n3 != 0) {
            this.doInteractionGroup(interactionArray2);
        }
    }

    @Override
    public void removeArea(FloatWindow floatWindow) {
        super.removeArea(floatWindow);
        if (floatWindow instanceof LegendWindow) {
            floatWindow.cleanUp();
            this.legendList.remove(floatWindow);
        }
    }

    public void repaintLegends() {
        for (LegendWindow legendWindow : this.legendList) {
            legendWindow.contentPaint((byte)7);
        }
    }

    public final boolean repaintPlot(byte by) {
        return this.repaintPlot(by, true);
    }

    public final boolean repaintPlot(byte by, boolean bl) {
        if (this.isOptimize3D) {
            this.repaint();
        }
        if (!this.isCreated() || this.isCleaned()) {
            return false;
        }
        boolean bl2 = this.contentPaint(by);
        this.updateLegends();
        this.updateDescriptionTextBox();
        return bl2;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        Object object;
        int n;
        super.SaveProperty(randomOutputStream);
        String string = randomOutputStream.getPrefix();
        for (n = 0; n < 3; ++n) {
            randomOutputStream.setPrefix(string + n);
            object = this.getRanges(n);
            randomOutputStream.writePropertyInt("nRan", ((ArrayList)object).size());
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                randomOutputStream.setPrefix(string + n + i);
                ((ArrayList)object).get(i).SaveProperty(randomOutputStream);
            }
        }
        randomOutputStream.setPrefix(string);
        randomOutputStream.writePropertyInt("plotBgC", this.getPlotBgColor().getRGB());
        randomOutputStream.writePropertyInt("axisC", this.getAxisColor().getRGB());
        randomOutputStream.writePropertyFloat("awidth", this.axisStroke.getLineWidth());
        randomOutputStream.writePropertyInt("gridC", this.getGridColor().getRGB());
        randomOutputStream.writePropertyFloat("gwidth", this.gridStroke.getLineWidth());
        randomOutputStream.writePropertyInt("borderC", this.getObjectBorderColor().getRGB());
        if (this.getZeroColor() != null) {
            randomOutputStream.writePropertyInt("zeroC", this.getZeroColor().getRGB());
        }
        randomOutputStream.writePropertyInt("selC", this.getSelectionColor().getRGB());
        randomOutputStream.writePropertyBoolean("sborder", this.showBorders);
        randomOutputStream.writePropertyBoolean("sgrids", this.showGrid);
        randomOutputStream.writePropertyBoolean("sticks", this.showTicks);
        randomOutputStream.writePropertyBoolean("zlines", this.showZeroLines);
        randomOutputStream.writePropertyDouble("xden", this.tickDensityX);
        randomOutputStream.writePropertyDouble("yden", this.tickDensityY);
        randomOutputStream.writePropertyInt("legendNo", this.legendList.size());
        n = 0;
        object = this.legendList.iterator();
        while (object.hasNext()) {
            randomOutputStream.writePropertyNode("legendW" + String.valueOf(n == 0 ? "" : Integer.valueOf(n + 1)), (DataTreeInterface)object.next());
            ++n;
        }
        randomOutputStream.writePropertyBoolean("aspRat", this.keepAspectRatio);
        randomOutputStream.writePropertyBoolean("autoclass", this.autoCreateLayerFromClass);
        this.plotAxisLayerPanel.SaveProperty(randomOutputStream);
    }

    public void selectedItems(SelectionList selectionList, boolean bl, boolean bl2) {
        for (ZoneLeaf zoneLeaf : selectionList) {
            if (!bl || zoneLeaf.getType() == 0) {
                zoneLeaf.setSelected(bl);
                continue;
            }
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            zoneArray.selectTagged(bl);
        }
        if (!bl) {
            selectionList.clear();
        }
        if (bl2 && this.selectionList != null && this.plot.hasInteractivity()) {
            this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
        }
    }

    public void selectLayer(AbstractAxisLayer abstractAxisLayer, boolean bl) {
        if (!bl) {
            this.selectedItems(this.selectionList, false, false);
        }
        abstractAxisLayer.selectLayer(this.selectionList);
        this.plot.getProject_GUI().doInteraction(this);
        this.repaintPlot((byte)2);
    }

    public abstract void selectNnearest(int var1, int var2);

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        return switch (by) {
            case 0, 6 -> this.plotAxisLayerPanel.SendGlobalMessage(by, by2);
            default -> super.SendGlobalMessage(by, by2);
        };
    }

    public void setAccessorPanel(JPanel jPanel) {
        this.plotAxisLayerPanel.setAccessorPanel(jPanel);
    }

    public void setAutoRescale(boolean bl) {
        this.plotAxisLayerPanel.setAutoRescale(bl);
        if (bl) {
            this.calculateAndRepaintSetAxis(false, true);
        }
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public void setAxisWidth(float f) {
        this.axisStroke = new BasicStroke(f, 0, 0, 10.0f);
    }

    @Override
    public void setContentReady(boolean bl) {
        super.setContentReady(bl);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.plotAxisLayerPanel.setCreated(abstractWindow_GUI, bl);
        this.plotAxisLayerPanel.setWindow(this.getParentBaseWindow());
        if (bl) {
            this.calculateAndRepaintSetAxis(false, false);
        }
        PlotInit plotInit = this.getPlotInit();
        if (!bl && plotInit != null) {
            this.plotAxisLayerPanel.newPlot(plotInit);
        }
        if (bl) {
            if (this.recalcLoaded) {
                this.plotAxisLayerPanel.recalculateAllLayers();
                this.calculateBuildAndRepaint();
            } else {
                this.repaintPlot((byte)7);
            }
        } else {
            this.calculateBuildAndRepaint();
        }
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setGridWidth(float f) {
        this.gridStroke = new BasicStroke(f, 0, 0, 10.0f);
    }

    @Override
    public void setInteractionFlag(byte by) {
        byte by2 = this.plot.getInteractionFlag();
        int n = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (!abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.isLayerReady()) continue;
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int j = 0; j < list.size(); ++j) {
                ZoneLeaf zoneLeaf = list.get(j);
                if (by != 2) {
                    if (this.plot.hasInteractivity() && by2 == 2 && zoneLeaf.isVisible() && !zoneLeaf.isSelected()) {
                        if (zoneLeaf.getType() == 0) {
                            zoneLeaf.setSelected(true);
                        } else {
                            ((ZoneArray)zoneLeaf).selectVisibleToSelected();
                        }
                        this.selectionList.add(zoneLeaf);
                    }
                    zoneLeaf.setVisible(true);
                    continue;
                }
                if (zoneLeaf.getType() == 0) {
                    zoneLeaf.setVisible(zoneLeaf.isSelected());
                    continue;
                }
                ((ZoneArray)zoneLeaf).selectSelectedToVisible();
            }
        }
        if (by == 2) {
            this.selectedItems(this.selectionList, false, true);
        }
        this.repaintPlot((byte)7, false);
    }

    public void setKeepAspectRatio(boolean bl) {
        this.keepAspectRatio = bl;
        if (bl) {
            this.adjustToAspectRatio();
        } else {
            this.calculateBuildAndRepaint();
        }
    }

    public void setLabel(byte by, String string) {
        FloatTextWindow floatTextWindow = this.getLabelWindow(by, string != null && string.length() > 0);
        if (floatTextWindow != null) {
            floatTextWindow.setFloatText(string);
        }
    }

    @Override
    public void setLayerOrder(AbstractAxisLayer abstractAxisLayer, Double[] doubleArray) {
        this.plotAxisLayerPanel.setLayerOrder(abstractAxisLayer, doubleArray);
    }

    public void setObjectBorderColor(Color color) {
        this.objectBorderColor = color;
    }

    public void setPlotBgColor(Color color) {
        this.plotBgColor = color;
    }

    @Override
    public BooleanArray setPrimaryArray(BooleanArray booleanArray) {
        Iterator iterator = this.selectionList.iterator();
        boolean bl = this.isFoldMatrix();
        boolean bl2 = this.hasInteractSecond();
        if (booleanArray == null) {
            int n = this.getSize(this.getPrimaryMatrixTag());
            booleanArray = new BooleanArray(n);
        }
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
            if (!zoneLeaf.isSelected()) continue;
            if (bl2 || bl) {
                int n = zoneLeaf.getSecondaryIndex();
                if (bl) {
                    int n2;
                    ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                    if (bl) {
                        n2 = this.plotAxisLayerPanel.getFoldN();
                        for (int i = 0; i < zoneArray.getNoChildren(); ++i) {
                            if (!zoneArray.isSelected(i)) continue;
                            booleanArray.set(zoneArray.getPrimaryIndex(i) * n2 + n);
                        }
                        continue;
                    }
                    for (n2 = 0; n2 < zoneArray.getNoChildren(); ++n2) {
                        if (!zoneArray.isTagged(n2)) continue;
                        booleanArray.set(zoneArray.getPrimaryIndex(n2));
                    }
                    continue;
                }
                booleanArray.set(n);
                continue;
            }
            booleanArray.set(zoneLeaf.getPrimaryIndex());
        }
        return booleanArray;
    }

    public void setRangesLocked(boolean bl) {
        this.rangesLocked = bl;
    }

    @Override
    public BooleanArray setSecondaryArray(BooleanArray booleanArray) {
        int n = this.getSize(this.getSecondaryMatrixTag());
        BooleanArray booleanArray2 = new BooleanArray(n);
        for (int i = 0; i < this.selectionArray.size(); ++i) {
            booleanArray2.set(i, this.selectionArray.get(i));
        }
        return booleanArray2;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = PerfectSpread.createTransparentColor(color, 100);
    }

    @Override
    public void setSettingBoxOption(byte by, Object[] objectArray) {
        this.plotAxisLayerPanel.setSettingBoxOption(by, objectArray);
    }

    @Override
    public Object getSettingBoxSelectedItem(byte by) {
        return this.plotAxisLayerPanel.getSettingBoxSelectedItem(by);
    }

    public void setShowBorders(boolean bl) {
        this.showBorders = bl;
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    public void setShowTicks(boolean bl) {
        this.showTicks = bl;
    }

    public void setShowZeroLines(boolean bl) {
        this.showZeroLines = bl;
    }

    public void setTickDensity(byte by, double d) {
        switch (by) {
            case 0: {
                this.tickDensityX = d;
                break;
            }
            case 1: {
                this.tickDensityY = d;
                break;
            }
        }
    }

    public void setTitle(String string) {
        this.plot.setPlotTitle(string);
        this.plotAxisLayerPanel.setWindow(this.plot);
    }

    public void setTrainTest(DataSet dataSet, AbstractDataInfo abstractDataInfo, boolean bl) {
        this.setTrainTest(dataSet, abstractDataInfo, bl, false, false);
    }

    public void setTrainTest(DataSet dataSet, AbstractDataInfo abstractDataInfo, boolean bl, boolean bl2, boolean bl3) {
        BooleanArray booleanArray = this.getIncludeExcludeArray();
        Train train = (Train)abstractDataInfo.getGroupColumnByType(4);
        Test test = (Test)abstractDataInfo.getGroupColumnByType(5);
        if (bl2) {
            ((InnerColumnBoolean)train.getPrimaryColumn()).fillColumn(false);
        }
        for (int i = 0; i < booleanArray.size(); ++i) {
            if (!booleanArray.get(i)) continue;
            train.setIncluded(i, bl);
            if (bl3) continue;
            test.setIncluded(i, !bl);
        }
        dataSet.updateReferences();
    }

    public void setTrainTest(ProgressManager progressManager, boolean bl, boolean bl2) {
        this.setTrainTest(progressManager, bl, bl2, true);
    }

    public void setTrainTest(ProgressManager progressManager, boolean bl, boolean bl2, boolean bl3) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit != null && plotInit.getDataTreeInterface() != null) {
            DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
            if (dataTreeInterface instanceof FoldMatrix) {
                dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
            }
            int n = plotInit.getMatrix(0).getMatrixTag();
            DataSet dataSet = this.getDataSet();
            if (!(dataSet == null || dataSet.isExternal() || (n & 1) != 1 && (n & 2) != 2)) {
                boolean bl4 = (n & 1) == 1;
                AbstractDataInfo abstractDataInfo = plotInit.getDataInfo(bl4 ? 0 : 1);
                this.setTrainTest(dataSet, abstractDataInfo, bl, bl2, bl3);
                dataSet.doUpdate(progressManager);
            }
        }
    }

    public void setZeroColor(Color color) {
        this.zeroColor = color;
    }

    public void show(String string, Double d) {
        boolean bl;
        boolean bl2 = bl = d.intValue() != 0;
        if (string.equalsIgnoreCase("grid")) {
            this.showGrid = bl;
        } else if (string.equalsIgnoreCase("ticks")) {
            this.showTicks = bl;
        } else if (string.equalsIgnoreCase("zerolines")) {
            this.showZeroLines = bl;
        } else if (string.equalsIgnoreCase("borders")) {
            this.showBorders = bl;
        } else if (string.equalsIgnoreCase("tickdenistyX")) {
            this.setTickDensity((byte)0, d);
        } else if (string.equalsIgnoreCase("tickdenistyY")) {
            this.setTickDensity((byte)1, d);
        } else if (string.equalsIgnoreCase("aspectratio")) {
            this.setKeepAspectRatio(d.intValue() == 1);
            this.contentPaint((byte)7);
        } else if (string.equalsIgnoreCase("autorescale")) {
            this.setAutoRescale(d.intValue() == 1);
        } else {
            AxisRange axisRange = this.getRange(0, 0);
            AxisRange axisRange2 = this.getRange(1, 0);
            if (string.equalsIgnoreCase("xmax")) {
                axisRange.setMinMax(axisRange.getMin(), d);
            } else if (string.equalsIgnoreCase("xmin")) {
                axisRange.setMinMax(d, axisRange.getMax());
            } else if (string.equalsIgnoreCase("ymax")) {
                axisRange2.setMinMax(axisRange2.getMin(), d);
            } else if (string.equalsIgnoreCase("ymin")) {
                axisRange2.setMinMax(d, axisRange2.getMax());
            }
        }
    }

    public boolean showBorders() {
        return this.showBorders;
    }

    public boolean showGrid() {
        return this.showGrid;
    }

    public boolean showTicks() {
        return this.showTicks;
    }

    public boolean showZeroLines() {
        return this.showZeroLines;
    }

    public boolean supportsTickDensity(byte by) {
        return true;
    }

    public double[] translateToPlotRelative(double d, double d2) {
        return new double[]{0.0, 0.0};
    }

    public double[] translateToScreenDouble(double[] dArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
        return new double[]{0.0, 0.0};
    }

    public void updateLables() {
        boolean bl = this.hasAutoText((byte)0);
        boolean bl2 = this.hasAutoText((byte)1);
        boolean bl3 = this.hasAutoText((byte)2);
        boolean bl4 = this instanceof FloatWindowScatter;
        if (this.isCreated() && (bl || bl2 || bl3)) {
            Object object = "";
            Object object2 = "";
            Object object3 = "";
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = true;
            int n = this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n; ++i) {
                String string;
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(i);
                if (abstractAxisLayer == null || !abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.hasAxisData()) continue;
                if (bl && !(string = abstractAxisLayer.getDataDescription((byte)0, bl4)).equals("")) {
                    if (bl5) {
                        object = string;
                        bl5 = false;
                    } else if (!((String)object).equals(string)) {
                        object = (String)object + "/" + string;
                    }
                }
                if (bl2 && !(string = abstractAxisLayer.getDataDescription((byte)1, bl4)).equals("")) {
                    if (bl6) {
                        object2 = string;
                        bl6 = false;
                    } else if (!((String)object2).equals(string)) {
                        object2 = (String)object2 + "/" + string;
                    }
                }
                if (!bl3 || (string = abstractAxisLayer.getDataDescription((byte)2, bl4)).equals("")) continue;
                if (bl7) {
                    object3 = string;
                    bl7 = false;
                    continue;
                }
                object3 = (String)object3 + "/" + string;
            }
            if (bl) {
                this.setAutoTextX((String)object);
            }
            if (bl2) {
                this.setAutoTextY((String)object2);
            }
            if (bl3) {
                this.setAutoTextZ((String)object3);
            }
        }
    }

    public void updateLayerPanel() {
        if (this.plotAxisLayerPanel != null) {
            this.plotAxisLayerPanel.repaintTable();
        }
    }

    public void updateLegend(LegendWindow legendWindow, int n) {
        try {
            if (!this.plot.hasWindow(legendWindow)) {
                this.plot.addWindow(legendWindow, 1, legendWindow.getWindowLayout());
            }
            if (legendWindow.getWindowLayout() != n) {
                legendWindow.setWindowLayout(n);
                this.baseWindow.autoLayout();
            }
            if (!this.legendList.contains(legendWindow)) {
                this.legendList.add(legendWindow);
            }
        }
        catch (LayoutException layoutException) {
            ErrorHandler.logAndReportException(layoutException);
        }
    }

    public void updateLegends() {
        if (this.plot != null) {
            this.plot.updateLegends();
        }
    }

    @Override
    public void zoomAll() {
        if (this.isOptimize3D || this.isCreated()) {
            this.updateLables();
            this.calculateAxisTicks(0, false, true);
            this.calculateAxisTicks(1, false, true);
            this.calculateAxisTicks(2, false, true);
            if (this.keepAspectRatio) {
                this.adjustToAspectRatio();
            }
            this.repaintPlot((byte)7);
        }
    }

    public void ZoomContinues(double d, double d2, double d3, int n) {
        this.getRange(0, n).zoom(d, d3);
        this.getRange(1, n).zoom(d2, d3);
    }

    protected void addCustomInformation(StringBuilder stringBuilder) {
    }

    protected void adjustToAspectRatio() {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.selectionList.clear();
        if (this.plotAxisLayerPanel != null) {
            this.plotAxisLayerPanel.cleanUp();
            this.plotAxisLayerPanel = null;
        }
        this.selectionArray = null;
        for (int i = this.legendList.size() - 1; i >= 0; --i) {
            this.legendList.get(i).cleanUp();
        }
        this.legendList.clear();
        this.quickLeaf = null;
    }

    protected abstract AbstractAxisLayer createLayer(PlotInit var1, int var2);

    protected void doInteractionByFold(AbstractAxisLayer abstractAxisLayer, BooleanArray booleanArray) {
        try {
            int n = abstractAxisLayer.getFoldN();
            boolean bl = (this.plot.getInteractionFlag() & 2) != 0;
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int i = 0; i < list.size(); ++i) {
                ZoneArray zoneArray = (ZoneArray)list.get(i);
                int n2 = zoneArray.getSecondaryIndex();
                boolean bl2 = false;
                for (int j = 0; j < zoneArray.getNoChildren(); ++j) {
                    int n3 = zoneArray.getPrimaryIndex(j);
                    boolean bl3 = booleanArray.get(n3 * n + n2);
                    if (bl) {
                        zoneArray.setVisible(j, bl3);
                        continue;
                    }
                    zoneArray.setSelected(j, bl3);
                    if (!bl3) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                this.selectionList.add(zoneArray);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
            Logg.warn("ConcurrentModificationException: ", concurrentModificationException.getMessage());
        }
    }

    protected void doInteractionGroup(InteractionArray interactionArray) {
        int[] nArray;
        AbstractDataMatrix abstractDataMatrix;
        int[] nArray2;
        PlotInit plotInit = this.getPlotInit();
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeParent();
        if (dataTreeInterface instanceof AbstractDataMatrix && (nArray2 = (abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface).getGroup(nArray = interactionArray.createReferenceArray())) != null) {
            int n = -1;
            for (int n2 : nArray2) {
                if (n2 <= n) continue;
                n = n2;
            }
            Object object = this.getInteractionArray(this.getInteractionRoot(1), 1, ++n, 0);
            for (int n3 : nArray2) {
                ((BooleanArray)object).set(n3);
            }
            return;
        }
        if (dataTreeInterface2 instanceof InteractionGroupInterface) {
            ((InteractionGroupInterface)((Object)dataTreeInterface2)).doInteractionGroup(interactionArray);
        }
    }

    protected int getFoldMatrixType() {
        return this.plotAxisLayerPanel.getFoldMatrixType();
    }

    protected int getGroupID() {
        return this.getPlotInit().getGroupID();
    }

    protected final InnerColumnBoolean getIncludeColumn(AbstractAxisLayer abstractAxisLayer) {
        IncExclude incExclude;
        AbstractDataInfo abstractDataInfo = this.getModelDataInfo(abstractAxisLayer.getPlotInit());
        if (abstractDataInfo != null && (incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1)) != null) {
            return (InnerColumnBoolean)incExclude.getPrimaryColumn();
        }
        return null;
    }

    protected InteractionArray getInteractionArray(DataTreeInterface dataTreeInterface, int n, int n2, int n3) {
        return this.plot.getPlot_GUI().getProject_GUI().getInteractionArray(dataTreeInterface, n, n2, n3);
    }

    public InteractionArray getInteractionArray(int n, int n2) {
        return this.plot.getPlot_GUI().getProject_GUI().getInteractionArray(n, n2);
    }

    protected DataTreeInterface getInteractionRoot(int n) {
        DataTreeInterface dataTreeInterface = this.getPlotInit().getDataTreeInterface();
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            switch (n) {
                case 1: 
                case 2: {
                    return abstractDataMatrix.getCase();
                }
                case 8: {
                    DataTreeInterface dataTreeInterface2;
                    if (dataTreeInterface instanceof FoldMatrix) {
                        dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
                    }
                    if ((dataTreeInterface2 = dataTreeInterface.getTreeParent()) instanceof AbstractModel) {
                        return dataTreeInterface2;
                    }
                    return dataTreeInterface2.getTreeParent();
                }
                case 4: {
                    return abstractDataMatrix;
                }
            }
        }
        return null;
    }

    protected ZoneLeaf getLeafAtIndex(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        if (abstractAxisLayer != null && abstractAxisLayer.isLayerReady()) {
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int i = 0; i < list.size(); ++i) {
                ZoneLeaf zoneLeaf = list.get(i);
                if (zoneLeaf instanceof ZoneArray) {
                    if (zoneLeaf.getSecondaryIndex() != n2) continue;
                    ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                    zoneArray.tagByPrimaryIndex(n);
                    return zoneArray;
                }
                if (zoneLeaf.getPrimaryIndex() != n) continue;
                return zoneLeaf;
            }
        }
        return null;
    }

    protected int getOriginalSize(boolean bl) {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit == null || plotInit.getMatrix(0) == null) {
            return 0;
        }
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        return abstractDataMatrix.getOrigSize(plotInit.plotType);
    }

    protected abstract int getPlotDepth();

    protected abstract int getPlotHeight();

    protected abstract int getPlotWidth();

    protected int getSize(int n) {
        int n2 = this.getLayerCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            AbstractAxisLayer abstractAxisLayer = this.getLayer(i);
            if (abstractAxisLayer == null || (n4 = abstractAxisLayer.getSize(n)) <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    protected boolean hasAutoText(byte by) {
        FloatTextWindow floatTextWindow = this.getLabelWindow(by);
        if (floatTextWindow == null) {
            return by == 0 || by == 1;
        }
        return floatTextWindow.hasAutoText();
    }

    protected boolean hasZoneArray() {
        return false;
    }

    @Override
    protected void init(final AbstractPlotLayout abstractPlotLayout) {
        Cloneable cloneable;
        Cloneable cloneable2;
        super.init(abstractPlotLayout);
        if (abstractPlotLayout != null && abstractPlotLayout.getPlotInit() != null && (cloneable2 = this.getModelDataInfo(abstractPlotLayout.getPlotInit())) != null) {
            ((AbstractDataInfo)cloneable2).addListener(this);
            if (this.hasZoneArray() && (cloneable = ((AbstractDataInfo)cloneable2).getOtherDataInfo()) != null) {
                ((AbstractDataInfo)cloneable).addListener(this);
            }
        }
        cloneable2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                DataSet dataSet = AbstractAxisPlot.this.getDataSet();
                boolean bl2 = bl = (AbstractAxisPlot.this.getPlotInit().getMatrix(0).getMatrixTag() & 1) == 1;
                AbstractDataInfo abstractDataInfo = dataSet != null ? dataSet.getDataInfo(bl ? 0 : 1) : null;
                Transformations transformations = abstractDataInfo.getTransformationNode();
                for (int i = transformations.getColumnCount() - 1; i >= 0; --i) {
                    AbstractTransform abstractTransform = transformations.getTransform(i);
                    if (!(abstractTransform instanceof Category)) continue;
                    ((Category)abstractTransform).createNewSubClass(AbstractAxisPlot.this);
                    break;
                }
            }
        };
        cloneable = new AbstractAction(this){
            final /* synthetic */ AbstractAxisPlot this$0;
            {
                this.this$0 = abstractAxisPlot;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolutionDialog resolutionDialog = new ResolutionDialog(abstractPlotLayout.getWidth(), abstractPlotLayout.getHeight(), "Copy");
                if (resolutionDialog.showModal()) {
                    BufferedImage bufferedImage = abstractPlotLayout.makeBufferedImageScreenShot(resolutionDialog.getResolutionWidth(), resolutionDialog.getResolutionHeight(), resolutionDialog.isIncludeSelection());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new ImgSel(bufferedImage), null);
                }
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(67, 2), (Action)((Object)cloneable));
        AbstractAction abstractAction = new AbstractAction(this){
            final /* synthetic */ AbstractAxisPlot this$0;
            {
                this.this$0 = abstractAxisPlot;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractPlotLayout.showSelectionDialog();
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(70, 2), abstractAction);
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(78, 3), (Action)((Object)cloneable2));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeItem(true, 0);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(39, 0), abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeItem(false, 0);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(37, 0), abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeItem(true, 1);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(38, 0), abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeItem(false, 1);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(40, 0), abstractAction5);
        AbstractAction abstractAction6 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeAllItems(true);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(521, 0), abstractAction6);
        AbstractAction abstractAction7 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.plotAxisLayerPanel.changeAllItems(false);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(45, 0), abstractAction7);
        AbstractAction abstractAction8 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSet dataSet = AbstractAxisPlot.this.getDataSet();
                if (dataSet != null) {
                    dataSet.doUpdate(null);
                }
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(116, 0), abstractAction8);
        AbstractAction abstractAction9 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.addDefaultLegend();
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(76, 2), abstractAction9);
        AbstractAction abstractAction10 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.includeExclude(true);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(73, 0), abstractAction10);
        AbstractAction abstractAction11 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAxisPlot.this.includeExclude(false);
            }
        };
        abstractPlotLayout.registerKeyAction(KeyStroke.getKeyStroke(69, 0), abstractAction11);
    }

    protected void interactiveSelectionFinished(byte by) {
        this.repaintPlot(by, false);
    }

    protected boolean isFoldMatrix() {
        return this.plotAxisLayerPanel.isFoldMatrix();
    }

    protected boolean isSAM() {
        if (this.plotAxisLayerPanel.getLayerCount() == 1) {
            AbstractAxisLayer abstractAxisLayer = (AbstractAxisLayer)this.plotAxisLayerPanel.getLayerAtRow(0);
            try {
                if (abstractAxisLayer != null) {
                    return abstractAxisLayer.getPlotInit().getMatrix(0).toString().contains("SAM matrix");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void openProjectLink(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null) {
            PlotInit plotInit = this.getPlotInit();
            int n = plotInit.getMatrix(0).getMatrixTag();
            int n2 = zoneLeaf.getPrimaryIndex();
            boolean bl = (n & 1) == 1;
            AbstractDataInfo abstractDataInfo = plotInit.getDataInfo(bl ? 0 : 1);
            Main_GUI main_GUI = Main_GUI.get();
            main_GUI.openProjectLink(abstractDataInfo, n, n2);
        }
    }

    @Override
    protected boolean resizeLayout(boolean bl) {
        boolean bl2 = super.resizeLayout(bl);
        if (bl) {
            this.calculateAndRepaintSetAxis(false, false);
        }
        return bl2;
    }

    protected void setAutoTextX(String string) {
        this.setLabel((byte)0, string);
    }

    protected void setAutoTextY(String string) {
        this.setLabel((byte)1, string);
    }

    protected void setAutoTextZ(String string) {
        this.setLabel((byte)2, string);
    }

    protected void setupDragContribution() {
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        if (abstractDataMatrix != null && (abstractDataMatrix.getMatrixTag() & 1) != 0) {
            new ContributionDragListener(this, this.selectionList);
        }
    }

    protected boolean shouldInteract(InteractionArray interactionArray, InteractionArray interactionArray2) {
        DataTreeInterface dataTreeInterface = interactionArray != null ? interactionArray.getRoot() : null;
        DataTreeInterface dataTreeInterface2 = interactionArray2 != null ? interactionArray2.getRoot() : null;
        return this.sharesParent(dataTreeInterface) || this.sharesParent(dataTreeInterface2);
    }

    protected boolean showLayerPanel() {
        return true;
    }

    protected boolean swapInteractionTag() {
        return this.hasInteractSecond() && !this.isFoldMatrix();
    }

    private void addDefaultLegend() {
        AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getMainLayer(0);
        if (abstractAxisLayer != null) {
            LegendWindow legendWindow = new LegendWindow(this.getParentBaseWindow());
            legendWindow.setWindowLayout(3);
            legendWindow.setLegendInterface(abstractAxisLayer.getComboBoxLegend((byte)3));
            this.updateLegend(legendWindow, legendWindow.getWindowLayout());
        }
    }

    private boolean deleteExistingSubLayers(AbstractAxisLayer abstractAxisLayer) {
        DefaultMutableTreeNode defaultMutableTreeNode = abstractAxisLayer.getLayerNode();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            if (JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Layer already has sublayers.\nIf you continue these will be removed\nContinue?", "Layer has sublayers", 0, 2) != 0) {
                return false;
            }
            for (int i = defaultMutableTreeNode.getChildCount() - 1; i >= 0; --i) {
                this.plotAxisLayerPanel.removeRecursize((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), abstractAxisLayer);
            }
        }
        return true;
    }

    private BooleanArray getIncludeExcludeArray() {
        if (this instanceof FloatWindowSpectral) {
            return this.selectionArray;
        }
        return this.setPrimaryArray(null);
    }

    private final AbstractDataInfo getModelDataInfo(PlotInit plotInit) {
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        if (dataTreeInterface != null) {
            DataSet dataSet;
            int n;
            AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
            if ((abstractDataMatrix.getMatrixTag() & 1) == 1) {
                n = 0;
            } else if ((abstractDataMatrix.getMatrixTag() & 2) == 2) {
                n = 1;
            } else {
                return null;
            }
            if (dataTreeInterface instanceof FoldMatrix) {
                dataTreeInterface = ((FoldMatrix)dataTreeInterface).getReferencedMatrix();
                n = 0;
            }
            if ((dataSet = (DataSet)DataTreeManager.getAncestorNull(dataTreeInterface, DataSet.class)) != null) {
                return dataSet.getDataInfo(n);
            }
        }
        return null;
    }

    private void setupModelLink() {
        DataTreeInterface dataTreeInterface;
        for (dataTreeInterface = this.getPlotInit().getDataTreeInterface(); dataTreeInterface != null && !(dataTreeInterface instanceof AbstractModel); dataTreeInterface = dataTreeInterface.getTreeParent()) {
        }
        if (dataTreeInterface == null) {
            return;
        }
        AbstractModel abstractModel = (AbstractModel)dataTreeInterface;
        abstractModel.addModelListener(() -> this.modelUpdated());
    }

    private boolean sharesParent(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2 = this.getPlotInit().getDataTreeInterface();
        boolean bl = false;
        if (dataTreeInterface == null) {
            return true;
        }
        while (true) {
            if (dataTreeInterface2 == dataTreeInterface) {
                return true;
            }
            if ((dataTreeInterface2 = dataTreeInterface2.getTreeParent()) != null) continue;
            if (bl || this.getDataSet() == null) break;
            dataTreeInterface2 = this.getDataSet().getCase();
            bl = true;
        }
        return false;
    }

    public static class SelectionList
    extends ArrayList<ZoneLeaf> {
        @Override
        public ZoneLeaf getFirst() {
            return this.isEmpty() ? null : (ZoneLeaf)this.get(0);
        }
    }
}

