/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.util.Vector;
import javax.swing.JComponent;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AxisChooseWizard;
import se.prediktera.map.plot.plotgenerator.AbstractPlotInfo;

public abstract class AbstractAxisPlotInfo
extends AbstractPlotInfo {
    private AxisChooseWizard axisChooseWizard;

    @Override
    public void beginWizard(DataTreeInterface dataTreeInterface) {
        super.beginWizard(dataTreeInterface);
        if (this.axisChooseWizard != null) {
            this.axisChooseWizard.beginWizard((PlotInit)this.getInit(dataTreeInterface), this.getAxisNames());
        }
    }

    @Override
    public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        if (abstractInit instanceof PlotInit) {
            DataTreeInterface dataTreeInterface;
            DataTreeInterface dataTreeInterface2;
            PlotInit plotInit = (PlotInit)abstractInit;
            plotInit.setStartAxis(this.getStartAxis());
            if (this.axisChooseWizard != null) {
                this.axisChooseWizard.saveTemplate();
            }
            if ((dataTreeInterface2 = plotInit.getDataTreeInterface()) != null && (dataTreeInterface = dataTreeInterface2.getTreeParent()) instanceof LayerMatrix) {
                LayerMatrix layerMatrix = (LayerMatrix)dataTreeInterface;
                int n = layerMatrix.indexOfTreeNode(dataTreeInterface2);
                if (this.doFold()) {
                    FoldMatrix foldMatrix = new FoldMatrix(layerMatrix);
                    foldMatrix.setFold(n);
                    plotInit.setDataTreeInterface(foldMatrix);
                } else {
                    plotInit.setDataTreeInterface(layerMatrix);
                    plotInit.axisPos = new int[]{n, n, n};
                }
            }
        }
        return null;
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = super.createWizard();
        this.axisChooseWizard = new AxisChooseWizard(this, this.getAxisNumber(), this.getStartAxis());
        vector.add(0, this.axisChooseWizard);
        return vector;
    }

    public boolean doFold() {
        return false;
    }

    public abstract int getAxisNumber();

    public int getStartAxis() {
        return 0;
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            return abstractDataMatrix.getN() != 0 && abstractDataMatrix.getK() != 0;
        }
        return false;
    }

    public boolean supportSecondaryIndex() {
        return false;
    }

    @Override
    protected void cleanUpChild() {
        if (this.axisChooseWizard != null) {
            this.axisChooseWizard.cleanUp();
            this.axisChooseWizard = null;
        }
    }

    @Override
    protected AbstractInit createInit(DataTreeInterface dataTreeInterface) {
        return new PlotInit(dataTreeInterface);
    }

    protected String[] getAxisNames() {
        return new String[]{"X Axis:", "Y Axis:", "Z Axis:"};
    }
}

