/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.util.List;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.ZoneLeaf;

public abstract class AbstractDensityField {
    public static final byte NONE = 0;
    public static final byte LOG = 1;
    public static final byte SQRT = 2;
    public static final String[] NAMES = new String[]{"None", "Log", "Square Root"};
    protected int maxDensity = 1;
    private byte transformation = (byte)2;

    public AbstractDensityField() {
    }

    public AbstractDensityField(AbstractAxisLayer abstractAxisLayer) {
        this.addFromLayer(abstractAxisLayer);
    }

    public void addFromLayer(AbstractAxisLayer abstractAxisLayer) {
        List<ZoneLeaf> list = abstractAxisLayer.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            this.addValue(list.get(i));
        }
    }

    public abstract void addValue(ZoneLeaf var1);

    public abstract double getDensityAt(ZoneLeaf var1);

    public double getMaxDensity() {
        return this.convertValue(this.maxDensity);
    }

    public byte getTranformation() {
        return this.transformation;
    }

    public void setTransformation(byte by) {
        this.transformation = by;
    }

    protected final double convertValue(double d) {
        return switch (this.transformation) {
            case 0 -> d;
            case 1 -> Math.log(d);
            case 2 -> Math.sqrt(d);
            default -> d;
        };
    }
}

