/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.window.AbstractWindowProperties;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.properties.PlotAxisProperties;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public abstract class AbstractPlotBaseWindow
extends AbstractPlotLayout {
    private FloatTextWindow title = null;
    private FloatTextWindow labelX = null;
    private FloatTextWindow labelY = null;

    public AbstractPlotBaseWindow(Plot_GUI plot_GUI, PlotInit plotInit) {
        super(plot_GUI, plotInit);
        if (plotInit.title == null) {
            this.setTitle(plot_GUI, plotInit);
        }
    }

    public AbstractPlotBaseWindow(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (this.getPlotInit().title == null) {
            this.setTitle((Plot_GUI)this.window_gui, this.getPlotInit());
        }
        this.title = (FloatTextWindow)mapProperty.resolveNodeFromName(randomInputStream, "title");
        this.labelX = (FloatTextWindow)mapProperty.resolveNodeFromName(randomInputStream, "xlabel");
        this.labelY = (FloatTextWindow)mapProperty.resolveNodeFromName(randomInputStream, "ylabel");
        try {
            this.addWindow(this.title, 1, 0);
            this.addWindow(this.labelX, 1, 1);
            this.addWindow(this.labelY, 1, 2);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    @Override
    public FloatWindow getArea(String string) {
        if ((string = string.toLowerCase()).equals("plot")) {
            return this.getMainWindow();
        }
        if (string.equals("title")) {
            return this.title;
        }
        if (string.equals("labelx")) {
            return this.labelX;
        }
        if (string.equals("labely")) {
            return this.labelY;
        }
        return null;
    }

    public AbstractAxisPlot getAxisPlot() {
        return (AbstractAxisPlot)this.floatPlotWindow;
    }

    public FloatTextWindow getLabelWindow(byte by) {
        return this.getLabelWindow(by, false);
    }

    public FloatTextWindow getLabelWindow(byte by, boolean bl) {
        AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
        if (abstractAxisPlot == null) {
            return null;
        }
        return switch (by) {
            case 0 -> {
                if (bl && this.labelX == null) {
                    this.labelX = new FloatTextWindow(new Font("SansSerif", 1, 25));
                    this.labelX.setFontColor(abstractAxisPlot.getAxisColor());
                    this.addLabelWindow(by, this.labelX);
                }
                yield this.labelX;
            }
            case 1 -> {
                if (bl && this.labelY == null) {
                    this.labelY = new FloatTextWindow(new Font("SansSerif", 1, 25));
                    this.labelY.setFontColor(abstractAxisPlot.getAxisColor());
                    this.labelY.setFloatRotate(true);
                    this.addLabelWindow(by, this.labelY);
                }
                yield this.labelY;
            }
            default -> null;
        };
    }

    public FloatTextWindow getTitleWindow() {
        return this.title;
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            PlotImages.beginScreenShot();
        }
        super.makeScreenShot(graphics2D, n, n2, bl, bl2, bl3);
        if (!bl2) {
            PlotImages.endScreenShot();
        }
    }

    @Override
    public void removeArea(String string) {
        try {
            this.floatPlotWindow.removeArea(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (string.equalsIgnoreCase("all")) {
            this.removeArea("title");
            this.removeArea("labelx");
            this.removeArea("labely");
        }
        super.removeArea(string);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("title", this.title);
        randomOutputStream.writePropertyNode("xlabel", this.labelX);
        randomOutputStream.writePropertyNode("ylabel", this.labelY);
    }

    @Override
    public void setPlotInitTitle(String string) {
        super.setPlotInitTitle(string);
    }

    @Override
    public void setPlotTitle(String string) {
        if (string.length() > 0) {
            if (this.title == null) {
                this.title = new FloatTextWindow(new Font("SansSerif", 1, 30));
                try {
                    this.addWindow(this.title, 1, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.title.setFloatText(string);
            this.autoLayout(true);
        } else if (this.title != null) {
            this.removeWindow(this.title);
            this.title = null;
        }
    }

    @Override
    public void setTextColor(Color color, Properties properties) {
        super.setTextColor(color, properties);
        if (properties != null && ScriptHelper.hasKey(properties, "labels")) {
            if (this.title != null) {
                this.title.setFontColor(color);
            }
            if (this.labelX != null) {
                this.labelX.setFontColor(color);
            }
            if (this.labelY != null) {
                this.labelY.setFontColor(color);
            }
        }
    }

    protected void addLabelWindow(byte by, FloatTextWindow floatTextWindow) {
        try {
            this.addWindow(floatTextWindow, 1, by == 0 ? 1 : 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.title != null) {
            this.title.cleanUp();
            this.title = null;
        }
        if (this.labelX != null) {
            this.labelX.cleanUp();
            this.labelX = null;
        }
        if (this.labelY != null) {
            this.labelY.cleanUp();
            this.labelY = null;
        }
    }

    @Override
    protected AbstractWindowProperties createProperties() {
        return new PlotAxisProperties(this);
    }

    private void setTitle(Plot_GUI plot_GUI, PlotInit plotInit) {
        DataTreeInterface dataTreeInterface = plotInit.getDataTreeInterface();
        StringBuilder stringBuilder = new StringBuilder();
        if (DataTreeManager.getAncestorNull(dataTreeInterface, AbstractModel.class) != null) {
            stringBuilder.append("$model - ");
        }
        stringBuilder.append(this.getDefaultTitle() + " ($matrix)");
        if (DataTreeManager.getAncestorNull(dataTreeInterface, DataSet.class) != null) {
            stringBuilder.append("\n$dataset");
        }
        plotInit.title = plot_GUI != null ? plot_GUI.getUniqueWindowName(stringBuilder.toString()) : stringBuilder.toString();
    }
}

