/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Color;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.TextIcon;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.axisplot.AxisPlotRubberband;

public class ActionToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private final JFlatButton buttonSave = new JFlatButton();
    private final JFlatButton buttonInclude = new JFlatButton();
    private final JFlatButton buttonExclude = new JFlatButton();
    private final JFlatButton buttonTrain = new JFlatButton();
    private final JFlatButton buttonTest = new JFlatButton();
    private final JFlatButton buttonApplyChanges = new JFlatButton();
    private final JFlatButton buttonExit = new JFlatButton();

    public ActionToolbar(AxisPlotRubberband axisPlotRubberband, ButtonGroup buttonGroup) {
        DataSet dataSet = axisPlotRubberband.getDataSet();
        AbstractDataInfo abstractDataInfo = axisPlotRubberband.getDataInfo();
        this.buttonInclude.setToolTipText("Include Selected Rows");
        this.buttonInclude.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/inc.png")));
        this.buttonInclude.addActionListener(actionEvent -> axisPlotRubberband.includeExclude(true));
        this.buttonExclude.setToolTipText("Exclude Selected Rows");
        this.buttonExclude.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/exc.png")));
        this.buttonExclude.addActionListener(actionEvent -> axisPlotRubberband.includeExclude(false));
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add(this.buttonInclude);
        this.add(this.buttonExclude);
        if (abstractDataInfo instanceof ObservationInfo) {
            this.buttonTrain.addActionListener(actionEvent -> axisPlotRubberband.setTrainTest(dataSet, abstractDataInfo, true));
            this.buttonTrain.setIcon(new TextIcon("Tr", Color.black));
            this.buttonTest.addActionListener(actionEvent -> axisPlotRubberband.setTrainTest(dataSet, abstractDataInfo, false));
            this.buttonTest.setIcon(new TextIcon("Te", Color.black));
            this.addSeparator();
            this.add(this.buttonTrain);
            this.add(this.buttonTest);
        }
        this.buttonApplyChanges.setToolTipText("Apply Changes");
        this.buttonApplyChanges.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
        this.buttonApplyChanges.addActionListener(actionEvent -> dataSet.doUpdate(null));
        this.addSeparator();
        this.add(this.buttonApplyChanges);
        this.buttonSave.setToolTipText("Save Project");
        this.buttonSave.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        this.buttonSave.addActionListener(actionEvent -> dataSet.getProject_GUI().save(null, false, false, false));
        this.buttonExit.setToolTipText("Exit");
        this.buttonExit.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/close.png")));
        this.buttonExit.addActionListener(actionEvent -> Main_GUI.get().thisWindowClosing());
        this.addSeparator();
        this.add(this.buttonSave);
        this.add(this.buttonExit);
    }

    @Override
    protected void cleanUpChild() {
    }
}

